/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.combined;

import com.sas.iquery.IQueryServicesIllegalStateException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.ModelVersion;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.AbstractModel;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.DataSelectionReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.combined.CombinedDataSelectionFactory;
import com.sas.iquery.strategies.combined.CombinedDataSelectionState;
import com.sas.iquery.strategies.combined.DataSelectionWithEmbeddedInterface;
import com.sas.iquery.strategies.sas.report.xml.XMLIntelligentQuery;
import com.sas.services.session.SessionContextInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;

public class DataSelectionWithEmbedded
extends DataSelectionImpl
implements DataSelectionWithEmbeddedInterface {
    private CombinedDataSelectionState _combinedDataSelectionState;
    XMLIntelligentQuery _xmlIntelligentQuery = new XMLIntelligentQuery();
    String _strategyClassName = "com.sas.iquery.strategies.combined.DataSelectionEmbeddedStrategy";

    public DataSelectionWithEmbedded() {
        this._combinedDataSelectionState = new CombinedDataSelectionState(this);
    }

    public DataSelectionWithEmbedded(AbstractBusinessModel baseModel) {
        super(baseModel);
        this._combinedDataSelectionState = new CombinedDataSelectionState(this);
    }

    @Override
    protected DataSelectionFactory getDataSelectionFactory() {
        return CombinedDataSelectionFactory.getInstance();
    }

    public DataSelectionWithEmbedded(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        super(session, service);
        this._combinedDataSelectionState = new CombinedDataSelectionState(this);
    }

    public DataSelectionWithEmbedded(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        super(session, service, dataLocale);
        this._combinedDataSelectionState = new CombinedDataSelectionState(this);
    }

    public void setEmbeddedElement(Element embeddedDataElement) {
        if (CombinedDataSelectionFactory.isValidEmbeddedDataElement(embeddedDataElement)) {
            this._xmlIntelligentQuery.setElement(embeddedDataElement);
            this._combinedDataSelectionState.transitionToEmbeddedValid();
        }
    }

    public Element getElement() {
        this.ensureEmbeddedValid();
        return this._xmlIntelligentQuery.getElement();
    }

    @Override
    public String retrieveStrategyClassName() {
        return this._strategyClassName;
    }

    @Override
    public void setStrategyClassName(String className) {
        this._strategyClassName = className;
    }

    @Override
    public String getFreshestStrategy() {
        return super.retrieveStrategyClassName();
    }

    @Override
    public String getFastestStrategy() {
        String fastestStrategy = this._combinedDataSelectionState.isEmbeddedValid() ? this._xmlIntelligentQuery.retrieveStrategyClassName() : null;
        return fastestStrategy;
    }

    @Override
    public void setID(String id) throws MetadataException {
        super.setID(id);
        if (this._xmlIntelligentQuery != null) {
            this._xmlIntelligentQuery.setID(id);
        }
    }

    @Override
    public XMLIntelligentQuery getXMLIntelligentQuery() {
        return this._xmlIntelligentQuery;
    }

    @Override
    public void setXMLIntelligentQuery(XMLIntelligentQuery xmlIntelligentQuery) {
        this._xmlIntelligentQuery = xmlIntelligentQuery;
        if (this._xmlIntelligentQuery != null) {
            this._combinedDataSelectionState.transitionToEmbeddedValid();
        } else {
            this._combinedDataSelectionState.transitionToEmbeddedInvalid();
        }
    }

    public void read(Element dataSelectionElement, Element embeddedDataElement, HashMap reuseBusinessModels) throws MetadataException {
        DataSelectionReadingContext readingContext = new DataSelectionReadingContext(this, embeddedDataElement, reuseBusinessModels);
        this.readV1(dataSelectionElement, readingContext);
    }

    public void read(Element dsElement, Map reuseBusinessModels) throws MetadataException {
        HashMap map = null;
        map = reuseBusinessModels != null ? new HashMap(reuseBusinessModels) : new HashMap();
        this.read(dsElement, null, map);
    }

    public static DataSelectionWithEmbedded readInNewDataSelectionWithEmbedded(SessionContextInterface session, IntelligentQueryMetadataServiceInterface iqService, Element dataSelectionElement, Element embeddedDataElement, Map reuseModels) throws MetadataException {
        DataSelectionWithEmbedded out = new DataSelectionWithEmbedded(session, iqService);
        ModelVersion version = IQModelImplUtilities.getModelVersionAttr(dataSelectionElement, "ver");
        boolean v2XML = out.checkModelVersion(version);
        if (v2XML) {
            ReadingContextV2 readingContext = new ReadingContextV2((AbstractModel)out, embeddedDataElement);
            readingContext.setModelsToReuse(reuseModels);
            out.readV2(dataSelectionElement, readingContext);
        } else {
            DataSelectionReadingContext readingContext = new DataSelectionReadingContext(out, embeddedDataElement, reuseModels);
            out.readV1(dataSelectionElement, readingContext);
        }
        return out;
    }

    @Override
    protected void readDefinitionV1(Element dataSelectionElement, ReadingContext readingContext) throws MetadataException {
        super.readDefinitionV1(dataSelectionElement, readingContext);
        Element embeddedDataElement = ((DataSelectionReadingContext)readingContext).getEmbeddedDataElement();
        if (embeddedDataElement != null) {
            this.setEmbeddedElement(embeddedDataElement);
            String dataSelectionID = this.getID();
            this._xmlIntelligentQuery.setID(dataSelectionID);
        }
    }

    @Override
    protected void readV2(Element dataSelectionElement, ReadingContextV2 readingContext) throws MetadataException {
        super.readV2(dataSelectionElement, readingContext);
        Element embeddedDataElement = readingContext.getEmbeddedDataElement();
        if (embeddedDataElement != null) {
            this.setEmbeddedElement(embeddedDataElement);
            String dataSelectionID = this.getID();
            this._xmlIntelligentQuery.setID(dataSelectionID);
        }
    }

    private boolean shouldWriteDual() {
        boolean out = false;
        if (this._xmlIntelligentQuery != null && this._combinedDataSelectionState.isEmbeddedValid()) {
            out = true;
        }
        return out;
    }

    @Override
    protected String getReferredToElementName() {
        return "DataSelectionWithEmbedded";
    }

    @Override
    public Element write(Element parentElement) throws MetadataException {
        Element dualElement = IQModelImplUtilities.newSubelement(parentElement, "DataSelectionWithEmbedded");
        super.write(dualElement);
        if (this._xmlIntelligentQuery != null && this._combinedDataSelectionState.isEmbeddedValid()) {
            this._xmlIntelligentQuery.write(dualElement);
        }
        return dualElement;
    }

    @Override
    public List<Reason> getReasonsNotValid() {
        List<Reason> reasons = super.getReasonsNotValid();
        StructureOfData dataType = this.getInputStructure();
        if (dataType.isOLAP()) {
            this.addOLAPReasons(reasons);
        } else if (dataType.isRelational()) {
            this.addRelationalReasons(reasons);
        }
        return reasons;
    }

    private void addOLAPReasons(List<Reason> reasonsList) {
    }

    private void addRelationalReasons(List<Reason> reasonsList) {
    }

    private void ensureEmbeddedValid() {
        if (!this._combinedDataSelectionState.isEmbeddedValid()) {
            throw new IQueryServicesIllegalStateException(IQDataServicesResourceBundle.getMessageFormatter("DataSelectionWithEmbedded.ensureEmbeddedValid.isInvalid.txt", new Object[0]));
        }
    }
}

