/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.combined;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.InstructionInterface;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.SimpleQueryConnector;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.strategies.combined.DataSelectionWithEmbeddedInterface;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.CodeGenerationFactory;
import com.sas.iquery.strategies.sas.oma.relational.CodeGenerationInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import com.sas.util.Guid;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSelectionEmbeddedStrategy
implements StrategyInterface,
InstructionInterface,
OverrideLocaleInterface,
OverrideMLSLookupsInterface,
OverrideStpNamesInterface {
    Locale _computationLocale = null;
    private StpNames _stpNames = null;
    private Map<String, MLSLookup> _mlsLookups = null;
    private static final Logger _logger = LogManager.getLogger(DataSelectionEmbeddedStrategy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetInterface retrieveResultSet(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        ResultSetInterface rs;
        this.checkValid(businessQuery);
        SimpleQueryConnector queryConnector = new SimpleQueryConnector();
        queryConnector.setComputationalLocale(this.getComputationalLocale());
        queryConnector.setStpNames(this.getStpNames());
        queryConnector.setMLSLookups(this.getMLSLookups());
        DataSelectionWithEmbeddedInterface ds = (DataSelectionWithEmbeddedInterface)businessQuery;
        String previousStrategy = ds.retrieveStrategyClassName();
        BusinessQuery businessQueryToUse = null;
        try {
            businessQueryToUse = this.selectBusinessQueryToUse(retrievalPolicy, ds, businessQueryToUse);
            RetrievalPolicy alwaysFreshest = new RetrievalPolicy(retrievalPolicy);
            alwaysFreshest.setPolicyValue(0);
            ArrayList<BusinessQuery> tempList = new ArrayList<BusinessQuery>();
            tempList.add(businessQueryToUse);
            Map<String, ResultSetInterface> resultMap = queryConnector.retrieveQueryResultMap(tempList, alwaysFreshest);
            rs = resultMap.get(ds.getID());
            Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(businessQueryToUse, this);
            if (rs instanceof ResultSetUpdateInterface) {
                ((ResultSetUpdateInterface)((Object)rs)).setComputationalLocale(effectiveComputationLocale);
                StpNames stpNames = queryConnector.getStpNames();
                ((ResultSetUpdateInterface)((Object)rs)).setStpNames(stpNames);
            }
        }
        finally {
            ds.setStrategyClassName(previousStrategy);
        }
        return rs;
    }

    private BusinessQuery selectBusinessQueryToUse(RetrievalPolicy retrievalPolicy, DataSelectionWithEmbeddedInterface ds, BusinessQuery businessQueryToUse) {
        String strategyClass;
        if (retrievalPolicy.getPolicyValue() == 1 && (strategyClass = ds.getFastestStrategy()) != null) {
            ds.setStrategyClassName(strategyClass);
            businessQueryToUse = ds.getXMLIntelligentQuery();
        }
        if (retrievalPolicy.getPolicyValue() == 0 || businessQueryToUse == null) {
            strategyClass = ds.getFreshestStrategy();
            ds.setStrategyClassName(strategyClass);
            businessQueryToUse = ds;
        }
        return businessQueryToUse;
    }

    private void checkValid(BusinessQuery businessQuery) throws IntelligentQueryException {
        if (!(businessQuery instanceof DataSelectionWithEmbeddedInterface)) {
            throw new IntelligentQueryException(IQDataServicesResourceBundle.getMessageFormatter("DataSelectionEmbeddedStrategy.checkValid.wrongquerytype.txt", new Object[0]));
        }
        List<Reason> reasons = businessQuery.getReasonsNotValid();
        if (!reasons.isEmpty()) {
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(businessQuery.getBusinessModel());
            for (Reason reason : reasons) {
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error(reason.getReasonString(viewerLocale));
            }
            MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("DataSelectionEmbeddedStrategy.checkValid.invalidquery.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, true);
            IntelligentQueryException iqe = new IntelligentQueryException(reasonListFormatter, reasons);
            throw iqe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        String queryString;
        this.checkValid(businessQuery);
        DataSelectionWithEmbeddedInterface ds = (DataSelectionWithEmbeddedInterface)businessQuery;
        String previousStrategy = ds.retrieveStrategyClassName();
        ds.setStrategyClassName(ds.getFreshestStrategy());
        DataSelectionWithEmbeddedInterface freshestBQ = ds;
        try {
            SessionContextInterface session = ds.getSession();
            QueryConnector qc = (QueryConnector)IQDataServices.newQueryConnector(session, 0, 0);
            try {
                queryString = qc.getPhysicalQuery(freshestBQ);
            }
            finally {
                try {
                    IQDataServices.closeQueryConnector(qc, session, null);
                }
                catch (Exception e) {
                    throw new IntelligentQueryException(e);
                }
            }
        }
        finally {
            ds.setStrategyClassName(previousStrategy);
        }
        return queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        String returnValue = null;
        QueryConnector queryConnector = (QueryConnector)IQDataServices.newQueryConnector(businessQuery.getBusinessModel().getSession(), -1, -1);
        DataSelectionWithEmbeddedInterface ds = (DataSelectionWithEmbeddedInterface)businessQuery;
        String previousStrategy = ds.retrieveStrategyClassName();
        BusinessQuery businessQueryToUse = null;
        try {
            businessQueryToUse = this.selectBusinessQueryToUse(retrievalPolicy, ds, businessQueryToUse);
            returnValue = queryConnector.getResultSetStructure(businessQueryToUse);
        }
        finally {
            ds.setStrategyClassName(previousStrategy);
        }
        return returnValue;
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationLocale;
    }

    @Override
    public void setComputationalLocale(Locale overrideComputationalLocale) {
        this._computationLocale = overrideComputationalLocale;
    }

    @Override
    public ExecutionInstructionInterface createInstructions(DataSelection bq, EntityInterface entity) throws IQueryServicesException {
        this.checkValid(bq);
        CodeGenerationFactory generationFactory = new CodeGenerationFactory();
        String id = "_ID_" + Guid.makeGuid();
        CodeGenerationInterface codeGenerator = generationFactory.selectCodeGenerator(bq, null);
        if (codeGenerator instanceof OverrideLocaleInterface) {
            ((OverrideLocaleInterface)((Object)codeGenerator)).setComputationalLocale(this.getComputationalLocale());
        }
        if (codeGenerator instanceof OverrideStpNamesInterface) {
            ((OverrideStpNamesInterface)((Object)codeGenerator)).setStpNames(this.getStpNames());
        }
        if (codeGenerator instanceof OverrideMLSLookupsInterface) {
            ((OverrideMLSLookupsInterface)((Object)codeGenerator)).setMLSLookups(this.getMLSLookups());
        }
        ExecutionInstructionInterface instruction = codeGenerator.generateInstructions(bq, id);
        return instruction;
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames;
    }

    @Override
    public Map<String, MLSLookup> getMLSLookups() {
        return this._mlsLookups;
    }

    @Override
    public void setMLSLookups(Map<String, MLSLookup> mlsLookupsByColumnName) {
        this._mlsLookups = mlsLookupsByColumnName;
    }
}

