/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionImpl;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptions;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionsBuilder;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionsImpl;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
class SASFormatDescriptionsBuilderImpl
implements SASFormatDescriptionsBuilder {
    private static final String DEFAULT_FORMAT_LOCATION = "SASFormatDescriptions.xml";
    private static SASFormatDescriptionsBuilder _instance;
    private Document _formatDescriptionData;
    private static final String SAS_FORMAT_FILE_NOTFOUND_ERROR = "SASFormatDescriptionsBuilderImpl.NotFoundError.fmt.txt";
    private static final String SAS_FORMAT_FILE_LOAD_ERROR = "SASFormatDescriptionsBuilderImpl.LoadError.txt";
    private static final String INVALID_SAS_FORMAT_FILE_ERROR = "SASFormatDescriptionsBuilderImpl.InvalidDataFile.txt";
    private static final String INVALID_SAS_FORMAT = "SASFormatDescriptionsBuilderImpl.InvalidFormat.txt";
    private static final Logger _logger;
    private static final String ROOT_ELEMENT = "FormatDescriptionList";
    private static final String FORMATCATEGORYGROUP_ELEMENT = "FormatCategoryGroup";
    private static final String CATEGORY_TYPENAME_ATTR = "CategoryTypeName";
    private static final String FORMAT_DESCRIPTION = "FormatDescription";
    private static final String DESC_FILE_KEY = "descPropertiesFile";
    private static final String BASE_NAME_ATTR = "baseName";
    private static final String DEC_WIDTH_SUPPORTED_ATTR = "decimalWidthSupported";
    private static final String OLAP_SUPPORTED_ATTR = "olapSupported";
    private static final String WIDTH_ELEMENT = "Width";
    private static final String DEFAULT_WIDTH_ATTR = "default";
    private static final String MIN_WIDTH_ATTR = "minimum";
    private static final String MAX_WIDTH_ATTR = "maximum";
    private static final String DECIMAL_WIDTH_ELEMENT = "DecimalWidth";
    private static final String EXAMPLE_ELEMENT = "Example";
    private static final String EXAMPLEVALUE_ELEMENT = "ExampleValue";
    private static final String IS_DATE_ATTR = "isDate";
    private static final String IS_DATE_TIME_ATTR = "isDateTime";
    private static final String IS_TIME_ATTR = "isTime";
    private static final String IS_LOCALIZED_ATTR = "isLocalized";

    public static synchronized SASFormatDescriptionsBuilder getInstance() throws SASFormatException {
        if (_instance == null) {
            _instance = new SASFormatDescriptionsBuilderImpl();
        }
        return _instance;
    }

    private SASFormatDescriptionsBuilderImpl() throws SASFormatException {
        InputStream dataStream = null;
        try {
            dataStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() {
                    return this.getClass().getResourceAsStream(SASFormatDescriptionsBuilderImpl.DEFAULT_FORMAT_LOCATION);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(SAS_FORMAT_FILE_LOAD_ERROR, new Object[0]), (Throwable)e.getException());
        }
        if (dataStream == null) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(SAS_FORMAT_FILE_NOTFOUND_ERROR, DEFAULT_FORMAT_LOCATION));
        }
        this._formatDescriptionData = this.loadFile(dataStream);
    }

    public SASFormatDescriptions build() throws SASFormatException {
        return this.build(null);
    }

    @Override
    public SASFormatDescriptions build(Locale descDefaultlocale) throws SASFormatException {
        Map<SASFormatCategory, List<SASFormatDescription>> formatsByTypes = this.buildSASFormats(this._formatDescriptionData, descDefaultlocale);
        return new SASFormatDescriptionsImpl(formatsByTypes);
    }

    private Document loadFile(InputStream dataStream) throws SASFormatException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(dataStream);
        }
        catch (IOException e) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_SAS_FORMAT_FILE_ERROR, new Object[0]), (Throwable)e);
        }
        catch (Exception e) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_SAS_FORMAT_FILE_ERROR, new Object[0]), (Throwable)e);
        }
    }

    private Map<SASFormatCategory, List<SASFormatDescription>> buildSASFormats(Document doc, Locale descDefaultlocale) throws SASFormatException {
        Element rootElement = doc.getDocumentElement();
        if (!ROOT_ELEMENT.equals(rootElement.getTagName())) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_SAS_FORMAT_FILE_ERROR, new Object[0]));
        }
        String descPropFileName = rootElement.getAttribute(DESC_FILE_KEY);
        HashMap<SASFormatCategory, List<SASFormatDescription>> formatsByTypes = new HashMap<SASFormatCategory, List<SASFormatDescription>>();
        NodeList childElements = rootElement.getChildNodes();
        if (childElements != null) {
            for (int i = 0; i < childElements.getLength(); ++i) {
                Node cur = childElements.item(i);
                if (cur.getNodeType() != 1) continue;
                Element child = (Element)cur;
                String tagName = child.getTagName();
                SASFormatCategory type = null;
                if (!FORMATCATEGORYGROUP_ELEMENT.equals(tagName)) continue;
                String categoryTypeName = IQModelImplUtilities.getAttr(child, CATEGORY_TYPENAME_ATTR);
                type = SASFormatCategory.getCategory(categoryTypeName);
                if (type == null) {
                    type = SASFormatCategory.newCategory(categoryTypeName, null, null);
                }
                List<SASFormatDescription> formats = this.buildFormatDescriptions(child, type, descPropFileName, descDefaultlocale);
                formatsByTypes.put(type, formats);
            }
        }
        return formatsByTypes;
    }

    private List<SASFormatDescription> buildFormatDescriptions(Element formatList, SASFormatCategory type, String descPropFileName, Locale descDefaultlocale) {
        List<Element> elements = IQModelImplUtilities.getSubelements(formatList);
        ArrayList<SASFormatDescription> formats = new ArrayList<SASFormatDescription>(elements.size());
        for (Element element : elements) {
            String tagName = element.getTagName();
            if (!FORMAT_DESCRIPTION.equals(tagName)) continue;
            try {
                SASFormatDescription desc = this.buildFormat(element, type, descPropFileName, descDefaultlocale);
                formats.add(desc);
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.WARN)) continue;
                String warnMsg = IQMetadataResourceBundle.getStringResource(INVALID_SAS_FORMAT);
                _logger.warn(warnMsg, (Throwable)me);
            }
        }
        formats.trimToSize();
        return formats;
    }

    private SASFormatDescription buildFormat(Element element, SASFormatCategory type, String descPropFileName, Locale descDefaultlocale) throws MetadataException {
        Element decWidthElement;
        String baseName = IQModelImplUtilities.getAttr(element, BASE_NAME_ATTR);
        boolean decWidthSupported = IQModelImplUtilities.getBooleanAttr(element, DEC_WIDTH_SUPPORTED_ATTR, false);
        boolean isOlapSupported = IQModelImplUtilities.getBooleanAttr(element, OLAP_SUPPORTED_ATTR, true);
        String example = null;
        Element exampleElement = IQModelImplUtilities.getFirstSubelementNamed(element, EXAMPLE_ELEMENT);
        if (exampleElement != null) {
            Node firstChild = exampleElement.getFirstChild();
            if (firstChild != null) {
                example = firstChild.getNodeValue();
            }
            example = example == null ? "" : example.trim();
        }
        boolean isLocalized = IQModelImplUtilities.getBooleanAttr(element, IS_LOCALIZED_ATTR, false);
        String exampleValue = "";
        Element exampleElement2 = IQModelImplUtilities.getFirstSubelementNamed(element, EXAMPLEVALUE_ELEMENT);
        if (exampleElement2 != null) {
            Node firstChild2 = exampleElement2.getFirstChild();
            if (firstChild2 != null) {
                exampleValue = firstChild2.getNodeValue();
            }
            exampleValue = exampleValue == null ? "" : exampleValue.trim();
        }
        Element widthElement = IQModelImplUtilities.getFirstSubelementNamed(element, WIDTH_ELEMENT);
        int minWidth = IQModelImplUtilities.getIntAttr(widthElement, MIN_WIDTH_ATTR, 0);
        int maxWidth = IQModelImplUtilities.getIntAttr(widthElement, MAX_WIDTH_ATTR, 0);
        int defaultWidth = IQModelImplUtilities.getIntAttr(widthElement, DEFAULT_WIDTH_ATTR, 0);
        int minDecWidth = -1;
        int maxDecWidth = -1;
        int defaultDecWidth = -1;
        if (decWidthSupported && (decWidthElement = IQModelImplUtilities.getFirstSubelementNamed(element, DECIMAL_WIDTH_ELEMENT)) != null) {
            minDecWidth = IQModelImplUtilities.getIntAttr(decWidthElement, MIN_WIDTH_ATTR, 0);
            maxDecWidth = IQModelImplUtilities.getIntAttr(decWidthElement, MAX_WIDTH_ATTR, 0);
            defaultDecWidth = IQModelImplUtilities.getIntAttr(decWidthElement, DEFAULT_WIDTH_ATTR, 0);
        }
        boolean isDate = IQModelImplUtilities.getBooleanAttr(element, IS_DATE_ATTR, false);
        boolean isDateTime = IQModelImplUtilities.getBooleanAttr(element, IS_DATE_TIME_ATTR, false);
        boolean isTime = IQModelImplUtilities.getBooleanAttr(element, IS_TIME_ATTR, false);
        SASFormatDescriptionImpl desc = new SASFormatDescriptionImpl(type, baseName, minWidth, maxWidth, defaultWidth, isOlapSupported, decWidthSupported, minDecWidth, maxDecWidth, defaultDecWidth, descPropFileName, descDefaultlocale, example, isLocalized, exampleValue, isDate, isDateTime, isTime);
        return desc;
    }

    static {
        _logger = LogManager.getLogger(SASFormatDescriptionsBuilderImpl.class);
    }
}

