/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iom.SAS.BaseType;
import com.sas.iom.SAS.BaseTypeSeqHolder;
import com.sas.iom.SAS.IFormatEnumerator;
import com.sas.iom.SAS.IFormatService;
import com.sas.iom.SAS.IFormatServicePackage.FormattingMethod;
import com.sas.iom.SAS.IFormatServicePackage.FormattingMethodSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.IFType;
import com.sas.iom.SAS.IFormatServicePackage.IFTypeSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.ImplType;
import com.sas.iom.SAS.IFormatServicePackage.ImplTypeSeqHolder;
import com.sas.iom.SAS.IFormatServicePackage.NameMatchOp;
import com.sas.iom.SAS.IOptionService;
import com.sas.iom.SAS.IOptionServicePackage.SetErrorSeqHolder;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionImpl;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptions;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionsFactory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.iquery.metadata.serverprop.formats.SASFormatStringParser;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
@SubjectToChange
public class SASFormatDescriptionUtil {
    private static final Logger _logger = LogManager.getLogger(SASFormatDescriptionUtil.class);

    @SASScope(value="ALL")
    @SubjectToChange
    public static SASFormatDescription getFormatDescription(String baseFormatName) {
        SASFormatDescription rval = null;
        try {
            SASFormatDescriptions descs = SASFormatDescriptionsFactory.getSASFormatDescriptions(null);
            rval = descs.getFormatDescription(baseFormatName);
        }
        catch (SASFormatException sASFormatException) {
            // empty catch block
        }
        return rval;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static SASFormatDescription getFormatDescription(String baseFormatName, Locale locale) {
        SASFormatDescription rval = null;
        try {
            SASFormatDescriptions descs = SASFormatDescriptionsFactory.getSASFormatDescriptions(locale);
            rval = descs.getFormatDescription(baseFormatName);
        }
        catch (SASFormatException sASFormatException) {
            // empty catch block
        }
        return rval;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static SASFormatAttributes getFormatAttributes(@Nonnull String formatString) throws SASFormatException {
        return SASFormatStringParser.parseFormatString(formatString);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(String baseFormatName) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(baseFormatName, "", "");
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(SASFormatDescription desc) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(desc.getBaseFormatName());
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(String baseFormatName, int width) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(baseFormatName, "" + width, "");
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(SASFormatDescription desc, int width) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(desc.getBaseFormatName(), width);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(String baseFormatName, int width, int decimalWidth) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(baseFormatName, "" + width, "" + decimalWidth);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static String getFormatDescriptionString(SASFormatDescription desc, int width, int decimalWidth) {
        return SASFormatDescriptionUtil.getFormatDescriptionString(desc.getBaseFormatName(), width, decimalWidth);
    }

    private static String getFormatDescriptionString(String baseFormatName, String width, String decimalWidth) {
        StringBuffer buf = new StringBuffer();
        buf.append(baseFormatName);
        buf.append(width);
        buf.append(".");
        buf.append(decimalWidth);
        return buf.toString();
    }

    @SASScope
    public static boolean isValidDescription(SASFormatDescription desc, int width, int decimalWidth) {
        boolean rval = width < 0 || decimalWidth < 0 ? false : (!desc.isDecimalWidthSupported() && decimalWidth > 0 ? false : (decimalWidth > width ? false : (width < desc.getMinWidth() || width > desc.getMaxWidth() ? false : decimalWidth >= desc.getMinDecimalWidth() && decimalWidth <= desc.getMaxDecimalWidth())));
        return rval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SASScope(value="ALL")
    @SubjectToChange
    public static boolean isFormatUserDefined(String format, BusinessModel model, Locale locale) throws SASFormatException {
        SASFormatDescription sasFormatDescription;
        boolean isUserDefined = false;
        if (model == null) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPConnectionInfoUtilNoModel.txt", new java.lang.Object[0]));
        }
        if (format == null) return isUserDefined;
        if (!model.getStructure().equals(StructureOfData.RELATIONAL)) throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("SASFormatDescriptionUtil.UDFForOLAPNotSupported.txt", new java.lang.Object[0]));
        LogicalServerInterface server = SASFormatDescriptionUtil.getLogicalServerInterface(model);
        Map<SASFormatCategory, List<SASFormatDescription>> actualFormats = SASFormatDescriptionUtil.getActualFormats(locale, model.getSession(), server);
        if (actualFormats.size() <= 0) throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("SASFormatDescriptionUtil.UDFListEmpty.txt", new java.lang.Object[0]));
        SASFormatAttributes attributes = SASFormatDescriptionUtil.getFormatAttributes(format);
        String baseName = attributes.getBaseFormatName();
        List<SASFormatDescription> userFormats = actualFormats.get(SASFormatCategory.USER_DEFINED_CATEGORY);
        Iterator<SASFormatDescription> iterator = userFormats.iterator();
        do {
            if (!iterator.hasNext()) return isUserDefined;
        } while (!(sasFormatDescription = iterator.next()).getBaseFormatName().equals(baseName));
        return true;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static List<SASFormatDescription> getUserDefinedFormats(BusinessModel model, Locale locale) throws SASFormatException {
        if (model == null) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPConnectionInfoUtilNoModel.txt", new java.lang.Object[0]));
        }
        List<SASFormatDescription> userFormats = Collections.emptyList();
        if (model.getStructure().equals(StructureOfData.RELATIONAL)) {
            LogicalServerInterface server = SASFormatDescriptionUtil.getLogicalServerInterface(model);
            Map<SASFormatCategory, List<SASFormatDescription>> actualFormats = SASFormatDescriptionUtil.getActualFormats(locale, model.getSession(), server);
            userFormats = actualFormats.get(SASFormatCategory.USER_DEFINED_CATEGORY);
        }
        return userFormats != null ? userFormats : Collections.emptyList();
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static List<SASFormatDescription> getFormatsByType(SASFormatCategory type, BusinessModel model, Locale locale) throws SASFormatException {
        LogicalServerInterface server = SASFormatDescriptionUtil.getLogicalServerInterface(model);
        Map<SASFormatCategory, List<SASFormatDescription>> actualFormats = SASFormatDescriptionUtil.getActualFormats(locale, model.getSession(), server);
        List<SASFormatDescription> formatsByType = actualFormats.get(type);
        return formatsByType != null ? formatsByType : Collections.emptyList();
    }

    private static LogicalServerInterface getLogicalServerInterface(BusinessModel model) throws SASFormatException {
        if (model == null) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPConnectionInfoUtilNoModel.txt", new java.lang.Object[0]));
        }
        List<DataSource> dataSources = model.getObjects(true, DataSource.class);
        LogicalServerInterface lsi = null;
        if (!dataSources.isEmpty()) {
            DataSource dataSource = dataSources.get(0);
            try {
                if (dataSource != null) {
                    try {
                        Server server = dataSource.getServer();
                        if (server instanceof SoftwareServer) {
                            lsi = ((SoftwareServer)server).getLogicalServerInterface();
                        }
                    }
                    catch (MetadataException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        throw new GenerationException(IQModelImplUtilities.getMessageFormatter("OLAPStrategyMetadataExceptionGetServer.txt", new java.lang.Object[0]), (Throwable)e);
                    }
                }
                if (lsi == null) {
                    GenerationException e = new GenerationException(IQModelImplUtilities.getMessageFormatter("OLAPConnectionInfoUtilNullServer.txt", new java.lang.Object[0]));
                    throw e;
                }
            }
            catch (GenerationException e) {
                throw new SASFormatException(e, e.getDetailMessage());
            }
        }
        if (lsi == null) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPConnectionInfoUtilNullServer.txt", new java.lang.Object[0]));
        }
        return lsi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<SASFormatCategory, List<SASFormatDescription>> getActualFormats(Locale descDefaultlocale, SessionContextInterface session, LogicalServerInterface logicalServer) throws SASFormatException {
        Hashtable<SASFormatCategory, List<SASFormatDescription>> hashtable;
        IWorkspace sasWorkspace = null;
        ConnectionRecycler cr = null;
        ConnectionInterface cx = null;
        try {
            cr = ConnectionUtil.getConnectionRecycler(session);
            RetrievalPolicy ret = new RetrievalPolicy();
            ret.setPolicyValue(1);
            cx = cr.getWorkspaceConnection(logicalServer, session.getUserContext(), ret, descDefaultlocale);
            Object obj = cx.getObject();
            sasWorkspace = IWorkspaceHelper.narrow((Object)obj);
            IUtilities iUtilities = sasWorkspace.Utilities();
            IFormatService iFormatService = iUtilities.FormatService();
            IOptionService iOptionService = iUtilities.OptionService();
            LongSeqHolder errorIndices = new LongSeqHolder();
            SetErrorSeqHolder setErrorCodes = new SetErrorSeqHolder();
            StringSeqHolder errorMsgs = new StringSeqHolder();
            iOptionService.SetOptions(new String[]{"Locale"}, new String[]{descDefaultlocale.getLanguage() + "_" + descDefaultlocale.getCountry()}, errorIndices, setErrorCodes, errorMsgs);
            IFType[] iFTypesFormatsFilter = new IFType[]{IFType.IFTypeFormat};
            NameMatchOp op = NameMatchOp.NameMatchOpContains;
            String nameFilterString = "";
            BaseType[] baseTypesFilter = new BaseType[]{BaseType.BaseTypeNumeric, BaseType.BaseTypeCharacter};
            ImplType[] implTypesFilter = new ImplType[]{ImplType.ImplTypePROCFormat, ImplType.ImplTypeSASInstalled};
            String keyword = "";
            FormattingMethod[] allFilter = new FormattingMethod[]{FormattingMethod.FormattingMethodNumeric, FormattingMethod.FormattingMethodCharacter, FormattingMethod.FormattingMethodDateTime, FormattingMethod.FormattingMethodNone, FormattingMethod.FormattingMethodUnknown};
            IntHolder numberFound = new IntHolder();
            IFormatEnumerator allFE = iFormatService.EnumerateFormats(iFTypesFormatsFilter, op, nameFilterString, baseTypesFilter, implTypesFilter, keyword, allFilter, numberFound);
            Hashtable<SASFormatCategory, List<SASFormatDescription>> formatsByTypes = SASFormatDescriptionUtil.loadEnumeratedFormats(iFormatService, allFE);
            allFE.Close();
            hashtable = formatsByTypes;
        }
        catch (Exception e) {
            try {
                throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("SASFormatDescriptionUtil.IFormatService.txt", new java.lang.Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    cr.closeConnection(cx);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPServerUtilitiesClose.txt", new java.lang.Object[0]), (Throwable)e2);
                }
            }
        }
        try {
            cr.closeConnection(cx);
            return hashtable;
        }
        catch (Exception e) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("OLAPServerUtilitiesClose.txt", new java.lang.Object[0]), (Throwable)e);
        }
    }

    private static Hashtable<SASFormatCategory, List<SASFormatDescription>> loadEnumeratedFormats(IFormatService formatService, IFormatEnumerator numericFE) throws SASFormatException {
        int count = numericFE.NumFormats();
        IFTypeSeqHolder IFTypes = new IFTypeSeqHolder();
        StringSeqHolder canonicalNames = new StringSeqHolder();
        BaseTypeSeqHolder baseTypes = new BaseTypeSeqHolder();
        LongSeqHolder minimumWidths = new LongSeqHolder();
        LongSeqHolder maximumWidths = new LongSeqHolder();
        LongSeqHolder defaultWidths = new LongSeqHolder();
        LongSeqHolder minimumDecimals = new LongSeqHolder();
        LongSeqHolder maximumDecimals = new LongSeqHolder();
        LongSeqHolder defaultDecimals = new LongSeqHolder();
        LongSeqHolder justifications = new LongSeqHolder();
        ImplTypeSeqHolder implTypes = new ImplTypeSeqHolder();
        FormattingMethodSeqHolder formattingMethods = new FormattingMethodSeqHolder();
        StringSeqHolder correspondings = new StringSeqHolder();
        StringSeqHolder keywords = new StringSeqHolder();
        StringSeqHolder descriptions = new StringSeqHolder();
        StringSeqHolder examples = new StringSeqHolder();
        try {
            numericFE.GetInfo(0, count, IFTypes, canonicalNames, baseTypes, minimumWidths, maximumWidths, defaultWidths, minimumDecimals, maximumDecimals, defaultDecimals, justifications, implTypes, formattingMethods, correspondings, keywords, descriptions, examples);
        }
        catch (GenericError e) {
            throw new SASFormatException(IQModelImplUtilities.getMessageFormatter("SASFormatDescriptionUtil.IFormatServiceLoadEnumFormats.txt", new java.lang.Object[0]), (Throwable)e);
        }
        Hashtable<SASFormatCategory, List<SASFormatDescription>> returnList = new Hashtable<SASFormatCategory, List<SASFormatDescription>>();
        for (int index = 0; index < count; ++index) {
            List<java.lang.Object> formats;
            ImplType implType = implTypes.value[index];
            String keyword = keywords.value[index];
            boolean isDate = false;
            boolean isDateTime = false;
            boolean isTime = false;
            boolean isCurrency = false;
            if (keyword.indexOf("datetime") > -1) {
                isDateTime = true;
            } else if (keyword.indexOf("date") > -1) {
                isDate = true;
            } else if (keyword.indexOf("time") > -1) {
                isTime = true;
            } else if (keyword.indexOf("curr") > -1) {
                isCurrency = true;
            }
            SASFormatCategory type = SASFormatDescriptionUtil.convertTypeToIQ(baseTypes.value[index], isDate, isDateTime, isTime, isCurrency, implType);
            boolean olapSupported = false;
            int maxDecimalWidth = maximumDecimals.value[index];
            int minDecimalWidth = minimumDecimals.value[index];
            int defaultDecimalWidth = defaultDecimals.value[index];
            if (maxDecimalWidth == 0) {
                maxDecimalWidth = -1;
            }
            if (maxDecimalWidth < 0) {
                minDecimalWidth = -1;
                defaultDecimalWidth = -1;
            }
            boolean decimalWidthSupported = maxDecimalWidth > 0;
            SASFormatDescriptionImpl format = new SASFormatDescriptionImpl(type, canonicalNames.value[index].trim(), minimumWidths.value[index], maximumWidths.value[index], defaultWidths.value[index], olapSupported, decimalWidthSupported, minDecimalWidth, maxDecimalWidth, defaultDecimalWidth, descriptions.value[index].trim(), examples.value[index].trim(), isDate, isDateTime, isTime);
            if (returnList.containsKey(type)) {
                formats = returnList.get(type);
                formats.add(format);
                continue;
            }
            formats = new ArrayList();
            formats.add(format);
            returnList.put(type, formats);
        }
        return returnList;
    }

    private static SASFormatCategory convertTypeToIQ(BaseType type, boolean isDate, boolean isDateTime, boolean isTime, boolean isCurrency, ImplType implType) {
        SASFormatCategory category = SASFormatCategory.CHARACTER_CATEGORY;
        if (type == BaseType.BaseTypeNumeric) {
            category = SASFormatCategory.NUMERIC_CATEGORY;
        }
        if (isDate || isDateTime || isTime) {
            category = SASFormatCategory.DATE_TIME_CATEGORY;
        } else if (isCurrency) {
            category = SASFormatCategory.CURRENCY_CONVERSION_CATEGORY;
        }
        if (implType == ImplType.ImplTypePROCFormat) {
            category = SASFormatCategory.USER_DEFINED_CATEGORY;
        }
        return category;
    }
}

