/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.text.SASFormat;
import com.sas.util.LocalizableString;
import com.sas.util.RBBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
class SASFormatDescriptionImpl
implements SASFormatDescription {
    private static final String DESC_PROPERTY = ".description.txt";
    private SASFormatCategory _type;
    private String _baseFormatName;
    private int _maxDecimalWidth;
    private int _minDecimalWidth;
    private int _maxWidth;
    private int _minWidth;
    private int _defaultWidth;
    private int _defaultDecimalWidth;
    private boolean _decimalWidthSupported;
    private boolean _olapSupported;
    private LocalizableString _description;
    private String _example;
    private boolean _isDate;
    private boolean _isDateTime;
    private boolean _isTime;
    private boolean _isLocalized;
    private String _exampleValue;
    private boolean _isPropFileUsed = true;
    private String _descPropFileName;
    private Locale _descLocaleDefault;
    private String _descriptionFromServer;
    private static final Map<String, RBBase> _descPropFilesCache = new HashMap<String, RBBase>();

    SASFormatDescriptionImpl(SASFormatCategory type, String baseFormatName, int minWidth, int maxWidth, int defaultWidth, boolean olapSupported, boolean decimalWidthSupported, int minDecimalWidth, int maxDecimalWidth, int defaultDecimalWidth, String descPropFileName, Locale descLocaleDefault, String example, boolean isDate, boolean isDateTime, boolean isTime) {
        this._type = type;
        this._baseFormatName = baseFormatName;
        this._defaultDecimalWidth = defaultDecimalWidth;
        this._maxDecimalWidth = maxDecimalWidth;
        this._minDecimalWidth = minDecimalWidth;
        this._maxWidth = maxWidth;
        this._minWidth = minWidth;
        this._defaultWidth = defaultWidth;
        this._decimalWidthSupported = decimalWidthSupported;
        this._olapSupported = olapSupported;
        this._description = null;
        this._descPropFileName = descPropFileName;
        this._descLocaleDefault = descLocaleDefault;
        this._example = example;
        this._isDate = isDate;
        this._isDateTime = isDateTime;
        this._isTime = isTime;
    }

    SASFormatDescriptionImpl(SASFormatCategory type, String baseFormatName, int minWidth, int maxWidth, int defaultWidth, boolean olapSupported, boolean decimalWidthSupported, int minDecimalWidth, int maxDecimalWidth, int defaultDecimalWidth, String description, String example, boolean isDate, boolean isDateTime, boolean isTime) {
        this(type, baseFormatName, minWidth, maxWidth, defaultWidth, olapSupported, decimalWidthSupported, minDecimalWidth, maxDecimalWidth, defaultDecimalWidth, null, null, example, isDate, isDateTime, isTime);
        this._isPropFileUsed = false;
        this._descriptionFromServer = description;
        this._isLocalized = false;
        this._exampleValue = null;
    }

    public SASFormatDescriptionImpl(SASFormatCategory type, String baseName, int minWidth, int maxWidth, int defaultWidth, boolean isOlapSupported, boolean decWidthSupported, int minDecWidth, int maxDecWidth, int defaultDecWidth, String descPropFileName, Locale descDefaultlocale, String example, boolean isLocalized, String exampleValue, boolean isDate, boolean isDateTime, boolean isTime) {
        this(type, baseName, minWidth, maxWidth, defaultWidth, isOlapSupported, decWidthSupported, minDecWidth, maxDecWidth, defaultDecWidth, descPropFileName, descDefaultlocale, example, isDate, isDateTime, isTime);
        this._isLocalized = isLocalized;
        this._exampleValue = exampleValue;
    }

    @Override
    public SASFormatCategory getType() {
        return this._type;
    }

    @Override
    public String getBaseFormatName() {
        return this._baseFormatName;
    }

    @Override
    public int getMaxDecimalWidth() {
        return this._maxDecimalWidth;
    }

    @Override
    public int getMinDecimalWidth() {
        return this._minDecimalWidth;
    }

    @Override
    public boolean isDecimalWidthSupported() {
        return this._decimalWidthSupported;
    }

    @Override
    public int getDefaultWidth() {
        return this._defaultWidth;
    }

    @Override
    public String getDescription() {
        if (this._isPropFileUsed) {
            return this.getDescription(this._descLocaleDefault);
        }
        return this._descriptionFromServer;
    }

    @Override
    public int getMaxWidth() {
        return this._maxWidth;
    }

    @Override
    public int getMinWidth() {
        return this._minWidth;
    }

    @Override
    public String getExample() {
        String result = this._example;
        if (this.isLocalized()) {
            result = this.getExample(null, true);
        }
        return result;
    }

    @Override
    public boolean isLocalized() {
        return this._isLocalized;
    }

    @Override
    public String getExample(Locale userLocale, boolean dualExample) {
        String result = this._example;
        if (this._isLocalized && this._exampleValue != null) {
            if (userLocale == null) {
                userLocale = LocaleUtilities.getDefaultViewerLocale();
            }
            Locale outLocale1 = userLocale;
            String example1 = this.getFormatExampleText(this._exampleValue, this._baseFormatName, outLocale1);
            StringBuffer text = new StringBuffer();
            if (example1 != null) {
                text.append(outLocale1.getDisplayName()).append(": ").append(example1);
            }
            if (dualExample) {
                Locale outLocale2 = null;
                if (!userLocale.equals(this._descLocaleDefault)) {
                    outLocale2 = this._descLocaleDefault;
                }
                if (outLocale2 == null) {
                    outLocale2 = userLocale.getLanguage().equals(Locale.ENGLISH.getLanguage()) ? Locale.GERMANY : Locale.ENGLISH;
                }
                String example2 = this.getFormatExampleText(this._exampleValue, this._baseFormatName, outLocale2);
                if (example1 != null && example2 != null) {
                    text.append("  ");
                }
                if (example2 != null) {
                    text.append(", " + outLocale2.getDisplayName()).append(": ").append(example2);
                }
            }
            if (text.length() > 0) {
                result = text.toString();
            }
        }
        return result;
    }

    private String getFormatExampleText(String exampleValue, String baseName, Locale descDefaultlocale) {
        String example = null;
        SASFormat format = SASFormat.getInstance((String)(baseName + "."), (Locale)descDefaultlocale);
        if (format != null) {
            String dateValue;
            example = dateValue = format.format((Object)Double.valueOf(exampleValue));
        }
        return example;
    }

    public String toString() {
        return this.getBaseFormatName();
    }

    @Override
    public boolean isSupportedByOlap() {
        return this._olapSupported;
    }

    @Override
    public boolean isDate() {
        return this._isDate;
    }

    @Override
    public boolean isDateTime() {
        return this._isDateTime;
    }

    @Override
    public boolean isTime() {
        return this._isTime;
    }

    @Override
    public int getDefaultDecimalWidth() {
        return this._defaultDecimalWidth;
    }

    @Override
    public String getDescription(Locale locale) {
        if (this._isPropFileUsed) {
            Locale useLocale = locale;
            if (useLocale == null) {
                useLocale = LocaleUtilities.getDefaultViewerLocale();
            }
            this._initDescResources(useLocale);
            String descText = this._description.getText(useLocale);
            return descText == null ? "" : descText;
        }
        return this._descriptionFromServer;
    }

    private void _initDescResources(Locale locale) {
        if (this._description == null) {
            this._description = new LocalizableString();
        }
        if (!this._description.getLocales().contains(locale)) {
            StringBuffer descProp;
            RBBase descResourceBundle = _descPropFilesCache.get(this._descPropFileName);
            if (descResourceBundle == null) {
                descResourceBundle = new IQMetadataResourceBundle(this._descPropFileName, locale);
                _descPropFilesCache.put(this._descPropFileName, descResourceBundle);
            }
            if ((descProp = new StringBuffer(this._baseFormatName + DESC_PROPERTY)).charAt(0) == '$') {
                descProp.replace(0, 1, "C_");
            }
            String descText = (String)descResourceBundle.getResourceAsObject(descProp.toString(), String.class, locale);
            this._description.setText(descText, locale);
        }
    }
}

