/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.LocalizableNamedObjectInterface;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableString;
import com.sas.util.LocalizableToStringInterface;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
@SubjectToChange
public abstract class SASFormatCategory
implements LocalizableNamedObjectInterface,
LocalizableToStringInterface {
    private static final Map<String, SASFormatCategory> _allCategories = new HashMap<String, SASFormatCategory>();
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String CHARACTER_FORMAT = "CharacterFormat";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String NUMERIC_FORMAT = "NumericFormat";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String DATE_TIME_FORMAT = "DateTimeFormat";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String CURRENCY_CONVERSION_FORMAT = "CurrencyConversionFormat";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final String USER_DEFINED_FORMAT = "UserDefinedFormat";
    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory CHARACTER_CATEGORY = SASFormatCategory.newCategory("CharacterFormat", IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Character.Label.txt", new Object[0]), IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Character.Description.txt", new Object[0]));
    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory NUMERIC_CATEGORY = SASFormatCategory.newCategory("NumericFormat", IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Numeric.Label.txt", new Object[0]), IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Numeric.Description.txt", new Object[0]));
    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory DATE_TIME_CATEGORY = SASFormatCategory.newCategory("DateTimeFormat", IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.DateTime.Label.txt", new Object[0]), IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.DateTime.Description.txt", new Object[0]));
    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory CURRENCY_CONVERSION_CATEGORY = SASFormatCategory.newCategory("CurrencyConversionFormat", IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Currency.Label.txt", new Object[0]), IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.Currency.Description.txt", new Object[0]));
    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory USER_DEFINED_CATEGORY = SASFormatCategory.newCategory("UserDefinedFormat", IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.UserDefined.Label.txt", new Object[0]), IQMetadataResourceBundle.getMessageFormatter("SASFormatCategory.UserDefined.Description.txt", new Object[0]));

    @SASScope
    public static final SASFormatCategory newCategory(String typeName, MessageFormatter labelsFormatter, MessageFormatter descriptionsFormatter) throws InvalidParameterException {
        if (SASFormatCategory.getCategory(typeName) != null) {
            String message = IQMetadataResourceBundle.getMessageString("SASFormatCateogry.Error.DuplicateTypeName.fmt.txt", typeName);
            throw new InvalidParameterException(message);
        }
        SASFormatCategoryImpl value = new SASFormatCategoryImpl(typeName, labelsFormatter, descriptionsFormatter);
        _allCategories.put(typeName, value);
        return value;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public static final SASFormatCategory[] getAllCategories() {
        Set<String> keys = _allCategories.keySet();
        return keys.toArray(new SASFormatCategory[keys.size()]);
    }

    @SASScope
    public abstract String getTypeName();

    @SASScope(value="ALL")
    @SubjectToChange
    public static SASFormatCategory getCategory(String typeName) {
        SASFormatCategory rval = _allCategories.get(typeName);
        return rval;
    }

    @SASScope
    static class SASFormatCategoryImpl
    extends SASFormatCategory {
        private String _typeName;
        private MessageFormatter _labelsFormatter;
        private MessageFormatter _descsFormatter;

        SASFormatCategoryImpl(String typeName, MessageFormatter labelsFormatter, MessageFormatter descsFormatter) {
            this._typeName = typeName;
            this._labelsFormatter = labelsFormatter;
            this._descsFormatter = descsFormatter;
        }

        @Override
        public String getTypeName() {
            return this._typeName;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Locale locale) {
            return this.getLabel(locale);
        }

        @Override
        public String getLabel() {
            return this.getLabel(null);
        }

        @Override
        public String getLabel(Locale locale) {
            String label = this.getTypeName();
            if (this._labelsFormatter != null) {
                if (locale == null) {
                    locale = LocaleUtilities.getDefaultViewerLocale();
                }
                label = this._labelsFormatter.getMessage(locale);
            }
            return label;
        }

        @Override
        public String getDescription() {
            return this.getDescription(null);
        }

        @Override
        public String getDescription(Locale locale) {
            String label = this.getTypeName();
            if (this._descsFormatter != null) {
                if (locale == null) {
                    locale = LocaleUtilities.getDefaultViewerLocale();
                }
                label = this._descsFormatter.getMessage(locale);
            }
            return label;
        }

        @Override
        public LocalizableString getLabels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalizableString getDescriptions() {
            throw new UnsupportedOperationException();
        }
    }
}

