/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionLabelComparator;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.Operator;
import com.sas.iquery.metadata.serverprop.Parameter;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.metadata.serverprop.ServerAttribute;
import com.sas.iquery.metadata.serverprop.ServerIdentification;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptions;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionsFactory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@SubjectToChange
public class ServerProperties {
    private static final String COMMA_SEPARATOR = ",";
    private static WeakReference<List<ServerProperties>> serverPropRef;
    private static final Map<String, Function> internalFunctions;
    private final String _name;
    private final String _id;
    private final String _description;
    private final String _baseServerProperties;
    private final List<Operator> _operatorDefinitions;
    private final List<Function> _functionDefinitions;
    private final Map<String, String> _serverAttributes;
    private final Map<ConnectionType, Map<String, String>> _connectionTypeSpecificAttributeMaps;
    private final Map<Category, ArrayList<Function>> _fctnByCat;
    private final Map<Category, ArrayList<Operator>> _opsByCat;
    private final Map<String, Function> _fctnById;
    private final ServerIdentification _serverIdentification;
    private List<Function> _numericAggregateFunctions;
    private List<Function> _charAggregateFunctions;
    private static final Logger _logger;
    private static final String SERVER_PROPERTIES_RESOURCE = "IQServerProperties.xml";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAME_ID = "nameId";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_BASE = "baseServerProperties";
    private static final String ATTR_VISUAL_PROP_FILE = "visualPropertiesFile";
    private static final String ATTR_CONNECTION_TYPE = "connectionType";
    private static final String TAG_OPERATOR = "Operator";
    private static final String TAG_FUNCTION = "Function";
    private static final String TAG_SERVER_ATTRS = "ServerAttributes";
    private static final String TAG_SERVER_IDS = "MatchingServerIdentification";
    private static final String TAG_SERVER_PROP_LIST = "ServerPropertiesList";
    private static final String TAG_SERVER_PROPERTIES = "ServerProperties";
    private static final String TAG_PARAMETER_TYPE_LIST = "ParmTypeList";
    private static final String TAG_CATEGORY_GROUP = "CategoryGroup";
    private static final String TAG_CONNECTION_TYPE_SPECIFIC_SERVER_ATTRS = "ServerConnectionTypeSpecificAttributes";
    private static final String ATTR_CLASS_IDENTIFIER = "classIdentifier";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_SIGNATURE = "Signature";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CANPARENWRAP = "canParenWrap";
    private static final String ATTR_RETURN_TYPE = "returnType";
    private static final String ATTR_SYNTAX_TOKEN = "syntaxToken";
    private static final String ATTR_SYNTAX_TEMPLATE = "syntaxTemplate";
    private static final String ATTR_PRECEDENCE = "precedence";
    private static final String DOT = ".";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_DISTINCT = "distinct";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_ENUMERATION_LIST = "enumList";
    private static final String ATTR_IS_VARYING = "isVarying";
    private static final String ATTR_SEPARATOR = "separator";
    private static final String ATTR_INDEPENDENT_EVAL = "independentEval";
    @SASScope
    public static final String VALIDATE_RULE_NO_SQUARE_BRACKETS = "Rule_NoSquareBrackets";

    private ServerProperties(String name, String id, String description, String baseServerProperties, List<Operator> operatorDefinitions, List<Function> functionDefinitions, Map<String, String> serverAttributes, Map<Category, ArrayList<Function>> fctnByCat, Map<Category, ArrayList<Operator>> opsByCat, Map<String, Function> fctnById, Map<ConnectionType, Map<String, String>> connSpecificMaps, ServerIdentification serverIdentification) {
        this._name = name;
        this._id = id;
        this._description = description;
        this._baseServerProperties = baseServerProperties;
        this._operatorDefinitions = operatorDefinitions;
        this._functionDefinitions = functionDefinitions;
        this._serverAttributes = serverAttributes;
        this._fctnByCat = fctnByCat;
        this._opsByCat = opsByCat;
        this._fctnById = fctnById;
        this._connectionTypeSpecificAttributeMaps = connSpecificMaps;
        this._serverIdentification = serverIdentification;
        if (id == null || id.length() == 0 || operatorDefinitions == null || functionDefinitions == null || serverIdentification == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("ServerProperties.NotFullyDefined.txt", new Object[0]));
        }
    }

    private static void _addSignature(List<FunctionSignature> signatures, ParameterType type, String pattern) {
        Parameter param = new Parameter(type, false, null, null);
        FunctionSignature signature = new FunctionSignature(pattern, true, type, Arrays.asList(param));
        signatures.add(signature);
    }

    @SASScope
    public boolean isPropertiesFor(SoftwareServer server) throws MetadataException {
        return this._serverIdentification.isPropertiesFor(server);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Operator> getOperators() {
        return this._operatorDefinitions;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Function> getFunctions() {
        return this._functionDefinitions;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public Map<String, String> getServerAttributes() {
        return new HashMap<String, String>(this._serverAttributes);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getServerAttributeValue(ServerAttribute attribute) {
        String result = null;
        if (attribute != null) {
            result = this._serverAttributes.get(attribute.getID());
        }
        return result;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getServerAttributeValue(ConnectionType type, ServerAttribute attribute) {
        Map<String, String> map;
        String result = null;
        if (type != null && attribute != null && (map = this._connectionTypeSpecificAttributeMaps.get(type)) != null) {
            result = map.get(attribute.getID());
        }
        return result;
    }

    @SASScope
    public ServerIdentification getServerIdentification() {
        return this._serverIdentification;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getName() {
        return this._name;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription() {
        return this._description;
    }

    @SASScope
    public String getID() {
        return this._id;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Function> getFunctions(Category category) {
        ArrayList<Function> results = new ArrayList<Function>();
        this.getFunctions(category, this._fctnByCat, results);
        this.getFunctions(category, this._opsByCat, results);
        if (results.isEmpty() && _logger.isDebugEnabled()) {
            _logger.debug(IQMetadataResourceBundle.getMessageString("ServerProperties.NoFunctions.fmt.txt", category.getLabel()));
        }
        return results;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Function> getFunctions(Category category, ParameterType type) {
        List<Function> results = this.getFunctions(category);
        if (!results.isEmpty()) {
            ArrayList<Function> tmp = new ArrayList<Function>();
            for (int i = 0; i < results.size(); ++i) {
                Function fnt = results.get(i);
                List<FunctionSignature> fntSigList = fnt.trustedGetSignatures();
                boolean found = false;
                for (int y = 0; y < fntSigList.size() && !found; ++y) {
                    Parameter param;
                    ParameterType paramType;
                    FunctionSignature fntSig = fntSigList.get(y);
                    List<Parameter> params = fntSig.getParameters();
                    if (params.size() != 1 || (paramType = (param = params.get(0)).getType()) != type && paramType != ParameterType.PARM_ANY) continue;
                    tmp.add(fnt);
                    found = true;
                }
            }
            results = tmp;
        }
        return results;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Category> getCategories() {
        ArrayList<Category> categories = new ArrayList<Category>(this._fctnByCat.keySet());
        Collections.sort(categories);
        return categories;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Operator> getOperators(Category category) {
        ArrayList<Operator> results = new ArrayList<Operator>();
        this.getFunctions(category, this._opsByCat, results);
        if (results.isEmpty() && _logger.isEnabled(Level.WARN)) {
            _logger.warn(IQMetadataResourceBundle.getMessageString("ServerProperties.NoOps.fmt.txt", category.getLabel()));
        }
        return results;
    }

    @SASScope
    public static Function getFunctionByFullID(String id) throws MetadataException {
        Function out = null;
        String left = IQModelImplUtilities.leftOfDot(id);
        String right = IQModelImplUtilities.rightOfDot(id);
        if (right != null) {
            out = internalFunctions.get(right);
        }
        if (out == null && left != null) {
            ServerProperties sp = ServerProperties.getServerPropertiesWithID(left);
            if (sp != null) {
                out = sp.getFunctionByID(id);
            } else if (_logger.isEnabled(Level.WARN)) {
                String msg = IQMetadataResourceBundle.getMessageString("ServerProperties.NoFunctionForID.fmt.txt", id);
                _logger.warn(msg);
            }
        }
        return out;
    }

    private static ServerProperties getServerPropertiesWithID(String spid) throws MetadataException {
        ServerProperties out = null;
        List<ServerProperties> props = ServerProperties.readServerProperties();
        int size = props.size();
        for (int i = 0; i < size && out == null; ++i) {
            ServerProperties sp = props.get(i);
            if (!spid.equals(sp.getID())) continue;
            out = sp;
        }
        return out;
    }

    @SASScope
    public Function getFunctionByID(String id) {
        String nameId = this.getNameID(id);
        Function fctn = internalFunctions.get(nameId);
        if (fctn == null) {
            fctn = this._fctnById.get(nameId);
        }
        if (!(fctn instanceof Function) && _logger.isEnabled(Level.WARN)) {
            String msg = IQMetadataResourceBundle.getMessageString("ServerProperties.InvalidFunctionId.fmt.txt", id);
            _logger.warn(msg);
        }
        return fctn;
    }

    @SASScope
    public Operator getOperatorByID(String id) {
        String nameId = this.getNameID(id);
        Function op = this._fctnById.get(nameId);
        if (op != null && !(op instanceof Operator)) {
            op = null;
        }
        if (op == null && _logger.isEnabled(Level.WARN)) {
            String msg = IQMetadataResourceBundle.getMessageString("ServerProperties.InvalidOperatorId.fmt.txt", id);
            _logger.warn(msg);
        }
        return (Operator)op;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public Function getFunctionByNameID(FunctionNameID fntID) {
        String functionID = fntID.getID();
        Function function = this.getFunctionByID(functionID);
        return function;
    }

    private String getNameID(String id) {
        Preconditions.ensureNonNull(id, "ID");
        String result = id;
        int indexOfDot = id.indexOf(DOT);
        if (indexOfDot != -1) {
            result = id.substring(indexOfDot + 1);
        }
        return result;
    }

    private void getFunctions(Category category, Map map, List results) {
        if (map.containsKey(category)) {
            results.addAll((Collection)map.get(category));
        }
        if (category.hasChildren()) {
            List<Category> children = category.getChildren();
            for (int index = 0; index < children.size(); ++index) {
                this.getFunctions(children.get(index), map, results);
            }
        }
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<SASFormatDescription> getSASFormatDescriptions() throws SASFormatException {
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        return this.getSASFormatDescriptions(locale);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<SASFormatDescription> getSASFormatDescriptions(SASFormatCategory type) throws SASFormatException {
        Locale locale = LocaleUtilities.getDefaultViewerLocale();
        return this.getSASFormatDescriptions(type, locale);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<SASFormatDescription> getSASFormatDescriptions(Locale locale) throws SASFormatException {
        SASFormatDescriptions formatDescs = SASFormatDescriptionsFactory.getSASFormatDescriptions(locale);
        List<SASFormatDescription> result = formatDescs.getAllSASFormatDescriptions();
        if (this.isOlapServerProperties()) {
            result = this.getOnlyOlapFormatsFrom(result);
        }
        return result;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<SASFormatDescription> getSASFormatDescriptions(SASFormatCategory type, Locale locale) throws SASFormatException {
        SASFormatDescriptions formatDescs = SASFormatDescriptionsFactory.getSASFormatDescriptions(locale);
        List<SASFormatDescription> result = formatDescs.getSASFormatDescriptions(type);
        if (this.isOlapServerProperties()) {
            result = this.getOnlyOlapFormatsFrom(result);
        }
        return result;
    }

    private boolean isOlapServerProperties() {
        boolean isOlap = Pattern.matches("^sasolaps.*", this._id);
        return isOlap;
    }

    private List<SASFormatDescription> getOnlyOlapFormatsFrom(List<SASFormatDescription> formats) {
        ArrayList<SASFormatDescription> olapFormats = new ArrayList<SASFormatDescription>();
        for (SASFormatDescription f : formats) {
            if (!f.isSupportedByOlap()) continue;
            olapFormats.add(f);
        }
        return olapFormats;
    }

    @SASScope
    public static synchronized List<ServerProperties> readServerProperties() throws MetadataException {
        List<ServerProperties> result = null;
        if (serverPropRef != null) {
            result = (List<ServerProperties>)serverPropRef.get();
        }
        if (result == null) {
            long startTime = ServerProperties.time();
            InputStream dataStream = ServerProperties.getServerPropertiesFile(SERVER_PROPERTIES_RESOURCE);
            result = ServerProperties.readServerProperties(dataStream);
            if (_logger.isDebugEnabled()) {
                double secondsElapsed = ServerProperties.elapsedTimeInSeconds(startTime);
                _logger.debug(new Date().getTime() + ": *** Parsed Server Properties: took " + secondsElapsed + " seconds");
                Exception e = new Exception();
                e.printStackTrace();
            }
            serverPropRef = new WeakReference<List<ServerProperties>>(result);
        }
        return result;
    }

    private static long time() {
        return System.currentTimeMillis();
    }

    private static double elapsedTimeInSeconds(long startTime) {
        long elapsedTimeMillis = ServerProperties.time() - startTime;
        double seconds = elapsedTimeMillis;
        return seconds /= 1000.0;
    }

    @SASScope
    public static List<ServerProperties> readServerProperties(InputStream dataStream) throws MetadataException {
        try {
            Document doc = Utils.loadXmlFile(dataStream);
            ArrayList<ServerProperties> outputList = new ArrayList<ServerProperties>();
            HashMap<String, ServerProperties> serverPropertiesMap = new HashMap<String, ServerProperties>();
            Element topElement = doc.getDocumentElement();
            String elementTagName = topElement.getTagName();
            if (!elementTagName.equals(TAG_SERVER_PROP_LIST)) {
                throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.InvalidElementName.fmt.txt", elementTagName));
            }
            List<Element> kidElements = IQModelImplUtilities.getKidElements(topElement);
            for (Element kidElement : kidElements) {
                String elementName = kidElement.getTagName();
                if (elementName.equals(TAG_SERVER_PROPERTIES)) {
                    ServerProperties sp = ServerProperties.read(kidElement, serverPropertiesMap);
                    if (sp == null) continue;
                    serverPropertiesMap.put(sp.getID(), sp);
                    outputList.add(sp);
                    continue;
                }
                if (elementName.equals(TAG_PARAMETER_TYPE_LIST)) {
                    ParameterType.read(kidElement);
                    continue;
                }
                if (elementName.equals(TAG_CATEGORY_GROUP)) {
                    Category.read(kidElement);
                    continue;
                }
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error(IQMetadataResourceBundle.getMessageString("ServerProperties.InvalidElementName.fmt.txt", elementName));
            }
            Category.categoriesHaveBeenRead();
            serverPropertiesMap.clear();
            return outputList;
        }
        catch (IOException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.CouldNotOpen.txt", new Object[0]), (Throwable)e);
        }
    }

    private static ServerProperties read(Element serverPropertiesElement, Map<String, ServerProperties> previouslyReadServerProperties) throws MetadataException {
        ServerProperties outProperties = null;
        ServerIdentification sId = null;
        ArrayList<Operator> operators = new ArrayList<Operator>();
        ArrayList<Function> functions = new ArrayList<Function>();
        HashMap<String, String> attribMap = new HashMap<String, String>();
        HashMap<Category, ArrayList<Function>> fctnByCat = new HashMap<Category, ArrayList<Function>>();
        HashMap<Category, ArrayList<Operator>> opsByCat = new HashMap<Category, ArrayList<Operator>>();
        HashMap<String, Function> fctnById = new HashMap<String, Function>();
        HashMap<ConnectionType, Map<String, String>> connectSpecificAttribMaps = new HashMap<ConnectionType, Map<String, String>>();
        String name = serverPropertiesElement.getAttribute(ATTR_NAME);
        String id = serverPropertiesElement.getAttribute(ATTR_NAME_ID);
        String description = serverPropertiesElement.getAttribute(ATTR_DESCRIPTION);
        String baseServerPropID = serverPropertiesElement.getAttribute(ATTR_BASE);
        String propFile = serverPropertiesElement.getAttribute(ATTR_VISUAL_PROP_FILE);
        IQMetadataResourceBundle resource = new IQMetadataResourceBundle(propFile);
        List<Element> elements = IQModelImplUtilities.getKidElements(serverPropertiesElement);
        for (Element e : elements) {
            Category category;
            String tagName = e.getTagName();
            Function function = null;
            if (tagName.equals(TAG_OPERATOR)) {
                Operator bop = ServerProperties.readOperators(e, resource, id);
                if (bop != null) {
                    ArrayList<Object> opList;
                    operators.add(bop);
                    category = bop.getCategory();
                    if (opsByCat.containsKey(category)) {
                        opList = opsByCat.get(category);
                        opList.add(bop);
                    } else {
                        opList = new ArrayList();
                        opList.add(bop);
                        opsByCat.put(category, opList);
                    }
                    function = bop;
                }
            } else if (tagName.equals(TAG_FUNCTION)) {
                ArrayList<Object> catList;
                Function fctn = ServerProperties.readFunctions(e, resource, id);
                functions.add(fctn);
                category = fctn.getCategory();
                if (fctnByCat.containsKey(category)) {
                    catList = fctnByCat.get(category);
                    catList.add(fctn);
                } else {
                    catList = new ArrayList();
                    catList.add(fctn);
                    fctnByCat.put(category, catList);
                }
                function = fctn;
            } else if (tagName.equals(TAG_SERVER_ATTRS)) {
                ServerProperties.readAttributes(e, attribMap);
            } else if (tagName.equals(TAG_CONNECTION_TYPE_SPECIFIC_SERVER_ATTRS)) {
                HashMap<String, String> newMap = new HashMap<String, String>();
                ServerProperties.readAttributes(e, newMap);
                String connectionTypeAttr = e.getAttribute(ATTR_CONNECTION_TYPE);
                ConnectionType connectionType = ConnectionType.fromPersistentForm(connectionTypeAttr);
                connectSpecificAttribMaps.put(connectionType, newMap);
            } else if (tagName.equals(TAG_SERVER_IDS)) {
                sId = ServerProperties.readServerId(e);
            }
            if (function != null) {
                String fctnId = function.getNameID();
                if (!fctnById.containsKey(fctnId)) {
                    fctnById.put(fctnId, function);
                } else {
                    throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.AmbiguousId.fmt.txt", fctnId));
                }
            }
            function = null;
        }
        if (baseServerPropID.length() > 0) {
            ServerProperties baseServerProp = previouslyReadServerProperties.get(baseServerPropID);
            ServerProperties.merge(baseServerProp, functions, operators, fctnByCat, opsByCat, fctnById, attribMap, connectSpecificAttribMaps);
        }
        operators.trimToSize();
        functions.trimToSize();
        for (ArrayList listOfOps : opsByCat.values()) {
            listOfOps.trimToSize();
        }
        for (ArrayList listOfFunctions : fctnByCat.values()) {
            listOfFunctions.trimToSize();
        }
        outProperties = new ServerProperties(name, id, description, baseServerPropID, operators, functions, attribMap, fctnByCat, opsByCat, fctnById, connectSpecificAttribMaps, sId);
        return outProperties;
    }

    private static final void merge(ServerProperties src, List<Function> fctnDest, List<Operator> opsDest, Map<Category, ArrayList<Function>> fctnByCatDest, Map<Category, ArrayList<Operator>> opsByCatDest, Map<String, Function> fctnByIdDest, Map<String, String> attribDest, Map<ConnectionType, Map<String, String>> connectSpecificAttribMapsDest) {
        ArrayList<Object> catList;
        for (Operator operator : src.getOperators()) {
            if (fctnByIdDest.containsKey(operator.getNameID())) continue;
            opsDest.add(operator);
            fctnByIdDest.put(operator.getNameID(), operator);
            Category category = operator.getCategory();
            if (opsByCatDest.containsKey(category)) {
                catList = opsByCatDest.get(category);
                catList.add(operator);
                continue;
            }
            catList = new ArrayList();
            catList.add(operator);
            opsByCatDest.put(category, catList);
        }
        for (Function function : src.getFunctions()) {
            if (fctnByIdDest.containsKey(function.getNameID())) continue;
            fctnDest.add(function);
            fctnByIdDest.put(function.getNameID(), function);
            Category category = function.getCategory();
            if (fctnByCatDest.containsKey(category)) {
                catList = fctnByCatDest.get(category);
                catList.add(function);
                continue;
            }
            catList = new ArrayList();
            catList.add(function);
            fctnByCatDest.put(category, catList);
        }
        Map<String, String> srcAttribs = src.getServerAttributes();
        for (Map.Entry<String, String> entry : srcAttribs.entrySet()) {
            if (attribDest.containsKey(entry.getKey())) continue;
            attribDest.put(entry.getKey(), entry.getValue());
        }
        Map<ConnectionType, Map<String, String>> map = src._connectionTypeSpecificAttributeMaps;
        for (Map.Entry<ConnectionType, Map<String, String>> e : map.entrySet()) {
            if (connectSpecificAttribMapsDest.containsKey(e.getKey())) continue;
            connectSpecificAttribMapsDest.put(e.getKey(), e.getValue());
        }
    }

    private static ServerIdentification readServerId(Element element) {
        String classIdentifier = element.getAttribute(ATTR_CLASS_IDENTIFIER);
        String srvVersion = element.getAttribute(ATTR_VERSION);
        ServerIdentification serverId = null;
        serverId = new ServerIdentification(classIdentifier, srvVersion);
        return serverId;
    }

    private static Operator readOperators(Element element, IQMetadataResourceBundle resource, String serverId) throws MetadataException {
        Operator result = null;
        String nameId = IQModelImplUtilities.getAttr(element, ATTR_NAME_ID);
        try {
            String syntaxToken = IQModelImplUtilities.getAttr(element, ATTR_SYNTAX_TOKEN);
            int precedence = IQModelImplUtilities.getIntAttr(element, ATTR_PRECEDENCE, 0);
            String strCategory = IQModelImplUtilities.getAttr(element, ATTR_CATEGORY);
            Category category = Category.fromPersistentForm(strCategory);
            ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>();
            List<Element> elements = IQModelImplUtilities.getKidElements(element);
            int numOfElmts = elements.size();
            for (int index = 0; index < numOfElmts; ++index) {
                Element signatureElement = elements.get(index);
                String tagName = signatureElement.getTagName();
                if (!tagName.equals(TAG_SIGNATURE)) continue;
                FunctionSignature signature = ServerProperties.readFunctionSignature(signatureElement);
                signatures.add(signature);
            }
            signatures.trimToSize();
            result = new Operator(serverId, nameId, precedence, syntaxToken, category, signatures, resource, false);
        }
        catch (NumberFormatException nfe) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.InvalidPrecedenceValue.fmt.txt", nameId), (Throwable)nfe);
        }
        return result;
    }

    private static Function readFunctions(Element element, IQMetadataResourceBundle resource, String serverId) throws MetadataException {
        String nameId = element.getAttribute(ATTR_NAME_ID);
        String syntaxToken = element.getAttribute(ATTR_SYNTAX_TOKEN);
        String category = element.getAttribute(ATTR_CATEGORY);
        boolean isDistinct = IQModelImplUtilities.getBooleanAttr(element, ATTR_DISTINCT, false);
        boolean isIndependentEval = IQModelImplUtilities.getBooleanAttr(element, ATTR_INDEPENDENT_EVAL, false);
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>();
        List<Element> elements = IQModelImplUtilities.getKidElements(element);
        for (Element signatureElement : elements) {
            String tagName = signatureElement.getTagName();
            if (!tagName.equals(TAG_SIGNATURE)) continue;
            FunctionSignature signature = ServerProperties.readFunctionSignature(signatureElement);
            signatures.add(signature);
        }
        Category categoryType = Category.fromPersistentForm(category);
        if (categoryType == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.InvalidCategory.fmt.txt", category, serverId + DOT + nameId));
        }
        signatures.trimToSize();
        return new Function(serverId, nameId, syntaxToken, isDistinct, Category.fromPersistentForm(category), signatures, resource, isIndependentEval);
    }

    private static FunctionSignature readFunctionSignature(Element element) throws MetadataException {
        String syntaxTemplate = IQModelImplUtilities.getAttr(element, ATTR_SYNTAX_TEMPLATE);
        String strReturnType = IQModelImplUtilities.getAttr(element, ATTR_RETURN_TYPE);
        ParameterType rType = ParameterType.fromPersistentForm(strReturnType);
        boolean canParenWrap = IQModelImplUtilities.getBooleanAttr(element, ATTR_CANPARENWRAP, true);
        List<Element> parms = IQModelImplUtilities.getKidElements(element);
        ArrayList<Parameter> parmList = new ArrayList<Parameter>();
        for (Element pe : parms) {
            Parameter parm = ServerProperties.readParameter(pe);
            parmList.add(parm);
        }
        parmList.trimToSize();
        return new FunctionSignature(syntaxTemplate, canParenWrap, rType, parmList);
    }

    private static Parameter readParameter(Element element) throws MetadataException {
        String strParmType = IQModelImplUtilities.getAttr(element, ATTR_TYPE);
        boolean isVarying = IQModelImplUtilities.getBooleanAttr(element, ATTR_IS_VARYING, false);
        String strSeparator = IQModelImplUtilities.getAttr(element, ATTR_SEPARATOR);
        ArrayList<ExpressionInterface> enumList = null;
        ParameterType parmType = ParameterType.fromPersistentForm(strParmType);
        if (parmType == ParameterType.PARM_ENUMERATION) {
            ConstantExpression value;
            enumList = new ArrayList<ExpressionInterface>();
            String strValueList = IQModelImplUtilities.getAttr(element, ATTR_ENUMERATION_LIST);
            int startIndex = 0;
            int endIndex = strValueList.indexOf(44);
            while (endIndex != -1) {
                value = new ConstantExpression();
                value.setExpressionType(11);
                value.setValue(strValueList.substring(startIndex, endIndex));
                enumList.add(value);
                startIndex = endIndex + 1;
                endIndex = strValueList.indexOf(44, startIndex);
            }
            value = new ConstantExpression();
            value.setExpressionType(11);
            value.setValue(strValueList.substring(startIndex));
            enumList.add(value);
            enumList.trimToSize();
        }
        return Parameter.getParameter(parmType, isVarying, strSeparator == null ? COMMA_SEPARATOR : strSeparator, enumList);
    }

    private static void readAttributes(Element element, Map<String, String> attribMap) {
        List<Element> elements = IQModelImplUtilities.getKidElements(element);
        for (Element e : elements) {
            String name = IQModelImplUtilities.getAttr(e, ATTR_NAME);
            String value = IQModelImplUtilities.getAttr(e, ATTR_VALUE);
            attribMap.put(name, value);
        }
    }

    private static InputStream getServerPropertiesFile(String resourceName) throws MetadataException {
        InputStream dataStream = null;
        try {
            final String resource = resourceName;
            dataStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() {
                    return ServerProperties.class.getResourceAsStream(resource);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.ErrorLoadingRes.fmt.txt", resourceName), (Throwable)e);
        }
        if (dataStream == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("ServerProperties.ErrorLoadingRes.fmt.txt", resourceName));
        }
        return dataStream;
    }

    @SASScope
    public Reason validateByRules(String value, String rules) {
        if (value == null) {
            return null;
        }
        if (rules == null) {
            return null;
        }
        ArrayList<String> subRules = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(rules, COMMA_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            subRules.add(tokenizer.nextToken());
        }
        return this.validateByRules(value, subRules);
    }

    public Reason validateByRules(String value, List<String> rules) {
        if (value == null) {
            return null;
        }
        if (rules == null) {
            return null;
        }
        for (String rule : rules) {
            if (rule == null || rule.length() <= 0) continue;
            if (rule.indexOf(44) != -1) {
                Reason reason = this.validateByRules(value, rule);
                if (reason == null) continue;
                return reason;
            }
            if (rule.compareToIgnoreCase(VALIDATE_RULE_NO_SQUARE_BRACKETS) != 0) continue;
            char[] chars = new char[]{'[', ']'};
            for (int i = 0; i < chars.length; ++i) {
                int pos = value.indexOf(chars[i]);
                if (pos == -1) continue;
                Reason reason = new Reason((Object)value, 5, 251, "ServerProperties.StringFailedRuleAtChar.fmt.txt", String.valueOf(chars[i]), pos);
                return reason;
            }
        }
        return null;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean containsAggregateFunction(String expressionText) throws MetadataException {
        boolean foundAgg = false;
        if (expressionText != null && expressionText.trim().length() > 0) {
            ParsedNode node = this.parse(expressionText);
            if (node == null) {
                _logger.debug("Could not parse expression text, evaluate it to not having an aggregation.");
            } else {
                foundAgg = ParsedNodeUtil.isAggFunction(node);
                if (!foundAgg) {
                    foundAgg = ParsedNodeUtil.containsAggFunction(node);
                }
            }
        }
        return foundAgg;
    }

    private ParsedNode parse(String expressionText) {
        ParsedNode node;
        block9: {
            boolean keepComments = false;
            boolean enableTuples = true;
            boolean enableSets = this.isOlapServerProperties();
            boolean enableObjRefs = this.isOlapServerProperties();
            node = null;
            try {
                try {
                    node = ParserUtil.parsePredicate(expressionText, keepComments, enableTuples, enableSets, enableObjRefs);
                }
                catch (ParseError e) {
                    _logger.debug("Expression was not a valid SQL expression, attempting to parse it as a SAS Format.");
                    try {
                        node = ParserUtil.parseFormat(expressionText, keepComments, enableTuples, enableSets, enableObjRefs);
                    }
                    catch (ParseError e2) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Could not parse as format: " + e.getMessage());
                        }
                        throw e;
                    }
                }
            }
            catch (TokenError e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Could not parse as expression: " + e.getMessage());
                    _logger.debug("Parsing Options = {" + (keepComments ? "keep comments" : "ignore comments") + COMMA_SEPARATOR + (enableTuples ? "enable tuples" : "disabled tuples") + COMMA_SEPARATOR + (enableSets ? "enable sets" : "disable sets") + COMMA_SEPARATOR + (enableObjRefs ? "enable object references" : "disable object references") + "}");
                    _logger.debug("Could not parse [" + expressionText + "] for embedded aggregation detection.", (Throwable)e);
                }
            }
            catch (ParseError e) {
                if (!_logger.isDebugEnabled()) break block9;
                _logger.debug("Could not parse as expression: " + e.getMessage());
                _logger.debug("Parsing Options = {" + (keepComments ? "keep comments" : "ignore comments") + COMMA_SEPARATOR + (enableTuples ? "enable tuples" : "disabled tuples") + COMMA_SEPARATOR + (enableSets ? "enable sets" : "disable sets") + COMMA_SEPARATOR + (enableObjRefs ? "enable object references" : "disable object references") + "}");
                _logger.debug("Could not parse [" + expressionText + "] for embedded aggregation detection.", (Throwable)e);
            }
        }
        return node;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<Function> getAggregationFunctions(ParameterType type) {
        ArrayList<Function> returnList;
        if (type == ParameterType.PARM_NUMERIC) {
            if (this._numericAggregateFunctions == null) {
                this._numericAggregateFunctions = this.getFunctions(Category.CAT_AGGREGATE, ParameterType.PARM_NUMERIC);
                Collections.sort(this._numericAggregateFunctions, FunctionLabelComparator.getInstance());
            }
            returnList = new ArrayList<Function>(this._numericAggregateFunctions);
        } else if (type == ParameterType.PARM_CHAR) {
            if (this._charAggregateFunctions == null) {
                this._charAggregateFunctions = this.getFunctions(Category.CAT_AGGREGATE, ParameterType.PARM_CHAR);
                Collections.sort(this._charAggregateFunctions, FunctionLabelComparator.getInstance());
            }
            returnList = new ArrayList<Function>(this._charAggregateFunctions);
        } else {
            returnList = new ArrayList<Function>();
        }
        return returnList;
    }

    @Deprecated
    @SASScope(value="ALL")
    @SubjectToChange
    public static Function[] sortFunctionsListByLabel(List functions) {
        Function[] funcsToSort = functions.toArray(new Function[functions.size()]);
        Arrays.sort(funcsToSort, FunctionLabelComparator.getInstance());
        return funcsToSort;
    }

    static {
        internalFunctions = new HashMap<String, Function>();
        ArrayList<FunctionSignature> signatures = new ArrayList<FunctionSignature>();
        String pattern = "{0}";
        ServerProperties._addSignature(signatures, ParameterType.PARM_BITSTRING, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_CHAR, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_DATE, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_NUMERIC, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_TIME, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_TIMESTAMP, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_INTERVAL_YM, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_TIMESTAMP, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_INTERVAL_DT, pattern);
        ServerProperties._addSignature(signatures, ParameterType.PARM_UNQUOTED_CHAR, pattern);
        String id = "InternalFunction";
        Function internalAggregation = new Function(id, FunctionNameID.INTERNAL_AGGREGATION.getID(), "", false, Category.CAT_AGGREGATE, signatures, IQMetadataResourceBundle.defaultBundle, false);
        Function internalAggregationAdditive = new Function(id, FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE.getID(), "", false, Category.CAT_AGGREGATE, signatures, IQMetadataResourceBundle.defaultBundle, false);
        internalFunctions.put(internalAggregation.getNameID(), internalAggregation);
        internalFunctions.put(internalAggregationAdditive.getNameID(), internalAggregationAdditive);
        _logger = LogManager.getLogger(ServerProperties.class);
    }
}

