/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.LocalizableNamedObjectInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.util.LocalizableString;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@SubjectToChange
@ThreadSafe
public class Category
implements Comparable<Category>,
LocalizableNamedObjectInterface {
    private static final Logger _logger = LogManager.getLogger(Category.class);
    private static ConcurrentMap<String, Category> MAP = new ConcurrentHashMap<String, Category>();
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_ALL = new Category("cat_all");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_FUNCTIONS = new Category("cat_functions");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_AGGREGATE = new Category("cat_aggregate");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_COUNTING_AGGREGATE = new Category("cat_counting_aggregation");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_NONCOUNTING_AGGREGATE = new Category("cat_noncounting_aggregation");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_OPERATORS = new Category("cat_operators");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_SCALAR = new Category("cat_scalar");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_CONDITIONAL = new Category("cat_conditional");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_LOGICAL = new Category("cat_logical");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_COMPARISON = new Category("cat_comparison");
    @SASScope(value="ALL")
    @SubjectToChange
    public static final Category CAT_LANGUAGE_SYNTAX = new Category("cat_lang_syntax");
    private String _persistentForm;
    private String _displayName;
    private String _description;
    private final ArrayList<Category> _children;
    private static boolean _categoriesReadOnce;
    private static final String TAG_CAT = "Category";
    private static final String TAG_CAT_GROUP = "CategoryGroup";
    private static final String ATTR_ID = "catId";

    private Category(String persistentForm) {
        this._persistentForm = persistentForm;
        this._displayName = null;
        this._description = null;
        this._children = new ArrayList();
    }

    @SASScope
    public String getPersistentForm() {
        return this._persistentForm;
    }

    @SASScope
    public static Category fromPersistentForm(String str) {
        if (str == null) {
            return null;
        }
        Category result = (Category)MAP.get(str);
        return result;
    }

    List<Category> getChildren() {
        return this._children;
    }

    boolean hasChildren() {
        return !this._children.isEmpty();
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getLabel() {
        if (this._displayName == null) {
            this._displayName = IQModelImplUtilities.getMessage(this._persistentForm + ".displayName.txt", new Object[0]);
        }
        return this._displayName;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription() {
        if (this._description == null) {
            this._description = IQModelImplUtilities.getMessage(this._persistentForm + ".description.txt", new Object[0]);
        }
        return this._description;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public int compareTo(Category cat) {
        int result = this._persistentForm.compareTo(cat._persistentForm);
        return result;
    }

    @SASScope
    public static void read(Element element) {
        if (!_categoriesReadOnce) {
            String tagName = element.getTagName();
            if (tagName.equals(TAG_CAT_GROUP)) {
                Category gc = Category.getCategory(element);
                Category.readGroupCategory(element, gc);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Category Count: " + MAP.size());
                _logger.debug("Functions category children Count: " + CAT_FUNCTIONS.getChildren().size());
            }
        }
    }

    private static void readGroupCategory(Element element, Category groupCategory) {
        List<Element> elements = IQModelImplUtilities.getKidElements(element);
        for (Element elem : elements) {
            String tagName = elem.getTagName();
            if (TAG_CAT.equals(tagName)) {
                groupCategory._children.add(Category.getCategory(elem));
                continue;
            }
            if (!TAG_CAT_GROUP.equals(tagName)) continue;
            Category gc = Category.getCategory(elem);
            groupCategory._children.add(gc);
            Category.readGroupCategory(elem, gc);
        }
    }

    private static Category getCategory(Element element) {
        Category newCat;
        String id = element.getAttribute(ATTR_ID);
        Category cat = (Category)MAP.get(id);
        if (cat == null && (cat = MAP.putIfAbsent(id, newCat = new Category(id))) == null) {
            cat = newCat;
        }
        return cat;
    }

    static void categoriesHaveBeenRead() {
        _categoriesReadOnce = true;
    }

    @SASScope
    public String toString() {
        return this.getLabel();
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public LocalizableString getLabels() {
        throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("LocalizableToString.LocalizableCollectionNotUnsupported.fmt.txt", this, this.getClass().getName()));
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public LocalizableString getDescriptions() {
        throw new UnsupportedOperationException(IQModelImplUtilities.getMessage("LocalizableToString.LocalizableCollectionNotUnsupported.fmt.txt", this, this.getClass().getName()));
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getLabel(Locale locale) {
        return IQModelImplUtilities.getMessage(this._persistentForm + ".displayName.txt", locale);
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public String getDescription(Locale locale) {
        return IQModelImplUtilities.getMessage(this._persistentForm + ".description.txt", locale);
    }

    @SASScope
    public String toString(Locale locale) {
        return this.getLabel(locale);
    }

    static {
        MAP.put(Category.CAT_ALL._persistentForm, CAT_ALL);
        MAP.put(Category.CAT_FUNCTIONS._persistentForm, CAT_FUNCTIONS);
        MAP.put(Category.CAT_AGGREGATE._persistentForm, CAT_AGGREGATE);
        MAP.put(Category.CAT_COUNTING_AGGREGATE._persistentForm, CAT_COUNTING_AGGREGATE);
        MAP.put(Category.CAT_NONCOUNTING_AGGREGATE._persistentForm, CAT_NONCOUNTING_AGGREGATE);
        MAP.put(Category.CAT_OPERATORS._persistentForm, CAT_OPERATORS);
        MAP.put(Category.CAT_SCALAR._persistentForm, CAT_SCALAR);
        MAP.put(Category.CAT_CONDITIONAL._persistentForm, CAT_CONDITIONAL);
        MAP.put(Category.CAT_LOGICAL._persistentForm, CAT_LOGICAL);
        MAP.put(Category.CAT_COMPARISON._persistentForm, CAT_COMPARISON);
        MAP.put(Category.CAT_LANGUAGE_SYNTAX._persistentForm, CAT_LANGUAGE_SYNTAX);
        _categoriesReadOnce = false;
    }
}

