/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.resourceutil.ModelXMLRetrievalInterface2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceObjectRelationshipUtility2;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class PhysicalResourceTree2 {
    PhysicalResourceObjectRelationshipUtility2 _relations = null;
    SessionContextInterface _session = null;
    IntelligentQueryMetadataServiceInterface _service = null;
    ModelXMLRetrievalInterface2 _map = null;
    Object _owningObject = null;
    List _resources = new ArrayList();
    private Logger _logger = null;

    public PhysicalResourceTree2(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Logger logger) {
        this._session = session;
        this._service = service;
        this._logger = logger;
        this._relations = new PhysicalResourceObjectRelationshipUtility2(this._session, this._service, this._logger);
    }

    public void addPhysicaResource(PhysicalResource in, Object map) throws MetadataException {
        if (in != null) {
            ExternalResourceType type = ExternalResourceType.getType(in);
            if (!this.exists(type, in)) {
                Node newNode = new Node(in, type);
                newNode.addOwningObject(map);
                if (ExternalResourceType.WorkspaceServer.equals(type) || ExternalResourceType.OLAPServer.equals(type)) {
                    this._resources.add(newNode);
                } else if (type.hasParentType()) {
                    PhysicalResource parent = this.getParentPhysicalResource(in);
                    if (parent != null) {
                        Node parentNode;
                        ExternalResourceType pType = ExternalResourceType.getType(parent);
                        if (!this.exists(pType, parent)) {
                            this.addPhysicaResource(parent, map);
                        }
                        if ((parentNode = this.getNode(parent)) != null) {
                            parentNode.addChild(newNode);
                        }
                    } else if (!this._resources.contains(newNode)) {
                        this._resources.add(newNode);
                    }
                }
            } else {
                Node value = this.getNode(in);
                value.addOwningObject(map);
            }
        }
    }

    private PhysicalResource getParentPhysicalResource(PhysicalResource in) throws MetadataException {
        PhysicalResource parent = null;
        if (in != null) {
            parent = this._relations.getParent(in);
        }
        return parent;
    }

    public List getResourcesByType(ExternalResourceType type) {
        ArrayList<PhysicalResource> resources = new ArrayList<PhysicalResource>(10);
        for (Node item : this._resources) {
            PhysicalResource res = item.getPhysicalResource();
            if (item.getType().equals(type)) {
                if (resources.contains(res)) continue;
                resources.add(res);
                continue;
            }
            item.addChildResourcesToListByType(resources, type);
        }
        return resources;
    }

    public void setReplacementName(PhysicalResource in, String replacement) throws MetadataException {
        Node inNode;
        if (in != null && replacement != null && (inNode = this.getNode(in)) != null) {
            inNode.setReplacementName(replacement);
        }
    }

    public PhysicalResource getPhysicalResource(PhysicalResource in) throws MetadataException {
        Node nodeValue;
        PhysicalResource returnValue = null;
        if (in != null && (nodeValue = this.getNode(in)) != null) {
            returnValue = nodeValue.getPhysicalResource();
        }
        return returnValue;
    }

    public void addPhysicalResources(List resources, ModelXMLRetrievalInterface2 map) throws MetadataException {
        this.addPhysicalResources(resources, (Object)map);
    }

    public void addPhysicalResources(List resources, Object map) throws MetadataException {
        this._relations.setParentsAccordingToType(resources);
        for (PhysicalResource res : resources) {
            this.addPhysicaResource(res, map);
        }
    }

    public void addPhysicalResources(PhysicalResourceTree2 tree) throws MetadataException {
        List resources = tree.getAllPhysicalResources();
        Object owningObj = tree.getOwningObject();
        this.addPhysicalResources(resources, owningObj);
    }

    private List getAllPhysicalResources() {
        ArrayList<PhysicalResource> resources = new ArrayList<PhysicalResource>(10);
        for (Node item : this._resources) {
            PhysicalResource res = item.getPhysicalResource();
            if (!resources.contains(res)) {
                resources.add(res);
            }
            item.addChildResourcesToList(resources);
        }
        return resources;
    }

    private boolean exists(ExternalResourceType type, PhysicalResource in) throws MetadataException {
        Node value;
        boolean returnValue = false;
        if (in != null && (value = this.getNode(in)) != null) {
            returnValue = true;
        }
        return returnValue;
    }

    private Node findTopNode(ExternalResourceType type, PhysicalResource in) {
        Node value = null;
        if (in != null) {
            Node source = new Node(in, type);
            for (Node item : this._resources) {
                if (!source.equals(item)) continue;
                value = item;
            }
            if (value == null) {
                Iterator iter = this._resources.iterator();
                while (iter.hasNext() && value == null) {
                    Node item;
                    item = (Node)iter.next();
                    value = item.findChildNode(source);
                }
            }
        }
        return value;
    }

    private Node getNode(PhysicalResource in) throws MetadataException {
        Node parentNode = null;
        Node inNode = null;
        if (in != null) {
            PhysicalResource parent = this._relations.getParent(in);
            if (parent != null) {
                parentNode = this.getNode(parent);
            } else {
                inNode = this.findTopNode(this.getResourceType(in), in);
            }
            if (parentNode != null) {
                inNode = parentNode.findChildNode(new Node(in, this.getResourceType(in)));
            }
        }
        return inNode;
    }

    public void setInformationMap(ModelXMLRetrievalInterface2 mti) {
        this._map = mti;
        for (Node top : this._resources) {
            top.setMap(mti);
        }
    }

    public void setOwningObject(Object mti) {
        this._owningObject = mti;
        for (Node top : this._resources) {
            top.setOwningObject(mti);
        }
    }

    public ModelXMLRetrievalInterface2 getInformationMap() {
        return this._map;
    }

    public Object getOwningObject() {
        return this._owningObject;
    }

    public List getResources() {
        return this.getAllPhysicalResources();
    }

    public ExternalResourceType getResourceType(PhysicalResource res) {
        return ExternalResourceType.getType(res);
    }

    public List getResourceMaps(PhysicalResource res) throws MetadataException {
        Node node;
        List returnValue = null;
        if (res != null && (node = this.getNode(res)) != null) {
            returnValue = node.getMaps();
        }
        if (returnValue == null) {
            returnValue = new ArrayList();
        }
        return returnValue;
    }

    public List getResourceOwningObjects(PhysicalResource res) throws MetadataException {
        Node node;
        List returnValue = null;
        if (res != null && (node = this.getNode(res)) != null) {
            returnValue = node.getOwningObjects();
        }
        if (returnValue == null) {
            returnValue = new ArrayList();
        }
        return returnValue;
    }

    public PhysicalResource getParentResource(PhysicalResource res) throws MetadataException {
        Node parentNode;
        Node childNode;
        PhysicalResource parent = null;
        if (res != null && (childNode = this.getNode(res)) != null && (parentNode = childNode.getParent()) != null) {
            parent = parentNode.getPhysicalResource();
        }
        return parent;
    }

    public String getAssociationName(PhysicalResource source, PhysicalResource target) {
        String returnValue = null;
        if (source != null && target != null) {
            ExternalResourceType sourceType = this.getResourceType(source);
            ExternalResourceType targetType = this.getResourceType(target);
            returnValue = sourceType.getOMAChildAssociationToTypeName(targetType);
        }
        return returnValue;
    }

    public List getChildResources(PhysicalResource res) throws MetadataException {
        Node resNode;
        ArrayList<PhysicalResource> returnList = new ArrayList<PhysicalResource>();
        if (res != null && (resNode = this.getNode(res)) != null) {
            List children = resNode.getChildren();
            for (Node childNode : children) {
                PhysicalResource child = childNode.getPhysicalResource();
                if (returnList.contains(child)) continue;
                returnList.add(child);
            }
        }
        return returnList;
    }

    public List getAllMaps() {
        ArrayList returnList = new ArrayList();
        for (Node top : this._resources) {
            List topMaps = top.getMaps();
            for (Object o : topMaps) {
                if (!(o instanceof ModelXMLRetrievalInterface2) || returnList.contains(o)) continue;
                returnList.add(o);
            }
            top.getAllMaps(returnList);
        }
        return returnList;
    }

    public List getAllOwningObjects() {
        ArrayList returnList = new ArrayList();
        for (Node top : this._resources) {
            List topMaps = top.getOwningObjects();
            for (Object o : topMaps) {
                if (returnList.contains(o)) continue;
                returnList.add(o);
            }
            top.getAllOwningObjects(returnList);
        }
        return returnList;
    }

    public String getReplacementName(PhysicalResource res) throws MetadataException {
        Node resNode;
        String returnValue = null;
        if (res != null && (resNode = this.getNode(res)) != null) {
            returnValue = resNode.getReplacementName();
        }
        return returnValue;
    }

    public String getReplacementPath(PhysicalResource res) throws MetadataException {
        Node resNode;
        String returnValue = null;
        if (res != null && (resNode = this.getNode(res)) != null) {
            returnValue = resNode.getReplacementPath();
        }
        return returnValue;
    }

    public void setReplacementPath(PhysicalResource resource, String newUrlPath) throws MetadataException {
        Node inNode;
        if (resource != null && (inNode = this.getNode(resource)) != null) {
            inNode.setReplacementPath(newUrlPath);
        }
    }

    public void setReplacementOMAObject(PhysicalResource resource, Object targetObject) throws MetadataException {
        Node inNode;
        if (resource != null && (inNode = this.getNode(resource)) != null) {
            inNode.setReplacementOMAObject(targetObject);
        }
    }

    public Object getReplacementOMAObject(PhysicalResource res) throws MetadataException {
        Node resNode;
        Object returnValue = null;
        if (res != null && (resNode = this.getNode(res)) != null) {
            returnValue = resNode.getReplacementOMAObject();
        }
        return returnValue;
    }

    private static class Node
    implements Comparable {
        private PhysicalResource _in = null;
        private ExternalResourceType _type = null;
        private Node _parent = null;
        private List _children = null;
        private String _replacementName = "";
        private String _replacementPath = "";
        private List _maps = new ArrayList();
        private List _owningObjects = new ArrayList();
        private Object _replacementOMAObject = null;

        public Node(PhysicalResource in, ExternalResourceType type) {
            this._in = in;
            this._type = type;
            this._children = new ArrayList(10);
            this._replacementName = in.getLabel();
            if (type.equals(ExternalResourceType.StoredProcess)) {
                this._replacementPath = ((JFSStoredProcess)in).getLocation();
            }
        }

        public void addChildResourcesToListByType(List resources, ExternalResourceType type) {
            for (Node item : this._children) {
                PhysicalResource res = item.getPhysicalResource();
                if (item.getType().equals(type)) {
                    if (resources.contains(res)) continue;
                    resources.add(res);
                    continue;
                }
                item.addChildResourcesToListByType(resources, type);
            }
        }

        public void addChildResourcesToList(List resources) {
            for (Node item : this._children) {
                PhysicalResource res = item.getPhysicalResource();
                if (!resources.contains(res)) {
                    resources.add(res);
                }
                item.addChildResourcesToList(resources);
            }
        }

        public void setReplacementName(String replacement) {
            this._replacementName = replacement;
        }

        public String getReplacementName() {
            return this._replacementName;
        }

        public PhysicalResource getPhysicalResource() {
            return this._in;
        }

        public Node findChildNode(Node source) {
            Node found = null;
            Iterator iter = this._children.iterator();
            while (iter.hasNext() && found == null) {
                Node child = (Node)iter.next();
                if (child.equals(source)) {
                    found = child;
                    continue;
                }
                found = child.findChildNode(source);
            }
            return found;
        }

        public int compareTo(Object o) {
            int returnValue = -1;
            if (o instanceof Node) {
                Node other = (Node)o;
                returnValue = other._type.compareTo(this._type);
                if (returnValue == 0) {
                    returnValue = other._in.getLabel().compareTo(this._in.getLabel());
                }
            }
            return returnValue;
        }

        public boolean equals(Object obj) {
            boolean returnValue = false;
            if (obj != null && this.compareTo(obj) == 0) {
                returnValue = true;
            }
            return returnValue;
        }

        protected void setParent(Node parent) {
            this._parent = parent;
        }

        protected Node getParent() {
            return this._parent;
        }

        protected void addChild(Node child) {
            if (!this._children.contains(child)) {
                this._children.add(child);
                child.setParent(this);
            }
        }

        protected void addMap(ModelXMLRetrievalInterface2 in) {
            if (in != null && !this._maps.contains(in)) {
                this._maps.add(in);
            }
        }

        protected void addOwningObject(Object in) {
            if (in != null && !this._owningObjects.contains(in)) {
                this._owningObjects.add(in);
            }
        }

        public void setMap(ModelXMLRetrievalInterface2 mti) {
            this._maps.clear();
            if (mti != null) {
                this._maps.add(mti);
            }
            for (Node top : this._children) {
                top.setMap(mti);
            }
        }

        public void setOwningObject(Object mti) {
            this._owningObjects.clear();
            if (mti != null) {
                this._owningObjects.add(mti);
            }
            for (Node top : this._children) {
                top.setOwningObject(mti);
            }
        }

        public List getMaps() {
            return this._maps;
        }

        public List getOwningObjects() {
            return this._owningObjects;
        }

        public List getChildren() {
            return this._children;
        }

        public ExternalResourceType getType() {
            return this._type;
        }

        public void getAllMaps(List returnList) {
            for (Node top : this._children) {
                List topMaps = top.getMaps();
                for (Object o : topMaps) {
                    if (!(o instanceof ModelXMLRetrievalInterface2) || returnList.contains(o)) continue;
                    returnList.add(o);
                }
                top.getAllMaps(returnList);
            }
        }

        public void getAllOwningObjects(List returnList) {
            for (Node top : this._children) {
                List topMaps = top.getOwningObjects();
                for (Object o : topMaps) {
                    if (returnList.contains(o)) continue;
                    returnList.add(o);
                }
                top.getAllMaps(returnList);
            }
        }

        public void setReplacementPath(String newUrlPath) {
            this._replacementPath = newUrlPath;
        }

        public String getReplacementPath() {
            return this._replacementPath;
        }

        public String toString() {
            return this._in.toString() + ", " + this._type.toString() + ": ==> " + this._replacementName + ", " + this._replacementPath;
        }

        public void setReplacementOMAObject(Object targetObject) {
            this._replacementOMAObject = targetObject;
        }

        public Object getReplacementOMAObject() {
            return this._replacementOMAObject;
        }
    }
}

