/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.MediatedResourceManager2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceUnresolvedTarget2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ReplacementMediator2;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalResourceTargetInformation2 {
    private Map _globalMappings = new LinkedHashMap();
    private Map _unresolvedResourceMapping = new LinkedHashMap();
    private Map _brrmToTargetMapping = new LinkedHashMap();
    private MediatedResourceManager2 _mediatedResourceManager = null;
    private Logger _logger = null;
    private static final Logger _prLogger = LogManager.getLogger(PhysicalResourceTargetInformation2.class);

    PhysicalResourceTargetInformation2(MediatedResourceManager2 mrm, Logger logger) throws MetadataException {
        this._mediatedResourceManager = mrm;
        this._logger = logger;
        List mediatedResources = this._mediatedResourceManager.getMediatedResourceList();
        for (List mediatedResourceList : mediatedResources) {
            BasicResourceReplacementMediator2 brrm = (BasicResourceReplacementMediator2)mediatedResourceList.get(mediatedResourceList.size() - 1);
            this.addMappings(brrm);
            if (!brrm.isGlobalReplacementMediator()) continue;
            this.addGlobalMapping(brrm);
        }
    }

    private void addGlobalMapping(BasicResourceReplacementMediator2 brrm) throws MetadataException {
        PhysicalResource target = (PhysicalResource)this._brrmToTargetMapping.get(brrm);
        this._globalMappings.put(brrm, target);
    }

    private void addParentMappings(BasicResourceReplacementMediator2 brrm) throws MetadataException {
        if (brrm != null) {
            this.addMappings(brrm.getParent());
        }
    }

    private void addMappings(BasicResourceReplacementMediator2 brrm) throws MetadataException {
        if (brrm != null) {
            this.addParentMappings(brrm);
            if (this._brrmToTargetMapping.get(brrm) == null) {
                PhysicalResource target = this.getTargetPhysicalResource(brrm);
                this._brrmToTargetMapping.put(brrm, target);
            }
        }
    }

    private PhysicalResource getTargetPhysicalResource(BasicResourceReplacementMediator2 brrm) throws MetadataException {
        PhysicalResource target = null;
        PhysicalResource source = brrm.getSourceObject().getPhysicalResource();
        if (brrm.isUnmatched()) {
            if (brrm.isGlobalReplacementMediator() && !(brrm instanceof LogicalResourceReplacementMediator2) && brrm.isUnresolvedTargetNeeded()) {
                PhysicalResource targetParent;
                BasicResourceUnresolvedTarget2 targetDesc;
                PhysicalResource unresolvedResource;
                if (_prLogger.isDebugEnabled()) {
                    _prLogger.debug("Created unresolved resource for: " + source);
                }
                if ((unresolvedResource = (PhysicalResource)this._unresolvedResourceMapping.get(targetDesc = new BasicResourceUnresolvedTarget2(brrm, targetParent = this.getTargetParent(brrm)))) == null) {
                    unresolvedResource = targetDesc.getResource();
                    this.populateUnresolvedObject(source, unresolvedResource, targetParent);
                    this._unresolvedResourceMapping.put(targetDesc, unresolvedResource);
                }
                target = unresolvedResource;
            }
        } else {
            target = brrm.getReplacementObject().getPhysicalResource();
        }
        if (target == null) {
            if (_prLogger.isDebugEnabled()) {
                _prLogger.debug("No target for BRRM (" + brrm.toString() + ")");
            }
            target = source;
        }
        return target;
    }

    private void populateUnresolvedObject(PhysicalResource sourceResource, PhysicalResource targetResource, PhysicalResource targetResourceParent) throws MetadataException {
        if (targetResourceParent != null) {
            ((ResourceRelationshipInterface)((Object)targetResource)).setUnresolvedProperties(sourceResource);
            ((ResourceRelationshipInterface)((Object)targetResource)).setUnresolvedParentResource(targetResourceParent);
            ((ResourceRelationshipInterface)((Object)targetResourceParent)).addUnresolvedChildResource(targetResource);
        }
        if (targetResource instanceof JFSStoredProcess) {
            // empty if block
        }
    }

    private PhysicalResource getTargetParent(BasicResourceReplacementMediator2 brrm) throws MetadataException {
        PhysicalResource targetParent = null;
        BasicResourceReplacementMediator2 brrmParent = brrm.getParent();
        if (brrmParent != null && (targetParent = (PhysicalResource)this._brrmToTargetMapping.get(brrmParent)) == null) {
            BasicResource br;
            if (!brrm.getParent().isUnmatched() && (br = brrmParent.getReplacementObject()) != null) {
                targetParent = br.getPhysicalResource();
            }
            if (targetParent != null) {
                this._brrmToTargetMapping.put(brrmParent, targetParent);
            }
        }
        return targetParent;
    }

    public List getSources() {
        ArrayList sources = new ArrayList(this._brrmToTargetMapping.keySet());
        return sources;
    }

    public List getTargets() {
        ArrayList targets = new ArrayList(this._brrmToTargetMapping.values());
        return targets;
    }

    public PhysicalResource getTarget(ReplacementMediator2 source) {
        return (PhysicalResource)this._brrmToTargetMapping.get(source);
    }

    public boolean isReplaced(ReplacementMediator2 source) {
        return this.getTarget(source) != null;
    }

    public boolean isReplaced(PhysicalResource source) {
        boolean replaced = false;
        List sources = this.getSources();
        Iterator iter = sources.iterator();
        while (iter.hasNext() && !replaced) {
            BasicResourceReplacementMediator2 mediator = (BasicResourceReplacementMediator2)iter.next();
            if (!mediator.getSourceObject().getPhysicalResource().equals(source)) continue;
            replaced = this.isReplaced(mediator);
        }
        return replaced;
    }

    public Map getGlobalMediators() {
        return this._globalMappings;
    }

    public PhysicalResource getGlobalMapping(ReplacementMediator2 source) {
        PhysicalResource target = (PhysicalResource)this._globalMappings.get(source);
        return target;
    }

    public boolean isGloballyReplaced(ReplacementMediator2 source) {
        return this._globalMappings.get(source) != null;
    }

    public Map getUniqueNonGlobalMappings() {
        IdentityHashMap<ReplacementMediator2, PhysicalResource> returnValue = new IdentityHashMap<ReplacementMediator2, PhysicalResource>();
        List sources = this.getSources();
        for (ReplacementMediator2 source : sources) {
            PhysicalResource target;
            if (this.isGloballyReplaced(source) || (target = this.getTarget(source)) == null) continue;
            returnValue.put(source, target);
        }
        return returnValue;
    }

    public static void addToMappingIfNotExist(Object key, Object value, Map mapping) {
        Object mappedValue = mapping.get(key);
        if (mappedValue == null) {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value);
            mapping.put(key, values);
        } else if (mappedValue instanceof List) {
            List mappedList = (List)mappedValue;
            if (!mappedList.contains(value)) {
                mappedList.add(value);
            }
        } else if (!mappedValue.equals(value)) {
            mapping.put(key, value);
        }
    }
}

