/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.IntelligentQueryMetadataService;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASOlapSchema;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalRelationshipResourceCache;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalResourceObjectRelationshipUtility2 {
    private static final Logger _clsLogger = LogManager.getLogger(PhysicalResourceObjectRelationshipUtility2.class);
    private SessionContextInterface _session = null;
    private IntelligentQueryMetadataService _service = null;
    private Logger _logger = null;
    private PhysicalResourceResolutionTypeComparator _comparator = null;
    PhysicalRelationshipResourceCache _childrenLookupCache = null;
    Map _directReplacementLookupCache = new IdentityHashMap();
    Map _parentLookupCache = new IdentityHashMap();

    public PhysicalResourceObjectRelationshipUtility2(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Logger logger) {
        this._session = session;
        this._service = (IntelligentQueryMetadataService)service;
        this._logger = logger;
    }

    public List getChildren(PhysicalResource parent, ExternalResourceType type, PhysicalResource restrictingObject) throws MetadataException {
        List children = new ArrayList();
        if (parent != null && this.hasChildren(parent)) {
            children = this.getChildrenRelationship(parent, type, restrictingObject);
        }
        return children;
    }

    private List getChildrenRelationship(PhysicalResource parent, ExternalResourceType type, PhysicalResource restrictingObject) throws MetadataException {
        List found;
        List<Object> children = new ArrayList();
        if (this._childrenLookupCache == null) {
            this._childrenLookupCache = new PhysicalRelationshipResourceCache();
        }
        if ((found = this._childrenLookupCache.get(parent, type)) != null) {
            children = found;
        } else {
            if (parent != null && parent instanceof ResourceRelationshipInterface) {
                children = ((ResourceRelationshipInterface)((Object)parent)).getChildResources(type);
            }
            this._childrenLookupCache.put(parent, type, children);
        }
        if (parent instanceof Table) {
            children = this.filterByTypeAndCriteria(restrictingObject, children);
        }
        return children;
    }

    private List filterByTypeAndCriteria(PhysicalResource restrictingObject, List children) throws MetadataException {
        ArrayList filterList = children;
        if (restrictingObject != null && restrictingObject instanceof Column) {
            filterList = new ArrayList(children);
            Column oColumn = (Column)restrictingObject;
            Iterator iter = filterList.iterator();
            while (iter.hasNext()) {
                Column c = (Column)iter.next();
                if (c.getSasType().equals(oColumn.getSasType())) continue;
                iter.remove();
            }
        }
        return filterList;
    }

    public PhysicalResource getParent(PhysicalResource child) {
        PhysicalResource returnObj = null;
        if (child != null && child instanceof ResourceRelationshipInterface && (returnObj = (PhysicalResource)this._parentLookupCache.get(child)) == null) {
            try {
                returnObj = ((ResourceRelationshipInterface)((Object)child)).getParentResource();
            }
            catch (MetadataUnresolvedException mue) {
                if (this._logger != null) {
                    this._logger.debug("Error loading parent for child: " + child, (Throwable)mue);
                } else {
                    _clsLogger.debug("Error loading parent for child: " + child, (Throwable)mue);
                }
            }
            catch (MetadataException me) {
                if (this._logger != null) {
                    this._logger.debug("Error loading parent for child: " + child, (Throwable)me);
                }
                _clsLogger.debug("Error loading parent for child: " + child, (Throwable)me);
            }
            if (returnObj != null) {
                this._parentLookupCache.put(child, returnObj);
            }
        }
        return returnObj;
    }

    public boolean hasChildren(PhysicalResource parent) {
        boolean returnValue = false;
        if (parent != null && parent instanceof ResourceRelationshipInterface) {
            returnValue = ((ResourceRelationshipInterface)((Object)parent)).hasChildResources();
        }
        return returnValue;
    }

    public boolean hasParent(PhysicalResource child) {
        boolean returnValue = false;
        if (child != null && child instanceof ResourceRelationshipInterface) {
            returnValue = ((ResourceRelationshipInterface)((Object)child)).hasParentResource();
        }
        return returnValue;
    }

    public List getDirectReplacments(PhysicalResource resource, MetadataServerInterface mdServer) throws MetadataException {
        List<Object> returnList = new ArrayList(0);
        if (resource != null) {
            List cachedList = (List)this._directReplacementLookupCache.get(resource);
            if (cachedList != null) {
                returnList = cachedList;
            } else {
                if (resource instanceof SASWorkspaceServer) {
                    SASWorkspaceServer wkspServer = (SASWorkspaceServer)resource;
                    List<Class<?>> types = Collections.singletonList(wkspServer.getClass());
                    returnList = this._service.getSoftwareServers(this._session, types, mdServer);
                } else if (resource instanceof SASLibrary) {
                    returnList = this._service.getSchemas(this._session, SASLibrary.class, mdServer);
                } else if (resource instanceof SASOlapServer) {
                    SASOlapServer olapServer = (SASOlapServer)resource;
                    List<Class<?>> types = Collections.singletonList(olapServer.getClass());
                    returnList = this._service.getSoftwareServers(this._session, types, mdServer);
                } else if (resource instanceof OlapSchema) {
                    returnList = this._service.getSchemas(this._session, SASOlapSchema.class, mdServer);
                }
                if (returnList.size() > 0) {
                    this._directReplacementLookupCache.put(resource, returnList);
                }
            }
        }
        return returnList;
    }

    public List getBaseReplacementObjects(List resources) {
        ArrayList<PhysicalResource> baseObjects = new ArrayList<PhysicalResource>(resources.size());
        for (PhysicalResource lo : resources) {
            if (!this.hasChildren(lo)) {
                baseObjects.add(lo);
                continue;
            }
            if (!(lo instanceof Hierarchy)) continue;
            baseObjects.add(lo);
        }
        return baseObjects;
    }

    public List getServerObjects(List resources) {
        ArrayList<PhysicalResource> serverObjects = new ArrayList<PhysicalResource>(resources.size());
        for (PhysicalResource lo : resources) {
            if (!this.hasParent(lo)) {
                serverObjects.add(lo);
                continue;
            }
            if (lo instanceof OlapSchema) {
                serverObjects.add(lo);
                continue;
            }
            if (!(lo instanceof Cube)) continue;
            serverObjects.add(lo);
        }
        return serverObjects;
    }

    private ExternalResourceType getResourceType(PhysicalResource res) throws RuntimeException {
        ExternalResourceType returnValue = null;
        returnValue = res instanceof ResourceRelationshipInterface ? ((ResourceRelationshipInterface)((Object)res)).getResourceType() : ExternalResourceType.getType(res);
        return returnValue;
    }

    public boolean isTopLevelObject(PhysicalResource res) {
        boolean returnValue = false;
        if (res != null) {
            if (res instanceof SASWorkspaceServer) {
                returnValue = true;
            } else if (res instanceof SASOlapServer) {
                returnValue = true;
            } else if (res instanceof OlapSchema) {
                returnValue = true;
            } else if (res instanceof Cube) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public PhysicalResourceResolutionTypeComparator getTypeComparator() {
        if (this._comparator == null) {
            this._comparator = new PhysicalResourceResolutionTypeComparator();
        }
        return this._comparator;
    }

    public boolean isEqual(PhysicalResource os, PhysicalResource ot, boolean bVerifyParent) throws MetadataException {
        if (os == null && ot == null || os == ot) {
            return true;
        }
        if (os == null || ot == null) {
            return false;
        }
        boolean returnValue = false;
        ExternalResourceType osType = this.getResourceType(os);
        if (osType.equals(this.getResourceType(ot))) {
            if (bVerifyParent && osType.hasParentType()) {
                PhysicalResource osP = this.getParent(os);
                PhysicalResource otP = this.getParent(ot);
                if (osP != null && otP != null) {
                    if (this.isEqual(osP, otP, true) && os instanceof ResourceRelationshipInterface) {
                        returnValue = ((ResourceRelationshipInterface)((Object)os)).isPhysicallyEquivalent(ot);
                    }
                } else if (osP == null && otP == null && os instanceof ResourceRelationshipInterface) {
                    returnValue = ((ResourceRelationshipInterface)((Object)os)).isPhysicallyEquivalent(ot);
                }
            } else if (os instanceof ResourceRelationshipInterface) {
                returnValue = ((ResourceRelationshipInterface)((Object)os)).isPhysicallyEquivalent(ot);
            }
        }
        return returnValue;
    }

    public void setParentsAccordingToType(List physicalRelationships) {
        BusinessModelResource server = null;
        Iterator iter = physicalRelationships.iterator();
        while (iter.hasNext() && server == null) {
            PhysicalResource element = (PhysicalResource)iter.next();
            if (!(element instanceof SoftwareServer)) continue;
            server = (SoftwareServer)element;
        }
        if (server != null && !server.isUnresolved()) {
            for (PhysicalResource element : physicalRelationships) {
                JFSStoredProcess proc;
                SoftwareServer assignedServer;
                if (element instanceof OMASASLibrary) {
                    OMASASLibrary lib = (OMASASLibrary)element;
                    assignedServer = lib.getAccessingServerWhenUnresolved();
                    if (assignedServer != null && !assignedServer.isUnresolved() || !(server instanceof SASWorkspaceServer)) continue;
                    lib.setAccessingServerWhenUnresolved((SASWorkspaceServer)server);
                    continue;
                }
                if (element instanceof OMAOlapSchema) {
                    OMAOlapSchema schema = (OMAOlapSchema)element;
                    assignedServer = schema.getAccessingServerWhenUnresolved();
                    if (assignedServer != null && !assignedServer.isUnresolved() || !(server instanceof OMASASOlapServer)) continue;
                    schema.setAccessingServerWhenUnresolved((OMASASOlapServer)server);
                    continue;
                }
                if (!(element instanceof JFSStoredProcess) || (assignedServer = (proc = (JFSStoredProcess)element).getUnresolvedSoftwareServer()) != null && !assignedServer.isUnresolved()) continue;
                proc.setUnresolvedAccessingServer((SoftwareServer)server);
            }
        }
    }

    public static class PhysicalResourceResolutionTypeComparator
    implements Comparator<PhysicalResource> {
        @Override
        public int compare(PhysicalResource o1, PhysicalResource o2) {
            ExternalResourceType type2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ExternalResourceType type1 = ExternalResourceType.getType(o1);
            int physicalTypeComparison = type1.compareTo(type2 = ExternalResourceType.getType(o2));
            if (physicalTypeComparison == 0) {
                String label2;
                String label1 = o1.getLabel();
                if (label1 == (label2 = o2.getLabel())) {
                    return 0;
                }
                if (label1 == null) {
                    return -1;
                }
                if (label2 == null) {
                    return 1;
                }
                int labelComparison = label1.compareTo(label2);
                return labelComparison;
            }
            return physicalTypeComparison;
        }
    }
}

