/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.ReferenceToBasicResourceMapping2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceObjectRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceToBasicResourceMapping;
import com.sas.iquery.metadata.resourceutil.physical.ReplacementMediator2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class OriginatingPhysicalResourceToBasicMapping2
implements ReferenceToBasicResourceMapping2 {
    private PhysicalResource _mainResourceObject = null;
    private LinkedList _objects = null;
    private PhysicalResourceObjectRelationshipUtility2 _modelRelationships = null;
    private PhysicalResourceToBasicResourceMapping _omaToBasicResourceMapping = null;
    private ModelResourceToBasicResourcelMappingManager2 _mappingMgr = null;
    boolean _useGlobalReplacement = false;
    BasicResourceRelationshipUtility2 _basicResourceRelationships = null;
    BasicResourceReplacementMapping _replacementResourceToResourceMappings = null;
    List _mediatorList = null;
    private Logger _logger = null;

    public OriginatingPhysicalResourceToBasicMapping2(PhysicalResource mainResourceObject, PhysicalResourceObjectRelationshipUtility2 modelRelationships, ModelResourceToBasicResourcelMappingManager2 mappingMgr, BasicResourceRelationshipUtility2 loRelationUtility, BasicResourceReplacementMapping loToLoMapping, boolean useGlobalReplacement, Logger logger) throws MetadataException {
        this._mainResourceObject = mainResourceObject;
        this._modelRelationships = modelRelationships;
        this._mappingMgr = mappingMgr;
        this._useGlobalReplacement = useGlobalReplacement;
        this._omaToBasicResourceMapping = new PhysicalResourceToBasicResourceMapping();
        this._basicResourceRelationships = loRelationUtility;
        this._replacementResourceToResourceMappings = loToLoMapping;
        this._objects = new LinkedList();
        this._logger = logger;
        if (this._mainResourceObject != null) {
            this._objects.add(this._mainResourceObject);
        }
        this.geBasicResourceMapping(this._mainResourceObject);
        this.addRelationshipObjects(this._mainResourceObject);
    }

    private void addRelationshipObjects(PhysicalResource resourceObject) throws MetadataException {
        if (!this._useGlobalReplacement) {
            PhysicalResource parent;
            if (this._modelRelationships.hasParent(resourceObject) && (parent = this._modelRelationships.getParent(resourceObject)) != null && !this._modelRelationships.isTopLevelObject(parent)) {
                this._objects.addFirst(parent);
                this.geBasicResourceMapping(parent);
                this.addRelationshipObjects(parent);
            }
            if (!this._objects.contains(resourceObject)) {
                this._objects.addFirst(resourceObject);
            }
        }
    }

    private void geBasicResourceMapping(PhysicalResource resourceObject) throws MetadataException {
        BasicResource basicResource = this._mappingMgr.getMappedBasicResource(resourceObject);
        if (basicResource != null) {
            this._omaToBasicResourceMapping.addMapping(basicResource, resourceObject);
            this._mappingMgr.addMapping(this);
        }
    }

    @Override
    public Object getMainReferenceObject() {
        return this._mainResourceObject;
    }

    @Override
    public List getReferenceObjects() {
        return Collections.unmodifiableList(this._objects);
    }

    public BasicResource getBasicResource(PhysicalResource omaResource) {
        BasicResource returnObject = null;
        if (this._objects.contains(omaResource)) {
            returnObject = this._omaToBasicResourceMapping.getSourceObject(omaResource);
        }
        return returnObject;
    }

    @Override
    public List getBasicResources() {
        ArrayList<BasicResource> returnList = new ArrayList<BasicResource>();
        for (PhysicalResource omaObject : this._objects) {
            BasicResource basicResource = this._omaToBasicResourceMapping.getSourceObject(omaObject);
            returnList.add(basicResource);
        }
        return returnList;
    }

    @Override
    public Object getReferenceObject(BasicResource basicResource) {
        PhysicalResource returnValue = this._omaToBasicResourceMapping.getTargetObject(basicResource);
        return returnValue;
    }

    @Override
    public BasicResource getMainBasicResource() {
        return this.getBasicResource(this.getMainReferenceObject());
    }

    @Override
    public BasicResource getBasicResource(Object referenceObject) {
        BasicResource returnValue = null;
        if (referenceObject instanceof PhysicalResource) {
            returnValue = this.getBasicResource((PhysicalResource)referenceObject);
        }
        return returnValue;
    }

    @Override
    public ReplacementMediator2 getMediator() {
        int numOfMediators;
        if (this._mediatorList == null) {
            this.populateMediatorList();
        }
        return (numOfMediators = this._mediatorList.size()) == 0 ? null : (ReplacementMediator2)this._mediatorList.get(numOfMediators - 1);
    }

    public List getMediatorList() {
        if (this._mediatorList == null) {
            this.populateMediatorList();
        }
        return this._mediatorList;
    }

    private void populateMediatorList() {
        this._mediatorList = new ArrayList();
        List basicResources = this.getBasicResources();
        Collections.sort(basicResources, this._basicResourceRelationships.getTypeComparator());
        int numOfbrs = basicResources.size();
        BasicResource last = (BasicResource)basicResources.get(numOfbrs - 1);
        ExternalResourceType originatingType = ExternalResourceType.getType((PhysicalResource)this.getReferenceObject(last));
        BasicResourceReplacementMediator2 lastMediator = null;
        for (int index = 0; index < numOfbrs; ++index) {
            BasicResource lo = (BasicResource)basicResources.get(index);
            PhysicalResource pResource = (PhysicalResource)this.getReferenceObject(lo);
            ExternalResourceType type = ExternalResourceType.getType(pResource);
            BasicResourceReplacementMediator2 mediator = BasicResourceReplacementMediator2.getInstance(originatingType, lo, this._basicResourceRelationships, this._replacementResourceToResourceMappings, type, this._mappingMgr, this._logger);
            this._mediatorList.add(mediator);
            if (lastMediator != null) {
                lastMediator.addChildMediator(mediator);
            }
            lastMediator = mediator;
        }
    }
}

