/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.ReferenceToBasicResourceMapping2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedEvent;
import com.sas.iquery.metadata.resourceutil.physical.ReplacementMediator2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

final class LogicalTableReplacementMediator2
extends LogicalResourceReplacementMediator2 {
    private List _sourceMediators = null;

    LogicalTableReplacementMediator2(BasicResource source, BasicResourceRelationshipUtility2 relationships, BasicResourceReplacementMapping replacements, ExternalResourceType type, ModelResourceToBasicResourcelMappingManager2 mgr, Logger logger) {
        super(source, relationships, replacements, type, mgr, logger);
    }

    @Override
    protected void populateReplacements() throws MetadataException {
        ArrayList<LogicalTableBasicResource> replacements = new ArrayList<LogicalTableBasicResource>();
        if (this._sourceMediators == null || this._sourceMediators.isEmpty()) {
            Collection sourceTables = this._origMapping.getBasicResourceForType(ExternalResourceType.Table);
            this._sourceMediators = new ArrayList(sourceTables.size());
            for (BasicResource br : sourceTables) {
                ReplacementMediator2 mediator;
                ReferenceToBasicResourceMapping2 ref = this._origMapping.getReferenceToBasicResourceMapping(br);
                if (ref == null || (mediator = ref.getMediator()) == null) continue;
                this._sourceMediators.add(mediator);
            }
        }
        if (this._sourceMediators != null && !this._sourceMediators.isEmpty()) {
            BasicResource targetParent = this._parent.getReplacementObject();
            int numOfMediators = this._sourceMediators.size();
            for (int index = 0; index < numOfMediators; ++index) {
                BasicResource ttParent;
                BasicResourceReplacementMediator2 mediator = (BasicResourceReplacementMediator2)this._sourceMediators.get(index);
                BasicResource tTable = mediator.getReplacementObject();
                if (tTable == null || (ttParent = this._relationships.getParent(tTable)) == null || !ttParent.equals(targetParent)) continue;
                LogicalTableBasicResource rTable = new LogicalTableBasicResource(tTable, mediator);
                replacements.add(rTable);
            }
        }
        this._replacementList = replacements;
        Collections.sort(this._replacementList, this._basicResourceComparator);
        if (this._logger != null && this._logger.isTraceEnabled()) {
            this._logger.debug("\tReplacement list populated for logical library " + this.getSourceObject().getLabel());
        }
    }

    @Override
    public void updateLocalChildren(MappingChangedEvent event) throws MetadataException {
        BasicResource replacementTarget = this.getReplacementObject();
        this.populateReplacements();
        BasicResourceReplacementMediator2 globalSource = (BasicResourceReplacementMediator2)event.getSource();
        ExternalResourceType sourceEventType = globalSource.getObjectType();
        if (sourceEventType == ExternalResourceType.Table) {
            if (this.getSourceObject().equals(globalSource.getSourceObject())) {
                replacementTarget = globalSource.getReplacementObject();
                if (replacementTarget != null) {
                    this._replacementObjectIndex = -1;
                    int foundIndex = -1;
                    int numOfreplacments = this._replacementList.size();
                    for (int index = 0; index < numOfreplacments && foundIndex == -1; ++index) {
                        LogicalTableBasicResource replacment = (LogicalTableBasicResource)this._replacementList.get(index);
                        BasicResourceReplacementMediator2 modMediator = replacment.getModifyingMediator();
                        if (modMediator != globalSource) continue;
                        foundIndex = index;
                    }
                    this.setReplacementObjectIndex(foundIndex);
                } else {
                    this.setReplacementObjectIndex(-1);
                }
            } else {
                this.setReplacementObject(replacementTarget);
            }
        } else {
            this.setReplacementObject(replacementTarget);
        }
    }

    @Override
    public void setReplacementObject(BasicResource repObj) throws MetadataException {
        if (repObj == null) {
            this.setReplacementObjectIndex(-1);
        } else {
            PhysicalResource phyRes;
            List replacements = this.getReplacementObjects();
            boolean found = false;
            BasicResource replacement = null;
            boolean useModifyingMediatorSource = false;
            if (!(repObj instanceof LogicalTableBasicResource) && (phyRes = repObj.getPhysicalResource()) instanceof DataSourceTable) {
                useModifyingMediatorSource = true;
            }
            Iterator iter = replacements.iterator();
            while (iter.hasNext()) {
                BasicResource rbr = null;
                BasicResource lo = (BasicResource)iter.next();
                rbr = useModifyingMediatorSource ? ((LogicalTableBasicResource)lo).getModifyingMediator().getSourceObject() : lo;
                if (!this._relationships.isEqual(rbr, repObj, false)) continue;
                if (!found) {
                    found = true;
                    replacement = lo;
                    continue;
                }
                replacement = null;
            }
            if (found && replacement != null) {
                int index = this._replacementList.indexOf(replacement);
                this.setReplacementObjectIndex(index);
            } else {
                this.setReplacementObjectIndex(-1);
            }
        }
    }

    public static final class LogicalTableBasicResource
    extends BasicResource {
        private BasicResource _underlineBasicResource = null;
        private BasicResourceReplacementMediator2 _modifyingMediator = null;

        LogicalTableBasicResource(BasicResource underlineBasicResource, BasicResourceReplacementMediator2 modifyingMediator) throws MetadataException {
            super(underlineBasicResource.getPhysicalResource());
            this._underlineBasicResource = underlineBasicResource;
            this._modifyingMediator = modifyingMediator;
        }

        public BasicResource getUnderlyingResource() {
            return this._underlineBasicResource;
        }

        public BasicResourceReplacementMediator2 getModifyingMediator() {
            return this._modifyingMediator;
        }

        @Override
        public boolean equals(Object obj) {
            boolean isEq = super.equals(obj);
            if (isEq && obj instanceof LogicalTableBasicResource) {
                LogicalTableBasicResource rhsLTBR = (LogicalTableBasicResource)obj;
                isEq = IQModelImplUtilities.same(rhsLTBR._modifyingMediator, this._modifyingMediator);
            }
            return isEq;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public String getLabel() {
            return this._modifyingMediator.getSourceObject().getLabel();
        }
    }
}

