/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.GlobalMappingChangedListener;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedEvent;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class LogicalLibraryReplacementMediator2
extends LogicalResourceReplacementMediator2 {
    private static final Logger _clsLogger = LogManager.getLogger(LogicalLibraryReplacementMediator2.class);

    LogicalLibraryReplacementMediator2(BasicResource source, BasicResourceRelationshipUtility2 relationships, BasicResourceReplacementMapping replacements, ExternalResourceType type, ModelResourceToBasicResourcelMappingManager2 mgr, Logger logger) {
        super(source, relationships, replacements, type, mgr, logger);
    }

    @Override
    protected void populateReplacements() throws MetadataException {
        ArrayList<BasicResource> replacements = new ArrayList<BasicResource>();
        List mediators = null;
        if (this._parent != null) {
            mediators = this._parent.getChildren();
        }
        if (mediators != null) {
            int numOfMediators = mediators.size();
            for (int index = 0; index < numOfMediators; ++index) {
                BasicResource replacement;
                BasicResourceReplacementMediator2 mediator = (BasicResourceReplacementMediator2)mediators.get(index);
                ExternalResourceType mediatorType = mediator.getObjectType();
                if (mediatorType != ExternalResourceType.Library || mediator instanceof LogicalResourceReplacementMediator2 || (replacement = mediator.getReplacementObject()) == null || replacements.contains(replacement)) continue;
                replacements.add(replacement);
            }
        }
        this._replacementList = replacements;
        Collections.sort(this._replacementList, this._basicResourceComparator);
        if (this._logger != null && this._logger.isTraceEnabled()) {
            this._logger.trace("\tReplacement list populated for logical library " + this.getSourceObject().getLabel());
        }
    }

    @Override
    public void updateFromGlobalChange(MappingChangedEvent event) throws MetadataException {
        if (this._parent != null) {
            this.disableListeners();
            BasicResource replacementTarget = this.getReplacementObject();
            this.populateReplacements();
            BasicResourceReplacementMediator2 globalSource = (BasicResourceReplacementMediator2)event.getSource();
            ExternalResourceType sourceEventType = globalSource.getObjectType();
            if (sourceEventType == ExternalResourceType.Table) {
                BasicResourceReplacementMediator2 childTable;
                BasicResource childTableSource;
                if (this._children.size() == 1 && (childTableSource = (childTable = (BasicResourceReplacementMediator2)this._children.get(0)).getSourceObject()).equals(globalSource.getSourceObject())) {
                    replacementTarget = globalSource.getParent().getReplacementObject();
                }
            } else if (sourceEventType == ExternalResourceType.Library) {
                if (this.getSourceObject().equals(globalSource.getSourceObject())) {
                    replacementTarget = globalSource.getReplacementObject();
                }
            } else if (sourceEventType == ExternalResourceType.WorkspaceServer) {
                replacementTarget = this._replacements.getTargetObject(this.getSourceObject());
            }
            if (replacementTarget == null) {
                this.setReplacementObjectIndex(-1);
            } else {
                this.setReplacementObject(replacementTarget);
            }
            this.enableListeners();
        }
    }

    @Override
    public void updateLocalChildren(MappingChangedEvent event) throws MetadataException {
        if (this._parent != null) {
            int numOfChildren = this._children.size();
            for (int index = 0; index < numOfChildren; ++index) {
                ((GlobalMappingChangedListener)this._children.get(index)).updateLocalChildren(event);
            }
            if (this._listnersEnabled && this._listenerList != null) {
                MappingChangedEvent logicalLibEvent = event = new MappingChangedEvent(this);
                int listenerCount = this._listenerList.size();
                for (int i = 0; i < listenerCount; ++i) {
                    MappingChangedListener listener = (MappingChangedListener)this._listenerList.get(i);
                    if (listener instanceof LogicalResourceReplacementMediator2 || !_clsLogger.isDebugEnabled()) continue;
                    _clsLogger.debug("\t\tFired event to child: " + listener);
                }
            }
        }
    }
}

