/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalTableReplacementMediator2;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.Logger;

final class LogicalColumnReplacementMediator2
extends LogicalResourceReplacementMediator2 {
    LogicalColumnReplacementMediator2(BasicResource source, BasicResourceRelationshipUtility2 relationships, BasicResourceReplacementMapping replacements, ExternalResourceType type, ModelResourceToBasicResourcelMappingManager2 mgr, Logger logger) {
        super(source, relationships, replacements, type, mgr, logger);
    }

    @Override
    protected void populateReplacements() throws MetadataException {
        BasicResource targetParent = this._parent.getReplacementObject();
        List replacements = null;
        if (targetParent instanceof LogicalTableReplacementMediator2.LogicalTableBasicResource) {
            LogicalTableReplacementMediator2.LogicalTableBasicResource ltbr = (LogicalTableReplacementMediator2.LogicalTableBasicResource)targetParent;
            replacements = this._relationships.getChildren(ltbr.getUnderlyingResource(), this._type, this.getSourceObject());
        } else {
            replacements = this._relationships.getChildren(targetParent, this._type, this.getSourceObject());
        }
        if (replacements != null) {
            this.performColumnManagement(targetParent, replacements);
            this._replacementList = replacements;
            Collections.sort(this._replacementList, this._basicResourceComparator);
            if (this._logger != null && this._logger.isTraceEnabled()) {
                this._logger.trace("\tReplacement list populated for logical library " + this.getSourceObject().getLabel());
            }
        }
    }

    private void performColumnManagement(BasicResource targetParentTable, List columns) throws MetadataException {
        if (!columns.isEmpty()) {
            List omittedCols;
            DataSourceTable table;
            ColumnManager colMgr;
            BasicResource sourceParent = null;
            if (targetParentTable instanceof LogicalTableReplacementMediator2.LogicalTableBasicResource) {
                LogicalTableReplacementMediator2.LogicalTableBasicResource ltbr = (LogicalTableReplacementMediator2.LogicalTableBasicResource)targetParentTable;
                sourceParent = ltbr.getModifyingMediator().getSourceObject();
            } else {
                sourceParent = this._replacements.getSourceObject(targetParentTable);
            }
            PhysicalResource phyRes = sourceParent.getPhysicalResource();
            if (phyRes instanceof DataSourceTable && (colMgr = (table = (DataSourceTable)phyRes).getColumnMgr()) != null && table.getColumnsAreManaged() && !(omittedCols = colMgr.getOmittedColumns()).isEmpty()) {
                int numOfOmitCols = omittedCols.size();
                ListIterator it = columns.listIterator();
                block0: while (it.hasNext()) {
                    BasicResource brQC = (BasicResource)it.next();
                    PhysicalResource prQC = brQC.getPhysicalResource();
                    for (int index = 0; index < numOfOmitCols; ++index) {
                        ResourceRelationshipInterface oqc = (ResourceRelationshipInterface)omittedCols.get(index);
                        if (!oqc.isPhysicallyEquivalent(prQC)) continue;
                        it.remove();
                        continue block0;
                    }
                }
            }
        }
    }
}

