/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.DataSourceCubeImpl;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.IntermediateSource;
import com.sas.iquery.metadata.business.impl.QualifiedColumnImpl;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASOlapServer;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.MediatedResourceManager2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.LogicalColumnReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalTableReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTargetInformation2;
import com.sas.iquery.metadata.resourceutil.physical.ReplacementMediator2;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSourceReplacementMediator2 {
    private Map _physicalResourceToDataSourceListMapping = null;
    private Map _physicalResourceGlobalReplacementMapping = null;
    private List _originalDataSourceResources = null;
    private InformationMap _map = null;
    private List<Reason> _reasonsUnableToProcess = new ArrayList<Reason>();
    private Logger _logger = null;
    private MediatedResourceManager2 _mediatedResourceManager = null;
    private PhysicalResourceTargetInformation2 _physicalResourceTargetInformation = null;
    private boolean _dataSourcesValidated = false;

    public DataSourceReplacementMediator2(InformationMap map, List dataSourceResources, Logger logger, MediatedResourceManager2 mrm) throws MetadataException {
        this._originalDataSourceResources = dataSourceResources;
        this._map = map;
        this._logger = logger;
        this._physicalResourceToDataSourceListMapping = new HashMap();
        this._mediatedResourceManager = mrm;
        this._physicalResourceTargetInformation = new PhysicalResourceTargetInformation2(mrm, this._logger);
        this.createPhysicalResourceGlobalReplacementMapping();
        this.createDataSourceMappings();
    }

    private void createPhysicalResourceGlobalReplacementMapping() {
        this._physicalResourceGlobalReplacementMapping = new IdentityHashMap();
        List sources = this._physicalResourceTargetInformation.getSources();
        for (ReplacementMediator2 source : sources) {
            PhysicalResource target;
            if (!this._physicalResourceTargetInformation.isReplaced(source) || (target = this._physicalResourceTargetInformation.getGlobalMapping(source)) == null) continue;
            this._physicalResourceGlobalReplacementMapping.put(source, target);
        }
    }

    public void validateDataSources() throws MetadataException {
        this._dataSourcesValidated = true;
    }

    private void addPhysicalResourceToDataSourceListMapping(PhysicalResource source, IntermediateSource target) {
        Preconditions.ensureNonNull(target, "target");
        ArrayList<IntermediateSource> targets = (ArrayList<IntermediateSource>)this._physicalResourceToDataSourceListMapping.get(source);
        if (targets == null) {
            targets = new ArrayList<IntermediateSource>();
            targets.add(target);
            this._physicalResourceToDataSourceListMapping.put(source, targets);
        } else if (!targets.contains(target)) {
            targets.add(target);
        }
    }

    private PhysicalResource getPhysicalResource(IntermediateSource source) {
        PhysicalResource returnValue = null;
        if (source instanceof DataSourceTable) {
            Table omaTable;
            DataSourceTable dsTable = (DataSourceTable)((Object)source);
            returnValue = omaTable = dsTable.getTable();
        } else if (source instanceof QualifiedColumn) {
            QualifiedColumn qc = (QualifiedColumn)((Object)source);
            Column omaColumn = qc.getColumn();
            returnValue = omaColumn;
        }
        return returnValue;
    }

    private void createDataSourceMappings() throws MetadataException {
        for (IntermediateSource ds : this._originalDataSourceResources) {
            if (ds instanceof DataSourceTable) {
                DataSourceTable dst = (DataSourceTable)((Object)ds);
                Table table = dst.getTable();
                this.addPhysicalResourceToDataSourceListMapping(table, (IntermediateSource)((Object)dst));
                List<Column> columns = dst.getColumns();
                for (QualifiedColumn qualifiedColumn : columns) {
                    Column physicalColumn = qualifiedColumn.getColumn();
                    if (physicalColumn == null) continue;
                    this.addPhysicalResourceToDataSourceListMapping(physicalColumn, (IntermediateSource)((Object)qualifiedColumn));
                }
                continue;
            }
            if (ds instanceof DataSourceCube) {
                DataSourceCube dsc = (DataSourceCube)((Object)ds);
                Cube cube = dsc.getCube();
                this.addPhysicalResourceToDataSourceListMapping(cube, (IntermediateSource)((Object)dsc));
                continue;
            }
            if (!(ds instanceof QualifiedColumn)) continue;
            QualifiedColumn qc = (QualifiedColumn)((Object)ds);
            Column column = qc.getColumn();
            this.addPhysicalResourceToDataSourceListMapping(column, (IntermediateSource)((Object)qc));
        }
    }

    private void replaceParentPhysicalResources(List<? super Reason> successReasons) throws MetadataException {
        ArrayList resources = new ArrayList(this._physicalResourceGlobalReplacementMapping.keySet());
        Collections.sort(resources, new BasicResourceReplacementMediator2.BasicRRMediatorComparator());
        ArrayList<BasicResourceReplacementMediator2> physicalResourcesToProcess = new ArrayList<BasicResourceReplacementMediator2>();
        for (BasicResourceReplacementMediator2 sMediator : resources) {
            ExternalResourceType resourceType = sMediator.getObjectType();
            if (resourceType != ExternalResourceType.WorkspaceServer && resourceType != ExternalResourceType.RelationalSchema && resourceType != ExternalResourceType.DatabaseSchema && resourceType != ExternalResourceType.OLAPServer && resourceType != ExternalResourceType.OLAPSchema) continue;
            physicalResourcesToProcess.add(sMediator);
        }
        HashMap toProcess = new HashMap();
        for (BasicResourceReplacementMediator2 sMediator : physicalResourcesToProcess) {
            PhysicalResource sResource = sMediator.getSourceObject().getPhysicalResource();
            toProcess.put(sResource, this._physicalResourceGlobalReplacementMapping.get(sMediator));
        }
        if (this._map instanceof InformationMapImpl2) {
            ((InformationMapImpl2)this._map).processResourceReplacementChanges(toProcess, true, this._logger);
        }
        Iterator iter = physicalResourcesToProcess.iterator();
        while (iter.hasNext()) {
            this._physicalResourceGlobalReplacementMapping.remove(iter.next());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void replaceQualifiedObjects(List<? super Reason> successReasons) throws MetadataException {
        List resources = this._physicalResourceTargetInformation.getSources();
        Collections.sort(resources, new BasicResourceReplacementMediator2.BasicRRMediatorComparatorDescByType());
        HashMap toProcess = new HashMap(this._physicalResourceGlobalReplacementMapping);
        for (BasicResourceReplacementMediator2 sMediator : resources) {
            PhysicalResource sResource;
            if (sMediator instanceof LogicalResourceReplacementMediator2 || !this.isValidDataSourcePhysicalResource(sResource = sMediator.getSourceObject().getPhysicalResource())) continue;
            PhysicalResource tResource = (PhysicalResource)this._physicalResourceGlobalReplacementMapping.get(sMediator);
            if (tResource == null) {
                toProcess.remove(sMediator);
                continue;
            }
            if (sResource != tResource) {
                ArrayList<PhysicalResource> oDataSources;
                block13: {
                    oDataSources = null;
                    if (sResource instanceof IntermediateSource) {
                        PhysicalResource pr = this.getPhysicalResource((IntermediateSource)((Object)sResource));
                        if (pr != tResource) {
                            oDataSources = new ArrayList<PhysicalResource>();
                            oDataSources.add(sResource);
                            sResource = pr;
                            break block13;
                        } else {
                            toProcess.remove(sMediator);
                            continue;
                        }
                    }
                    oDataSources = this.getDataSourcesForPhysicalResource(sResource);
                }
                ArrayList<Object[]> tReplacements = new ArrayList<Object[]>();
                tReplacements.add(new Object[]{sResource, tResource});
                if (sMediator.getObjectType() == ExternalResourceType.Table) {
                    BasicResourceReplacementMediator2 pMediator = sMediator.getParent();
                    PhysicalResource prLibSource = pMediator.getSourceObject().getPhysicalResource();
                    PhysicalResource physicalResource = this._physicalResourceTargetInformation.getTarget(pMediator);
                    tReplacements.add(new Object[]{prLibSource, physicalResource});
                }
                int numOfTRes = tReplacements.size();
                if (this._logger != null) {
                    void var12_17;
                    String sourceLabel = sResource.getLabel();
                    String string = tResource.getLabel();
                    if (numOfTRes == 2) {
                        Object[] st = (Object[])tReplacements.get(1);
                        sourceLabel = ((PhysicalResource)st[0]).getLabel() + "." + sourceLabel;
                        String string2 = ((PhysicalResource)st[1]).getLabel() + "." + string;
                    }
                    this._logger.info(IQMetadataResourceBundle.getMessageString("DataSourceReplacementMediator.ReplacingDataSource.fmt.txt", sourceLabel, var12_17));
                }
                for (IntermediateSource intermediateSource : oDataSources) {
                    if (intermediateSource == tResource) continue;
                    for (int index = 0; index < numOfTRes; ++index) {
                        Object[] st = (Object[])tReplacements.get(index);
                        BusinessModelResourceReferencer dmrr = (BusinessModelResourceReferencer)((Object)intermediateSource);
                        dmrr.replaceResource((BusinessModelResource)st[0], (BusinessModelResource)st[1], this._map, true);
                    }
                }
                if (!this._physicalResourceTargetInformation.isGloballyReplaced(sMediator)) continue;
                toProcess.remove(sMediator);
                continue;
            }
            if (!this._physicalResourceTargetInformation.isGloballyReplaced(sMediator)) continue;
            toProcess.remove(sMediator);
        }
        if (this._map instanceof InformationMapImpl2) {
            HashMap map = new HashMap();
            for (BasicResourceReplacementMediator2 sMediator : toProcess.keySet()) {
                PhysicalResource sResource = sMediator.getSourceObject().getPhysicalResource();
                map.put(sResource, toProcess.get(sMediator));
            }
            ((InformationMapImpl2)this._map).processResourceReplacementChanges(map, false, this._logger);
        }
    }

    private void replaceDSCLabel(List<? super Reason> successReasons) throws MetadataException {
        List<DataSourceCubeImpl> dscs = this._map.getObjects(false, DataSourceCubeImpl.class);
        for (DataSourceCubeImpl dsCube : dscs) {
            String cubeLabel;
            String dsCubeLabel;
            Cube cube = dsCube.getCube();
            if (!cube.isOLAPCubeBuilt()) {
                Object[] msgArgs1 = new Object[]{cube.getLabel()};
                this._logger.warn(IQDataServicesResourceBundle.getMessageString("OLAPConnectionInfoUtilBadCube.fmt.txt", msgArgs1));
            }
            if ((dsCubeLabel = dsCube.getLabel()).equalsIgnoreCase(cubeLabel = cube.getLabel())) continue;
            dsCube.setLabel(cubeLabel);
        }
    }

    private void addNewDSTColumns(List dsts, List<? super Reason> successReasons) throws MetadataException {
        Map globalMediators = this._physicalResourceTargetInformation.getGlobalMediators();
        ArrayList<PhysicalResource> processedTables = new ArrayList<PhysicalResource>();
        for (BasicResourceReplacementMediator2 sMediator : globalMediators.keySet()) {
            PhysicalResource resource;
            if (ExternalResourceType.Table != sMediator.getObjectType() || !((resource = this._physicalResourceTargetInformation.getTarget(sMediator)) instanceof Table)) continue;
            Table table = (Table)resource;
            if (!processedTables.contains(table)) {
                ListIterator it = dsts.listIterator();
                while (it.hasNext()) {
                    DataSourceTableImpl2 dst = (DataSourceTableImpl2)it.next();
                    if (dst.getTable() != table) continue;
                    this.updateQualifiedColumns(dst, table);
                }
            }
            processedTables.add(resource);
        }
        processedTables.clear();
        ListIterator it = dsts.listIterator();
        while (it.hasNext()) {
            DataSourceTableImpl2 dstImpl = (DataSourceTableImpl2)it.next();
            if (dstImpl.getColumnsAreManaged()) {
                dstImpl.resyncColumnManagerColumnsWithPhysColumns(this._logger);
                List<Column> dstUsedPhysicalCols = dstImpl.getUsedPhysicalColumns();
                ColumnManager colMgr = dstImpl.getColumnMgr();
                List omittedCols = colMgr.getOmittedColumns();
                boolean oneKept = false;
                for (Column omittedCol : omittedCols) {
                    if (!dstUsedPhysicalCols.contains(omittedCol)) continue;
                    colMgr.keep(omittedCol);
                    oneKept = true;
                }
                if (oneKept) {
                    dstImpl.setColumnMgr(colMgr);
                }
            }
            dstImpl.addUnusedColumns();
        }
    }

    private void removeDSTColumns(List dsts, List<? super Reason> successReasons) throws MetadataException {
        ListIterator it = dsts.listIterator();
        while (it.hasNext()) {
            DataSourceTableImpl2 dstImpl = (DataSourceTableImpl2)it.next();
            if (dstImpl.getColumnsAreManaged()) continue;
            dstImpl.removedUnusedUnresolvedColumns();
        }
    }

    private void updateQualifiedColumns(DataSourceTableImpl2 logicalTable, Table phyTable) throws MetadataException {
        List<Column> phyColumns = phyTable.getColumns();
        List<Column> qColumns = logicalTable.getColumns();
        ListIterator<Column> qcIt = qColumns.listIterator();
        while (qcIt.hasNext()) {
            QualifiedColumnImpl qc = (QualifiedColumnImpl)qcIt.next();
            Column rPhyCol = null;
            ListIterator<Column> pcIt = phyColumns.listIterator();
            while (pcIt.hasNext() && rPhyCol == null) {
                Column pc = pcIt.next();
                if (!qc.isPhysicallyEquivalent(pc)) continue;
                rPhyCol = pc;
            }
            Column qculColumn = qc.getColumn();
            if (rPhyCol == null) {
                if (qculColumn.isUnresolved() && qculColumn.getOwningTable().equals(phyTable)) {
                    rPhyCol = qculColumn;
                } else {
                    Column column = (Column)ExternalResourceType.Column.createUnresolvedPhysicalResource();
                    if (column instanceof ResourceRelationshipInterface) {
                        ((ResourceRelationshipInterface)((Object)column)).setUnresolvedProperties(qculColumn);
                        ((ResourceRelationshipInterface)((Object)column)).setUnresolvedParentResource(phyTable);
                    }
                    rPhyCol = column;
                }
            }
            if (qculColumn == rPhyCol) continue;
            qc.replaceResource(qculColumn, rPhyCol, this._map, true);
        }
    }

    private void replaceLogicalObjects(List<? super Reason> successReasons) throws MetadataException {
        List logicalMediators = this._mediatedResourceManager.getListOfReplacementHierarchyByLowestType(ExternalResourceType.Column);
        for (List mediatorList : logicalMediators) {
            Object mediator;
            if (mediatorList.isEmpty() || !((mediator = mediatorList.get(mediatorList.size() - 1)) instanceof LogicalColumnReplacementMediator2)) continue;
            LogicalColumnReplacementMediator2 lColMediator = (LogicalColumnReplacementMediator2)mediator;
            BasicResourceReplacementMediator2 brMedParent = lColMediator.getParent();
            if (brMedParent instanceof LogicalTableReplacementMediator2) {
                DataSourceTableImpl2 tLogicalTable;
                QualifiedColumnImpl targetQC;
                LogicalTableReplacementMediator2.LogicalTableBasicResource ltbr;
                BasicResourceReplacementMediator2 brrm;
                BasicResource br;
                PhysicalResource pr;
                BasicResource targetParentTable;
                BasicResource brColSource;
                PhysicalResource prColSource;
                PhysicalResource prColTarget;
                LogicalTableReplacementMediator2 lTabMediator = (LogicalTableReplacementMediator2)brMedParent;
                BasicResource brColTarget = lColMediator.getReplacementObject();
                if (brColTarget == null || !((prColTarget = brColTarget.getPhysicalResource()) instanceof Column) || !((prColSource = (brColSource = lColMediator.getSourceObject()).getPhysicalResource()) instanceof QualifiedColumn) || !((targetParentTable = lTabMediator.getReplacementObject()) instanceof LogicalTableReplacementMediator2.LogicalTableBasicResource) || !((pr = (br = (brrm = (ltbr = (LogicalTableReplacementMediator2.LogicalTableBasicResource)targetParentTable).getModifyingMediator()).getSourceObject()).getPhysicalResource()) instanceof DataSourceTable) || prColSource.equals(targetQC = (tLogicalTable = (DataSourceTableImpl2)pr).getQualifiedColumn((Column)prColTarget))) continue;
                this.replaceQualifiedColumnInTheMap((QualifiedColumn)prColSource, targetQC);
                continue;
            }
            if (this._logger == null) continue;
            this._logger.debug(MessageFormat.format("Cannot process mediator {0} because parent mediator {1} is not a LogicalTableReplacementMediator2 (it was a {2})", lColMediator, brMedParent, brMedParent.getClass().getSimpleName()));
        }
    }

    public List<Reason> processReplacements() throws MetadataException {
        ArrayList<Reason> successReasons = new ArrayList<Reason>();
        if (!this._dataSourcesValidated) {
            this.validateDataSources();
        }
        this.logXMLChanges("Map XML: No Changes: ");
        this.replaceParentPhysicalResources(successReasons);
        this.logXMLChanges("Map XML: Server/Schema updates: ");
        this.replaceQualifiedObjects(successReasons);
        this.logXMLChanges("Map XML: Replace DS/Physical updates: ");
        StructureOfData structureOfData = this._map.getStructure();
        if (structureOfData.isRelational()) {
            List<DataSourceTableImpl2> dsts = this._map.getObjects(false, DataSourceTableImpl2.class);
            this.addNewDSTColumns(dsts, successReasons);
            this.logXMLChanges("Map XML: Add new table data source column management:  ");
            this.replaceLogicalObjects(successReasons);
            this.logXMLChanges("Map XML: Replace logical objects management:  ");
            this.removeDSTColumns(dsts, successReasons);
            this.logXMLChanges("Map XML: Remove table data source column management:  ");
        } else if (structureOfData.isOLAP()) {
            this.replaceDSCLabel(successReasons);
        }
        if (this._logger != null && this._logger.isTraceEnabled()) {
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(this._map);
            for (Reason successReason : successReasons) {
                this._logger.trace("Success Reason: " + successReason.getReasonString(viewerLocale));
            }
        }
        return successReasons;
    }

    private void replaceQualifiedColumnInTheMap(QualifiedColumn oldResource, QualifiedColumn newResource) throws MetadataException {
        List<BusinessItem> allBusinessItems = this._map.getObjects(true, BusinessItem.class);
        for (BusinessModelObject businessModelObject : allBusinessItems) {
            businessModelObject.replaceResource(oldResource, newResource, this._map, true);
        }
    }

    private void logXMLChanges(String message) {
        try {
            if (this._logger != null && this._logger.isTraceEnabled() && message != null) {
                this._logger.trace(message + this._map.toXML(0));
            }
        }
        catch (MetadataException e) {
            this._logger.trace("Could not log " + message + " because of following exception: " + e.getLocalizedMessage());
        }
    }

    private List getDataSourcesForPhysicalResource(PhysicalResource res) throws MetadataException {
        ArrayList<IntermediateSource> returnValue = null;
        if (this.isValidDataSourcePhysicalResource(res)) {
            returnValue = (ArrayList<IntermediateSource>)this._physicalResourceToDataSourceListMapping.get(res);
            if (returnValue == null) {
                returnValue = new ArrayList<IntermediateSource>();
                this._physicalResourceToDataSourceListMapping.put(res, returnValue);
            }
            boolean isRRI = false;
            if (res instanceof ResourceRelationshipInterface) {
                isRRI = true;
            }
            Iterator iter = this._originalDataSourceResources.iterator();
            while (iter.hasNext() && returnValue != null) {
                IntermediateSource ds = (IntermediateSource)iter.next();
                PhysicalResource dsPhysical = null;
                if (ds instanceof DataSourceTable) {
                    DataSourceTable dst = (DataSourceTable)((Object)ds);
                    dsPhysical = dst.getTable();
                } else if (ds instanceof DataSourceCube) {
                    DataSourceCube dsc = (DataSourceCube)((Object)ds);
                    dsPhysical = dsc.getCube();
                } else if (ds instanceof QualifiedColumn) {
                    QualifiedColumn qC = (QualifiedColumn)((Object)ds);
                    dsPhysical = qC.getColumn();
                } else {
                    throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataSourceReplacementMediator.unableToProcessType.fmt.txt", ds.getClass()));
                }
                if (dsPhysical == null) continue;
                boolean isPhyEq = false;
                if (isRRI) {
                    if (((ResourceRelationshipInterface)((Object)res)).isPhysicallyEquivalent(dsPhysical)) {
                        isPhyEq = true;
                    }
                } else if (dsPhysical instanceof ResourceRelationshipInterface && ((ResourceRelationshipInterface)((Object)dsPhysical)).isPhysicallyEquivalent(res)) {
                    isPhyEq = true;
                }
                if (!isPhyEq || !(dsPhysical instanceof ResourceRelationshipInterface)) continue;
                ResourceRelationshipInterface dsPhysicalRelation = (ResourceRelationshipInterface)((Object)dsPhysical);
                if (dsPhysicalRelation.hasParentResource()) {
                    if (!this.validateParentsEquivalent(dsPhysical, res) || returnValue.contains(ds)) continue;
                    returnValue.add(ds);
                    continue;
                }
                if (returnValue.contains(ds)) continue;
                returnValue.add(ds);
            }
            if (returnValue == null) {
                Logger log = LogManager.getLogger(this.getClass());
                log.debug("DataSourceReplacementMediator2: Unable to find DataSource for: " + res + ", Class=" + res.getClass().getName());
            }
        }
        return returnValue;
    }

    private boolean isValidDataSourcePhysicalResource(PhysicalResource res) {
        boolean returnValue = true;
        if (res instanceof SASWorkspaceServer) {
            returnValue = false;
        } else if (res instanceof SASLibrary) {
            returnValue = false;
        } else if (res instanceof SASOlapServer) {
            returnValue = false;
        } else if (res instanceof Measure) {
            returnValue = false;
        } else if (res instanceof OlapSchema) {
            returnValue = false;
        } else if (res instanceof Dimension) {
            returnValue = false;
        } else if (res instanceof Level) {
            returnValue = false;
        } else if (res instanceof Hierarchy) {
            returnValue = false;
        } else if (res instanceof JFSResource) {
            returnValue = false;
        } else if (res instanceof CalculatedMember) {
            returnValue = false;
        } else if (res instanceof NamedSet) {
            returnValue = false;
        }
        return returnValue;
    }

    private boolean validateParentsEquivalent(PhysicalResource dsPhysical, PhysicalResource res) throws MetadataException {
        boolean returnValue = false;
        if (dsPhysical == res) {
            returnValue = true;
        } else if (dsPhysical == null) {
            returnValue = false;
        } else if (res == null) {
            returnValue = false;
        } else {
            ResourceRelationshipInterface a = (ResourceRelationshipInterface)((Object)dsPhysical);
            ResourceRelationshipInterface b = (ResourceRelationshipInterface)((Object)res);
            if (a.hasParentResource()) {
                PhysicalResource aParent = a.getParentResource();
                PhysicalResource bParent = b.getParentResource();
                if (aParent != null) {
                    if (((ResourceRelationshipInterface)((Object)aParent)).isPhysicallyEquivalent(bParent)) {
                        returnValue = this.validateParentsEquivalent(aParent, bParent);
                    }
                } else if (bParent == null) {
                    returnValue = true;
                }
            } else {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public List<Reason> getReasonsUnableToProcess() throws MetadataException {
        if (!this._dataSourcesValidated) {
            this.validateDataSources();
        }
        return this._reasonsUnableToProcess;
    }
}

