/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.physical;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.ObjectReplacementInterface;
import com.sas.iquery.metadata.resourceutil.physical.DimensionReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.GlobalMappingChangedListener;
import com.sas.iquery.metadata.resourceutil.physical.InMemoryLibraryReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalColumnReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalLibraryReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.LogicalTableReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedEvent;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedListener;
import com.sas.iquery.metadata.resourceutil.physical.ReplacementMediator2;
import com.sas.metadata.remote.CMetadata;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicResourceReplacementMediator2
extends ReplacementMediator2
implements ObjectReplacementInterface,
MappingChangedListener,
GlobalMappingChangedListener {
    private static final Logger _clsLogger = LogManager.getLogger(BasicResourceReplacementMediator2.class);
    static final int REPLACEMENT_NOT_SET = -1;
    int _replacementObjectIndex = -1;
    private final BasicResource _sourceObject;
    BasicResourceReplacementMediator2 _parent;
    final List _children = new ArrayList();
    List _replacementList = null;
    ExternalResourceType _type = null;
    BasicResourceReplacementMapping _replacements = null;
    ModelResourceToBasicResourcelMappingManager2 _origMapping = null;
    Logger _logger = null;
    private boolean _globalReplacmentMediator;
    Comparator<BasicResource> _basicResourceComparator = new BasicResourceComparator();

    public static BasicResourceReplacementMediator2 getInstance(ExternalResourceType originatingType, BasicResource source, BasicResourceRelationshipUtility2 relationships, BasicResourceReplacementMapping replacements, ExternalResourceType type, ModelResourceToBasicResourcelMappingManager2 mgr, Logger logger) {
        BasicResourceReplacementMediator2 mediator = null;
        mediator = originatingType == ExternalResourceType.Column ? (type == ExternalResourceType.Library ? new LogicalLibraryReplacementMediator2(source, relationships, replacements, type, mgr, logger) : (type == ExternalResourceType.Table ? new LogicalTableReplacementMediator2(source, relationships, replacements, type, mgr, logger) : (type == ExternalResourceType.Column ? new LogicalColumnReplacementMediator2(source, relationships, replacements, type, mgr, logger) : new BasicResourceReplacementMediator2(source, relationships, replacements, type, mgr, logger)))) : (type == ExternalResourceType.Dimension ? new DimensionReplacementMediator2(source, relationships, replacements, type, mgr, logger) : (type == ExternalResourceType.Library && source.getPhysicalResource() instanceof InMemorySASLibrary ? new InMemoryLibraryReplacementMediator2(source, relationships, replacements, type, mgr, logger) : new BasicResourceReplacementMediator2(source, relationships, replacements, type, mgr, logger)));
        return mediator;
    }

    BasicResourceReplacementMediator2(BasicResource source, BasicResourceRelationshipUtility2 relationships, BasicResourceReplacementMapping replacements, ExternalResourceType type, ModelResourceToBasicResourcelMappingManager2 mgr, Logger logger) {
        super(relationships);
        this._sourceObject = source;
        this._replacements = replacements;
        this._type = type;
        this._origMapping = mgr;
        this._logger = logger;
    }

    public void setReplacementObjectIndex(int replacementObjectIndex) throws MetadataException {
        boolean changed;
        boolean bl = changed = this._replacementObjectIndex != replacementObjectIndex;
        if (changed) {
            if (this._replacementList != null && this._replacementList.size() > 0) {
                if (replacementObjectIndex > -1 && replacementObjectIndex < this._replacementList.size()) {
                    this._replacementObjectIndex = replacementObjectIndex;
                    if (this._globalReplacmentMediator) {
                        this._replacements.addMapping(this._sourceObject, this.getReplacementObject());
                    }
                    if (_clsLogger.isDebugEnabled()) {
                        _clsLogger.debug("Setting Replacement based on index=" + replacementObjectIndex + ", object=" + this.toString());
                    }
                } else {
                    this._replacementObjectIndex = -1;
                    if (this._globalReplacmentMediator) {
                        this._replacements.removeMapping(this._sourceObject);
                    }
                    if (_clsLogger.isDebugEnabled()) {
                        _clsLogger.debug("Unsetting Replacement based on index=" + replacementObjectIndex + ", object=" + this.toString());
                    }
                }
            } else {
                this._replacementObjectIndex = -1;
                if (this._globalReplacmentMediator) {
                    this._replacements.removeMapping(this._sourceObject);
                }
                if (_clsLogger.isDebugEnabled()) {
                    _clsLogger.debug("Unsetting Replacement based on index=" + replacementObjectIndex + ", object=" + this.toString());
                }
            }
            this.fireUpdateChildMappingFromParent();
            if (this._globalReplacmentMediator) {
                this.fireUpdateGlobalMappingChange();
            }
        }
    }

    @Override
    public BasicResource getSourceObject() {
        return this._sourceObject;
    }

    @Override
    public BasicResource getReplacementObject() throws MetadataException {
        BasicResource returnObj = null;
        if (this._replacementObjectIndex != -1) {
            returnObj = (BasicResource)this.getReplacementObjects().get(this._replacementObjectIndex);
        }
        return returnObj;
    }

    @Override
    public List getReplacementObjects() throws MetadataException {
        ArrayList returnValues = new ArrayList();
        if (this._replacementList == null || this._replacementList.size() == 0) {
            this.populateReplacements();
        }
        if (this._replacementList != null) {
            returnValues.addAll(this._replacementList);
        }
        return returnValues;
    }

    protected void populateReplacements() throws MetadataException {
        BasicResource targetParent = null;
        List replacementRetrieved = null;
        if (this._parent == null) {
            replacementRetrieved = this._relationships.getDirectReplacementObjects(this._sourceObject);
        } else {
            targetParent = this._parent.getReplacementObject();
            replacementRetrieved = this._relationships.getChildren(targetParent, this._type, this.getSourceObject());
        }
        if (replacementRetrieved != null) {
            this._replacementList = replacementRetrieved;
            Collections.sort(this._replacementList, this._basicResourceComparator);
            if (this._logger != null && this._logger.isTraceEnabled()) {
                this._logger.trace("\tReplacement list populated for " + this.getSourceObject().getLabel());
            }
        }
    }

    @Override
    public int getReplacementObjectIndex() {
        return this._replacementObjectIndex;
    }

    @Override
    public ExternalResourceType getObjectType() {
        return this._type;
    }

    public void setReplacementEqualToSource() throws MetadataException {
        this.setReplacementObject(this.getSourceObject());
    }

    public void setReplacementObject(BasicResource in) throws MetadataException {
        List replacements = this.getReplacementObjects();
        boolean found = false;
        BasicResource replacement = null;
        for (BasicResource lo : replacements) {
            if (!this._relationships.isEqual(in, lo, false)) continue;
            if (!found) {
                found = true;
                replacement = lo;
                continue;
            }
            replacement = null;
        }
        if (found && replacement != null) {
            int index = this._replacementList.indexOf(replacement);
            this.setReplacementObjectIndex(index);
        } else {
            this.setReplacementObjectIndex(-1);
        }
    }

    @Override
    public void updateChildMappingFromParent(MappingChangedEvent event) throws MetadataException {
        this.setReplacementObjectIndex(-1);
        this.populateReplacements();
        if (this._replacementList != null && this._replacementList.size() > 0) {
            this.setReplacementObject(this.getSourceObject());
        }
    }

    public void addChildMediator(BasicResourceReplacementMediator2 childMediator) {
        if (!this._children.contains(childMediator) && ExternalResourceType.isSuitableParentType(childMediator.getObjectType(), this.getObjectType())) {
            this._children.add(childMediator);
            childMediator.setParentMediator(this);
            this.addMappingChangedListener(childMediator);
        }
    }

    private void addChild(BasicResourceReplacementMediator2 childMediator) {
        if (!this._children.contains(childMediator) && ExternalResourceType.isSuitableParentType(childMediator.getObjectType(), this.getObjectType())) {
            this._children.add(childMediator);
            this.addMappingChangedListener(childMediator);
        }
    }

    private void setParentMediator(BasicResourceReplacementMediator2 parentMediator) {
        if (parentMediator != null && ExternalResourceType.isSuitableParentType(this.getObjectType(), parentMediator.getObjectType())) {
            this._parent = parentMediator;
            this._parent.addChild(this);
        }
    }

    public BasicResourceReplacementMediator2 getParent() {
        return this._parent;
    }

    public void setParent(BasicResourceReplacementMediator2 parent) {
        this.setParentMediator(parent);
    }

    public List getChildren() {
        return this._children;
    }

    public String toString() {
        String returnValue = this._toString();
        if (this._sourceObject != null) {
            returnValue = returnValue + "={" + this._sourceObject.getLabel() + ", Id=" + this._sourceObject.getId() + ", Type=" + this._type + "}";
        }
        return returnValue;
    }

    String _toString() {
        String returnValue = "BRRM";
        if (this._globalReplacmentMediator) {
            returnValue = returnValue + "_GLOBAL";
        }
        return returnValue;
    }

    public BasicResource getSourceObjectParent() throws MetadataException {
        return this._relationships.getParent(this.getSourceObject());
    }

    public PhysicalResource[] getMappingValue() throws MetadataException {
        PhysicalResource phyTarget;
        BasicResource target;
        PhysicalResource[] returnValue = new PhysicalResource[2];
        PhysicalResource source = this._origMapping.getPhysicalResourceMapping(this.getSourceObject());
        if (source != null) {
            returnValue[0] = source;
        }
        if ((target = this.getReplacementObject()) != null && (phyTarget = this._origMapping.getPhysicalResourceMapping(target)) != null) {
            returnValue[1] = phyTarget;
        }
        return returnValue;
    }

    public boolean isResolved() throws MetadataException {
        boolean returnValue = true;
        if (this._sourceObject != null && this._sourceObject.isUnresolved()) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean isUnmatched() throws MetadataException {
        boolean returnValue = true;
        BasicResource replacement = this.getReplacementObject();
        if (replacement != null) {
            returnValue = false;
        }
        return returnValue;
    }

    public PhysicalResource getPhysicalSourceObject() throws MetadataException {
        return this._origMapping.getPhysicalResourceMapping(this.getSourceObject());
    }

    public void setReplacmentByName(String newResourceName, Object underlyingOMAObject) throws MetadataException {
        CMetadata uCMeta;
        String sourceOMAObjID = null;
        String sourceType = null;
        if (underlyingOMAObject instanceof CMetadata) {
            uCMeta = (CMetadata)underlyingOMAObject;
            try {
                sourceOMAObjID = uCMeta.getId();
                sourceType = uCMeta.getCMetadataType();
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        } else if (underlyingOMAObject instanceof com.sas.metadata.CMetadata) {
            uCMeta = (com.sas.metadata.CMetadata)underlyingOMAObject;
            sourceOMAObjID = uCMeta.getId();
            sourceType = uCMeta.getCMetadataType();
        }
        int foundIndex = -1;
        BasicResource targetObj = null;
        List replacements = this.getReplacementObjects();
        int numOfReplacements = replacements.size();
        for (int index = 0; index < numOfReplacements; ++index) {
            BasicResource obj = (BasicResource)replacements.get(index);
            PhysicalResource target = this._origMapping.getPhysicalResourceMapping(obj);
            if (underlyingOMAObject != null && target instanceof OMAResource) {
                OMAResource oTarget = (OMAResource)target;
                Object targetOMA = null;
                targetOMA = oTarget instanceof OMASoftwareServer ? ((OMASoftwareServer)oTarget).getServerContext() : oTarget.getOMAObject();
                try {
                    if (!sourceOMAObjID.equals(targetOMA.getId())) continue;
                    foundIndex = index;
                    targetObj = obj;
                    break;
                }
                catch (RemoteException e) {
                    throw new MetadataException(e);
                }
            }
            if (!target.getLabel().equals(newResourceName)) continue;
            if (foundIndex != -1) {
                targetObj = null;
                continue;
            }
            foundIndex = index;
            targetObj = obj;
        }
        if (targetObj != null || underlyingOMAObject != null) {
            // empty if block
        }
        if (targetObj != null) {
            this.setReplacementObjectIndex(foundIndex);
        }
        if (targetObj == null && this._logger.isEnabled(Level.WARN)) {
            String message;
            String tType = this._type.getOMRType();
            if (tType == null) {
                tType = this._type.getPublicType();
            }
            String sMsg = this.getSourceObject().getPhysicalResource().getLabel() + " (" + tType + ")";
            String tMsg = newResourceName;
            if (sourceType != null) {
                newResourceName = newResourceName + " (" + sourceType + ")";
            }
            if (foundIndex == -1) {
                message = IQModelImplUtilities.getMessage("BasicResourceReplacementMediator.replacementNotFound.fmt.txt", sMsg, tMsg);
                this._logger.warn(message);
            } else {
                message = "Duplicated target objects found (Source: " + sMsg + " Target: " + tMsg + ")";
                this._logger.warn(message);
            }
        }
    }

    public void setReplacmentFromSource(PhysicalResource sourceObject) throws MetadataException {
        BasicResource targetObj = null;
        if (sourceObject instanceof ResourceRelationshipInterface) {
            ResourceRelationshipInterface source = (ResourceRelationshipInterface)((Object)sourceObject);
            List replacements = this.getReplacementObjects();
            boolean found = false;
            for (BasicResource obj : replacements) {
                PhysicalResource target = this._origMapping.getPhysicalResourceMapping(obj);
                if (!source.isPhysicallyEquivalent(target)) continue;
                if (found) {
                    targetObj = null;
                    continue;
                }
                found = true;
                targetObj = obj;
            }
        }
        if (targetObj != null) {
            this.setReplacementObject(targetObj);
        } else if (this._logger.isTraceEnabled()) {
            String message = IQModelImplUtilities.getMessage("BasicResourceReplacementMediator.replacementNotFound.fmt.txt", this, sourceObject);
            this._logger.trace(message);
        }
    }

    public void setReplacementByPath(String path) throws MetadataException {
        List replacements = this.getReplacementObjects();
        boolean found = false;
        BasicResource targetObj = null;
        for (BasicResource obj : replacements) {
            JFSResource tRes;
            String tResLocation;
            PhysicalResource target = this._origMapping.getPhysicalResourceMapping(obj);
            if (!(target instanceof JFSResource) || (tResLocation = (tRes = (JFSResource)target).getLocation()) == null || !tResLocation.equals(path)) continue;
            if (found) {
                targetObj = null;
                continue;
            }
            found = true;
            targetObj = obj;
        }
        if (targetObj != null) {
            this.setReplacementObject(targetObj);
        }
        if (!found && _clsLogger.isDebugEnabled()) {
            String message = IQModelImplUtilities.getMessage("BasicResourceReplacementMediator.replacementNotFound.fmt.txt", this, path);
            _clsLogger.debug(message);
        }
    }

    public boolean isGlobalReplacementMediator() {
        return this._globalReplacmentMediator;
    }

    public void setGlobalReplacmentMediator(boolean globalReplacmentMediator) {
        this._globalReplacmentMediator = globalReplacmentMediator;
    }

    @Override
    public void updateFromGlobalChange(MappingChangedEvent event) throws MetadataException {
        BasicResourceReplacementMediator2 globalSource = (BasicResourceReplacementMediator2)event.getSource();
        int index = globalSource.getReplacementObjectIndex();
        boolean sameTargetSet = this.isGlobalTargetSameAsLocal(globalSource);
        if (index != -1 && !sameTargetSet) {
            this.disableListeners();
            if (this._replacementList == null || this._replacementList.size() < index) {
                this._replacementList = globalSource.getReplacementObjects();
                Collections.sort(this._replacementList, this._basicResourceComparator);
            }
            this.setReplacementObjectIndex(index);
            this.enableListeners();
        }
    }

    private boolean isGlobalTargetSameAsLocal(BasicResourceReplacementMediator2 globalSource) throws MetadataException {
        boolean sameSource = false;
        BasicResource globalTarget = globalSource.getReplacementObject();
        BasicResource localTarget = this.getReplacementObject();
        if (globalTarget != null && globalTarget.equals(localTarget)) {
            sameSource = true;
        }
        return sameSource;
    }

    @Override
    public void updateLocalChildren(MappingChangedEvent event) throws MetadataException {
        BasicResourceReplacementMediator2 globalSource = (BasicResourceReplacementMediator2)event.getSource();
        int index = globalSource.getReplacementObjectIndex();
        if (index != -1) {
            this.fireUpdateChildMappingFromParent();
            if (this.isGlobalReplacementMediator()) {
                this.fireUpdateGlobalMappingChange();
            }
        }
    }

    public void setBasicResourceComparator(Comparator basicResourceComparator) {
        this._basicResourceComparator = basicResourceComparator;
    }

    public boolean isUnresolvedTargetNeeded() throws MetadataException {
        PhysicalResource source;
        boolean needed = false;
        if (this.isUnmatched() && this._parent != null && !((source = this.getSourceObject().getPhysicalResource()) instanceof InMemoryQueryTable)) {
            needed = this._parent.hasHierarchyChanged();
        }
        return needed;
    }

    private boolean hasHierarchyChanged() throws MetadataException {
        boolean changed = false;
        BasicResource replacement = this.getReplacementObject();
        if (replacement != this._sourceObject) {
            changed = true;
        } else if (this._parent != null) {
            changed = this._parent.hasHierarchyChanged();
        }
        return changed;
    }

    static class BasicRRMediatorComparatorDescByType
    implements Comparator<BasicResourceReplacementMediator2> {
        BasicRRMediatorComparatorDescByType() {
        }

        @Override
        public int compare(BasicResourceReplacementMediator2 o1, BasicResourceReplacementMediator2 o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int objectTypeComparison = o1.getObjectType().compareTo(o2.getObjectType());
            if ((objectTypeComparison = -objectTypeComparison) == 0) {
                String label2;
                String label1 = o1.getSourceObject().getLabel();
                if (label1 == (label2 = o2.getSourceObject().getLabel())) {
                    return 0;
                }
                if (label1 == null) {
                    return -1;
                }
                if (label2 == null) {
                    return 1;
                }
                int labelComparison = label1.compareTo(label2);
                return labelComparison;
            }
            return objectTypeComparison;
        }
    }

    static class BasicRRMediatorComparator
    implements Comparator<BasicResourceReplacementMediator2> {
        BasicRRMediatorComparator() {
        }

        @Override
        public int compare(BasicResourceReplacementMediator2 o1, BasicResourceReplacementMediator2 o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int objectTypeComparison = o1.getObjectType().compareTo(o2.getObjectType());
            if (objectTypeComparison == 0) {
                String label2;
                String label1 = o1.getSourceObject().getLabel();
                if (label1 == (label2 = o2.getSourceObject().getLabel())) {
                    return 0;
                }
                if (label1 == null) {
                    return -1;
                }
                if (label2 == null) {
                    return 1;
                }
                int labelComparison = label1.compareTo(label2);
                return labelComparison;
            }
            return objectTypeComparison;
        }
    }

    private static class BasicResourceComparator
    implements Comparator<BasicResource> {
        private BasicResourceComparator() {
        }

        @Override
        public int compare(BasicResource arg0, BasicResource arg1) {
            int returnValue = -1;
            if (IQModelImplUtilities.same(arg0, arg1)) {
                returnValue = 0;
            } else {
                BasicResource br1 = arg0;
                BasicResource br2 = arg1;
                returnValue = br1.compareTo(br2);
            }
            return returnValue;
        }
    }
}

