/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.util;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.resourceutil.memberRepair.FilterType;
import com.sas.iquery.metadata.resourceutil.memberRepair.OLAPMemberRepairElementInterface;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanMapMembers;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanReportMembers;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolBase;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.ToolsUtility;
import com.sas.iquery.metadata.resourceutil.memberRepair.util.OLAPMemberRemovalElement;
import com.sas.iquery.metadata.resourceutil.memberRepair.util.OLAPMemberRemovalUtilityContainer;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPMemberRemovalUtility {
    private static ToolsUtility _toolUtility = null;
    private static OLAPMemberRemovalUtility _olapRepairUtil = null;
    private static OLAPMemberRemovalUtilityContainer removalResultsContainer = null;
    private static final Logger _logger = LogManager.getLogger(OLAPMemberRemovalUtility.class);

    public OLAPMemberRemovalUtility() {
        if (_toolUtility == null) {
            _toolUtility = ToolsUtility.getInstance();
        }
        removalResultsContainer = new OLAPMemberRemovalUtilityContainer();
    }

    public OLAPMemberRemovalUtilityContainer analyzeRemove(BusinessQuery query) throws IQueryServicesException {
        String id;
        if (!(query instanceof BusinessQuery)) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(query.toString());
            }
            throw new IQueryServicesException(IQDataServicesResourceBundle.getStringResource("MemberRepairAnalyzerOnlyBusinessModel.txt"));
        }
        removalResultsContainer.setBusinessModel((BusinessModel)((Object)query));
        BusinessModel model = (BusinessModel)((Object)query);
        BusinessModel mapModel = query.getBusinessModel().getBaseModel();
        String mapName = "No Map Found";
        ArrayList<OLAPMemberRemovalElement> elements = new ArrayList<OLAPMemberRemovalElement>();
        OrphanToolBase tool = null;
        OrphanToolBase tool2 = null;
        if (mapModel instanceof InformationMap) {
            InformationMap map = (InformationMap)mapModel;
            removalResultsContainer.setMap(map);
            Class<OrphanMapMembers> classIn = OrphanMapMembers.class;
            tool = (OrphanMapMembers)_toolUtility.getRequestTool(classIn);
            if (tool != null) {
                ((OrphanMapMembers)tool).analyze(mapModel);
                for (OLAPMemberRepairElementInterface mRepairInterface : tool.getOrphans()) {
                    OLAPMemberRemovalElement olapUnrElement = new OLAPMemberRemovalElement(mRepairInterface.getOrphanedMembers(), mRepairInterface.getBusinessItem(), false, mRepairInterface.getType(), mapModel);
                    elements.add(olapUnrElement);
                    id = "No id";
                    id = mRepairInterface.getBusinessItem() == null ? mapModel.getIdentityString() : mRepairInterface.getBusinessItem().getIdentityString();
                    String filterType = this.getFilterTypeString(mRepairInterface);
                    MDXGenerationUtil.applyDebugStatement("Unresolved " + filterType + " " + id + " in " + mapName, OLAPMemberRemovalUtility.class);
                }
                if (tool.getOrphans().size() == 0) {
                    MDXGenerationUtil.applyDebugStatement("No stale members in information map were found, no repair of map is necessary", OLAPMemberRemovalUtility.class);
                } else {
                    ((OrphanMapMembers)tool).repair();
                }
            }
        }
        if (model instanceof LookThroughDataSelection) {
            throw new IllegalArgumentException("Model can not be a child data selection.");
        }
        if (model instanceof DataSelection) {
            Class<OrphanReportMembers> classIn2 = OrphanReportMembers.class;
            tool2 = (OrphanReportMembers)_toolUtility.getRequestTool(classIn2);
            ((OrphanReportMembers)tool2).analyze(model);
            for (OLAPMemberRepairElementInterface mRepairInterface : tool2.getOrphans()) {
                OLAPMemberRemovalElement removeElement = new OLAPMemberRemovalElement(mRepairInterface.getOrphanedMembers(), mRepairInterface.getBusinessItem(), true, mRepairInterface.getType(), model);
                elements.add(removeElement);
                String filterType = this.getFilterTypeString(mRepairInterface);
                id = "No id";
                id = mRepairInterface.getBusinessItem() == null ? model.getIdentityString() : mRepairInterface.getBusinessItem().getIdentityString();
                MDXGenerationUtil.applyDebugStatement("Removed " + filterType + " " + id + " in " + mapName, OLAPMemberRemovalUtility.class);
                for (String member : mRepairInterface.getOrphanedMembers()) {
                    mRepairInterface.removeValue(member);
                }
                removalResultsContainer.setElements(elements);
                if (tool2.getOrphans().size() == 0) {
                    MDXGenerationUtil.applyDebugStatement("No stale members in report were found, no repair of report is necessary", OLAPMemberRemovalUtility.class);
                } else {
                    ((OrphanReportMembers)tool2).repair();
                }
                removalResultsContainer.setBusinessModel((BusinessModel)((Object)query));
            }
        }
        if (tool != null) {
            tool.release();
        }
        if (tool2 != null) {
            tool2.release();
        }
        return removalResultsContainer;
    }

    public OLAPMemberRemovalUtilityContainer analyzeRemove(InformationMap map) throws IQueryServicesException {
        Class<OrphanMapMembers> classIn = OrphanMapMembers.class;
        removalResultsContainer.setBusinessModel(map);
        OrphanMapMembers tool2 = (OrphanMapMembers)_toolUtility.getRequestTool(classIn);
        String mapName = map.getLabel();
        removalResultsContainer.setMap(map);
        ArrayList<OLAPMemberRemovalElement> elements = new ArrayList<OLAPMemberRemovalElement>();
        try {
            tool2.analyze(map.getBaseModel());
            Iterator iterator = tool2.getOrphans().iterator();
            boolean toRepair = false;
            if (tool2.getOrphans().size() == 0) {
                MDXGenerationUtil.applyDebugStatement("No stale member string filter conditions were found after analysis, no repair is necessary", OLAPMemberRemovalUtility.class);
            } else {
                toRepair = true;
                while (iterator.hasNext()) {
                    OLAPMemberRepairElementInterface mRepairInterface = (OLAPMemberRepairElementInterface)iterator.next();
                    OLAPMemberRemovalElement olapRemoveElement = new OLAPMemberRemovalElement(mRepairInterface.getOrphanedMembers(), mRepairInterface.getBusinessItem(), true, mRepairInterface.getType(), map);
                    String filterType = this.getFilterTypeString(mRepairInterface);
                    String id = "No id";
                    id = mRepairInterface.getBusinessItem() == null ? map.getIdentityString() : mRepairInterface.getBusinessItem().getIdentityString();
                    MDXGenerationUtil.applyDebugStatement("Removed " + filterType + " " + id + " in " + mapName, OLAPMemberRemovalUtility.class);
                    for (String member : mRepairInterface.getOrphanedMembers()) {
                        mRepairInterface.removeValue(member);
                    }
                    elements.add(olapRemoveElement);
                }
                if (toRepair) {
                    tool2.repair();
                }
                removalResultsContainer.setElements(elements);
                removalResultsContainer.setBusinessModel(map);
                tool2.release();
            }
        }
        catch (Throwable t) {
            throw new IQueryServicesException(t.getLocalizedMessage());
        }
        return removalResultsContainer;
    }

    private String getFilterTypeString(OLAPMemberRepairElementInterface mRepairInterface) {
        String filterType = IQDataServicesResourceBundle.getStringResource("FilterTypeCHILD_FILTER.txt");
        if (mRepairInterface.getType().equals(FilterType.CUSTOMIZED_ITEM)) {
            filterType = IQDataServicesResourceBundle.getStringResource("FilterTypeCUSTOMIZED_ITEM.txt");
        } else if (mRepairInterface.getType().equals(FilterType.PARENT_FILTER)) {
            filterType = IQDataServicesResourceBundle.getStringResource("FilterTypePARENT_FILTER.txt");
        }
        return filterType;
    }

    public void dispose() {
        _toolUtility = null;
        _olapRepairUtil.dispose();
    }
}

