/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.resourceutil.memberRepair.FilterType;
import com.sas.iquery.metadata.resourceutil.memberRepair.OLAPMemberRepairElementInterface;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolBase;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.information.metadata.FolderInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPMemberRepairElement
implements OLAPMemberRepairElementInterface {
    public static final String REMOVE_ELEMENT = "##REMOVE#";
    private BusinessItem _associatedBusinessItem = null;
    private String _associatedFilterId = null;
    private FilterType _associatedFilterType = null;
    private FolderInterface _associatedFolder = null;
    private HashMap _listOfResolvedMembers = new HashMap();
    private List _listOfUnresolvedMembers = new ArrayList();
    private OrphanToolBase _tool = null;
    private BusinessModel _associatedBusinessModel = null;
    private Role _associatedFilterRole = null;
    private static final Logger _logger = LogManager.getLogger(OLAPMemberRepairElement.class);

    public OLAPMemberRepairElement(FilterType filterType, String filterId, String memberValue, Object busItem, OrphanToolBase tool, FolderInterface folder, BusinessModel businessModel) throws IQueryServicesException {
        this._associatedFilterId = filterId;
        this._associatedFilterType = filterType;
        this._associatedBusinessModel = businessModel;
        this._tool = tool;
        if (busItem instanceof FilterItem) {
            FilterItem fi = (FilterItem)busItem;
            this._associatedBusinessItem = fi;
        } else if (busItem instanceof DataItem) {
            DataItem di = (DataItem)busItem;
            this._associatedBusinessItem = di;
        } else if (busItem instanceof DataSelection) {
            this._associatedBusinessItem = null;
        } else {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerBadBusItem.fmt.txt", busItem.toString());
            throw new IQueryServicesException(formatter);
        }
        this.addMemberInfo(memberValue);
        this._associatedFolder = folder;
    }

    protected void addMemberInfo(String memberValue) {
        this._listOfUnresolvedMembers.add(memberValue);
    }

    protected void dispose() {
        this._listOfResolvedMembers.clear();
        this._listOfUnresolvedMembers.clear();
    }

    @Override
    public BusinessItem getBusinessItem() {
        return this._associatedBusinessItem;
    }

    @Override
    public BusinessModel getBusinessModel() {
        return this._associatedBusinessModel;
    }

    @Override
    public String getDescription() {
        String mapPath;
        StringBuilder buffer;
        block3: {
            Iterator iterator = this._listOfUnresolvedMembers.iterator();
            buffer = new StringBuilder();
            while (iterator.hasNext()) {
                buffer.append((String)iterator.next()).append(MDXGenerationUtil.NEWLINE);
            }
            mapPath = " ";
            try {
                mapPath = this._associatedFolder.getPath();
            }
            catch (RemoteException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block3;
                _logger.error(e.getLocalizedMessage());
            }
        }
        String id = "No Id";
        id = this._associatedBusinessItem == null ? this._associatedBusinessModel.getIdentityString() : (this._associatedFilterRole != null ? this._associatedBusinessItem.getIdentityString() + " " + this._associatedFilterRole.toString() : this._associatedBusinessItem.getIdentityString());
        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OrphanedItemDescription.fmt.txt", id, mapPath + " " + this.getInformationMap(), this._associatedFilterType.toString(), buffer.toString());
        return formatter.toString();
    }

    private String getDimensionHierarchy(ExpressionInterface exp, String filterLevelName) throws MetadataException {
        String dimHier = "";
        String defaultLevelName = null;
        boolean levelOnly = false;
        if (exp instanceof Dimension) {
            dimHier = ((Dimension)exp).getUniqueName();
            List<Hierarchy> hiers = ((Dimension)exp).getHierarchies();
            Hierarchy hier = hiers.get(0);
            List<Level> levels = hier.getLevels();
            int levelCount = 0;
            if (levels.size() > 1) {
                ++levelCount;
            }
            Level level = levels.get(levelCount);
            defaultLevelName = level.getLevelName();
        } else if (exp instanceof Hierarchy) {
            dimHier = ((Hierarchy)exp).getUniqueName();
            List<Level> levels = ((Hierarchy)exp).getLevels();
            int levelCount = 0;
            if (levels.size() > 1) {
                ++levelCount;
            }
            Level level = levels.get(levelCount);
            defaultLevelName = level.getLevelName();
        } else if (exp instanceof Level) {
            dimHier = ((Level)exp).getOwningDimension().getUniqueName();
            levelOnly = true;
        }
        if (filterLevelName != null && !levelOnly) {
            dimHier = dimHier + "." + filterLevelName;
        } else if (!levelOnly) {
            dimHier = dimHier + "." + defaultLevelName;
        }
        return dimHier;
    }

    protected String getFilterId() {
        return this._associatedFilterId;
    }

    public FolderInterface getFolder() {
        return this._associatedFolder;
    }

    @Override
    public InformationMap getInformationMap() {
        BusinessModel baseModel = this._associatedBusinessModel.getBaseModel();
        if (this._associatedBusinessModel instanceof InformationMap) {
            return (InformationMap)this._associatedBusinessModel;
        }
        if (baseModel instanceof InformationMap) {
            return (InformationMap)baseModel;
        }
        _logger.error("No information model was found for this business model.");
        return null;
    }

    @Override
    public List getOrphanedMembers() {
        return ListUtils.newCOWList(this._listOfUnresolvedMembers);
    }

    @Override
    public List getReplacement() throws IQueryServicesException {
        BusinessModelResourceReferencer busItem = this.getBusinessItem();
        if (busItem == null) {
            busItem = this._associatedBusinessModel;
        }
        List returnList = new ArrayList();
        BusinessModel businessModel = this._associatedBusinessModel;
        String cubeName = OLAPConnectionInfoUtil.getCube(businessModel).getCubeName();
        if (busItem instanceof FilterItem) {
            ExpressionInterface expr = ((FilterItem)busItem).getExpression();
            if (expr instanceof MemberFilterExpression) {
                MemberFilterExpression mfe = (MemberFilterExpression)expr;
                ExpressionInterface exp = ((DataItem)mfe.getWhatToCompare()).getExpression();
                String filterLevelName = mfe.getMemberLevelRoot();
                String dimHier = this.getDimensionHierarchy(exp, filterLevelName);
                returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
            } else if (expr instanceof TimeRangeFilterExpression) {
                TimeRangeFilterExpression timeFilter = (TimeRangeFilterExpression)expr;
                ExpressionInterface exp = ((DataItem)timeFilter.getWhatToCompare()).getExpression();
                String dimHier = this.getDimensionHierarchy(exp, null);
                returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
            } else if (expr instanceof TimeFilterNParallelPeriodsExpression) {
                TimeFilterNParallelPeriodsExpression timeFilter = (TimeFilterNParallelPeriodsExpression)expr;
                ExpressionInterface exp = ((DataItem)timeFilter.getWhatToCompare()).getExpression();
                String dimHier = this.getDimensionHierarchy(exp, null);
                returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
            } else if (expr instanceof TimeFilterNPeriodsExpression) {
                TimeFilterNPeriodsExpression timeFilter = (TimeFilterNPeriodsExpression)expr;
                ExpressionInterface exp = ((DataItem)timeFilter.getWhatToCompare()).getExpression();
                String dimHier = this.getDimensionHierarchy(exp, null);
                returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
            } else if (expr instanceof TimeFilterFirstLastPeriodsExpression) {
                TimeFilterFirstLastPeriodsExpression timeFilter = (TimeFilterFirstLastPeriodsExpression)expr;
                ExpressionInterface exp = ((DataItem)timeFilter.getWhatToCompare()).getExpression();
                String dimHier = this.getDimensionHierarchy(exp, null);
                returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
            }
        } else if (busItem instanceof DataItem) {
            ExpressionInterface expr = ((DataItem)busItem).getExpression();
            String dimHier = null;
            String defaultLevelName = null;
            if (expr instanceof OLAPResourceAwareStringExpression) {
                OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)expr;
                Hierarchy hier = olapRASE.getHierarchy();
                if (hier != null) {
                    dimHier = hier.getUniqueName();
                    List<Level> levels = hier.getLevels();
                    if (levels.size() < 1) {
                        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerNoLevel.fmt.txt", dimHier);
                        throw new IQueryServicesException(formatter);
                    }
                    Level level = levels.get(1);
                    defaultLevelName = level.getLevelName();
                    dimHier = dimHier + "." + defaultLevelName;
                }
                if (dimHier != null) {
                    returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
                }
                if (returnList.isEmpty()) {
                    String memberValue = MDXGenerationUtil.buildMDXOnFlyExpression((DataItem)busItem);
                    memberValue = memberValue.substring(0, memberValue.indexOf("."));
                    returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(memberValue, cubeName, true)));
                    return returnList;
                }
            } else if (expr instanceof Hierarchy) {
                dimHier = ((Hierarchy)expr).getUniqueName();
                List<Level> levels = ((Hierarchy)expr).getLevels();
                if (levels.size() < 1) {
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MemberRepairAnalyzerNoLevel.fmt.txt", dimHier);
                    throw new IQueryServicesException(formatter);
                }
                Level level = levels.get(1);
                defaultLevelName = level.getLevelName();
            } else if (expr instanceof Level) {
                dimHier = ((Level)expr).getOwningDimension().getUniqueName();
            }
            dimHier = dimHier + "." + defaultLevelName;
            returnList = this._tool.createTupleReturnList(this._tool.executeQuery(this._tool.buildSetQuery(dimHier, cubeName, true)));
        }
        if (returnList.isEmpty() && _logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error("No replacement could be found. " + this.getBusinessModel().getIdentityString() + this._associatedFilterType.toString());
        }
        return returnList;
    }

    protected Object getResolvedValue(Object oldValue) {
        Object returnObject = null;
        if (oldValue instanceof StringExpression) {
            try {
                returnObject = this._listOfResolvedMembers.get(((StringExpression)oldValue).getText());
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage() + oldValue);
                }
            }
        } else {
            returnObject = oldValue instanceof ConstantExpression ? this._listOfResolvedMembers.get(((ConstantExpression)oldValue).getValue()) : this._listOfResolvedMembers.get(oldValue);
        }
        return returnObject;
    }

    @Override
    public FilterType getType() {
        return this._associatedFilterType;
    }

    protected boolean isMemberOrphaned(String memberValue) {
        boolean isMemberOrphaned = false;
        isMemberOrphaned = this.isMemberValueResolved(memberValue);
        if (!isMemberOrphaned) {
            isMemberOrphaned = this.isMemberValueUnResolved(memberValue);
        }
        return isMemberOrphaned;
    }

    protected boolean isMemberValueResolved(String memberValue) {
        boolean returnValue = false;
        if (this._listOfResolvedMembers.containsKey(memberValue)) {
            returnValue = true;
        }
        if (!returnValue) {
            for (Object object : this._listOfResolvedMembers.keySet()) {
                if (!(object instanceof String) || !((String)object).equalsIgnoreCase(memberValue)) continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }

    protected boolean isMemberValueUnResolved(String memberValue) {
        boolean returnValue = false;
        if (this._listOfUnresolvedMembers.contains(memberValue)) {
            returnValue = true;
        }
        if (!returnValue) {
            for (Object object : this._listOfUnresolvedMembers) {
                if (!(object instanceof String) || !((String)object).equalsIgnoreCase(memberValue)) continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }

    protected boolean isResolved() {
        boolean returnValue = true;
        for (String oldValue : this._listOfUnresolvedMembers) {
            if (this._listOfResolvedMembers.containsKey(oldValue)) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    @Override
    public boolean isUnResolved() {
        boolean returnValue = true;
        for (String oldValue : this._listOfUnresolvedMembers) {
            if (this._listOfResolvedMembers.containsKey(oldValue)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    @Override
    public void removeAllValues() {
        for (String oldValue : this.getOrphanedMembers()) {
            this.removeValue(oldValue);
        }
    }

    @Override
    public void removeValue(String oldValue) {
        this._listOfResolvedMembers.put(oldValue, REMOVE_ELEMENT);
        this.updateUnresolveList(oldValue);
        MDXGenerationUtil.applyDebugStatement(oldValue + " removed in this repair. ", this.getClass());
    }

    @Override
    public void replaceMemberValue(String oldValue, String newValue) {
        this._listOfResolvedMembers.put(oldValue, newValue);
        this.updateUnresolveList(oldValue);
        MDXGenerationUtil.applyDebugStatement(oldValue + " replaced by " + newValue + " in this repair. ", this.getClass());
    }

    private void updateUnresolveList(String oldValue) {
        if (this._listOfUnresolvedMembers.contains(oldValue)) {
            this._listOfUnresolvedMembers.remove(oldValue);
            MDXGenerationUtil.applyDebugStatement(oldValue + " removed from unresolved", this.getClass());
        }
    }
}

