/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair.impl;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OLAPMemberRepairElement;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolBase;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class MemberRepairReport {
    private static final String ORPHAN_MEMBER_REPORT_REPOSITORY_ID_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersRepositoryIDLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_REPOSITORY_NAME_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersRepositoryNameLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_RESOURCES_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersResourcesLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_SECTION2_TITLE = IQDataServicesResourceBundle.getStringResource("OrphanedMembersSection2Title.txt");
    private static final String ORPHAN_MEMBER_REPORT_SERVER_MACHINE_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersServerMachineLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_SERVER_PORT_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersServerPortLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_INPUT_USER_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersInputUserLabel.txt");
    private static final String ORPHAN_MEMBER_REPORT_INFORMATION_ORPH_MAP_LABEL = IQDataServicesResourceBundle.getStringResource("OrphanedMembersInformationMap.txt");
    private static final String ORPHAN_MEMBER_REPORT_TITLE = "< Repair Report Title >";
    private static final String ALL_ORPH_MEM_RESOURCE_USAGE_REPORT = "<Resource Usage by each Map>";
    private static final String ORPHAN_MEMBER_RESOURCE_USAGE_REPORT = "<Map Resource Usage Report>";
    private static final String ORPHAN_MEMBER_RESOURCES = "<Members>";
    private static final String PLATFORM_REPOS = "<Platform Repos>";
    private static final String REPORT_USER = "<Report User>";
    private static final String TIMESTAMP = "<TimeStamp>";
    private static final String ALTERNATING_ROWCOLOR_STYLE = "ROWCOLOR";
    private static final String EVEN_ROWCOLOR_STYLE = "EvenRowBackground";
    private static final String MAPNAME_OF_ORPHANS = "<Map Name>";
    private static final String METADATA_HOST = "<Metadata Host>";
    private static final String METADATA_PORT = "<Metadata Port>";
    private static final String METADATA_REPOS = "<Metadata Repos>";
    private static final String ODD_ROWCOLOR_STYLE = "OddRowBackground";
    private static final String ORPHAN_MEMBER_REPORT_INPUT_TEMPLATE = " <table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"0\">   <tr valign=\"top\"><td><hr size=\"1\"></td></tr> <tr valign=\"top\"><td class=\"EightyPercent\">" + ORPHAN_MEMBER_REPORT_SERVER_MACHINE_LABEL + "&nbsp; <B>" + "<Metadata Host>" + "</B><br>" + ORPHAN_MEMBER_REPORT_SERVER_PORT_LABEL + "&nbsp; <B>" + "<Metadata Port>" + "</B><br>" + ORPHAN_MEMBER_REPORT_REPOSITORY_ID_LABEL + "&nbsp; <B>" + "<Metadata Repos>" + "</B><br>" + ORPHAN_MEMBER_REPORT_REPOSITORY_NAME_LABEL + "&nbsp; <B>" + "<Platform Repos>" + "</B><br>" + ORPHAN_MEMBER_REPORT_INPUT_USER_LABEL + "&nbsp;<B>" + "<Report User>" + "</B><br></td></tr> </table>" + MDXGenerationUtil.NEWLINE;
    private static final String ORPHAN_MEMBER_REPORT_MAIN_TEMPLATE = " <html>   <head>  " + MDXGenerationUtil.NEWLINE + " <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">   <style type=\"text/css\">  " + MDXGenerationUtil.NEWLINE + " <!--   body {    font:normal 80% 'trebuchet ms',helvetica,sans-serif;    color:#000000;   }  .EightyPercent { font:normal 80% 'trebuchet ms',helvetica,sans-serif;  } table.details tr td {       font:normal 80% 'trebuchet ms',helvetica,sans-serif;   }  " + MDXGenerationUtil.NEWLINE + " table.details tr th{    font:normal 80% 'trebuchet ms',helvetica,sans-serif;    font-weight: bold;    text-align:left;    background-color: #f1eacb;border-top: 1px solid #7f9db9; border-left: 1px solid #7f9db9; border-right: 1px solid #7f9db9;border-bottom: 1px solid #cfcbb1; }   table.details {border: 1px solid #7f9db9 }   table.details td{border-left:1px solid #cfcbb1; border-right:1px solid #cfcbb1 }   p {  font: 80% 'trebuchet ms',helvetica,sans-serif  }  " + MDXGenerationUtil.NEWLINE + " h1 {    margin: 0px 0px 5px; font: bold 165% 'trebuchet ms',helvetica,sans-serif   }  " + MDXGenerationUtil.NEWLINE + " h2 {    margin-top: 1em; margin-bottom: 0.5em; font: bold 125% 'trebuchet ms',helvetica,sans-serif   }  " + MDXGenerationUtil.NEWLINE + " h3 {    margin-bottom: 0.5em; font: bold 115% 'trebuchet ms',helvetica,sans-serif   }  " + MDXGenerationUtil.NEWLINE + " h4 {    margin-bottom: 0.5em; font: bold 100% 'trebuchet ms',helvetica,sans-serif   }  " + MDXGenerationUtil.NEWLINE + " h5 {  MARGIN-BOTTOM: 0.00em; FONT:  100% 'trebuchet ms',helvetica,sans-serif } " + MDXGenerationUtil.NEWLINE + " h6 {     margin-bottom: 0.00em; font: 80% 'trebuchet ms',helvetica,sans-serif   } .OddRowBackground {     color:black;  background-color:#ffffff;  }   .EvenRowBackground {     color:black;  background-color:#faf8ed;  }   -->   </style>   <title>" + "< Repair Report Title >" + "</title> </head>   <body>  " + MDXGenerationUtil.NEWLINE + " <h1 align=\"center\"><b>" + "< Repair Report Title >" + " -- " + MDXGenerationUtil.NEWLINE + "</b>" + "<TimeStamp>" + "</h1>  ";
    private static final String ALL_ORPH_MEM_RESOURCE_USAGE_REPORT_TEMPLATE = "<A name=\"Section2\"></A> <table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"0\">   <tr valign=\"top\"><td><h1 align=\"left\">" + ORPHAN_MEMBER_REPORT_SECTION2_TITLE + "</h1></td></tr>  </table> <table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" border=\"0\" class=\"details\">  <tr valign=\"top\">  <th width=\"50%\">" + ORPHAN_MEMBER_REPORT_INFORMATION_ORPH_MAP_LABEL + "</th><th width=\"50%\">" + ORPHAN_MEMBER_REPORT_RESOURCES_LABEL + "</th>  </tr>" + "<Map Resource Usage Report>" + " </table>  <br><hr size=\"1\">";
    private static final String ORPHAN_MEMBER_RESOURCE_USAGE_REPORT_TEMPLATE = " <tr valign=\"top\" class=\"ROWCOLOR\">  <td><Map Name></td><td><Members></td> </tr> ";
    private static final String ORPHAN_MEMBER_RESOURCE_USAGE_REPORT_MAIN = ORPHAN_MEMBER_REPORT_MAIN_TEMPLATE + "<Resource Usage by each Map>" + " </body>   </html>  ";

    private static String escapeSpecialCharactersInLabel(String label) {
        label = label.replaceAll("&", "&amp;");
        label = label.replaceAll(">", "&gt;");
        label = label.replaceAll("<", "&lt;");
        label = label.replaceAll("\\$", "&#36;");
        return label;
    }

    private static String getFullQualifiedName(FolderInterface folder, String mapLabel) throws IQueryServicesException {
        String fullyQualifiedLabel = "";
        if (folder != null) {
            try {
                fullyQualifiedLabel = folder.getPath() + "/" + mapLabel;
                if (fullyQualifiedLabel.charAt(0) == '/') {
                    fullyQualifiedLabel = fullyQualifiedLabel.substring(1);
                }
                fullyQualifiedLabel = MemberRepairReport.escapeSpecialCharactersInLabel(fullyQualifiedLabel);
            }
            catch (RemoteException e) {
                throw new IQueryServicesException(e.getLocalizedMessage());
            }
        } else {
            fullyQualifiedLabel = mapLabel;
        }
        return fullyQualifiedLabel;
    }

    private static String getMapReportInput(IntelligentQueryMetadataServiceInterface iqService, SessionContextInterface session, FolderInterface folderLocation, Locale locale) throws IQueryServicesException {
        String mapReportInput = ORPHAN_MEMBER_REPORT_INPUT_TEMPLATE;
        try {
            UserContextInterface user = session.getUserContext();
            String userName = user.getName();
            RepositoryInterface repos = folderLocation.getRepository();
            String metadataHost = repos.getHost();
            int metadataPort = repos.getPort();
            String metadataRepos = repos.getBase();
            String platformRepos = repos.getISName();
            mapReportInput = mapReportInput.replaceFirst(METADATA_HOST, metadataHost);
            mapReportInput = mapReportInput.replaceFirst(METADATA_PORT, "" + metadataPort);
            mapReportInput = mapReportInput.replaceFirst(METADATA_REPOS, metadataRepos);
            mapReportInput = mapReportInput.replaceFirst(PLATFORM_REPOS, platformRepos);
            String serverMachineLabel = ORPHAN_MEMBER_REPORT_SERVER_MACHINE_LABEL;
            String serverPortLabel = ORPHAN_MEMBER_REPORT_SERVER_PORT_LABEL;
            String repositoryIDLabel = ORPHAN_MEMBER_REPORT_REPOSITORY_ID_LABEL;
            String repositoryNameLabel = ORPHAN_MEMBER_REPORT_REPOSITORY_NAME_LABEL;
            String userLabel = ORPHAN_MEMBER_REPORT_INPUT_USER_LABEL;
            mapReportInput = mapReportInput.replaceFirst(ORPHAN_MEMBER_REPORT_SERVER_MACHINE_LABEL, serverMachineLabel);
            mapReportInput = mapReportInput.replaceFirst(ORPHAN_MEMBER_REPORT_SERVER_PORT_LABEL, serverPortLabel);
            mapReportInput = mapReportInput.replaceFirst(ORPHAN_MEMBER_REPORT_REPOSITORY_ID_LABEL, repositoryIDLabel);
            mapReportInput = mapReportInput.replaceFirst(ORPHAN_MEMBER_REPORT_REPOSITORY_NAME_LABEL, repositoryNameLabel);
            mapReportInput = mapReportInput.replaceFirst(ORPHAN_MEMBER_REPORT_INPUT_USER_LABEL, userLabel);
            mapReportInput = mapReportInput.replaceFirst(REPORT_USER, userName);
        }
        catch (RemoteException e) {
            throw new IQueryServicesException(e.getLocalizedMessage());
        }
        return mapReportInput;
    }

    private static String getMemberOrphanedList(OrphanToolBase tool, BusinessModel model, FolderInterface folder) throws IQueryServicesException {
        List filterOrphaned = tool.getOrphans();
        HashMap<String, String> membersRepairMap = new HashMap<String, String>();
        String mapLabel = model.getLabel();
        String fullyQualifiedMapLabel = MemberRepairReport.getFullQualifiedName(folder, mapLabel);
        for (Object memObject : filterOrphaned) {
            if (!(memObject instanceof OLAPMemberRepairElement)) continue;
            String memberRepairTemplate = ORPHAN_MEMBER_RESOURCE_USAGE_REPORT_TEMPLATE;
            OLAPMemberRepairElement filterRepairElement = (OLAPMemberRepairElement)memObject;
            String filterLabel = filterRepairElement.getDescription() + filterRepairElement.getType().getPersistentForm();
            memberRepairTemplate = memberRepairTemplate.replaceFirst(MAPNAME_OF_ORPHANS, fullyQualifiedMapLabel + "-(" + filterLabel) + ")";
            Iterator iterA = filterRepairElement.getOrphanedMembers().iterator();
            while (iterA.hasNext()) {
                memberRepairTemplate = memberRepairTemplate.replaceFirst(ORPHAN_MEMBER_RESOURCES, (String)iterA.next());
            }
            membersRepairMap.put(fullyQualifiedMapLabel + filterRepairElement.getFilterId(), memberRepairTemplate);
        }
        StringBuffer memberRepairBuffer = new StringBuffer();
        int rowCount = 0;
        for (Object memObject : filterOrphaned) {
            if (!(memObject instanceof OLAPMemberRepairElement)) continue;
            OLAPMemberRepairElement filterRepairElement = (OLAPMemberRepairElement)memObject;
            String mapResourceUsageReport = (String)membersRepairMap.get(fullyQualifiedMapLabel + filterRepairElement.getFilterId());
            String rowColor = ++rowCount % 2 != 0 ? ODD_ROWCOLOR_STYLE : EVEN_ROWCOLOR_STYLE;
            mapResourceUsageReport = mapResourceUsageReport.replaceFirst(ALTERNATING_ROWCOLOR_STYLE, rowColor);
            memberRepairBuffer.append(mapResourceUsageReport);
        }
        String allMapsResourceUsageReport = ALL_ORPH_MEM_RESOURCE_USAGE_REPORT_TEMPLATE;
        String infoMapLabel = ORPHAN_MEMBER_REPORT_INFORMATION_ORPH_MAP_LABEL;
        allMapsResourceUsageReport = allMapsResourceUsageReport.replaceFirst(ORPHAN_MEMBER_REPORT_INFORMATION_ORPH_MAP_LABEL, infoMapLabel);
        allMapsResourceUsageReport = allMapsResourceUsageReport.replaceFirst(ORPHAN_MEMBER_RESOURCE_USAGE_REPORT, memberRepairBuffer.toString());
        return allMapsResourceUsageReport;
    }

    public static void getOrphanedMapReport(SessionContextInterface session, OutputStream outputStream, IntelligentQueryMetadataServiceInterface iqService, FolderInterface bipTreeFolder, BusinessModel model, OrphanToolBase tool) throws IQueryServicesException {
        String mapReportMain = ORPHAN_MEMBER_REPORT_MAIN_TEMPLATE;
        Locale rLocale = model.getComputationalLocale();
        String mapReportInput = MemberRepairReport.getMapReportInput(iqService, session, bipTreeFolder, rLocale);
        String mapReportTitle = IQDataServicesResourceBundle.getStringResource("OrphanedMembersUsageReportGenerator.reportTitle.txt");
        mapReportMain = mapReportMain.replaceAll(ORPHAN_MEMBER_REPORT_TITLE, mapReportTitle);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, rLocale);
        String timeStamp = dateFormat.format(new Date());
        mapReportMain = mapReportMain.replaceFirst(TIMESTAMP, timeStamp);
        String orphanedMembersMain = ORPHAN_MEMBER_RESOURCE_USAGE_REPORT_MAIN;
        String orphanedMembersTitle = IQDataServicesResourceBundle.getStringResource("OrphanedMembersMems.txt");
        orphanedMembersMain = orphanedMembersMain.replaceAll(ORPHAN_MEMBER_REPORT_TITLE, orphanedMembersTitle);
        String memberUsageList = MemberRepairReport.getMemberOrphanedList(tool, model, bipTreeFolder);
        orphanedMembersMain = orphanedMembersMain.replaceFirst(ALL_ORPH_MEM_RESOURCE_USAGE_REPORT, memberUsageList);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            if (mapReportMain != null) {
                writer.write(mapReportMain);
            }
            if (mapReportInput != null) {
                writer.write(mapReportInput);
            }
            if (orphanedMembersMain != null) {
                writer.write(orphanedMembersMain);
            }
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new IQueryServicesException(e);
        }
        catch (IOException e) {
            throw new IQueryServicesException(e);
        }
    }

    protected MemberRepairReport() {
    }
}

