/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil.memberRepair;

import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanMapMembers;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanReportMembers;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.OrphanToolBase;
import com.sas.iquery.metadata.resourceutil.memberRepair.impl.ToolsUtility;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.PartialResultsException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPMemberRepairAnalyzer {
    private static ToolsUtility _toolUtility = null;
    private FolderInterface _folderLocation = null;
    private boolean _hasAnalzed = false;
    private IntelligentQueryMetadataServiceInterface _iqService = null;
    private SessionContextInterface _session = null;
    private OrphanToolBase _tool = null;
    private BusinessModel _toRepairObject = null;
    private static final Logger _logger = LogManager.getLogger(OLAPMemberRepairAnalyzer.class);

    public OLAPMemberRepairAnalyzer() {
        _toolUtility = ToolsUtility.getInstance();
    }

    public void analyze(BusinessModel toRepairObject) throws IQueryServicesException {
        Class classIn = OrphanReportMembers.class;
        if (toRepairObject instanceof InformationMap) {
            classIn = OrphanMapMembers.class;
        }
        this._tool = (OrphanToolBase)_toolUtility.getRequestTool(classIn);
        String reposName = "";
        try {
            if (toRepairObject instanceof BusinessModel) {
                BusinessModel baseModel;
                BusinessModel businessModel = this._toRepairObject = toRepairObject;
                this._iqService = businessModel.getMetadataService();
                if (toRepairObject instanceof InformationMap) {
                    InformationMap map = (InformationMap)toRepairObject;
                    reposName = map.getBriefMap().getRepositoryName();
                }
                this._session = businessModel.getSession();
                if (this._toRepairObject instanceof InformationMap) {
                    this._folderLocation = ((InformationMap)this._toRepairObject).getBriefMap().getOwningFolder();
                } else if (this._toRepairObject instanceof DataSelection && (baseModel = this._toRepairObject.getBaseModel()) instanceof InformationMap) {
                    this._folderLocation = ((InformationMap)baseModel).getBriefMap().getOwningFolder();
                }
                if (this._folderLocation == null && reposName.length() > 0) {
                    this._folderLocation = this._iqService.getBIPTreeRootFolder(this._session, reposName);
                }
            } else {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(toRepairObject.toString());
                }
                throw new IQueryServicesException(IQDataServicesResourceBundle.getStringResource("MemberRepairAnalyzerOnlyBusinessModel.txt"));
            }
            if (this._folderLocation != null) {
                this._tool.setFolderLocation(this._folderLocation);
            }
            this._tool.analyze(toRepairObject);
        }
        catch (Throwable t) {
            throw new IQueryServicesException(t);
        }
        if (this._tool.hasOrphans()) {
            MDXGenerationUtil.applyDebugStatement("No stale member string filter conditions were found after analysis, no repair is necessary", this.getClass());
        }
        this._hasAnalzed = true;
    }

    public List analyze(FolderInterface bipTreeFolder, SessionContextInterface sessionContext, IntelligentQueryMetadataServiceInterface iqService, boolean recurseFolders) throws IQueryServicesException {
        this._hasAnalzed = true;
        ArrayList output = new ArrayList();
        this._folderLocation = bipTreeFolder;
        for (BriefInformationMap briefMap : this.getInfoMapForThisFolder(bipTreeFolder)) {
            InformationMap map = InformationMapFactory.getInstance().newInformationMap(sessionContext, iqService, briefMap);
            if (!map.getStructure().isOLAP()) continue;
            this.analyze(map);
        }
        output.addAll(this._tool.getOrphans());
        this._tool.release();
        return output;
    }

    private void cleanOut() {
        if (this._tool != null) {
            this._tool.release();
            this._tool = null;
        }
        _toolUtility = null;
        this._folderLocation = null;
        this._toRepairObject = null;
    }

    public void closeCancelRepair() {
        this.cleanOut();
    }

    public void closeCommitRepair() throws IQueryServicesException {
        if (this._tool != null) {
            this._tool.repair(this._toRepairObject);
        }
        this._hasAnalzed = false;
        this.cleanOut();
    }

    private List getInfoMapForThisFolder(FolderInterface folder) throws IQueryServicesException {
        List briefMaps;
        try {
            briefMaps = folder.getItemsByClass(BriefInformationMap.class);
        }
        catch (PartialResultsException e) {
            throw new IQueryServicesException(e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            throw new IQueryServicesException(e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            throw new IQueryServicesException(e.getLocalizedMessage());
        }
        return briefMaps;
    }

    public List getOrphanedConditions() {
        return this._tool.getOrphans();
    }

    public boolean isRepairNeeded() {
        boolean returnValue = false;
        if (this._tool == null || !this._hasAnalzed) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MemberRepairStatusIncomplete.txt"));
            }
        } else {
            returnValue = this._tool.isRepairNeeded();
        }
        return returnValue;
    }
}

