/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.ReferenceToBasicResourceMapping2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceObjectRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceToBasicResourceMapping;
import com.sas.services.session.SessionContextInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ModelResourceToBasicResourcelMappingManager2 {
    Map _internalMapping = new IdentityHashMap();
    private Map _internalMappingByType = new IdentityHashMap();
    SessionContextInterface _session = null;
    PhysicalResourceToBasicResourceMapping _resourceToBasicResourceMapping = new PhysicalResourceToBasicResourceMapping();
    PhysicalResourceObjectRelationshipUtility2 _relationshipUtility = null;

    public ModelResourceToBasicResourcelMappingManager2(SessionContextInterface session, PhysicalResourceObjectRelationshipUtility2 relationships) {
        this._session = session;
        this._relationshipUtility = relationships;
    }

    public PhysicalResource getPhysicalResourceMapping(BasicResource basicResource) {
        PhysicalResource returnObj = null;
        ReferenceToBasicResourceMapping2 mapping = (ReferenceToBasicResourceMapping2)this._internalMapping.get(basicResource);
        if (mapping != null) {
            Object o = mapping.getReferenceObject(basicResource);
            if (o instanceof PhysicalResource) {
                returnObj = (PhysicalResource)o;
            }
        } else {
            returnObj = this._resourceToBasicResourceMapping.getTargetObject(basicResource);
        }
        return returnObj;
    }

    private BasicResource getBasicResourceMapping(PhysicalResource in) throws MetadataException {
        Collection resources;
        BasicResource returnValue = null;
        ExternalResourceType inType = ExternalResourceType.getType(in);
        if (inType == ExternalResourceType.QualifiedLevel) {
            inType = ExternalResourceType.Level;
        }
        if ((resources = (Collection)this._internalMappingByType.get(inType)) != null) {
            Iterator itRes = resources.iterator();
            while (itRes.hasNext() && returnValue == null) {
                BasicResource key = (BasicResource)itRes.next();
                PhysicalResource res = this.getPhysicalResourceMapping(key);
                if (res == null || !this._relationshipUtility.isEqual(in, res, true) || res.getClass() != in.getClass()) continue;
                returnValue = key;
            }
        }
        return returnValue;
    }

    public Collection getBasicResourceForType(ExternalResourceType type) {
        ExternalResourceType inType = type;
        if (inType == ExternalResourceType.QualifiedLevel) {
            inType = ExternalResourceType.Level;
        }
        return (Collection)this._internalMappingByType.get(inType);
    }

    public BasicResource addMapping(ReferenceToBasicResourceMapping2 tree) {
        BasicResource returnObject = null;
        returnObject = tree.getMainBasicResource();
        this._internalMapping.put(returnObject, tree);
        if (returnObject != null) {
            Object value;
            ExternalResourceType type = returnObject.getPhysicalResourceType();
            if (type == ExternalResourceType.QualifiedLevel) {
                type = ExternalResourceType.Level;
            }
            if ((value = this._internalMappingByType.get(type)) == null) {
                value = new LinkedHashSet();
                this._internalMappingByType.put(type, value);
            }
            ((LinkedHashSet)value).add(returnObject);
        }
        return returnObject;
    }

    public ReferenceToBasicResourceMapping2 getReferenceToBasicResourceMapping(BasicResource br) {
        ReferenceToBasicResourceMapping2 mapping = null;
        if (br != null) {
            mapping = (ReferenceToBasicResourceMapping2)this._internalMapping.get(br);
        }
        return mapping;
    }

    public BasicResource getMappedBasicResource(PhysicalResource omaResource) throws MetadataException {
        BasicResource returnObj = this._resourceToBasicResourceMapping.getSourceObject(omaResource);
        if (returnObj == null) {
            returnObj = this.getBasicResourceMapping(omaResource);
            if (returnObj == null) {
                returnObj = this.getNewBasicResource(omaResource);
            }
            this._resourceToBasicResourceMapping.addMapping(returnObj, omaResource);
        }
        return returnObj;
    }

    public BasicResource getNewBasicResource(PhysicalResource resourceObject) throws MetadataException {
        BasicResource returnObject = new BasicResource(resourceObject);
        return returnObject;
    }

    public PhysicalResourceObjectRelationshipUtility2 getRelationshipUtility() {
        return this._relationshipUtility;
    }

    public List<BasicResource> getMappedBasicResources(List<? extends PhysicalResource> physicalList) throws MetadataException {
        ArrayList<BasicResource> returnList = new ArrayList<BasicResource>(physicalList.size());
        for (PhysicalResource physicalResource : physicalList) {
            BasicResource li = this.getMappedBasicResource(physicalResource);
            if (li == null) continue;
            returnList.add(li);
        }
        return returnList;
    }
}

