/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.BasicResourceRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.BasicResourceReplacementMapping;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.physical.BasicResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.LogicalResourceReplacementMediator2;
import com.sas.iquery.metadata.resourceutil.physical.MediatedResourceResolutionComparator;
import com.sas.iquery.metadata.resourceutil.physical.OriginatingPhysicalResourceToBasicMapping2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceObjectRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class MediatedResourceManager2 {
    List _mediatedResourceList = null;
    List _mapExternalResources = null;
    SessionContextInterface _session = null;
    MetadataServerInterface _server = null;
    IntelligentQueryMetadataServiceInterface _service = null;
    boolean _useGlobalReplacement = false;
    List _unusedExternalResources = null;
    private boolean _relationalData = true;
    private Logger _logger = null;

    public MediatedResourceManager2(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, RepositoryInterface repository, List physicalResources, boolean globalReplacement, Logger logger) throws MetadataException {
        this._mapExternalResources = physicalResources;
        this._session = session;
        this._service = service;
        this._useGlobalReplacement = globalReplacement;
        this._mediatedResourceList = new ArrayList();
        this._unusedExternalResources = new ArrayList();
        this._logger = logger;
        if (repository != null) {
            try {
                this._server = (MetadataServerInterface)repository.getServer();
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
        this.populateMediatedResourceList();
        this.populateGlobalListeners();
    }

    private void populateGlobalListeners() throws MetadataException {
        for (List outter : this._mediatedResourceList) {
            BasicResourceReplacementMediator2 mediator;
            Object last = outter.get(outter.size() - 1);
            if (last == null) continue;
            if (last instanceof LogicalResourceReplacementMediator2) {
                mediator = (LogicalResourceReplacementMediator2)outter.get(0);
                mediator.getRelationships().addLogicalMappingChangedListener(mediator);
                continue;
            }
            mediator = (BasicResourceReplacementMediator2)last;
            mediator.setGlobalReplacmentMediator(true);
            ExternalResourceType type = mediator.getObjectType();
            List objOfType = this.getMediatedResourcesByType(type);
            for (BasicResourceReplacementMediator2 typeObj : objOfType) {
                if (typeObj.isGlobalReplacementMediator() || typeObj instanceof LogicalResourceReplacementMediator2 || !typeObj.getSourceObject().equals(mediator.getSourceObject())) continue;
                mediator.addGlobalSyncListener(typeObj);
            }
        }
    }

    private void populateMediatedResourceList() throws MetadataException {
        PhysicalResourceObjectRelationshipUtility2 physicalRelationships = new PhysicalResourceObjectRelationshipUtility2(this._session, this._service, this._logger);
        physicalRelationships.setParentsAccordingToType(this._mapExternalResources);
        this._mapExternalResources = this.getListofAllResources(physicalRelationships);
        this._unusedExternalResources.addAll(this._mapExternalResources);
        Collections.sort(this._unusedExternalResources, physicalRelationships.getTypeComparator());
        Collections.reverse(this._unusedExternalResources);
        ModelResourceToBasicResourcelMappingManager2 modelResourceToBasicResourceMappingManager = new ModelResourceToBasicResourcelMappingManager2(this._session, physicalRelationships);
        BasicResourceRelationshipUtility2 basicResourcRelationships = new BasicResourceRelationshipUtility2(modelResourceToBasicResourceMappingManager, this._server);
        BasicResourceReplacementMapping replacementMappings = new BasicResourceReplacementMapping();
        this.processMediatedResources(physicalRelationships, modelResourceToBasicResourceMappingManager, basicResourcRelationships, replacementMappings);
    }

    private List getListofAllResources(PhysicalResourceObjectRelationshipUtility2 physicalRelationships) throws MetadataException {
        ArrayList<PhysicalResource> allResources = new ArrayList<PhysicalResource>();
        for (PhysicalResource res : this._mapExternalResources) {
            if (!allResources.contains(res)) {
                allResources.add(res);
            }
            this.getAllParentRelationships(physicalRelationships, allResources, res);
        }
        return allResources;
    }

    private void getAllParentRelationships(PhysicalResourceObjectRelationshipUtility2 physicalRelationships, List allResources, PhysicalResource res) throws MetadataException {
        PhysicalResource pRes;
        ExternalResourceType resType = ExternalResourceType.getType(res);
        if (resType != ExternalResourceType.Library && resType != ExternalResourceType.Cube && resType != ExternalResourceType.StoredProcess && (pRes = physicalRelationships.getParent(res)) != null) {
            if (!allResources.contains(pRes)) {
                allResources.add(pRes);
            }
            this.getAllParentRelationships(physicalRelationships, allResources, pRes);
        }
    }

    private void processMediatedResources(PhysicalResourceObjectRelationshipUtility2 physicalRelationships, ModelResourceToBasicResourcelMappingManager2 modelResourceToBasicResourceMappingManager, BasicResourceRelationshipUtility2 basicResourceRelationships, BasicResourceReplacementMapping replacementMappings) throws MetadataException {
        for (ExternalResourceType type = ExternalResourceType.last(); type != null; type = type.predecessor()) {
            this.processMediatedResourceType(physicalRelationships, modelResourceToBasicResourceMappingManager, basicResourceRelationships, replacementMappings, type);
        }
    }

    private void processMediatedResourceType(PhysicalResourceObjectRelationshipUtility2 physicalRelationships, ModelResourceToBasicResourcelMappingManager2 modelResourceToBasicResourceMappingManager, BasicResourceRelationshipUtility2 basicResourceRelationships, BasicResourceReplacementMapping replacementMappings, ExternalResourceType type) throws MetadataException {
        ArrayList<PhysicalResource> typeList = new ArrayList<PhysicalResource>();
        List toProcess = null;
        toProcess = this._useGlobalReplacement ? this._unusedExternalResources : this._mapExternalResources;
        for (PhysicalResource res : toProcess) {
            if (ExternalResourceType.getType(res) != type) continue;
            typeList.add(res);
        }
        if (!typeList.isEmpty()) {
            this.addMediatedResources(physicalRelationships, typeList, modelResourceToBasicResourceMappingManager, basicResourceRelationships, replacementMappings);
        }
    }

    private void addMediatedResources(PhysicalResourceObjectRelationshipUtility2 physicalRelationships, List lowLevelObjects, ModelResourceToBasicResourcelMappingManager2 modelResourceToBasicResourceMappingManager, BasicResourceRelationshipUtility2 basicResourceRelationships, BasicResourceReplacementMapping replacementMappings) throws MetadataException {
        ArrayList<PhysicalResource> processed = new ArrayList<PhysicalResource>(this._mapExternalResources);
        processed.removeAll(this._unusedExternalResources);
        for (PhysicalResource physicalResource : lowLevelObjects) {
            if (processed.contains(physicalResource)) continue;
            OriginatingPhysicalResourceToBasicMapping2 oMapping = new OriginatingPhysicalResourceToBasicMapping2(physicalResource, physicalRelationships, modelResourceToBasicResourceMappingManager, basicResourceRelationships, replacementMappings, this._useGlobalReplacement, this._logger);
            List resourceMediators = oMapping.getMediatorList();
            Iterator Riter = resourceMediators.iterator();
            while (Riter.hasNext()) {
                BasicResourceReplacementMediator2 med = (BasicResourceReplacementMediator2)Riter.next();
                BasicResource source = med.getSourceObject();
                PhysicalResource res = (PhysicalResource)oMapping.getReferenceObject(source);
                if (res != null) {
                    if (!this._unusedExternalResources.contains(res) || Riter.hasNext()) continue;
                    processed.add(res);
                    continue;
                }
                MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("MediatedResourceManager.unableToFindOriginalObject.fmt.txt", med);
                throw new MetadataException(message);
            }
            this._mediatedResourceList.add(0, resourceMediators);
        }
        this._unusedExternalResources.removeAll(processed);
    }

    public List getMediatedResourcesByType(ExternalResourceType type) throws MetadataException {
        ArrayList<BasicResourceReplacementMediator2> returnList = new ArrayList<BasicResourceReplacementMediator2>();
        for (List resourceList : this._mediatedResourceList) {
            for (BasicResourceReplacementMediator2 med : resourceList) {
                ExternalResourceType typeV;
                if (med == null || (typeV = med.getObjectType()) == null || !typeV.equals(type)) continue;
                returnList.add(med);
            }
        }
        return returnList;
    }

    public boolean isTypeUnmatched(ExternalResourceType type) throws MetadataException {
        boolean returnValue = false;
        List typeObjects = this.getListOfReplacementHierarchyByLowestType(type);
        Iterator iter = typeObjects.iterator();
        while (iter.hasNext() && !returnValue) {
            returnValue = this.containsUnmatchedResource((List)iter.next());
        }
        return returnValue;
    }

    public boolean containsUnmatchedResource(List brrmObjects) throws MetadataException {
        boolean returnValue = false;
        Iterator iter = brrmObjects.iterator();
        while (iter.hasNext() && !returnValue) {
            BasicResourceReplacementMediator2 brrm;
            Object obj = iter.next();
            if (!(obj instanceof BasicResourceReplacementMediator2) || !(brrm = (BasicResourceReplacementMediator2)obj).isUnmatched()) continue;
            returnValue = true;
        }
        return returnValue;
    }

    public List getGlobalMediatedResourcesByType(ExternalResourceType type) throws MetadataException {
        ArrayList<BasicResourceReplacementMediator2> returnList = new ArrayList<BasicResourceReplacementMediator2>();
        for (List resourceList : this._mediatedResourceList) {
            BasicResourceReplacementMediator2 last = (BasicResourceReplacementMediator2)resourceList.get(resourceList.size() - 1);
            if (!last.getObjectType().equals(type) || !last.isGlobalReplacementMediator() || returnList.contains(last)) continue;
            returnList.add(last);
        }
        return returnList;
    }

    public List getListOfReplacementHierarchyByLowestType(ExternalResourceType type) throws MetadataException {
        ArrayList<List> returnList = new ArrayList<List>();
        for (List resourceList : this._mediatedResourceList) {
            BasicResourceReplacementMediator2 last = (BasicResourceReplacementMediator2)resourceList.get(resourceList.size() - 1);
            if (!last.getObjectType().equals(type) || returnList.contains(resourceList)) continue;
            returnList.add(resourceList);
        }
        return returnList;
    }

    public BasicResourceReplacementMediator2 getMediatedResourcesBySourceObject(BasicResource source) throws MetadataException {
        BasicResourceReplacementMediator2 returnValue = null;
        Iterator iter = this._mediatedResourceList.iterator();
        while (iter.hasNext() && returnValue == null) {
            List resourceList = (List)iter.next();
            Iterator lIter = resourceList.iterator();
            while (lIter.hasNext() && returnValue == null) {
                BasicResourceReplacementMediator2 med = (BasicResourceReplacementMediator2)lIter.next();
                if (med == null || !med.getSourceObject().equals(source)) continue;
                returnValue = med;
            }
        }
        return returnValue;
    }

    public List getMediatedResourceList() {
        return this._mediatedResourceList;
    }

    public List getIncreasingImportanceMediatedResourceList() {
        ArrayList returnList = new ArrayList(this._mediatedResourceList);
        Collections.sort(returnList, new MediatedResourceResolutionComparator());
        return returnList;
    }

    public void populateResolvedResourceReplacements() throws MetadataException {
        if (this._relationalData) {
            BasicResourceReplacementMediator2 server = this.populateResolvedResourceByType(ExternalResourceType.WorkspaceServer);
            this.populateResolvedResourceByType(ExternalResourceType.StoredProcess, server);
            if (this._useGlobalReplacement) {
                server = this.populateResolvedResourceByType(ExternalResourceType.Library, server);
                server = this.populateResolvedResourceByType(ExternalResourceType.DatabaseSchema, server);
                server = this.populateResolvedResourceByType(ExternalResourceType.Table, server);
                server = this.populateResolvedResourceByType(ExternalResourceType.Column, server);
            } else {
                this.populateStructuredObjects(server);
            }
        } else {
            BasicResourceReplacementMediator2 structuredParent = this.populateResolvedResourceByType(ExternalResourceType.OLAPServer);
            this.populateResolvedResourceByType(ExternalResourceType.StoredProcess, structuredParent);
            structuredParent = this.populateResolvedResourceByType(ExternalResourceType.OLAPSchema, structuredParent);
            structuredParent = this.populateResolvedResourceByType(ExternalResourceType.Cube, structuredParent);
            this.populateResolvedResourceByType(ExternalResourceType.Measure, structuredParent);
            this.populateResolvedResourceByType(ExternalResourceType.CalculatedMeasure, structuredParent);
            if (this._useGlobalReplacement) {
                structuredParent = this.populateResolvedResourceByType(ExternalResourceType.Dimension, structuredParent);
                structuredParent = this.populateResolvedResourceByType(ExternalResourceType.Hierarchy, structuredParent);
                this.populateResolvedResourceByType(ExternalResourceType.QualifiedLevel, structuredParent);
                this.populateResolvedResourceByType(ExternalResourceType.Level, structuredParent);
                this.populateResolvedResourceByType(ExternalResourceType.NamedSet, structuredParent);
                this.populateResolvedResourceByType(ExternalResourceType.CalculatedMember, structuredParent);
            } else {
                this.populateStructuredObjects(structuredParent);
            }
        }
    }

    private void populateStructuredObjects(BasicResourceReplacementMediator2 structuredParent) throws MetadataException {
        for (List mediatedResources : this._mediatedResourceList) {
            Collections.sort(mediatedResources, new MediatedResourceResolutionComparator());
            BasicResourceReplacementMediator2 parent = structuredParent;
            if (mediatedResources.size() > 1) {
                for (BasicResourceReplacementMediator2 med : mediatedResources) {
                    if (parent != null) {
                        med.setParent(parent);
                        parent = med;
                    }
                    med.setReplacementEqualToSource();
                }
                continue;
            }
            for (BasicResourceReplacementMediator2 med : mediatedResources) {
                if (parent != null && med != parent) {
                    boolean parentNotSet;
                    boolean typeNeedsParent = med.getObjectType().hasParentType();
                    boolean bl = parentNotSet = med.getParent() == null;
                    if (typeNeedsParent && parentNotSet) {
                        med.setParent(parent);
                        parent = med;
                    }
                }
                med.setReplacementEqualToSource();
            }
        }
    }

    private BasicResourceReplacementMediator2 populateResolvedResourceByType(ExternalResourceType resolveType) throws MetadataException {
        return this.populateResolvedResourceByType(resolveType, null);
    }

    private BasicResourceReplacementMediator2 populateResolvedResourceByType(ExternalResourceType resolveType, BasicResourceReplacementMediator2 server) throws MetadataException {
        List servers = this.getMediatedResourcesByType(resolveType);
        BasicResourceReplacementMediator2 med2 = null;
        boolean bSetTempServer = false;
        for (BasicResourceReplacementMediator2 med2 : servers) {
            BasicResource sourceParent;
            if (server == null && this._useGlobalReplacement && (sourceParent = med2.getSourceObjectParent()) != null) {
                server = this.getMediatedResourcesBySourceObject(sourceParent);
                bSetTempServer = true;
            }
            if (server != null && med2.getParent() == null) {
                med2.setParent(server);
            }
            if (med2 != null) {
                med2.setReplacementEqualToSource();
            }
            if (!bSetTempServer) continue;
            bSetTempServer = !bSetTempServer;
            server = null;
        }
        if (servers.size() != 1) {
            med2 = null;
        }
        return med2;
    }

    public boolean isRelationalData() throws MetadataException {
        return this._relationalData;
    }

    public void setRelationalData(boolean relationalData) throws MetadataException {
        this._relationalData = relationalData;
    }

    public MetadataServerInterface getServer() {
        return this._server;
    }

    public void setServer(MetadataServerInterface server) {
        this._server = server;
    }

    public PhysicalResourceTree2 getDependentPhysicalObjectsAsTree() throws MetadataException {
        PhysicalResourceTree2 returnValue = new PhysicalResourceTree2(this._session, this._service, this._logger);
        returnValue.addPhysicalResources(this._mapExternalResources, null);
        return returnValue;
    }

    public String toString() {
        StringBuffer o = new StringBuffer();
        o.append("MediatedResourceManager2: ");
        o.append("MapExternalResources=");
        o.append(this._mapExternalResources.toString());
        o.append(", MediatedResourceList=");
        o.append(this._mediatedResourceList.toString());
        o.append(", GlobalReplacement=");
        o.append(this._useGlobalReplacement);
        o.append(", RelationalDataStructure=");
        o.append(this._relationalData);
        return o.toString();
    }

    public void setResourceReplacements(PhysicalResourceTree2 baseTree) throws MetadataException {
        this.populateResolvedResourceReplacements();
        List mediatedResources = this.getMediatedResourceList();
        for (List loRes : mediatedResources) {
            for (BasicResourceReplacementMediator2 med : loRes) {
                PhysicalResource pRes = med.getPhysicalSourceObject();
                if (pRes instanceof JFSResource) {
                    String path = baseTree.getReplacementPath(pRes);
                    med.setReplacementByPath(path);
                    continue;
                }
                String newResourceName = baseTree.getReplacementName(pRes);
                if (newResourceName != null) {
                    med.setReplacmentByName(newResourceName, baseTree.getReplacementOMAObject(pRes));
                    continue;
                }
                med.setReplacmentFromSource(pRes);
            }
        }
    }
}

