/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InformationMapMetadataState {
    public static final int IM_VALID_STATE = 1;
    public static final int IM_ERROR_STATE_NO_TEXTSTORE = 2;
    public static final int IM_ERROR_STATE_NOT_IN_FOLDER = 4;
    public static final int IM_ERROR_STATE_DUPLICATE_IN_FOLDER = 8;
    public static final int IM_ERROR_STATE_NO_NAME = 16;
    public static final int IM_ERROR_STATE_TEXTSTORE_NO_DATA = 32;
    public static final int IM_ERROR_STATE_TEXTSTORE_NOT_RETRIEVED = 64;
    public static final int IM_ERROR_STATE_INVALID_SMART_OBJECT = 128;
    public static final int IM_WARN_STATE_NO_TX_SOURCES = 4096;
    public static final int IM_WARN_STATE_NO_PUBLICTYPE_SET = 8192;
    public static final int IM_WARN_STATE_NO_USAGEVERSION_SET = 16384;
    private int _state = 1;
    private static int[] warningStates;
    private static int[] errorStates;
    private static final int warnMask;
    private static final int errorMask;

    private static Map<BriefInformationMap, InformationMapMetadataState> getStateMaps(List<? extends BriefInformationMap> maps, int stateToCheck) throws IllegalArgumentException, RemoteException, ServiceException, MdException {
        HashMap<BriefInformationMap, InformationMapMetadataState> allMaps = new HashMap<BriefInformationMap, InformationMapMetadataState>();
        HashMap<BriefInformationMap, InformationMapMetadataState> returnValue = new HashMap<BriefInformationMap, InformationMapMetadataState>();
        HashMap<String, BriefInformationMap> knownInformationMapPaths = new HashMap<String, BriefInformationMap>();
        for (BriefInformationMap briefInformationMap : maps) {
            InformationMapMetadataState state = null;
            if (briefInformationMap == null) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("InformationMapMetadataState.nullMap.msg.txt", new Object[0]));
            }
            state = InformationMapMetadataState.retrieveBriefInformationMapState(allMaps, knownInformationMapPaths, briefInformationMap);
            allMaps.put(briefInformationMap, state);
        }
        for (Map.Entry entry : allMaps.entrySet()) {
            InformationMapMetadataState state;
            BriefInformationMap bMap = (BriefInformationMap)entry.getKey();
            if (returnValue.containsKey(bMap) || !(state = (InformationMapMetadataState)entry.getValue()).isStateSet(stateToCheck)) continue;
            returnValue.put(bMap, state);
        }
        return returnValue;
    }

    public static Map<BriefInformationMap, InformationMapMetadataState> getInvalidMaps(List<? extends BriefInformationMap> maps) throws RemoteException, MdException, IllegalStateException, ServiceException {
        return InformationMapMetadataState.getStateMaps(maps, errorMask);
    }

    public static Map<BriefInformationMap, InformationMapMetadataState> getWarningMaps(List<? extends BriefInformationMap> maps) throws RemoteException, MdException, IllegalStateException, ServiceException {
        return InformationMapMetadataState.getStateMaps(maps, warnMask);
    }

    public static Map<BriefInformationMap, InformationMapMetadataState> getValidMaps(List<? extends BriefInformationMap> maps) throws RemoteException, MdException, IllegalStateException, ServiceException {
        return InformationMapMetadataState.getStateMaps(maps, 1);
    }

    private static InformationMapMetadataState retrieveBriefInformationMapState(Map<BriefInformationMap, InformationMapMetadataState> allKnownBriefInformationMaps, Map<String, BriefInformationMap> knownInformationMapPaths, BriefInformationMap bMap) throws RemoteException, MdException, ServiceException {
        InformationMapMetadataState state = new InformationMapMetadataState();
        Transformation tx = null;
        try {
            tx = (Transformation)bMap.getRepositoryEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tx == null) {
            state.addState(128);
        } else {
            InformationMapMetadataState.checkAttributeStates(bMap, state);
            InformationMapMetadataState.checkStoredTextStates(state, tx);
            InformationMapMetadataState.checkTransformationSourcesStates(state, tx);
            InformationMapMetadataState.checkContainingFolderStates(allKnownBriefInformationMaps, knownInformationMapPaths, bMap, state, tx);
        }
        return state;
    }

    private static void checkContainingFolderStates(Map<BriefInformationMap, InformationMapMetadataState> allKnownBriefInformationMaps, Map<String, BriefInformationMap> knownInformationMapPaths, BriefInformationMap bMap, InformationMapMetadataState state, Transformation tx) throws RemoteException, MdException, ServiceException {
        List<Tree> trees = AssociationListUtil.filteredSnapshot(tx.getTrees(false), Tree.class);
        if (trees.isEmpty()) {
            List parents = bMap.getParents();
            if (parents.size() == 0) {
                state.addState(4);
            }
        } else {
            PathUrl pathURL = bMap.getPathUrl();
            if (pathURL != null) {
                String path = pathURL.toString();
                BriefInformationMap existingMap = knownInformationMapPaths.get(path);
                if (existingMap != null) {
                    state.addState(8);
                    InformationMapMetadataState returnedMapState = allKnownBriefInformationMaps.get(existingMap);
                    if (returnedMapState != null) {
                        returnedMapState.addState(8);
                    } else {
                        returnedMapState = new InformationMapMetadataState();
                        returnedMapState.addState(8);
                        allKnownBriefInformationMaps.put(existingMap, returnedMapState);
                    }
                } else {
                    knownInformationMapPaths.put(path, bMap);
                }
            }
        }
    }

    private static void checkAttributeStates(BriefInformationMap bMap, InformationMapMetadataState state) throws RemoteException {
        double usageVersion;
        Transformation tx;
        String publicType;
        if (bMap.getName().length() == 0) {
            state.addState(16);
        }
        if ((publicType = (tx = (Transformation)bMap.getRepositoryEntity()).getPublicType()).length() == 0) {
            state.addState(8192);
        }
        if ((usageVersion = tx.getUsageVersion()) <= 0.0) {
            state.addState(16384);
        }
    }

    private static void checkTransformationSourcesStates(InformationMapMetadataState state, Transformation tx) throws RemoteException, MdException {
        List<Object> txSources = AssociationListUtil.filteredSnapshot(tx.getTransformationSources(), Object.class);
        if (txSources.isEmpty()) {
            state.addState(4096);
        }
    }

    private static void checkStoredTextStates(InformationMapMetadataState state, Transformation tx) throws RemoteException {
        List<TextStore> sourceCode = null;
        try {
            sourceCode = AssociationListUtil.filteredSnapshot(tx.getSourceCodes(), TextStore.class);
        }
        catch (MdException e) {
            state.addState(64);
        }
        if (sourceCode != null) {
            if (sourceCode.isEmpty()) {
                state.addState(2);
            } else {
                TextStore store = sourceCode.get(0);
                String storedText = store.getStoredText();
                if (storedText.length() <= 0) {
                    state.addState(32);
                }
            }
        }
    }

    public void addState(int iValue) {
        if ((errorMask & iValue) != 0 && (this._state & 1) != 0) {
            this._state &= 0xFFFFFFFE;
        }
        this._state |= iValue;
    }

    public void resetState() {
        this._state = 1;
    }

    public boolean isStateSet(int inState) {
        boolean returnValue = false;
        if ((this._state & inState) != 0) {
            returnValue = true;
        }
        return returnValue;
    }

    public String toString() {
        String output = "";
        if (this._state == 1) {
            output = "VALID";
        } else {
            if ((this._state & 0x10) != 0) {
                output = output + " NO_NAME ";
            }
            if ((this._state & 2) != 0) {
                output = output + " NO_TEXTSTORE ";
            }
            if ((this._state & 0x20) != 0) {
                output = output + " NO_TEXTSTORE_CONTENT ";
            }
            if ((this._state & 0x40) != 0) {
                output = output + " ERROR_RETRIEVING_TEXTSTORE ";
            }
            if ((this._state & 4) != 0) {
                output = output + " NOT_IN_FOLDER ";
            }
            if ((this._state & 8) != 0) {
                output = output + " DUPLICATE_IN_FOLDER ";
            }
            if ((this._state & 0x80) != 0) {
                output = output + " INVALID_SMARTOBJECT ";
            }
        }
        if ((this._state & 0x1000) != 0) {
            output = output + " NO_TX_SOURCES_SET ";
        }
        if ((this._state & 0x2000) != 0) {
            output = output + " NO_PUBLICTYPE_SET ";
        }
        if ((this._state & 0x4000) != 0) {
            output = output + " NO_USAGEVERSION_SET ";
        }
        return output;
    }

    public static boolean isErrorState(int inState) {
        boolean returnValue = false;
        returnValue = (inState & errorMask) != 0 ? true : !InformationMapMetadataState.isValidState(inState);
        return returnValue;
    }

    public static boolean isValidState(int inState) {
        boolean returnValue = true;
        returnValue = (inState & 1) != 0;
        return returnValue;
    }

    public static boolean isWarningState(int inState) {
        boolean returnValue = false;
        if ((inState & warnMask) != 0) {
            returnValue = true;
        }
        return returnValue;
    }

    static {
        int i;
        warningStates = new int[]{8192, 4096, 16384};
        errorStates = new int[]{8, 16, 2, 4, 32, 64, 128};
        int intmask = 0;
        for (i = 0; i < warningStates.length; ++i) {
            intmask |= warningStates[i];
        }
        warnMask = intmask;
        intmask = 0;
        for (i = 0; i < errorStates.length; ++i) {
            intmask |= errorStates[i];
        }
        errorMask = intmask;
    }
}

