/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.BasicResource;
import com.sas.iquery.metadata.resourceutil.ModelResourceToBasicResourcelMappingManager2;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.MappingChangedListener;
import com.sas.services.information.MetadataServerInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BasicResourceRelationshipUtility2 {
    private Set _logicalObjlisteners;
    private ModelResourceToBasicResourcelMappingManager2 _mappingManager = null;
    private MetadataServerInterface _server = null;
    private BasicResourceResourceResolutionTypeComparator _comparator = null;

    public BasicResourceRelationshipUtility2(ModelResourceToBasicResourcelMappingManager2 mgr, MetadataServerInterface server) {
        this._mappingManager = mgr;
        this._server = server;
        this._comparator = new BasicResourceResourceResolutionTypeComparator();
    }

    public BasicResource getParent(BasicResource child) throws MetadataException {
        PhysicalResource oma_parent;
        BasicResource parent = null;
        PhysicalResource oma_child = this._mappingManager.getPhysicalResourceMapping(child);
        if (oma_child != null && (oma_parent = this._mappingManager.getRelationshipUtility().getParent(oma_child)) != null) {
            parent = this._mappingManager.getMappedBasicResource(oma_parent);
        }
        return parent;
    }

    public List getChildren(BasicResource parent, ExternalResourceType type, BasicResource restrictingObject) throws MetadataException {
        List<Object> returnChildren = new ArrayList();
        PhysicalResource oma_parent = this._mappingManager.getPhysicalResourceMapping(parent);
        if (oma_parent != null) {
            List physicalList = this._mappingManager.getRelationshipUtility().getChildren(oma_parent, type, restrictingObject.getPhysicalResource());
            returnChildren = this._mappingManager.getMappedBasicResources(physicalList);
        }
        return returnChildren;
    }

    public ExternalResourceType getResourceType(BasicResource sourceObject) {
        ExternalResourceType returnValue = null;
        PhysicalResource res = this._mappingManager.getPhysicalResourceMapping(sourceObject);
        if (res != null) {
            returnValue = ExternalResourceType.getType(res);
        }
        return returnValue;
    }

    public List getDirectReplacementObjects(BasicResource sourceObject) throws MetadataException {
        PhysicalResource physicalObject = this._mappingManager.getPhysicalResourceMapping(sourceObject);
        List omaReplacements = this._mappingManager.getRelationshipUtility().getDirectReplacments(physicalObject, this._server);
        List<BasicResource> returnList = this._mappingManager.getMappedBasicResources(omaReplacements);
        return returnList;
    }

    public void addLogicalMappingChangedListener(MappingChangedListener listener) {
        if (this._logicalObjlisteners == null) {
            this._logicalObjlisteners = new LinkedHashSet();
        }
        this._logicalObjlisteners.add(listener);
    }

    public void removeLogicalMappingChangedListener(MappingChangedListener listener) {
        if (this._logicalObjlisteners != null) {
            this._logicalObjlisteners.remove(listener);
        }
    }

    public Collection getLogicalMappingListeners() {
        Collection listeners = null;
        listeners = this._logicalObjlisteners != null ? this._logicalObjlisteners : Collections.EMPTY_LIST;
        return listeners;
    }

    public boolean isEqual(BasicResource sourceObject, BasicResource lo, boolean validateParents) throws MetadataException {
        boolean same = false;
        if (sourceObject == null && lo == null || sourceObject != null && lo != null) {
            PhysicalResource oS = this._mappingManager.getPhysicalResourceMapping(sourceObject);
            PhysicalResource oT = this._mappingManager.getPhysicalResourceMapping(lo);
            same = oS != null && oT != null ? this._mappingManager.getRelationshipUtility().isEqual(oS, oT, validateParents) : sourceObject.equals(lo);
        }
        return same;
    }

    public BasicResourceResourceResolutionTypeComparator getTypeComparator() {
        return this._comparator;
    }

    private class BasicResourceResourceResolutionTypeComparator
    implements Comparator<BasicResource> {
        private BasicResourceResourceResolutionTypeComparator() {
        }

        @Override
        public int compare(BasicResource o1, BasicResource o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return this.doCompare(o1, o2);
        }

        private int doCompare(BasicResource lo1, BasicResource lo2) {
            ExternalResourceType type2;
            ExternalResourceType type1 = BasicResourceRelationshipUtility2.this.getResourceType(lo1);
            if (type1 == (type2 = BasicResourceRelationshipUtility2.this.getResourceType(lo2))) {
                return 0;
            }
            if (type1 == null) {
                return -1;
            }
            if (type2 == null) {
                return 1;
            }
            return type1.compareTo(type2);
        }
    }
}

