/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.resourceutil;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.jfs.JFSResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.metadata.remote.CMetadata;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.services.information.metadata.MetadataInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BasicResource
implements Comparable {
    private static final String ATTRIBUTE_TYPE = "Type";
    private static final String ATTRIBUTE_LABEL = "Label";
    private static final String ATTRIBUTE_ID = "Id";
    private static final String ATTRIBUTE_PHYSICALRESOURCETYPE = "PhysicalResourceType";
    private String _label = null;
    private String _id = null;
    private String _type = null;
    private Map _attributes = new HashMap();
    private Map _relationships = new HashMap();
    private PhysicalResource _underlyingResource = null;
    private static final Map _nlsComparatorCache = Collections.synchronizedMap(new HashMap());

    public BasicResource(PhysicalResource resourceObject) throws MetadataException {
        if (resourceObject != null) {
            this._underlyingResource = resourceObject;
            if (this._underlyingResource instanceof Column) {
                this.setLabel(((Column)this._underlyingResource).getSasName());
            } else {
                this.setLabel(this._underlyingResource.getLabel());
            }
            ExternalResourceType type = ExternalResourceType.getType(this._underlyingResource);
            this.setType(type.getMetadataType(this._underlyingResource));
            this._attributes.put(ATTRIBUTE_PHYSICALRESOURCETYPE, type);
            try {
                CMetadata rmtjOMAObj = this.getRepositoryObject(this._underlyingResource);
                if (rmtjOMAObj != null) {
                    this.setId(rmtjOMAObj.getId());
                    this.addAttributes(rmtjOMAObj.getAttrs());
                } else {
                    this.setId(this._underlyingResource.getIdentityString());
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
        if (key.equals(ATTRIBUTE_ID)) {
            this._id = (String)value;
        }
        if (key.equals(ATTRIBUTE_LABEL)) {
            this._label = (String)value;
        }
        if (key.equals(ATTRIBUTE_TYPE)) {
            this._type = (String)value;
        }
    }

    public void addAttributes(Map attributes) {
        this._attributes.putAll(attributes);
        if (attributes.containsKey(ATTRIBUTE_ID)) {
            this._id = (String)attributes.get(ATTRIBUTE_ID);
        }
        if (attributes.containsKey(ATTRIBUTE_LABEL)) {
            this._label = (String)attributes.get(ATTRIBUTE_LABEL);
        }
        if (attributes.containsKey(ATTRIBUTE_TYPE)) {
            this._type = (String)attributes.get(ATTRIBUTE_TYPE);
        }
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
        this._attributes.put(ATTRIBUTE_ID, this._id);
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
        this._attributes.put(ATTRIBUTE_LABEL, this._label);
    }

    public Map getRelationships() {
        return Collections.unmodifiableMap(this._relationships);
    }

    public void addRelationship(String key, Object value) {
        ArrayList<Object> rels = (ArrayList<Object>)this._relationships.get(key);
        if (rels == null) {
            rels = new ArrayList<Object>();
        }
        if (!rels.contains(value)) {
            rels.add(value);
        }
        this._relationships.put(key, rels);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
        this._attributes.put(ATTRIBUTE_TYPE, this._type);
    }

    private CMetadata getRepositoryObject(PhysicalResource omaResource) throws RemoteException {
        Object repositoryObject = null;
        if (omaResource instanceof JFSResourceImpl) {
            MetadataInterface mi = ((JFSResourceImpl)omaResource).getMetadataInterface();
            if (mi != null) {
                repositoryObject = mi.getRepositoryEntity();
            }
        } else if (omaResource instanceof OMAWrapper) {
            repositoryObject = ((OMAWrapper)((Object)omaResource)).getOMAObject();
        }
        return repositoryObject;
    }

    public boolean equals(Object obj) {
        BasicResource basicObj;
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof BasicResource && (basicObj = (BasicResource)obj).getType() == this.getType() && IQModelImplUtilities.same(basicObj._id, this._id) && IQModelImplUtilities.same(basicObj._underlyingResource, this._underlyingResource);
    }

    public int hashCode() {
        int result = 167;
        result = 13 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 13 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 13 * result + (this._underlyingResource == null ? 0 : this._underlyingResource.hashCode());
        result = 13 * result + 7;
        return result;
    }

    public String toString() {
        ArrayList keys = new ArrayList(this._attributes.keySet());
        Collections.sort(keys);
        LinkedHashMap linkedResources = new LinkedHashMap();
        for (Object element : keys) {
            linkedResources.put(element, this._attributes.get(element));
        }
        return "BasicResource: " + linkedResources;
    }

    public PhysicalResource getPhysicalResource() {
        return this._underlyingResource;
    }

    public boolean isUnresolved() {
        boolean isUnresolved = false;
        if (this._underlyingResource instanceof BusinessModelObject) {
            BusinessModelObject bmo = (BusinessModelObject)((Object)this._underlyingResource);
            isUnresolved = bmo.isUnresolved();
            if (!isUnresolved) {
                List<OMAResource> resources = bmo.getResources(OMAResource.class, 0);
                List<JFSResource> jfsRes = bmo.getResources(JFSResource.class, 0);
                IQModelImplUtilities.addButNoDuplicates(resources, jfsRes);
                Iterator<OMAResource> it = resources.iterator();
                while (it.hasNext() && !isUnresolved) {
                    PhysicalResource phyRes = it.next();
                    isUnresolved = phyRes.isUnresolved();
                }
            }
        } else {
            isUnresolved = this._underlyingResource.isUnresolved();
        }
        return isUnresolved;
    }

    public ExternalResourceType getPhysicalResourceType() {
        return (ExternalResourceType)this._attributes.get(ATTRIBUTE_PHYSICALRESOURCETYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(Object arg0) {
        int returnValue = -1;
        if (arg0 == this) {
            returnValue = 0;
        } else if (arg0 == null) {
            returnValue = 1;
        } else if (arg0 instanceof BasicResource) {
            Locale compareLocale;
            if (this._underlyingResource instanceof BusinessModelObject) {
                BusinessModelObject bmo = (BusinessModelObject)((Object)this._underlyingResource);
                compareLocale = LocaleUtilities.getDefaultViewerLocale(bmo.getBusinessModel());
            } else {
                compareLocale = LocaleUtilities.getDefaultViewerLocale();
            }
            String label = this.getLabel();
            if (label != null) {
                SASStringComparator comparator;
                BasicResource br = (BasicResource)arg0;
                SASStringComparator sASStringComparator = comparator = this.getSASComparator(compareLocale);
                synchronized (sASStringComparator) {
                    returnValue = comparator.compare(label, br.getLabel());
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASStringComparator getSASComparator(Locale compareLocale) {
        SASStringComparator comparator;
        Map map = _nlsComparatorCache;
        synchronized (map) {
            comparator = (SASStringComparator)_nlsComparatorCache.get(compareLocale);
            if (comparator == null) {
                comparator = SASCollatorFactory.createCollator((Locale)compareLocale);
                _nlsComparatorCache.put(compareLocale, comparator);
            }
        }
        return comparator;
    }
}

