/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class OMAWrapperImpl
implements OMAWrapper {
    protected CMetadata underlyingOmrObject;
    protected SessionContextInterface session;
    protected static final Logger _logger = LogManager.getLogger((String)"com.sas.iquery.metadata.physical.oma");
    private MetadataServerInterface _metadataServer;

    public OMAWrapperImpl() {
    }

    public OMAWrapperImpl(CMetadata omrObject, SessionContextInterface inputSession, MetadataServerInterface metadataServer) {
        this.underlyingOmrObject = omrObject;
        this.session = inputSession;
        this._metadataServer = metadataServer;
    }

    @Override
    public String getLabel() {
        String label = null;
        try {
            label = this.underlyingOmrObject.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return label;
    }

    @Override
    public String getDescription() {
        String description = null;
        try {
            description = this.underlyingOmrObject.getDesc();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return description;
    }

    public String getType() {
        String out = null;
        try {
            out = this.underlyingOmrObject.getCMetadataType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return out;
    }

    public SessionContextInterface getSession() {
        return this.session;
    }

    @Override
    public CMetadata getOMAObject() {
        return this.underlyingOmrObject;
    }

    protected OMAWrapper getReposObject(CMetadata forThisOmaObject) throws MetadataException {
        return OMAResourceFactory.getReposObject(forThisOmaObject, this.session, this._metadataServer);
    }

    protected <T> List<T> getReposObjects(List<? extends CMetadata> omrObjects, Class<T> type) throws MetadataException {
        return OMAResourceFactory.getReposObjects(omrObjects, type, this.session, this._metadataServer);
    }

    protected List<OMAWrapper> getReposObjects(List<? extends CMetadata> omrObjects) throws MetadataException {
        return OMAResourceFactory.getReposObjects(omrObjects, this.session, this._metadataServer);
    }

    protected void debug(String stringToLog, Throwable t) {
        _logger.debug(stringToLog, t);
    }

    protected void debug(String stringToLog) {
        _logger.debug(stringToLog);
    }

    protected void info(String stringToLog, Throwable t) {
        _logger.info(stringToLog, t);
    }

    protected void info(String stringToLog) {
        _logger.info(stringToLog);
    }

    protected void warn(String stringToLog) {
        _logger.warn(stringToLog);
    }

    protected void error(Throwable errorFound) throws MetadataException {
        _logger.error("", errorFound);
        throw new MetadataException(errorFound);
    }

    protected void error(MessageFormatter msg, Throwable errorFound) throws MetadataException {
        _logger.error(msg == null ? "" : msg.toString(), errorFound);
        throw new MetadataException(msg, errorFound);
    }
}

