/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.OMRTemplates;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ReadingContextV2;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.ForeignKey;
import com.sas.iquery.metadata.physical.Index;
import com.sas.iquery.metadata.physical.IndexKey;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.PrimaryKey;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.StructuredData;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.TableRelationshipKey;
import com.sas.iquery.metadata.physical.TableResource;
import com.sas.iquery.metadata.physical.UniqueKey;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMAPrimaryKey;
import com.sas.iquery.metadata.physical.oma.OMARelationalSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASLibrary;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OMATable
extends OMAResourceImpl
implements Table,
TableResource,
StructuredData {
    private static final long serialVersionUID = 1L;
    private PhysicalTable omrTable;
    private OMARelationalSchema relationalSchemaWhenV1Unresolved = null;
    private OMASASLibrary _accessingSASLibraryWhenV2Unresolved = null;
    private List<OMAColumn> unresolvedColumnsWhenUnresolved = new ArrayList<OMAColumn>();
    private boolean caseEnabled;
    private boolean specialCharEnabled;
    private static final Logger _logger = LogManager.getLogger(OMATable.class);
    private static final Logger _OMALogger = LogManager.getLogger((String)"com.sas.iquery.metadata.physical.oma");
    private static final String MEMBER_TYPE_VIEW = "View";

    public OMATable() {
    }

    public OMATable(PhysicalTable omrTable, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrTable, session, metadataServer);
        this.omrTable = omrTable;
        this.loadQuotingProperties();
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposTable";
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Columns", this.unresolvedColumnsWhenUnresolved);
    }

    public OMASASLibrary getAccessingSASLibraryWhenUnresolved() {
        return this._accessingSASLibraryWhenV2Unresolved;
    }

    @Override
    public void setAccessingSASLibraryWhenUnresolved(SASLibrary lib) {
        this._accessingSASLibraryWhenV2Unresolved = (OMASASLibrary)lib;
    }

    @Override
    public String getSasName() throws MetadataException {
        String name = null;
        try {
            if (this.isUnresolved()) {
                throw new MetadataUnresolvedException((BusinessModelResource)this, this.getLabel());
            }
            name = this.omrTable.getSASTableName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return name;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        String name = null;
        try {
            if (this.isUnresolved()) {
                throw new MetadataUnresolvedException((BusinessModelResource)this, this.getLabel());
            }
            name = this.omrTable.getTableName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return name;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getRelationalSchema());
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Tables";
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return null;
    }

    @Override
    public RelationalSchema getRelationalSchema() throws MetadataException {
        RelationalSchema outSchema = null;
        if (this.isUnresolved()) {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                this.unresolvedCheck();
            } else {
                outSchema = this.relationalSchemaWhenV1Unresolved;
            }
        } else {
            try {
                com.sas.metadata.remote.RelationalSchema schema = this.omrTable.getTablePackage();
                outSchema = (RelationalSchema)((Object)this.getReposObject((CMetadata)schema));
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
        return outSchema;
    }

    public void setOwningRelationalSchema(OMARelationalSchema inputRelationalSchema) {
        this.relationalSchemaWhenV1Unresolved = inputRelationalSchema;
    }

    @Override
    public List<Column> getColumns() throws MetadataException {
        return this.getColumns(true);
    }

    public List<Column> getColumns(boolean forceQueryToOMR) throws MetadataException {
        ArrayList<Column> columns;
        _OMALogger.debug(">> getColumns");
        try {
            if (!this.isUnresolved()) {
                if (forceQueryToOMR) {
                    this.fetchColumns();
                }
                columns = this.getReposObjects((List<? extends CMetadata>)this.omrTable.getColumns(), Column.class);
                if (MEMBER_TYPE_VIEW.equalsIgnoreCase(this.omrTable.getMemberType())) {
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>(columns.size() * 2);
                    Iterator iter = columns.iterator();
                    while (iter.hasNext()) {
                        Column column = (Column)iter.next();
                        String columnName = column.getSasName().toUpperCase();
                        if (!map.containsKey(columnName)) {
                            map.put(columnName, Boolean.FALSE);
                            continue;
                        }
                        if (Boolean.FALSE.equals(map.get(columnName))) {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("Column named " + columnName + " is duplicated in the table " + this.getLabel() + ". Explicit references to it will be to the first one.");
                            }
                            map.put(columnName, Boolean.TRUE);
                        }
                        iter.remove();
                    }
                }
            } else {
                columns = new ArrayList<OMAColumn>(this.unresolvedColumnsWhenUnresolved);
            }
        }
        catch (MdException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        if (_OMALogger.isDebugEnabled()) {
            _OMALogger.debug("<< getColumns returning: " + columns);
        }
        return columns;
    }

    private void fetchColumns() throws RemoteException, MdException {
        String template = OMRTemplates.getColumnsInTableTemplate();
        MdOMIUtil omiUtil = this.omrTable.getObjectStore().getFactory().getOMIUtil();
        omiUtil.getMetadataAllDepths((CMetadata)this.omrTable, null, null, template, 260);
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        _OMALogger.debug(">> getKeys");
        List<Key> results = this.getKeys(Key.class);
        if (_OMALogger.isDebugEnabled()) {
            _OMALogger.debug("<< getKeys returning: " + results);
        }
        return results;
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        ArrayList<NamedObjectInterface> results;
        block14: {
            _OMALogger.debug(">> getKeys");
            this.unresolvedCheck();
            if (type == null) {
                throw new IllegalArgumentException("");
            }
            if (!Key.class.isAssignableFrom(type)) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("OMAColumn.illegalType.fmt.txt", "com.sas.iquery.metadata.physical.Key"));
            }
            results = new ArrayList<NamedObjectInterface>();
            try {
                if (PrimaryKey.class.isAssignableFrom(type)) {
                    List<OMAWrapper> keys = this.getReposObjects((List<? extends CMetadata>)this.omrTable.getUniqueKeys());
                    for (OMAWrapper oMAWrapper : keys) {
                        if (!(oMAWrapper instanceof OMAPrimaryKey)) continue;
                        results.add(oMAWrapper);
                    }
                    break block14;
                }
                if (UniqueKey.class.isAssignableFrom(type)) {
                    results.addAll(this.getReposObjects((List<? extends CMetadata>)this.omrTable.getUniqueKeys()));
                    break block14;
                }
                if (ForeignKey.class.isAssignableFrom(type)) {
                    results.addAll(this.getReposObjects((List<? extends CMetadata>)this.omrTable.getForeignKeys()));
                    break block14;
                }
                if (TableRelationshipKey.class.isAssignableFrom(type)) {
                    results.addAll(this.getKeys(UniqueKey.class));
                    results.addAll(this.getKeys(ForeignKey.class));
                    break block14;
                }
                if (IndexKey.class.isAssignableFrom(type)) {
                    List<OMAWrapper> indexes = this.getReposObjects((List<? extends CMetadata>)this.omrTable.getIndexes());
                    for (Index index : indexes) {
                        IndexKey indexKey = index.getKey();
                        results.add(indexKey);
                    }
                    break block14;
                }
                if (Key.class.isAssignableFrom(type)) {
                    results.addAll(this.getKeys(TableRelationshipKey.class));
                    results.addAll(this.getKeys(IndexKey.class));
                    break block14;
                }
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("OMAColumn.illegalType.fmt.txt", "com.sas.iquery.metadata.physical.Key"));
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        if (_OMALogger.isDebugEnabled()) {
            _OMALogger.debug("<< getKeys returning: " + results);
        }
        return results;
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        String numColsAttr;
        super.consumeExternalReferenceAttributes(attrsProvider);
        ReadingContextV2 readingContext = attrsProvider.getReadingContext();
        String charColsAttr = attrsProvider.consumeAttr("charCols");
        if (charColsAttr != null) {
            this.parseAndAddColumns(charColsAttr, readingContext, false);
        }
        if ((numColsAttr = attrsProvider.consumeAttr("numCols")) != null) {
            this.parseAndAddColumns(numColsAttr, readingContext, true);
        }
        this.setColumnToTableLink();
    }

    private void parseAndAddColumns(String attr, ReadingContextV2 readingContext, boolean colTypeIsNumeric) throws SAXException {
        boolean done = false;
        int semiColon = -1;
        int columnTextStart = 0;
        boolean columnHasDoubledSemicolons = false;
        while (!done) {
            if ((semiColon = attr.indexOf(59, semiColon + 1)) == -1) {
                String text = attr.substring(columnTextStart);
                this.processColumnText(text, readingContext, colTypeIsNumeric, columnHasDoubledSemicolons);
                done = true;
                continue;
            }
            if (semiColon + 1 >= attr.length()) continue;
            char nextChar = attr.charAt(semiColon + 1);
            if (nextChar == ';') {
                ++semiColon;
                columnHasDoubledSemicolons = true;
                continue;
            }
            String text = attr.substring(columnTextStart, semiColon);
            this.processColumnText(text, readingContext, colTypeIsNumeric, columnHasDoubledSemicolons);
            columnTextStart = semiColon + 1;
            columnHasDoubledSemicolons = false;
        }
    }

    private void processColumnText(String columnText, ReadingContextV2 readingContext, boolean colTypeIsNumeric, boolean hasSemi) throws SAXException {
        int iComma;
        if (hasSemi) {
            columnText = OMATable.unDoubleSemicolons(columnText);
        }
        if ((iComma = columnText.indexOf(44)) >= 0) {
            String columnPersistenceID = columnText.substring(0, iComma);
            String sasName = columnText.substring(iComma + 1);
            OMAColumn omaColumn = (OMAColumn)readingContext.getObjectForNewObjectElement(columnPersistenceID, "ReposColumn");
            omaColumn.setExternalReferenceInfo(sasName, colTypeIsNumeric);
            this.unresolvedColumnsWhenUnresolved.add(omaColumn);
        }
    }

    private static String unDoubleSemicolons(String text) {
        StringBuffer buf = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            buf.append(c);
            if (c != ';' || i + 1 >= text.length() || text.charAt(i + 1) != ';') continue;
            ++i;
        }
        return buf.toString();
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(thisElement, readingContext);
        this.unresolvedColumnsWhenUnresolved = OMATable.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposColumn", new Class[]{OMAColumn.class});
        this.setColumnToTableLink();
    }

    private void setColumnToTableLink() {
        int size = this.unresolvedColumnsWhenUnresolved.size();
        for (int i = 0; i < size; ++i) {
            OMAColumn unresolvedColumn = this.unresolvedColumnsWhenUnresolved.get(i);
            unresolvedColumn.setOwningTable(this);
        }
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() throws MetadataException {
        this.unresolvedCheck();
        try {
            List<SASLibrary> ourLibs = this.getClientSASLibrariesThatCanAccessThisTable();
            ArrayList<AccessPath> outPaths = new ArrayList<AccessPath>(ourLibs.size());
            for (SASLibrary ourLib : ourLibs) {
                List<SoftwareServer> ourServers = ourLib.getSoftwareServers();
                for (SoftwareServer ourServer : ourServers) {
                    if (!(ourServer instanceof SASWorkspaceServer)) continue;
                    SASWorkspaceServer sasWorkspaceServer = (SASWorkspaceServer)ourServer;
                    AccessPathToRelationalData path = new AccessPathToRelationalData(sasWorkspaceServer, ourLib);
                    outPaths.add(path);
                }
            }
            return outPaths;
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
    }

    private List<SASLibrary> getClientSASLibrariesThatCanAccessThisTable() throws MdException, RemoteException, MetadataException {
        List<Object> tempLibList;
        com.sas.metadata.remote.RelationalSchema tablePackage = this.omrTable.getTablePackage();
        if (tablePackage instanceof DatabaseSchema) {
            tempLibList = AssociationListUtil.filteredSnapshot(tablePackage.getUsedByPackages(), com.sas.metadata.remote.SASLibrary.class);
        } else {
            tempLibList = new ArrayList();
            if (tablePackage instanceof com.sas.metadata.remote.SASLibrary) {
                tempLibList.add((com.sas.metadata.remote.SASLibrary)tablePackage);
            }
        }
        ArrayList<SASLibrary> libs = new ArrayList<SASLibrary>();
        int size = tempLibList.size();
        while (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                com.sas.metadata.remote.SASLibrary omrLib = (com.sas.metadata.remote.SASLibrary)tempLibList.get(i);
                List<com.sas.metadata.remote.SASLibrary> omrSasLibraries = AssociationListUtil.filteredSnapshot(omrLib.getUsedByPackages(true), com.sas.metadata.remote.SASLibrary.class);
                if (omrSasLibraries.isEmpty()) {
                    SASLibrary ourLib = (SASLibrary)((Object)this.getReposObject((CMetadata)omrLib));
                    if (ourLib != null) {
                        libs.add(ourLib);
                    }
                } else {
                    tempLibList.addAll(omrSasLibraries);
                }
                tempLibList.remove(i);
            }
            size = tempLibList.size();
        }
        return libs;
    }

    @Override
    public String getDataSetOptionsAsString() {
        String options;
        block8: {
            options = "";
            try {
                CMetadata metadata = this.getOMAObject();
                if (metadata instanceof PhysicalTable) {
                    List<Property> datasetOptions = AssociationListUtil.filteredSnapshot(((PhysicalTable)metadata).getProperties(true), Property.class);
                    StringBuffer optionsBuf = new StringBuffer();
                    for (Property datasetOption : datasetOptions) {
                        if (datasetOption.getUseValueOnly() != 0) {
                            optionsBuf.append(" ").append(datasetOption.getDefaultValue());
                            continue;
                        }
                        String delim = datasetOption.getDelimiter();
                        if (delim.trim().length() == 0) {
                            delim = "=";
                        }
                        optionsBuf.append(" ");
                        optionsBuf.append(datasetOption.getPropertyName());
                        optionsBuf.append(delim).append(datasetOption.getDefaultValue());
                    }
                    options = optionsBuf.toString();
                }
            }
            catch (MdException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    String msg = IQMetadataResourceBundle.getMessageString("DataSourceTableImpl.DatasetoptionsError.fmt.txt", this.getLabel());
                    _logger.warn(msg, (Throwable)e);
                }
            }
            catch (RemoteException e) {
                if (!_logger.isEnabled(Level.WARN)) break block8;
                String msg = IQMetadataResourceBundle.getMessageString("DataSourceTableImpl.DatasetoptionsError.fmt.txt", this.getLabel());
                _logger.warn(msg, (Throwable)e);
            }
        }
        return options;
    }

    public boolean isCaseEnabled() {
        return this.caseEnabled;
    }

    public boolean isSpecialCharEnabled() {
        return this.specialCharEnabled;
    }

    private void loadQuotingProperties() throws MetadataException {
        block7: {
            try {
                List<PropertySet> propertySets = Collections.unmodifiableList(this.omrTable.getPropertySets());
                for (PropertySet propertySet : propertySets) {
                    if (!propertySet.getSetRole().equals("DBMSNames")) continue;
                    List<Property> properties = AssociationListUtil.filteredSnapshot(propertySet.getProperties(), Property.class);
                    for (Property property : properties) {
                        if (property.getName().equals("Case")) {
                            this.caseEnabled = "Y".equalsIgnoreCase(property.getDefaultValue());
                        }
                        if (!property.getName().equals("SpecChar")) continue;
                        this.specialCharEnabled = "Y".equalsIgnoreCase(property.getDefaultValue());
                    }
                }
            }
            catch (MdException e) {
                if (_logger.isEnabled(Level.WARN)) {
                    String msg = IQMetadataResourceBundle.getMessageString("OMATable.QuotingError.fmt.txt", this.getLabel());
                    _logger.warn(msg, (Throwable)e);
                }
            }
            catch (RemoteException e) {
                if (!_logger.isEnabled(Level.WARN)) break block7;
                String msg = IQMetadataResourceBundle.getMessageString("OMATable.QuotingError.fmt.txt", this.getLabel());
                _logger.warn(msg, (Throwable)e);
            }
        }
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Table.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Table;
    }

    public static void writeReposColumns(Element reposTableElement, List<MetadataRepositoryResource> columns, WritingContext writingContext) throws MetadataException {
        if (columns != null) {
            int size = columns.size();
            StringBuffer numColBuf = new StringBuffer(size * 20);
            StringBuffer charColBuf = new StringBuffer(size * 20);
            for (int i = 0; i < size; ++i) {
                String sasName;
                MetadataRepositoryResource col = columns.get(i);
                String persistenceID = writingContext.getExternalPersistenceIDFor(col);
                writingContext.markObjAsWritten(col);
                if ("C".equalsIgnoreCase(((Column)((Object)col)).getSasType())) {
                    if (charColBuf.length() != 0) {
                        charColBuf.append(';');
                    }
                    charColBuf.append(persistenceID);
                    charColBuf.append(',');
                    sasName = OMATable.getSASColumnNameToWrite(((Column)((Object)col)).getSasName());
                    charColBuf.append(sasName);
                    continue;
                }
                if (numColBuf.length() != 0) {
                    numColBuf.append(';');
                }
                numColBuf.append(persistenceID);
                numColBuf.append(',');
                sasName = OMATable.getSASColumnNameToWrite(((Column)((Object)col)).getSasName());
                numColBuf.append(sasName);
            }
            if (numColBuf.length() > 0) {
                IQModelImplUtilities.setAttr(reposTableElement, "numCols", numColBuf.toString());
            }
            if (charColBuf.length() > 0) {
                IQModelImplUtilities.setAttr(reposTableElement, "charCols", charColBuf.toString());
            }
        }
    }

    private static String getSASColumnNameToWrite(String sasColumnName) {
        int iSemi;
        String out = sasColumnName;
        if (sasColumnName != null && (iSemi = sasColumnName.indexOf(59)) != -1) {
            StringBuffer buf = new StringBuffer(sasColumnName.length() + 2);
            for (int i = 0; i < sasColumnName.length(); ++i) {
                char c = sasColumnName.charAt(i);
                buf.append(c);
                if (c != ';') continue;
                buf.append(';');
            }
            out = buf.toString();
        }
        return out;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return this.getColumns(false);
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        PhysicalResource returnValue = null;
        if (this.isUnresolved()) {
            returnValue = this.getAccessingSASLibraryWhenUnresolved();
            if (returnValue == null) {
                returnValue = this.getResourceContainer();
            }
        } else {
            returnValue = this.getResourceContainer();
            if (returnValue instanceof OMASASLibrary) {
                if (!((OMASASLibrary)returnValue).isDBMSLibname()) {
                    com.sas.metadata.remote.RelationalSchema assocMetadata;
                    com.sas.metadata.remote.SASLibrary omrLib = (com.sas.metadata.remote.SASLibrary)((OMAResourceImpl)returnValue).getOMAObject();
                    List<com.sas.metadata.remote.RelationalSchema> relationalSchemas = null;
                    try {
                        relationalSchemas = AssociationListUtil.filteredSnapshot(omrLib.getUsedByPackages(true), com.sas.metadata.remote.RelationalSchema.class);
                    }
                    catch (RemoteException e) {
                        this.error(e);
                    }
                    catch (MdException e) {
                        this.error(e);
                    }
                    if (!relationalSchemas.isEmpty() && (assocMetadata = relationalSchemas.get(0)) instanceof com.sas.metadata.remote.SASLibrary) {
                        returnValue = (PhysicalResource)((Object)this.getReposObject((CMetadata)assocMetadata));
                    }
                }
            } else {
                returnValue = ((OMAResourceImpl)returnValue).getParentResource();
            }
        }
        return returnValue;
    }

    private PhysicalResource getParentAssociation() throws MetadataException {
        OMAResourceImpl parent = null;
        parent = this.isUnresolved() ? (this.getV2ResourceResolutionRelationshipsApply() ? this.getAccessingSASLibraryWhenUnresolved() : this.relationalSchemaWhenV1Unresolved) : this.getResourceContainer();
        return parent;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        if (childResource != null && childResource instanceof OMAColumn) {
            OMAColumn col = (OMAColumn)childResource;
            if (!this.unresolvedColumnsWhenUnresolved.contains(childResource)) {
                this.unresolvedColumnsWhenUnresolved.add(col);
            }
            col.setOwningTable(this);
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null) {
            if (parentResource instanceof OMASASLibrary) {
                this.setAccessingSASLibraryWhenUnresolved((OMASASLibrary)parentResource);
            } else if (parentResource instanceof OMARelationalSchema) {
                this.setOwningRelationalSchema((OMARelationalSchema)parentResource);
            }
        }
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
        super.setUnresolvedProperties(sourceResource);
        if (sourceResource != null && sourceResource instanceof OMATable) {
            OMATable sourceTable = (OMATable)sourceResource;
            this.caseEnabled = sourceTable.caseEnabled;
            this.specialCharEnabled = sourceTable.specialCharEnabled;
        }
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getLabel()).append("'][");
        OMAResourceImpl parent = (OMAResourceImpl)this.getParentAssociation();
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype)).append("]");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        OMAResourceImpl parent = (OMAResourceImpl)this.getParentAssociation();
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuffer search = new StringBuffer(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']/").append(parent.getUsedBySearchString(type));
        return search.toString();
    }

    @Override
    public StructureOfData getStructure() {
        return StructureOfData.RELATIONAL;
    }
}

