/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.physical.LibraryResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.xml.sax.SAXException;

public class OMASASWorkspaceServer
extends OMASoftwareServer
implements SASWorkspaceServer {
    private static final long serialVersionUID = 1L;
    private List _unresolvedSASLibrariesWhenV2Unresolved;
    private LogicalServer _logicalPooledWorkspaceServer;

    public OMASASWorkspaceServer() {
    }

    public OMASASWorkspaceServer(ServerContext inputServerContext, LogicalServer unpooledLogicalWorkspaceServer, LogicalServer pooledWorkspaceServer, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super(unpooledLogicalWorkspaceServer, inputServerContext, session, metadataServer);
        this._logicalPooledWorkspaceServer = pooledWorkspaceServer;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposWorkspaceServer";
    }

    @Override
    @Nonnull
    public List<SASLibrary> getSasLibraries() throws MetadataException {
        _logger.debug(">> getSasLibraries");
        List<SASLibrary> outLibs = null;
        if (this.isUnresolved()) {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                outLibs = new ArrayList<SASLibrary>(this._unresolvedSASLibrariesWhenV2Unresolved);
            } else {
                this.unresolvedCheck();
            }
        } else {
            outLibs = this.getDataPackageObjects(SASLibrary.class);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getSasLibraries returning: " + outLibs);
        }
        assert (outLibs != null);
        return outLibs;
    }

    @Override
    public String getType() {
        return IQMetadataResourceBundle.getStringResource("Type.SASWorkspaceServer.txt");
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.WorkspaceServer;
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedSASLibrariesWhenV2Unresolved = rilsHolder.consumeObjects("SASLibraries", SASLibrary.class);
        this.setLibraryToAccessingServerLink();
    }

    private void setLibraryToAccessingServerLink() {
        int size = this._unresolvedSASLibrariesWhenV2Unresolved.size();
        for (int i = 0; i < size; ++i) {
            SASLibrary unresolvedLib = (SASLibrary)this._unresolvedSASLibrariesWhenV2Unresolved.get(i);
            if (!(unresolvedLib instanceof LibraryResource)) continue;
            ((LibraryResource)((Object)unresolvedLib)).setAccessingServerWhenUnresolved(this);
        }
    }

    @Override
    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        super.addRelationshipsToUnresolvedResources(mapping);
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "SASLibraries", this._unresolvedSASLibrariesWhenV2Unresolved);
    }

    @Override
    public List getChildResources(ExternalResourceType type) throws MetadataException {
        List<SASLibrary> returnValue = super.getChildResources(type);
        if (type == ExternalResourceType.Library) {
            returnValue = this.getSasLibraries();
        }
        return returnValue;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        super.addUnresolvedChildResource(childResource);
        if (childResource != null && childResource instanceof SASLibrary) {
            if (this._unresolvedSASLibrariesWhenV2Unresolved == null) {
                this._unresolvedSASLibrariesWhenV2Unresolved = new ArrayList();
            }
            if (!this._unresolvedSASLibrariesWhenV2Unresolved.contains(childResource)) {
                this._unresolvedSASLibrariesWhenV2Unresolved.add(childResource);
            }
        }
    }

    @Override
    public LogicalServerInterface getPooledLogicalServerInterface() throws MetadataException {
        LogicalServerInterface outServer = null;
        try {
            if (this._logicalPooledWorkspaceServer != null) {
                outServer = (LogicalServerInterface)this.newJFSObject((Root)this._logicalPooledWorkspaceServer);
            }
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return outServer;
    }

    @Override
    public CMetadata getOMAObject() {
        CMetadata out = super.getOMAObject();
        if (out == null) {
            out = this._logicalPooledWorkspaceServer;
        }
        return out;
    }

    @Override
    public List<Schema> getSchemas() throws MetadataException {
        List<SASLibrary> sasLibraries = this.getSasLibraries();
        ArrayList<Schema> schemas = new ArrayList<Schema>(sasLibraries);
        return schemas;
    }

    @Override
    public Schema getSchemaWithLabel(String tableLabel) throws MetadataException {
        Schema schema = null;
        for (Schema check : this.getSchemas()) {
            if (check == null || !check.getLabel().equalsIgnoreCase(tableLabel)) continue;
            schema = check;
            break;
        }
        return schema;
    }
}

