/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelRepositoryResource;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.impl.MetadataRepositoryResource;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.OMAResource;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class OMAResourceImpl
extends AbstractModelRepositoryResource
implements OMAResource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final boolean FORCE_TO_SERVER = true;
    private CMetadata underlyingOmrObject;
    private MetadataServerInterface _metadataServer;
    protected SessionContextInterface session;
    private String nameWhenUnresolved = "";
    private String descriptionWhenUnresolved = "";
    private String repositoryTypeWhenUnresolved = "";
    protected static final Logger _logger = LogManager.getLogger((String)"com.sas.iquery.metadata.physical.oma");
    public static final String PHYSICAL_RESOURCE_ID_PREFIX = "XR";

    public OMAResourceImpl() {
    }

    public OMAResourceImpl(CMetadata omrObject, SessionContextInterface inputSession, MetadataServerInterface metadataServer) throws MetadataException {
        this.underlyingOmrObject = omrObject;
        this.session = inputSession;
        this._metadataServer = metadataServer;
    }

    protected OMAResourceImpl(SessionContextInterface inputSession, String name) {
        this.underlyingOmrObject = null;
        this.session = inputSession;
        this.nameWhenUnresolved = name;
    }

    protected OMAWrapper getReposObject(CMetadata forThisOmaObject) throws MetadataException {
        return OMAResourceFactory.getReposObject(forThisOmaObject, this.session, this._metadataServer);
    }

    protected <T> List<T> getReposObjects(List<? extends CMetadata> omrObjects, @Nonnull Class<T> c) throws MetadataException {
        return OMAResourceFactory.getReposObjects(omrObjects, c, this.session, this._metadataServer);
    }

    protected List<OMAWrapper> getReposObjects(List<? extends CMetadata> omrObjects) throws MetadataException {
        return OMAResourceFactory.getReposObjects(omrObjects, this.session, this._metadataServer);
    }

    public MetadataServerInterface getMetadataServer() {
        return this._metadataServer;
    }

    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return null;
    }

    @Override
    public MetadataRepositoryResource getConstrainingResource() throws MetadataException {
        return this.getResourceContainer();
    }

    public String getName() {
        return this.getLabel();
    }

    @Override
    public String getLabel() {
        String out = null;
        try {
            if (this.isUnresolved()) {
                out = this.nameWhenUnresolved;
            } else {
                CMetadata omaObject = this.getOMAObject();
                if (omaObject != null) {
                    out = omaObject.getName();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return out;
    }

    @Override
    public String getDescription() {
        String out = null;
        try {
            out = this.isUnresolved() ? this.descriptionWhenUnresolved : this.getOMAObject().getDesc();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return out;
    }

    public String getID() {
        return null;
    }

    public final String toString() {
        return this.getLabel();
    }

    public String toDebugString() {
        return this.getIdentityString();
    }

    @Override
    protected void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setAttr(thisElement, "name", this.getLabel());
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this.nameWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "label");
        this.descriptionWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "desc");
        this.repositoryTypeWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "omrType");
        this.setV2ResourceResolutionRelationshipsApply(false);
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        super.consumeExternalReferenceAttributes(attrsProvider);
        this.nameWhenUnresolved = attrsProvider.consumeAttr("name");
        if (this.nameWhenUnresolved == null) {
            this.nameWhenUnresolved = "";
        }
        this.descriptionWhenUnresolved = "";
        this.repositoryTypeWhenUnresolved = "";
    }

    public RepositoryInterface getRepository() {
        RepositoryInterface repos;
        block7: {
            repos = null;
            if (!this.isUnresolved()) {
                try {
                    repos = IQModelImplUtilities.getRepos(this.getOMAObject(), this.session);
                }
                catch (RemoteException re) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(re.getMessage());
                    }
                    break block7;
                }
                catch (ServiceException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(e.getMessage());
                    }
                    break block7;
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("The OMA resource " + this.getLabel() + " is unresolved.");
            }
        }
        return repos;
    }

    @Override
    public MetadataInterface getJFSObject() throws MetadataException {
        MetadataInterface outObject = null;
        try {
            if (!this.isUnresolved()) {
                outObject = this.newJFSObject((Root)this.getOMAObject());
            }
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return outObject;
    }

    MetadataInterface newJFSObject(Root omrObject) throws ServiceException, RemoteException {
        MetadataServerInterface server = this.getMetadataServer();
        return server.factoryProcess((Object)omrObject);
    }

    @Override
    public String getIdentityString() {
        String msg = IQMetadataResourceBundle.getMessageString("IdentityStringTwoArgs.fmt.txt", this.getType(), this.getLabel());
        return msg;
    }

    @Override
    public CMetadata getOMAObject() {
        return this.underlyingOmrObject;
    }

    public SessionContextInterface getSession() {
        return this.session;
    }

    protected final void unexpectedConditionFound() throws MetadataException {
        MessageFormatter msg = IQModelImplUtilities.getMessageFormatter("OMAResourceImpl.UnexpectedConditionFound.txt", new Object[0]);
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(msg.toString());
        }
        throw new MetadataException(msg);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public final void addListener(PropertyChangeListener listener) {
    }

    @Override
    protected final void addListenersUnsynchronized(IdentityList listeners) {
    }

    protected static List pre92_readExternalReferenceListDirectlyUnderElement(Element parentElement, ReadingContext readingContext, String subelementName, Class[] allowedTypes) throws MetadataException {
        List<Element> subelements = IQModelImplUtilities.getSubelementsNamed(parentElement, subelementName);
        int size = subelements.size();
        ArrayList<AbstractModelItem> outList = new ArrayList<AbstractModelItem>(size);
        for (int i = 0; i < size; ++i) {
            Element subelement = subelements.get(i);
            AbstractModelItem item = readingContext.readExternalReferenceElement(subelement);
            outList.add(item);
        }
        return outList;
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
        if (sourceResource instanceof PhysicalResource) {
            PhysicalResource physicalResource = sourceResource;
            this.nameWhenUnresolved = physicalResource.getLabel();
            this.descriptionWhenUnresolved = physicalResource.getDescription();
        }
        if (sourceResource instanceof OMAResourceImpl) {
            OMAResourceImpl omaSourceResource = (OMAResourceImpl)sourceResource;
            this.setV2ResourceResolutionRelationshipsApply(omaSourceResource.getV2ResourceResolutionRelationshipsApply());
            this.session = omaSourceResource.getSession();
            this.repositoryTypeWhenUnresolved = omaSourceResource.repositoryTypeWhenUnresolved;
        }
    }

    @Override
    public String getSearchString() throws MetadataException {
        return null;
    }
}

