/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.oma.OMASchema;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.w3c.dom.Element;

public abstract class OMARelationalSchema
extends OMASchema
implements RelationalSchema {
    private com.sas.metadata.remote.RelationalSchema omrRelationalSchema = null;
    private List unresolvedTablesWhenUnresolved = new ArrayList();

    public OMARelationalSchema() {
    }

    public OMARelationalSchema(com.sas.metadata.remote.RelationalSchema inputOmrRelationalSchema, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((DeployedDataPackage)inputOmrRelationalSchema, session, metadataServer);
        this.omrRelationalSchema = inputOmrRelationalSchema;
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(thisElement, readingContext);
        this.unresolvedTablesWhenUnresolved = OMARelationalSchema.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposTable", new Class[]{OMATable.class});
        this.setTableToSchemaLink();
    }

    private void setTableToSchemaLink() {
        int size = this.unresolvedTablesWhenUnresolved.size();
        for (int i = 0; i < size; ++i) {
            OMATable unresolvedTable = (OMATable)this.unresolvedTablesWhenUnresolved.get(i);
            unresolvedTable.setOwningRelationalSchema(this);
        }
    }

    @Override
    public List<Table> getContainedTables() throws MetadataException {
        List<Table> outTables;
        _logger.debug(">> getContainedTables");
        if (!this.isUnresolved()) {
            try {
                outTables = this.getReposObjects((List<? extends CMetadata>)this.omrRelationalSchema.getTables(true), Table.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        } else {
            if (this.getV2ResourceResolutionRelationshipsApply()) {
                throw new MetadataUnresolvedException((BusinessModelResource)this, IQModelImplUtilities.getMessageFormatter("BusinessModelUnresolvedCheck.txt", new Object[0]));
            }
            outTables = new ArrayList<Table>(this.unresolvedTablesWhenUnresolved);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getContainedTables returning: " + outTables);
        }
        return outTables;
    }

    @Override
    @CheckForNull
    public Table getTableWithLabel(String tableLabel) throws MetadataException {
        List<Table> tables = this.getContainedTables();
        return this.getTableWithLabel(tableLabel, tables);
    }

    @CheckForNull
    protected Table getTableWithLabel(String tableLabel, List<Table> tables) throws MetadataException {
        Table outTable = null;
        for (Table table : tables) {
            if (!IQModelImplUtilities.sameIgnoreCase(table.getLabel(), tableLabel)) continue;
            if (outTable != null) {
                MessageFormatter errorMsg = IQModelImplUtilities.getMessageFormatter("OMARelationalSchema.DuplicateTableFound.fmt.txt", tableLabel, this.getLabel());
                Reason reason = new Reason((Object)this, 6, 80, errorMsg);
                MetadataException me = new MetadataException(errorMsg, Arrays.asList(reason));
                throw me;
            }
            outTable = table;
        }
        return outTable;
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.RelationalSchema;
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        ArrayList<PhysicalResource> physicalResources = new ArrayList<PhysicalResource>(this.getContainedTables());
        return physicalResources;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
    }

    @Override
    protected boolean isRelational() {
        return true;
    }
}

