/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerCube;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerDimension;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerHierarchy;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerLevel;
import com.sas.iquery.metadata.physical.Connection;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.services.information.MetadataServerInterface;
import com.sas.storage.olap.MetadataInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMAQualifiedLevel
extends OMAResourceImpl
implements QualifiedLevel,
OMAHierarchy.ChildOfHierarchy {
    private static final long serialVersionUID = 1L;
    private OMAHierarchy _hierarchy;
    private Level _jomaLevel;
    private static final Logger _logger = LogManager.getLogger(OMAQualifiedLevel.class);
    private String hierAllMember = null;
    private String uniqueNameOfHierAllMember = null;
    private boolean isDataLoaded = false;

    public OMAQualifiedLevel() {
    }

    public OMAQualifiedLevel(OMAHierarchy hierarchy, Level jomaLevel, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)jomaLevel, hierarchy.getSession(), metadataServer);
        if (jomaLevel == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("QualifiedLevelImplLevelRequired.txt", new Object[0]));
        }
        this._hierarchy = hierarchy;
        this._jomaLevel = jomaLevel;
    }

    public OMAQualifiedLevel(OMAHierarchy hierarchy, String levelName) throws MetadataException {
        super(hierarchy.getSession(), levelName);
        this._hierarchy = hierarchy;
        this._jomaLevel = null;
        this.setUnresolved();
    }

    @Override
    public Hierarchy getOwningHierarchy() throws MetadataException {
        return this._hierarchy;
    }

    @Override
    public void setOwningHierarchy(OMAHierarchy hier) {
        this._hierarchy = hier;
    }

    @Override
    public String getLevelName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getLevelUniqueName() throws MetadataException {
        Dimension dimension = this.getOwningDimension();
        List<Hierarchy> numberOf = dimension.getHierarchies();
        String dim = this._hierarchy.getDimensionName();
        String hie = this._hierarchy.getHierarchyName();
        StringBuffer levelU = new StringBuffer();
        levelU.append("[");
        if (dim.equalsIgnoreCase(hie) && numberOf.size() == 1) {
            levelU.append(hie);
        } else {
            levelU.append(dim);
            levelU.append("].[");
            levelU.append(hie);
        }
        levelU.append("].[");
        levelU.append(this.toString());
        levelU.append("]");
        return levelU.toString();
    }

    @Override
    public String getLevelCaption() throws MetadataException {
        return this.getDescription();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public List<Member> getMembers() throws MetadataException {
        void var1_5;
        void var1_2;
        Object var1_1 = null;
        MetadataInterface metadata = null;
        Dimension dim = this.getOwningDimension();
        if (dim != null) {
            Cube owningCube = dim.getOwningCube();
            if (owningCube != null) {
                OlapSchema olapSchema = owningCube.getOwningOlapSchema();
                if (olapSchema == null) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                Connection conn = ((OMAOlapSchema)olapSchema).getConnection();
                if (conn == null) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                if (!(olapSchema instanceof OMAOlapSchema)) {
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, this.getCubeName(), IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoCredentials.txt"));
                    throw new MetadataException(msF.toString());
                }
                metadata = ((OMAOlapSchema)olapSchema).getMetadata();
            }
            String cubename = this.getCubeName();
            if (metadata == null) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cubename, IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"));
                throw new MetadataException(msF.toString());
            }
            OlapServerCube cube = new OlapServerCube(metadata, cubename);
            List dimensions = cube.getDimensions();
            boolean found = false;
            Iterator it = dimensions.iterator();
            while (it.hasNext() && !found) {
                OlapServerDimension dimension = (OlapServerDimension)it.next();
                dimension.setOwningDimension(this.getOwningDimension());
                List hierarchies = dimension.getHierarchies();
                Iterator ith = hierarchies.iterator();
                while (ith.hasNext() && !found) {
                    OlapServerHierarchy hierarchyO = (OlapServerHierarchy)ith.next();
                    if (!hierarchyO.getHierarchyName().equalsIgnoreCase(this._hierarchy.getHierarchyName())) continue;
                    hierarchyO.setOwnDimension(dimension.getOwningDimension());
                    List levels = hierarchyO.getLevels();
                    Iterator itl = levels.iterator();
                    while (itl.hasNext() && !found) {
                        OlapServerLevel level = (OlapServerLevel)itl.next();
                        String olapName = level.getLevelName();
                        String thisName = this.toString();
                        level.setOwningDimension(this.getOwningDimension());
                        level.setOwningHierarchy(hierarchyO.getOwningHierarchy());
                        if (!olapName.equalsIgnoreCase(thisName)) continue;
                        List list = level.getMembers();
                        found = true;
                    }
                }
            }
        } else if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
            _logger.error(IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesNoDimension.txt"));
        }
        if (var1_2 == null) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQMetadataResourceBundle.getStringResource("HierarchyImplErrorInMember.txt"));
            }
            ArrayList arrayList = new ArrayList();
        }
        return var1_5;
    }

    @Override
    public int getLevelNumber() throws MetadataException {
        this.unresolvedCheck();
        int levelNumber = 0;
        try {
            levelNumber = this._jomaLevel.getCardinality();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return levelNumber;
    }

    @Override
    public String getSasFormat() throws MetadataException {
        return null;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposLevel";
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public String getDimensionName() throws MetadataException {
        return this.getOwningDimension().getLabel();
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        int dimType = this.getOwningDimension().getDimensionType();
        return dimType == 1;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        return this._hierarchy.getOwningDimension();
    }

    @Override
    public String getCubeName() throws MetadataException {
        return this._hierarchy.getCubeName();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        this.unresolvedCheck();
        String uniqueName = null;
        try {
            uniqueName = this._jomaLevel.getUniqueName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return uniqueName;
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        if (!this.isDataLoaded) {
            this.loadData();
        }
        return this.uniqueNameOfHierAllMember;
    }

    @Override
    public String getIdentityString() {
        String msg = IQMetadataResourceBundle.getMessageString("IdentityStringThreeArgs.fmt.txt", "QualifiedLevel", this.getLabel(), "-");
        return msg;
    }

    @Override
    public int getExpressionType() {
        return 3;
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj instanceof OMAQualifiedLevel) {
            OMAQualifiedLevel that = (OMAQualifiedLevel)obj;
            if (IQModelImplUtilities.same(that._hierarchy, this._hierarchy) && IQModelImplUtilities.sameIgnoreCase(that.getLabel(), this.getLabel())) {
                rc = true;
            }
        }
        return rc;
    }

    public int hashCode() {
        int hashCode = 19;
        String label = this.getLabel();
        if (label != null) {
            hashCode += label.hashCode();
        }
        if (this._hierarchy != null) {
            hashCode = hashCode * 7 + this._hierarchy.hashCode();
        }
        return hashCode;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return this._hierarchy;
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Levels";
    }

    private void loadData() throws MetadataException {
        if (!this.isDataLoaded) {
            this.unresolvedCheck();
            try {
                List<com.sas.metadata.remote.Hierarchy> listHiers = AssociationListUtil.filteredSnapshot(this._jomaLevel.getHierarchies(), com.sas.metadata.remote.Hierarchy.class);
                com.sas.metadata.remote.Hierarchy omrHier = listHiers.get(0);
                this.hierAllMember = omrHier.getAllMember();
                if ("".equalsIgnoreCase(this.hierAllMember)) {
                    StringBuffer nameBuffer = new StringBuffer();
                    nameBuffer.append("[");
                    nameBuffer.append(omrHier.getName());
                    nameBuffer.append("].[");
                    String aM = null;
                    try {
                        List<Property> properties = AssociationListUtil.filteredSnapshot(omrHier.getProperties(), Property.class);
                        for (Property property : properties) {
                            if (!property.getPropertyName().equalsIgnoreCase("AllMemberCaption")) continue;
                            aM = property.getDefaultValue();
                            break;
                        }
                    }
                    catch (RemoteException ee) {
                        this.error(ee);
                    }
                    catch (MdException e) {
                        this.error(e);
                    }
                    nameBuffer.append(aM);
                    nameBuffer.append("]");
                    this.hierAllMember = nameBuffer.toString();
                }
                this.uniqueNameOfHierAllMember = this.hierAllMember;
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
    }

    @Override
    public String getType() {
        return IQMetadataResourceBundle.getMessageString("Type.Level.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.QualifiedLevel;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return null;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getOwningHierarchy();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMAHierarchy) {
            this.setOwningHierarchy((OMAHierarchy)parentResource);
        }
    }
}

