/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.LocalizableNamedObjectInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.oma.OMACube;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.OMRPropertySet;
import com.sas.services.session.SessionContextInterface;
import com.sas.util.LocalizableString;
import com.sas.util.LocalizableToStringInterface;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class OMAMeasure
extends OMAResourceImpl
implements Measure,
LocalizableToStringInterface,
LocalizableNamedObjectInterface {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.Measure omrMeasure = null;
    private OMACube owningCubeWhenUnresolved = null;
    LocalizableString _labels = null;
    LocalizableString _descriptions = null;

    public OMAMeasure() {
    }

    public OMAMeasure(com.sas.metadata.remote.Measure omrMeasure, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrMeasure, session, metadataServer);
        this.omrMeasure = omrMeasure;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposMeasure";
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Measures";
    }

    @Override
    public String getMeasureName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getMeasureCaption() throws MetadataException {
        return this.getDescription();
    }

    @Override
    public int getAggregator() throws MetadataException {
        this.unresolvedCheck();
        int type = 9;
        try {
            String statistic = this.omrMeasure.getStatistic();
            if (statistic.equalsIgnoreCase("SUM")) {
                type = 1;
            } else if (statistic.equalsIgnoreCase("AVG")) {
                type = 5;
            } else if (statistic.equalsIgnoreCase("N")) {
                type = 2;
            } else if (statistic.equalsIgnoreCase("MIN")) {
                type = 3;
            } else if (statistic.equalsIgnoreCase("MAX")) {
                type = 4;
            } else if (statistic.equalsIgnoreCase("VAR")) {
                type = 6;
            } else if (statistic.equalsIgnoreCase("STD")) {
                type = 7;
            } else if (statistic.equalsIgnoreCase("CALCULATED")) {
                type = 8;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return type;
    }

    @Override
    public Cube getOwningCube() throws MetadataException {
        OMACube outCube = this.owningCubeWhenUnresolved;
        if (!this.isUnresolved()) {
            try {
                ArrayList cubes = new ArrayList(this.omrMeasure.getCubes());
                if (cubes.size() > 0) {
                    com.sas.metadata.remote.Cube omrCube = (com.sas.metadata.remote.Cube)cubes.get(0);
                    outCube = (OMACube)this.getReposObject((CMetadata)omrCube);
                } else {
                    outCube = null;
                }
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return outCube;
    }

    @Override
    public int getExpressionType() {
        return ExpressionUtil.getExprType(2);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Measure;
    }

    @Override
    public String getDimensionName() throws MetadataException {
        if (this.isUnresolved()) {
            _logger.debug("Measure " + this.getLabel() + " is unresolved so we returned the Type string");
            return this.getType();
        }
        Dimension dim = this.getOwningDimension();
        return dim.getLabel();
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return true;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        this.unresolvedCheck();
        OMADimension outDimension = null;
        try {
            com.sas.metadata.remote.Dimension omrDimension = this.omrMeasure.getOwningDimension();
            outDimension = (OMADimension)this.getReposObject((CMetadata)omrDimension);
        }
        catch (MdException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return outDimension;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getOwningCube());
    }

    @Override
    public String getCubeName() throws MetadataException {
        Cube owningCube = this.getOwningCube();
        return owningCube.getLabel();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        this.unresolvedCheck();
        String uniqueName = null;
        try {
            uniqueName = this.omrMeasure.getUniqueName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return uniqueName;
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        return this.getUniqueName();
    }

    @Override
    public String getMeasureUniqueName() throws MetadataException {
        return this.getUniqueName();
    }

    @Override
    public String getSasFormat() throws MetadataException {
        this.unresolvedCheck();
        String format = null;
        try {
            format = this.omrMeasure.getSASFormat();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return format;
    }

    public void setOwningCube(OMACube inputOwningCube) {
        this.owningCubeWhenUnresolved = inputOwningCube;
    }

    @Override
    public String getType() {
        return IQMetadataResourceBundle.getStringResource("Type.Measure.txt");
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        return null;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getOwningCube();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMACube) {
            this.setOwningCube((OMACube)parentResource);
        }
    }

    public String toString(Locale locale) {
        return this.getLabel(locale);
    }

    @Override
    public String getLabel(Locale locale) {
        if (locale == null) {
            return this.getLabel();
        }
        LocalizableString labels = this.getLabels();
        if (labels == null) {
            return this.getLabel();
        }
        return labels.getText(locale);
    }

    @Override
    public String getDescription(Locale locale) {
        if (locale == null) {
            return this.getDescription();
        }
        LocalizableString descriptions = this.getDescriptions();
        if (descriptions == null) {
            return this.getDescription();
        }
        return descriptions.getText(locale);
    }

    @Override
    public LocalizableString getLabels() {
        LocalizableString dup = null;
        if (this._labels == null) {
            this._labels = this._getLabels();
        }
        try {
            dup = (LocalizableString)this._labels.clone();
        }
        catch (CloneNotSupportedException e) {
            dup = IQModelImplUtilities.copyToLocalizablePersistableString(this._labels);
        }
        return dup;
    }

    protected LocalizableString _getLabels() {
        LocalizablePersistableString labels = new LocalizablePersistableString();
        try {
            Cube owningCube = this.getOwningCube();
            ArrayList<String> locales = new ArrayList<String>();
            List properties = ((OMACube)owningCube).getJFSObject().getPropertySets();
            for (Object object : properties) {
                List locs = ((OMRPropertySet)object).getSetProperties();
                for (Object object2 : locs) {
                    String loc = ((OMRProperty)object2).getValue();
                    locales.add(loc);
                }
            }
            labels = IOMServerUtils.getOLAPMeasureCaptions(this.session, this.getMetadataServer(), this.omrMeasure, locales);
        }
        catch (Exception e) {
            String msg = "Error encountered when getting labels from the server. ";
            ConnectionUtil.LoggerErrorWithObjects(_logger, msg, e);
        }
        return labels;
    }

    @Override
    public LocalizableString getDescriptions() {
        if (this._descriptions == null) {
            this._descriptions = new LocalizablePersistableString();
        }
        return this._descriptions;
    }
}

