/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.execution2.MLSValueInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.metadata.physical.MLSLookupDetailsTable;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.datalocalization.DataLocalizationModel;
import com.sas.services.information.metadata.datalocalization.InvalidModelOperationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OMAMLSLookupDetailsTable
implements MLSLookupDetailsTable {
    private static final Logger _logger = LogManager.getLogger(OMAMLSLookupDetailsTable.class);
    private final String lookupQueryDefKey;
    private final DataTableInterface detailDataTable;
    private final DataLocalizationModel.Type modelType;
    private final ColumnInterface keyColumn;
    private final ColumnInterface localeColumn;
    private final Set<ColumnInterface> valueColumns = new LinkedHashSet<ColumnInterface>();
    private final Map<ColumnInterface, String> foreignKeyColumns = new LinkedHashMap<ColumnInterface, String>();
    private final Set<SASLibraryInterface> _neededLibrefAssignments = new LinkedHashSet<SASLibraryInterface>();

    public static String generateLookupDefKey(DataTableInterface detailDataTable, DataLocalizationModel.Type modelType) throws MetadataException {
        String lookupDefKey;
        try {
            String reposKey = detailDataTable.getReposKey();
            String name = modelType.name();
            lookupDefKey = reposKey + ":" + name;
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return lookupDefKey;
    }

    public static OMAMLSLookupDetailsTable newDetailLookupDef(String lookupQueryDefKey, DataLocalizationModel model, DataTableInterface detailDataTable) throws MetadataException {
        OMAMLSLookupDetailsTable lookupQueryDef;
        try {
            DataLocalizationModel.Type modelType = model.getModelType(detailDataTable);
            ColumnInterface keyColumn = model.getKeyColumn(detailDataTable);
            ColumnInterface localeColumn = model.getLocaleColumn(detailDataTable);
            List valueColumns = model.getValueColumns(detailDataTable);
            lookupQueryDef = new OMAMLSLookupDetailsTable(lookupQueryDefKey, detailDataTable, modelType, keyColumn, localeColumn, valueColumns);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return lookupQueryDef;
    }

    private OMAMLSLookupDetailsTable(String lookupQueryDefKey, DataTableInterface detailDataTable, DataLocalizationModel.Type modelType, ColumnInterface keyColumn, ColumnInterface localeColumn, List<ColumnInterface> valueColumns) {
        this.lookupQueryDefKey = lookupQueryDefKey;
        this.detailDataTable = detailDataTable;
        this.modelType = modelType;
        this.keyColumn = keyColumn;
        this.localeColumn = localeColumn;
        this.valueColumns.addAll(valueColumns);
    }

    @Override
    public String getLookupQueryDefKey() {
        return this.lookupQueryDefKey;
    }

    public DataLocalizationModel.Type getModelType() {
        return this.modelType;
    }

    @Override
    public Set<SASLibraryInterface> getNeededLibrefAssignments() {
        return this._neededLibrefAssignments;
    }

    public DataTableInterface getDetailDataTable() {
        return this.detailDataTable;
    }

    public ColumnInterface getKeyColumn() {
        return this.keyColumn;
    }

    public ColumnInterface getLocaleColumn() {
        return this.localeColumn;
    }

    public void addForeignKeyColumn(ColumnInterface foreignKeyColumn, String columnName) {
        this.foreignKeyColumns.put(foreignKeyColumn, columnName);
    }

    public Map<ColumnInterface, String> getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public Set<ColumnInterface> getValueColumns() {
        return this.valueColumns;
    }

    public String getLookupValuesSql(Set<SASLibrary> requiredLibrefs, ColumnInterface baseTableColumn, boolean includeExtraColumns, Locale lookupLocaleValue, Object ... lookupKeyValues) throws MetadataException {
        String sql;
        LookupQueryType lookupType = includeExtraColumns ? LookupQueryType.MATCHING_WITH_EXTRA_VALUES : LookupQueryType.MATCHING_VALUE;
        try {
            sql = this.getLookupSql(requiredLibrefs, lookupType, baseTableColumn, lookupLocaleValue, lookupKeyValues);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        return sql;
    }

    public String servicesEverythingSql(Set<SASLibrary> needLibrefAssignments) throws MetadataException {
        String sql;
        try {
            sql = this.getLookupSql(needLibrefAssignments, LookupQueryType.MATCHING_WITH_EXTRA_VALUES, null, null, new Object[0]);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        return sql;
    }

    public String servicesLookupLocalesSql(Set<SASLibrary> needLibrefAssignments) throws MetadataException {
        String sql;
        try {
            sql = this.getLookupSql(needLibrefAssignments, LookupQueryType.LOCALES, null, null, new Object[0]);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        return sql;
    }

    public String servicesLookupKeysSql(Set<SASLibrary> needLibrefAssignments) throws MetadataException {
        String sql;
        try {
            sql = this.getLookupSql(needLibrefAssignments, LookupQueryType.KEYS, null, null, new Object[0]);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
        return sql;
    }

    private String getLookupSql(Set<SASLibrary> requiredLibrefs, LookupQueryType lookupType, ColumnInterface baseTableColumn, Locale lookupLocaleValue, Object ... lookupKeyValues) throws RemoteException, ServiceException, MdException, MetadataException {
        boolean matchLocale = lookupLocaleValue != null;
        boolean matchKeyValue = lookupKeyValues != null && lookupKeyValues.length != 0;
        DataTableInterface detailDataTable = this.getDetailDataTable();
        DataTable omrDetailDataTable = OMAMLSLookupDetailsTable.getRemoteDataTable(detailDataTable);
        ColumnInterface keyColumn = this.getKeyColumn();
        Column omrKeyColumn = OMAMLSLookupDetailsTable.getRemoteColumn(keyColumn);
        ColumnInterface localeColumn = this.getLocaleColumn();
        Set<ColumnInterface> valueColumns = this.getValueColumns();
        LinkedHashSet<Column> omrValueColumns = new LinkedHashSet<Column>();
        if (valueColumns != null && valueColumns.size() != 0) {
            for (ColumnInterface valueColumn : valueColumns) {
                Column omrValueColumn = OMAMLSLookupDetailsTable.getRemoteColumn(valueColumn);
                omrValueColumns.add(omrValueColumn);
            }
        }
        Column omrForeignKeyColumn = baseTableColumn == null ? null : OMAMLSLookupDetailsTable.getRemoteColumn(baseTableColumn);
        Column omrLocaleColumn = OMAMLSLookupDetailsTable.getRemoteColumn(localeColumn);
        return this.getLookupSql(requiredLibrefs, lookupType, omrForeignKeyColumn, omrDetailDataTable, omrKeyColumn, omrLocaleColumn, omrValueColumns, matchLocale, lookupLocaleValue, matchKeyValue, lookupKeyValues);
    }

    private String getLookupSql(Set<SASLibrary> requiredLibrefs, LookupQueryType lookupType, Column omrForeignKeyColumn, DataTable omrDetailDataTable, Column omrKeyColumn, Column omrLocaleColumn, Set<Column> omrValueColumns, boolean matchLocale, Locale lookupLocaleValue, boolean matchKeyValue, Object ... lookupKeyValues) throws RemoteException, MdException, MetadataException {
        String columnType;
        RelationalSchema omrDetailDataSchema = omrDetailDataTable.getTablePackage();
        String detailTableLibref = OMAMLSLookupDetailsTable.getLibrefAssignment(requiredLibrefs, omrDetailDataSchema);
        if (detailTableLibref == null) {
            throw new MetadataException("The libref of the detail table \"" + omrDetailDataTable.getName() + "\" could not be found. " + omrDetailDataSchema.getName());
        }
        LinkedHashSet<String> omrValueColumnNames = new LinkedHashSet<String>();
        for (Column omrValueColumn : omrValueColumns) {
            String omrValueColumnName = omrValueColumn.getColumnName();
            if (omrValueColumnName == null || omrValueColumnName.trim().isEmpty()) {
                omrValueColumnName = omrValueColumn.getSASColumnName();
            }
            omrValueColumnNames.add(omrValueColumnName);
        }
        String detailDataTableName = omrDetailDataTable.getTableName();
        String detailKeyColumnName = omrKeyColumn.getColumnName();
        if (detailKeyColumnName == null || detailKeyColumnName.trim().isEmpty()) {
            detailKeyColumnName = omrKeyColumn.getSASColumnName();
        }
        boolean quoteKeyColumnValue = (columnType = omrKeyColumn.getSASColumnType()) != null && columnType.equalsIgnoreCase("C");
        String detailLocaleColumnName = omrLocaleColumn.getColumnName();
        if (detailLocaleColumnName == null || detailLocaleColumnName.trim().isEmpty()) {
            detailLocaleColumnName = omrLocaleColumn.getSASColumnName();
        }
        String baseForeignKeyColumnName = null;
        if (omrForeignKeyColumn != null && ((baseForeignKeyColumnName = omrForeignKeyColumn.getColumnName()) == null || baseForeignKeyColumnName.trim().isEmpty())) {
            baseForeignKeyColumnName = omrForeignKeyColumn.getSASColumnName();
        }
        return this.getLookupSql(lookupType, baseForeignKeyColumnName, detailTableLibref, detailDataTableName, detailKeyColumnName, detailLocaleColumnName, omrValueColumnNames, matchLocale, lookupLocaleValue, matchKeyValue, quoteKeyColumnValue, lookupKeyValues);
    }

    public static boolean isPreassigned(SASLibrary baseSASLibrary) throws RemoteException {
        int isPreassigned = baseSASLibrary.getIsPreassigned();
        return isPreassigned != 0;
    }

    public static String getLibrefAssignment(Set<SASLibrary> needLibrefAssignments, RelationalSchema omrDetailDataSchema) throws RemoteException {
        String locTableLibref = null;
        if (omrDetailDataSchema instanceof SASLibrary) {
            SASLibrary omrDetailSASLibrary = (SASLibrary)omrDetailDataSchema;
            locTableLibref = omrDetailSASLibrary.getLibref();
            if (!OMAMLSLookupDetailsTable.isPreassigned(omrDetailSASLibrary)) {
                boolean found = false;
                for (SASLibrary library : needLibrefAssignments) {
                    if (!library.getLibref().equalsIgnoreCase(locTableLibref)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    needLibrefAssignments.add(omrDetailSASLibrary);
                }
            }
        }
        return locTableLibref;
    }

    private void loadLibrefs(CredentialResolver resolver, Set<String> neededLibrefs, Set<SASLibrary> requiredLibrefs) throws MetadataException {
        try {
            for (SASLibrary library : requiredLibrefs) {
                boolean isPreassigned = OMAMLSLookupDetailsTable.isPreassigned(library);
                if (isPreassigned) continue;
                String libnameStatement = this.getLibnameStatement(resolver, library);
                neededLibrefs.add(libnameStatement);
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        catch (MdException e) {
            throw new MetadataException(e);
        }
    }

    private String getLibnameStatement(CredentialResolver resolver, SASLibrary library) throws RemoteException, MdException {
        String prompt = null;
        boolean encodePasswords = true;
        boolean genFileNameForXMLLibs = true;
        boolean ignorePreassigned = false;
        boolean readonlyLibname = false;
        MdLibGenInterface generator = MdModelUtil.getInstance((CredentialResolver)resolver, prompt, (boolean)encodePasswords, (boolean)genFileNameForXMLLibs, (boolean)ignorePreassigned, (boolean)readonlyLibname);
        String libnameStatement = generator.genLibname(library);
        return libnameStatement;
    }

    private String getLookupSql(LookupQueryType lookupType, String foreignKeyColumnName, String tableLibrefName, String tableName, String keyColumnName, String localeColumnName, Set<String> extraColumnNames, boolean matchLocale, Locale lookupLocaleValue, boolean matchKeyValue, boolean quoteKeyColumnValue, Object ... lookupKeyValues) throws MetadataException {
        String firstValueColumnName;
        String valueColumnName = extraColumnNames == null || extraColumnNames.size() == 0 ? keyColumnName : (foreignKeyColumnName == null ? (firstValueColumnName = extraColumnNames.iterator().next()) : (extraColumnNames.contains(foreignKeyColumnName) ? foreignKeyColumnName : (firstValueColumnName = extraColumnNames.iterator().next())));
        LinkedHashSet<String> localeStrings = new LinkedHashSet<String>();
        if (matchLocale) {
            String p1 = lookupLocaleValue.getLanguage();
            String p2 = lookupLocaleValue.getCountry();
            String p3 = lookupLocaleValue.getVariant();
            localeStrings.add(lookupLocaleValue.toString());
            if (p3 != null && !p3.trim().isEmpty()) {
                localeStrings.add(new Locale(p1, p2, "").toString());
            }
            if (p2 != null && !p2.trim().isEmpty()) {
                localeStrings.add(new Locale(p1, "", "").toString());
            }
            if (p1 != null && !p1.trim().isEmpty()) {
                localeStrings.add(new Locale("", "", "").toString());
            }
        }
        return this.getLookupSql(lookupType, tableLibrefName, tableName, keyColumnName, localeColumnName, valueColumnName, extraColumnNames, matchLocale, localeStrings, matchKeyValue, quoteKeyColumnValue, lookupKeyValues);
    }

    private String getLookupSql(LookupQueryType lookupType, String tableLibrefName, String tableName, String keyColumnName, String localeColumnName, String valueColumnName, Collection<String> extraColumnNames, boolean matchLocale, Collection<String> localeStrings, boolean matchKeyValue, boolean quoteKeyColumnValue, Object ... lookupKeyValues) throws MetadataException {
        String localeSourceColumn;
        String keySourceColumn;
        boolean returnKeyColumn = lookupType.returnKeyColumn;
        boolean returnLocaleColumn = lookupType.returnLocaleColumn;
        boolean returnValueColumn = lookupType.returnValueColumn;
        boolean returnExtraColumns = lookupType.returnExtraColumns;
        String tableAlias = "lookup";
        StringBuffer sbQuery = new StringBuffer();
        sbQuery.append("Select distinct ");
        String colSep = "\n    ";
        if (returnKeyColumn) {
            keySourceColumn = GenerationUtil.generateFullyQualifiedIdentifier("lookup", keyColumnName);
            sbQuery.append(colSep).append(keySourceColumn).append("  as _key_");
            colSep = ",\n    ";
        } else {
            keySourceColumn = null;
        }
        if (returnLocaleColumn) {
            localeSourceColumn = GenerationUtil.generateFullyQualifiedIdentifier("lookup", localeColumnName);
            sbQuery.append(colSep).append(localeSourceColumn).append(" as _locale_");
            colSep = ",\n    ";
            if (matchLocale) {
                sbQuery.append(colSep);
                int j = 0;
                sbQuery.append("(case trim(").append(localeSourceColumn).append(")");
                for (String string : localeStrings) {
                    sbQuery.append("\n      when '").append(string).append("' then " + ++j);
                }
                sbQuery.append("\n      else 0 end) as _localeLevel_");
            }
        } else {
            localeSourceColumn = null;
        }
        if (returnValueColumn && valueColumnName != null) {
            String valueSourceColumn = GenerationUtil.generateFullyQualifiedIdentifier("lookup", valueColumnName);
            sbQuery.append(colSep).append(valueSourceColumn).append(" as _value_");
            colSep = ",\n    ";
        }
        if (returnExtraColumns && extraColumnNames != null && extraColumnNames.size() > 0) {
            for (String omrValueColumnName : extraColumnNames) {
                String extraValueSourceColumn = GenerationUtil.generateFullyQualifiedIdentifier("lookup", omrValueColumnName);
                sbQuery.append(colSep).append(extraValueSourceColumn);
                colSep = ",\n    ";
            }
        }
        String fromTable = GenerationUtil.generateFullyQualifiedIdentifier(tableLibrefName, tableName);
        sbQuery.append("\n  from ").append(fromTable).append(" ").append("lookup");
        if (matchKeyValue || matchLocale && returnLocaleColumn) {
            int len = sbQuery.length();
            sbQuery.append("\n  where ");
            if (matchKeyValue) {
                if (quoteKeyColumnValue) {
                    sbQuery.append("trim(").append(keySourceColumn).append(")");
                } else {
                    sbQuery.append(keySourceColumn);
                }
                if (lookupKeyValues.length == 1) {
                    Object object = lookupKeyValues[0];
                    String text = this.getText(object, quoteKeyColumnValue);
                    sbQuery.append(" = ").append(text);
                } else {
                    sbQuery.append(" in (");
                    String valSep = "";
                    for (Object lookupKeyValue : lookupKeyValues) {
                        sbQuery.append(valSep);
                        if (sbQuery.length() - len > 50) {
                            len = sbQuery.length();
                            sbQuery.append("\n      ");
                        }
                        String text = this.getText(lookupKeyValue, quoteKeyColumnValue);
                        sbQuery.append(text);
                        valSep = ",";
                    }
                    sbQuery.append(")");
                }
            }
            if (matchKeyValue && matchLocale && returnLocaleColumn) {
                sbQuery.append("\n   and ");
            }
            if (matchLocale && returnLocaleColumn) {
                sbQuery.append("calculated _localeLevel_ > 0");
            }
        }
        if (returnKeyColumn) {
            if (returnLocaleColumn) {
                if (matchLocale) {
                    sbQuery.append("\n  order by 1, 2, 3");
                } else {
                    sbQuery.append("\n  order by 1, 2");
                }
            } else {
                sbQuery.append("\n  order by 1");
            }
        } else if (returnLocaleColumn) {
            if (matchLocale) {
                sbQuery.append("\n  order by 1, 2");
            } else {
                sbQuery.append("\n  order by 1");
            }
        }
        sbQuery.append(";");
        return sbQuery.toString();
    }

    private String getText(Object object, boolean quoteKeyColumnValue) throws MetadataException {
        String text = null;
        if (object instanceof MLSValueInterface) {
            MLSValueInterface valueDef = (MLSValueInterface)object;
            Object value = valueDef.getValue();
            text = String.valueOf(value);
            if (quoteKeyColumnValue) {
                String val = text.trim();
                text = GenerationUtil.generateQuotedLiteral(val);
            } else {
                text = text.trim();
            }
        } else if (object instanceof ExpressionInterface) {
            ExpressionInterface expr = (ExpressionInterface)object;
            List<BusinessModelResource> resources = expr.getResources(BusinessModelResource.class, 65535);
            text = StringExpressionUtil.getInstance().getText(expr);
            if (resources != null & resources.size() > 0) {
                throw new MetadataException("The localization query does not support dynamically calculated key values.  The following value cannot be used: " + text + ".");
            }
            boolean utilDidNotQuote = false;
            if (object instanceof StringExpression && !(expr instanceof ResourceAwareStringExpression)) {
                utilDidNotQuote = true;
            } else {
                boolean bl = utilDidNotQuote = expr.getExpressionType() != 3;
            }
            if (quoteKeyColumnValue && utilDidNotQuote) {
                String val = text.trim();
                text = GenerationUtil.generateQuotedLiteral(val);
            }
        } else if (object == null) {
            text = null;
        } else {
            text = String.valueOf(object);
            if (quoteKeyColumnValue) {
                String val = text.trim();
                text = GenerationUtil.generateQuotedLiteral(val);
            }
        }
        return text;
    }

    public static DataTable getRemoteDataTable(DataTableInterface dataTable) throws RemoteException {
        return (DataTable)dataTable.getRepositoryEntity();
    }

    public static String getTableName(DataTableInterface servicesTable) throws MetadataException {
        String tableName = null;
        try {
            DataTable remoteDataTable = OMAMLSLookupDetailsTable.getRemoteDataTable(servicesTable);
            tableName = remoteDataTable.getTableName();
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return tableName;
    }

    public static Column getRemoteColumn(ColumnInterface column) throws RemoteException {
        return (Column)column.getRepositoryEntity();
    }

    public static String getColumnName(ColumnInterface servicesColumn) throws MetadataException {
        String columnName = null;
        try {
            Column remoteColumn = OMAMLSLookupDetailsTable.getRemoteColumn(servicesColumn);
            columnName = remoteColumn.getColumnName();
            if (columnName == null || columnName.trim().isEmpty()) {
                columnName = remoteColumn.getSASColumnName();
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return columnName;
    }

    public <T> List<T> getExtraColumns(Class<T> cls) throws RemoteException {
        boolean useRemoteObject;
        ArrayList<T> list = new ArrayList<T>();
        if (ColumnInterface.class.isAssignableFrom(cls)) {
            useRemoteObject = false;
        } else if (Column.class.isAssignableFrom(cls)) {
            useRemoteObject = true;
        } else {
            throw new IllegalArgumentException("Invalid class parameter " + cls.getName() + " to getExtraColumns(...). Only " + ColumnInterface.class.getName() + " and " + Column.class.getName() + " are valid.");
        }
        Set<ColumnInterface> valueColumns = this.getValueColumns();
        LinkedHashSet<String> omrValueColumnNames = new LinkedHashSet<String>();
        LinkedHashSet<Column> omrValueColumns = new LinkedHashSet<Column>();
        if (valueColumns != null && valueColumns.size() != 0) {
            for (ColumnInterface valueColumn : valueColumns) {
                Column omrValueColumn = OMAMLSLookupDetailsTable.getRemoteColumn(valueColumn);
                if (!omrValueColumns.add(omrValueColumn)) continue;
                String omrValueColumnName = omrValueColumn.getColumnName();
                if (omrValueColumnName == null || omrValueColumnName.trim().isEmpty()) {
                    omrValueColumnName = omrValueColumn.getSASColumnName();
                }
                if (!omrValueColumnNames.add(omrValueColumnName)) continue;
                if (useRemoteObject) {
                    list.add(cls.cast(omrValueColumn));
                    continue;
                }
                list.add(cls.cast(valueColumn));
            }
        }
        return list;
    }

    @Override
    public String getEverythingSql(CredentialResolver resolver, Set<String> neededLibrefs) throws MetadataException {
        LinkedHashSet<SASLibrary> requiredLibrefs = new LinkedHashSet<SASLibrary>();
        String sql = this.servicesEverythingSql(requiredLibrefs);
        this.loadLibrefs(resolver, neededLibrefs, requiredLibrefs);
        return sql;
    }

    @Override
    public String getLookupKeysSql(CredentialResolver resolver, Set<String> neededLibrefs) throws MetadataException {
        LinkedHashSet<SASLibrary> requiredLibrefs = new LinkedHashSet<SASLibrary>();
        String sql = this.servicesLookupKeysSql(requiredLibrefs);
        this.loadLibrefs(resolver, neededLibrefs, requiredLibrefs);
        return sql;
    }

    @Override
    public String getLookupLocalesSql(CredentialResolver resolver, Set<String> neededLibrefs) throws MetadataException {
        LinkedHashSet<SASLibrary> requiredLibrefs = new LinkedHashSet<SASLibrary>();
        String sql = this.servicesLookupLocalesSql(requiredLibrefs);
        this.loadLibrefs(resolver, neededLibrefs, requiredLibrefs);
        return sql;
    }

    @Override
    public String getLookupValuesSql(CredentialResolver resolver, Set<String> neededLibrefs, String baseTableColumnName, boolean includeExtraColumns, Locale lookupLocaleValue, Object ... lookupKeyValues) throws MetadataException {
        ColumnInterface baseColumn = null;
        for (Map.Entry<ColumnInterface, String> entry : this.foreignKeyColumns.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(baseTableColumnName)) continue;
            baseColumn = entry.getKey();
            break;
        }
        LinkedHashSet<SASLibrary> requiredLibrefs = new LinkedHashSet<SASLibrary>();
        String sql = this.getLookupValuesSql(requiredLibrefs, baseColumn, includeExtraColumns, lookupLocaleValue, lookupKeyValues);
        this.loadLibrefs(resolver, neededLibrefs, requiredLibrefs);
        return sql;
    }

    @Override
    public String getModelTypeName() throws MetadataException {
        DataLocalizationModel.Type modelType = this.getModelType();
        return modelType == null ? null : modelType.toString();
    }

    @Override
    public String getSchemaName() throws MetadataException {
        String schemaName = null;
        DataTableInterface dataTable = this.getDetailDataTable();
        if (this.detailDataTable != null) {
            try {
                DataTable remoteDataTable = OMAMLSLookupDetailsTable.getRemoteDataTable(dataTable);
                RelationalSchema remoteSchema = remoteDataTable.getTablePackage();
                if (remoteSchema instanceof SASLibrary) {
                    SASLibrary omrDetailSASLibrary = (SASLibrary)remoteSchema;
                    schemaName = omrDetailSASLibrary.getLibref();
                } else {
                    schemaName = remoteSchema.getName();
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
        }
        return schemaName;
    }

    @Override
    public String getTableName() throws MetadataException {
        DataTableInterface servicesTable = this.getDetailDataTable();
        return OMAMLSLookupDetailsTable.getTableName(servicesTable);
    }

    @Override
    public String getKeyColumnName() throws MetadataException {
        ColumnInterface servicesColumn = this.getKeyColumn();
        return OMAMLSLookupDetailsTable.getColumnName(servicesColumn);
    }

    @Override
    public String getLocaleColumnName() throws MetadataException {
        ColumnInterface servicesColumn = this.getLocaleColumn();
        return OMAMLSLookupDetailsTable.getColumnName(servicesColumn);
    }

    @Override
    public String getValueColumnName(String foreignKeyColumnName) throws MetadataException {
        Map<ColumnInterface, String> foreignKeyColumns = this.getForeignKeyColumns();
        ColumnInterface valueColumn = null;
        for (Map.Entry<ColumnInterface, String> entry : foreignKeyColumns.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(foreignKeyColumnName)) continue;
            valueColumn = entry.getKey();
            break;
        }
        if (valueColumn == null) {
            valueColumn = this.getValueColumns().iterator().next();
        }
        String valueColumnName = OMAMLSLookupDetailsTable.getColumnName(valueColumn);
        return valueColumnName;
    }

    @Override
    public String[] getExtraColumnNames() throws MetadataException {
        String[] extraColumnNames;
        try {
            List<Column> extraColumns = this.getExtraColumns(Column.class);
            extraColumnNames = new String[extraColumns.size()];
            if (extraColumns != null && extraColumns.size() > 0) {
                for (int i = 0; i < extraColumns.size(); ++i) {
                    Column column = extraColumns.get(i);
                    String columnName = column.getColumnName();
                    if (columnName == null || columnName.trim().isEmpty()) {
                        columnName = column.getSASColumnName();
                    }
                    extraColumnNames[i] = columnName;
                }
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return extraColumnNames;
    }

    public static MLSLookup buildMLSLookup(DataTableInterface miTable, ColumnInterface miColumn, String foreignKeyColumnName, DataLocalizationModel model, DataLocalizationModel.Type modelType, Map<String, MLSLookup> lookupsCache) throws InvalidModelOperationException, ServiceException, RemoteException, MetadataException {
        RelationalSchemaInterface schema;
        String mlsLookupKey;
        MLSLookup mlsLookup = null;
        DataTableInterface detailDataTable = model.getDetailTable(miColumn);
        if (detailDataTable != null && (mlsLookup = lookupsCache.get(mlsLookupKey = OMAMLSLookupDetailsTable.generateLookupDefKey(detailDataTable, modelType))) == null) {
            mlsLookup = OMAMLSLookupDetailsTable.newDetailLookupDef(mlsLookupKey, model, detailDataTable);
            lookupsCache.put(mlsLookupKey, mlsLookup);
        }
        if (mlsLookup instanceof OMAMLSLookupDetailsTable) {
            ((OMAMLSLookupDetailsTable)mlsLookup).addForeignKeyColumn(miColumn, foreignKeyColumnName);
        }
        if ((schema = miTable.getSchema()) instanceof SASLibraryInterface) {
            Set<SASLibraryInterface> needLibrefAssignments = mlsLookup.getNeededLibrefAssignments();
            SASLibraryInterface library = (SASLibraryInterface)schema;
            boolean isPreassigned = library.isPreassigned();
            if (!isPreassigned) {
                needLibrefAssignments.add(library);
            }
        }
        return mlsLookup;
    }

    public static MLSLookup buildMLSLookup(DataLocalizationModel model, ColumnInterface miColumn, String foreignKeyColumnName, Map<String, MLSLookup> lookupsCache) throws MetadataException {
        MLSLookup mlsLookup = null;
        try {
            DataTableInterface miTable = miColumn.getTable();
            DataLocalizationModel.Type modelType = model.getModelType(miTable);
            if (modelType != null) {
                switch (modelType) {
                    case DETAIL_TABLES: {
                        mlsLookup = OMAMLSLookupDetailsTable.buildMLSLookup(miTable, miColumn, foreignKeyColumnName, model, modelType, lookupsCache);
                        break;
                    }
                    default: {
                        _logger.warn("Localization model for table '" + miTable.getTableName() + "' was of unknown type: '" + modelType + "'");
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return mlsLookup;
    }

    protected static enum LookupQueryType {
        KEYS(true, false, false, false),
        LOCALES(false, true, false, false),
        MATCHING_VALUE(true, true, true, false),
        MATCHING_WITH_EXTRA_VALUES(true, true, true, true);

        public boolean returnKeyColumn;
        public boolean returnLocaleColumn;
        public boolean returnValueColumn;
        public boolean returnExtraColumns;

        private LookupQueryType(boolean returnKeyColumn, boolean returnLocaleColumn, boolean returnValueColumns, boolean returnExtraColumns) {
            this.returnKeyColumn = returnKeyColumn;
            this.returnLocaleColumn = returnLocaleColumn;
            this.returnValueColumn = returnValueColumns;
            this.returnExtraColumns = returnExtraColumns;
        }
    }
}

