/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.Index;
import com.sas.iquery.metadata.physical.IndexKey;
import com.sas.iquery.metadata.physical.oma.OMAColumn;
import com.sas.iquery.metadata.physical.oma.OMAIndexKey;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.physical.oma.OMAWrapperImpl;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.List;

public class OMAIndex
extends OMAWrapperImpl
implements Index {
    private com.sas.metadata.remote.Index omrIndex;
    private IndexKey indexKey = null;

    public OMAIndex(com.sas.metadata.remote.Index omrIndex, SessionContextInterface session, MetadataServerInterface metadataServer) {
        super((CMetadata)omrIndex, session, metadataServer);
        this.omrIndex = omrIndex;
        OMATable omaTable = null;
        List<OMAColumn> omaColumns = null;
        try {
            PhysicalTable omrTable = omrIndex.getOwningPhysicalTable();
            omaTable = (OMATable)this.getReposObject((CMetadata)omrTable);
            omaColumns = this.getReposObjects((List<? extends CMetadata>)omrIndex.getColumns(), OMAColumn.class);
        }
        catch (MdException e) {
            this.warn(e.getLocalizedMessage());
        }
        catch (RemoteException e) {
            this.warn(e.getLocalizedMessage());
        }
        catch (MetadataException e) {
            this.warn(e.getLocalizedMessage());
        }
        this.indexKey = new OMAIndexKey(this, omaTable, omaColumns);
    }

    @Override
    public IndexKey getKey() {
        return this.indexKey;
    }

    @Override
    public String getIndexName() throws MetadataException {
        String indexName = null;
        try {
            indexName = this.omrIndex.getIndexName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return indexName;
    }

    @Override
    public boolean isClustered() throws MetadataException {
        boolean isClustered = false;
        try {
            if (this.omrIndex.getIsClustered() != 0) {
                isClustered = true;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return isClustered;
    }

    @Override
    public boolean isMissingValueMaintainedByIndex() throws MetadataException {
        boolean isNoMiss = false;
        try {
            if (this.omrIndex.getIsNoMiss() != 0) {
                isNoMiss = true;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return isNoMiss;
    }

    @Override
    public boolean isUnique() throws MetadataException {
        boolean isUnique = false;
        try {
            if (this.omrIndex.getIsUnique() != 0) {
                isUnique = true;
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return isUnique;
    }
}

