/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.QualifiedLevelImpl;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerMember;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMember;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMALevel;
import com.sas.iquery.metadata.physical.oma.OMANamedSet;
import com.sas.iquery.metadata.physical.oma.OMAQualifiedLevel;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class OMAHierarchy
extends OMAResourceImpl
implements Hierarchy {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.Hierarchy _omrHierarchy = null;
    private OMADimension _owningDimensionWhenUnresolved = null;
    private List _qualifiedLevels = new ArrayList();
    private String _hierAllMember = null;
    private String _uniqueNameOfHierAllMember = null;
    private MetadataInterface _metadata = null;
    private OlapServerMember _defaultMember = null;
    private boolean _isDataLoaded = false;
    private volatile AllLevel _allLevel;
    private List<OMACalculatedMember> _calMembers = new ArrayList<OMACalculatedMember>();
    private List<OMANamedSet> _namedSets = new ArrayList<OMANamedSet>();
    private static final Logger _OMALogger = LogManager.getLogger((String)"com.sas.iquery.metadata.physical.oma");
    private static final Logger _logger = LogManager.getLogger(OMAHierarchy.class);

    public OMAHierarchy() {
    }

    public OMAHierarchy(com.sas.metadata.remote.Hierarchy omrHierarchy, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrHierarchy, session, metadataServer);
        this._omrHierarchy = omrHierarchy;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposHierarchy";
    }

    @Override
    public String getHierarchyName() throws MetadataException {
        return this.getLabel();
    }

    @Override
    public String getHierarchyCaption() throws MetadataException {
        return this.getDescription();
    }

    @Override
    public List<Level> getLevels() throws MetadataException {
        return this.getLevels(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Level> getLevels(boolean includeAllLevel) throws MetadataException {
        ArrayList<Level> outLevels;
        if (this.isUnresolved()) {
            outLevels = new ArrayList<Level>(this._qualifiedLevels);
        } else {
            boolean isDebug = _OMALogger.isDebugEnabled();
            try {
                ArrayList omrLevels = new ArrayList(this._omrHierarchy.getLevels());
                if (isDebug) {
                    _logger.debug(IQMetadataResourceBundle.getMessageString("HierarchyImplGetOMRLevels.fmt.txt", String.valueOf(omrLevels.size()), this.getHierarchyName()));
                }
                ArrayList<OMAQualifiedLevel> qualified = new ArrayList<OMAQualifiedLevel>(omrLevels.size());
                for (Object omrLevel : omrLevels) {
                    if (isDebug) {
                        _logger.debug(IQMetadataResourceBundle.getMessageString("HierarchyImplGetLevels.fmt.txt", omrLevel.toString(), omrLevel.getClass().getName()));
                    }
                    OMAQualifiedLevel qLevel = this.getRepresentativeLevel((com.sas.metadata.remote.Level)omrLevel, false);
                    qualified.add(qLevel);
                }
                AllLevel result = null;
                if (includeAllLevel && (result = this._allLevel) == null) {
                    Object omrLevel;
                    omrLevel = this;
                    synchronized (omrLevel) {
                        result = this._allLevel;
                        if (result == null) {
                            this._allLevel = result = new AllLevel(this);
                        }
                    }
                }
                ArrayList<AbstractModelItem> levels = new ArrayList<AbstractModelItem>(qualified.size() + (result == null ? 0 : 1));
                if (result != null) {
                    levels.add(result);
                }
                levels.addAll(qualified);
                this._qualifiedLevels = levels;
                outLevels = new ArrayList(this._qualifiedLevels);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        }
        return outLevels;
    }

    public OMANamedSet getRepresentativeNamedSet(com.sas.metadata.remote.NamedSet omrNamedSet) throws MetadataException {
        OMANamedSet out = null;
        String label = null;
        try {
            label = omrNamedSet.getName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        if (this._namedSets != null) {
            int size = this._namedSets.size();
            for (int i = 0; i < size; ++i) {
                OMANamedSet namedSet = this._namedSets.get(i);
                if (!namedSet.getLabel().equalsIgnoreCase(label)) continue;
                out = namedSet;
                break;
            }
        }
        if (out == null) {
            out = new OMANamedSet(omrNamedSet, this, this.getMetadataServer());
            this._namedSets.add(out);
        }
        return out;
    }

    public OMAQualifiedLevel getRepresentativeLevel(com.sas.metadata.remote.Level jomaLevel, boolean addToManagedLevels) throws MetadataException {
        OMAQualifiedLevel out = null;
        try {
            out = this.getLevelWithName(jomaLevel.getName());
            if (out == null) {
                out = this.newQualifiedLevel(jomaLevel);
                if (addToManagedLevels) {
                    this._qualifiedLevels.add(out);
                }
            }
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return out;
    }

    public OMAQualifiedLevel getEquivalentLevel(QualifiedLevelImpl v1Level) throws MetadataException {
        OMAQualifiedLevel out = null;
        String name = v1Level.getLabel();
        this.getLevels();
        out = this.getLevelWithName(name);
        if (out == null) {
            out = new OMAQualifiedLevel(this, name);
            if (this.isUnresolved()) {
                if (this._qualifiedLevels == null) {
                    this._qualifiedLevels = new ArrayList();
                }
                this._qualifiedLevels.add(out);
            }
        }
        return out;
    }

    private OMAQualifiedLevel getLevelWithName(String namedLevel) throws MetadataException {
        OMAQualifiedLevel out = null;
        if (this._qualifiedLevels != null) {
            int size = this._qualifiedLevels.size();
            for (int i = 0; i < size; ++i) {
                Object oLevel = this._qualifiedLevels.get(i);
                OMAQualifiedLevel qLevel = null;
                if (!(oLevel instanceof OMAQualifiedLevel) || !(qLevel = (OMAQualifiedLevel)oLevel).getLabel().equalsIgnoreCase(namedLevel)) continue;
                out = qLevel;
                break;
            }
        }
        return out;
    }

    private OMAQualifiedLevel newQualifiedLevel(com.sas.metadata.remote.Level jomaLevel) throws MetadataException {
        OMAQualifiedLevel out = new OMAQualifiedLevel(this, jomaLevel, this.getMetadataServer());
        return out;
    }

    @Override
    public String getDefaultMember() throws MetadataException {
        String name;
        this.unresolvedCheck();
        try {
            name = this._omrHierarchy.getDefaultMember();
        }
        catch (RemoteException e) {
            _logger.error("", (Throwable)e);
            throw new MetadataException(e);
        }
        return name;
    }

    @Override
    public String getAllMember() throws MetadataException {
        this.unresolvedCheck();
        StringBuilder nameBuffer = new StringBuilder(500);
        try {
            nameBuffer.append(this._omrHierarchy.getAllMember());
        }
        catch (RemoteException e) {
            this.error(e);
        }
        Dimension dimA = this.getOwningDimension();
        List<Hierarchy> numberOf = dimA.getHierarchies();
        if (nameBuffer.length() == 0) {
            String hie;
            String dim = this.getDimensionName();
            if (dim.equalsIgnoreCase(hie = this.getHierarchyName()) && numberOf.size() == 1) {
                nameBuffer.append("[").append(hie).append("]");
            } else {
                nameBuffer.append(this.getUniqueName());
            }
            String aM = null;
            try {
                List<Property> properties = AssociationListUtil.filteredSnapshot(this._omrHierarchy.getProperties(), Property.class);
                for (Property property : properties) {
                    if (!"AllMemberCaption".equalsIgnoreCase(property.getPropertyName())) continue;
                    aM = property.getDefaultValue();
                    break;
                }
            }
            catch (RemoteException ee) {
                this.error(ee);
            }
            catch (MdException e) {
                this.error(e);
            }
            nameBuffer.append(".[").append(aM).append("]");
        }
        return nameBuffer.toString();
    }

    private void loadData() throws MetadataException {
        if (!this._isDataLoaded) {
            this.unresolvedCheck();
            this._uniqueNameOfHierAllMember = this._hierAllMember = this.getAllMember();
            this._isDataLoaded = true;
        }
    }

    @Override
    public String getDimensionName() throws MetadataException {
        Dimension dim = this.getOwningDimension();
        return dim.getLabel();
    }

    public void setOwningDimension(OMADimension inputOwningDimension) {
        this._owningDimensionWhenUnresolved = inputOwningDimension;
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return false;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        OMADimension outDimension = this._owningDimensionWhenUnresolved;
        if (!this.isUnresolved()) {
            try {
                com.sas.metadata.remote.Dimension omrDimension = this._omrHierarchy.getOwningDimension();
                outDimension = (OMADimension)this.getReposObject((CMetadata)omrDimension);
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return outDimension;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getOwningDimension());
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Hierarchies";
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._qualifiedLevels = rilsHolder.consumeObjects("Levels", OMAQualifiedLevel.class);
        this._namedSets = rilsHolder.consumeObjects("NamedSets", OMANamedSet.class);
        this._calMembers = rilsHolder.consumeObjects("CalculatedMembers", OMACalculatedMember.class);
        this.setHierarchyLinks(this._qualifiedLevels);
        this.setHierarchyLinks(this._namedSets);
        this.setHierarchyLinks(this._calMembers);
    }

    private <T extends ChildOfHierarchy> void setHierarchyLinks(List<T> omaObjects) {
        int size = omaObjects.size();
        for (int i = 0; i < size; ++i) {
            ChildOfHierarchy omaObject = (ChildOfHierarchy)omaObjects.get(i);
            omaObject.setOwningHierarchy(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Levels", this._qualifiedLevels);
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "NamedSets", this._namedSets);
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "CalculatedMembers", this._calMembers);
    }

    @Override
    public String getCubeName() throws MetadataException {
        Dimension dim = this.getOwningDimension();
        Cube cube = dim.getOwningCube();
        return cube.getLabel();
    }

    @Override
    public String getHierarchyUniqueName() throws MetadataException {
        return this.getUniqueName();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        this.unresolvedCheck();
        String uniqueName = null;
        try {
            uniqueName = this._omrHierarchy.getUniqueName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return uniqueName;
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        if (!this._isDataLoaded) {
            this.loadData();
        }
        return this._uniqueNameOfHierAllMember;
    }

    @Override
    public synchronized Member getMember(int memberFlag) throws MetadataException {
        if (memberFlag != 1 && memberFlag != 2) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("HierarchyImplInvalidParameter.txt", new Object[0]));
        }
        if (this._defaultMember == null) {
            this.unresolvedCheck();
            Dimension dim = this.getOwningDimension();
            OLAPServerUtilities olapServerUtil = null;
            if (this._metadata == null) {
                olapServerUtil = OLAPServerUtilities.getInstance();
                olapServerUtil.setOlapMetadata(dim);
                this._metadata = olapServerUtil.getOlapMetadata();
            }
            try {
                Filter filter = new Filter();
                String uniqueName = this.getUniqueName();
                String cubeName = this.getCubeName();
                filter.setCubeName(cubeName);
                filter.setUniqueHierarchyName(uniqueName);
                HierarchyInterface[] hierarchies = this._metadata.getHierarchies(filter);
                MemberInterface member = null;
                member = memberFlag == 2 ? hierarchies[0].getTopMember() : hierarchies[0].getDefaultMember();
                this._defaultMember = new OlapServerMember(member);
                this._defaultMember.setOwningDimension(this.getOwningDimension());
            }
            catch (OLAPException e) {
                this.error(IQModelImplUtilities.getMessageFormatter("OMAHierarchy.getMemberError.fmt.txt", this.getHierarchyName()), e);
            }
        }
        return this._defaultMember;
    }

    @Override
    public int getExpressionType() {
        return 3;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Hierarchy.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Hierarchy;
    }

    @Override
    public List<PhysicalResource> getChildResources(ExternalResourceType type) throws MetadataException {
        List<PhysicalResource> resources = type == ExternalResourceType.Level || type == ExternalResourceType.QualifiedLevel ? new ArrayList<PhysicalResource>(this.getLevels(false)) : (type == ExternalResourceType.CalculatedMember ? new ArrayList<CalculatedMember>(this.getCalculatedMembers()) : (type == ExternalResourceType.NamedSet ? new ArrayList<NamedSet>(this.getNamedSets()) : Collections.emptyList()));
        return resources;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getOwningDimension();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        if (childResource != null) {
            if (childResource instanceof OMAQualifiedLevel || childResource instanceof OMALevel) {
                if (this._qualifiedLevels == null) {
                    this._qualifiedLevels = new ArrayList();
                }
                if (!this._qualifiedLevels.contains(childResource)) {
                    this._qualifiedLevels.add(childResource);
                }
                if (childResource instanceof OMAQualifiedLevel) {
                    ((OMAQualifiedLevel)childResource).setOwningHierarchy(this);
                }
            } else if (childResource instanceof OMACalculatedMember) {
                if (this._calMembers == null) {
                    this._calMembers = new ArrayList<OMACalculatedMember>();
                }
                if (!this._calMembers.contains(childResource)) {
                    this._calMembers.add((OMACalculatedMember)childResource);
                }
            } else if (childResource instanceof OMANamedSet) {
                if (this._namedSets == null) {
                    this._namedSets = new ArrayList<OMANamedSet>();
                }
                if (!this._namedSets.contains(childResource)) {
                    this._namedSets.add((OMANamedSet)childResource);
                }
            }
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMADimension) {
            this.setOwningDimension((OMADimension)parentResource);
        }
    }

    @Override
    public List<CalculatedMember> getCalculatedMembers() throws MetadataException {
        ArrayList<CalculatedMember> calMembers;
        if (this.isUnresolved()) {
            calMembers = new ArrayList<OMACalculatedMember>(this._calMembers);
        } else {
            try {
                calMembers = this.getReposObjects((List<? extends CMetadata>)this._omrHierarchy.getCalculatedMembers(), CalculatedMember.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        }
        if (_OMALogger.isDebugEnabled()) {
            _logger.debug("Got " + calMembers.size() + " calculated members back from OMR for hierarchy " + this.getHierarchyName());
        }
        return calMembers;
    }

    @Override
    public List<NamedSet> getNamedSets() throws MetadataException {
        ArrayList<NamedSet> namedSets;
        if (this.isUnresolved()) {
            namedSets = new ArrayList<OMANamedSet>(this._namedSets);
        } else {
            namedSets = new ArrayList();
            try {
                ArrayList omrNamedSets = new ArrayList(this._omrHierarchy.getNamedSets());
                for (Object obj : omrNamedSets) {
                    if (!(obj instanceof com.sas.metadata.remote.NamedSet)) continue;
                    com.sas.metadata.remote.NamedSet omrNamedSet = (com.sas.metadata.remote.NamedSet)obj;
                    OMANamedSet omaNamedSet = this.getRepresentativeNamedSet(omrNamedSet);
                    namedSets.add(omaNamedSet);
                }
                if (_OMALogger.isDebugEnabled()) {
                    _logger.debug("Got " + namedSets.size() + " named set objects back from OMR for hierarchy " + this.getHierarchyName());
                }
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return namedSets;
    }

    static interface ChildOfHierarchy {
        public void setOwningHierarchy(OMAHierarchy var1);
    }
}

