/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.physical.DatabaseSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.oma.OMARelationalSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.List;

public class OMADatabaseSchema
extends OMARelationalSchema
implements DatabaseSchema {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.DatabaseSchema _omrSchema;

    public OMADatabaseSchema() {
    }

    public OMADatabaseSchema(com.sas.metadata.remote.DatabaseSchema omrDatabaseSchema, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((RelationalSchema)omrDatabaseSchema, session, metadataServer);
        this._omrSchema = omrDatabaseSchema;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        this.unresolvedCheck();
        String name = null;
        try {
            name = this._omrSchema.getSchemaName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return name;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposDatabaseSchema";
    }

    @Override
    protected Class<?> getServerType() {
        return OMASASWorkspaceServer.class;
    }

    @Override
    public String getType() {
        return IQMetadataResourceBundle.getStringResource("Type.DatabaseSchema.txt");
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.DatabaseSchema;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        PhysicalResource returnValue = null;
        if (!this.isUnresolved()) {
            try {
                RelationalSchema assocMetadata;
                List<RelationalSchema> relationalSchemas = AssociationListUtil.filteredSnapshot(this._omrSchema.getUsedByPackages(true), RelationalSchema.class);
                if (relationalSchemas.size() > 0 && (assocMetadata = relationalSchemas.get(0)) instanceof SASLibrary) {
                    returnValue = (PhysicalResource)((Object)this.getReposObject((CMetadata)assocMetadata));
                }
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
        return returnValue;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)this.getParentResource();
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getLabel()).append("'][");
        OMAResourceImpl parent = this.getResourceContainer();
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype)).append("]");
        return search.toString();
    }

    @Override
    public String getUsedBySearchString(ExternalResourceType usingType) throws MetadataException {
        OMAResourceImpl parent = (OMAResourceImpl)this.getParentResource();
        ExternalResourceType type = this.getResourceType();
        String associationName = usingType.getAssociationToTypeName(type);
        StringBuffer search = new StringBuffer(associationName);
        search.append("/*[@Name='").append(this.getLabel()).append("']/").append(parent.getUsedBySearchString(type));
        return search.toString();
    }
}

