/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.AccessPathToOlapData;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OlapSchema;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.StructuredData;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.metadata.physical.oma.OMADimension;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.metadata.physical.oma.OMAOlapSchema;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASASOlapServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class OMACube
extends OMAResourceImpl
implements Cube,
StructuredData {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.Cube _omrCube = null;
    private OMAOlapSchema _owningOlapSchemaWhenUnresolved = null;
    private List<Dimension> _unresolvedDimensionsWhenUnresolved = new ArrayList<Dimension>();
    private List _unresolvedMeasuresWhenUnresolved = new ArrayList();
    private static final Logger _olapConnLogger = LogManager.getLogger(OLAPConnectionInfoUtil.class);

    public OMACube() {
    }

    public OMACube(com.sas.metadata.remote.Cube omrCube, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrCube, session, metadataServer);
        this._omrCube = omrCube;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposCube";
    }

    @Override
    public String getCubeName() {
        return this.getLabel();
    }

    @Override
    public boolean isOLAPCubeBuilt() {
        boolean returnValue = false;
        String cubeName = null;
        if (this._omrCube != null) {
            block4: {
                try {
                    cubeName = this._omrCube.getCubeName();
                }
                catch (RemoteException e) {
                    if (!_olapConnLogger.isEnabled(Level.ERROR)) break block4;
                    _olapConnLogger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (cubeName != null && cubeName.length() > 0) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    @Override
    public String getCubeType() throws MetadataException {
        this.unresolvedCheck();
        String cubeType = null;
        try {
            cubeType = this._omrCube.getCubeType();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return cubeType;
    }

    @Override
    @Nonnull
    public List<Dimension> getDimensions() throws MetadataException {
        List<Dimension> outDimensions;
        if (!this.isUnresolved()) {
            try {
                outDimensions = this.getReposObjects((List<? extends CMetadata>)this._omrCube.getDimensions(), Dimension.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            for (Dimension dim : outDimensions) {
                ((OMADimension)dim).setOwningCube(this);
            }
        } else {
            outDimensions = new ArrayList<Dimension>(this._unresolvedDimensionsWhenUnresolved);
        }
        return outDimensions;
    }

    @Override
    public OlapSchema getOwningOlapSchema() throws MetadataException {
        OMAOlapSchema outOlapSchema = this._owningOlapSchemaWhenUnresolved;
        if (!this.isUnresolved()) {
            try {
                OLAPSchema omrOLAPSchema = this._omrCube.getAssociatedOLAPSchema();
                outOlapSchema = (OMAOlapSchema)this.getReposObject((CMetadata)omrOLAPSchema);
            }
            catch (MdException e) {
                this.error(e);
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return outOlapSchema;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getOwningOlapSchema());
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Cubes";
    }

    @Override
    public List<Measure> getMeasures() throws MetadataException {
        List<Measure> outMeasures;
        if (!this.isUnresolved()) {
            try {
                outMeasures = this.getReposObjects((List<? extends CMetadata>)this._omrCube.getMeasures(), Measure.class);
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        } else {
            outMeasures = new ArrayList<Measure>(this._unresolvedMeasuresWhenUnresolved);
        }
        return outMeasures;
    }

    @Override
    public void consumeExternalReferenceRelatedItems(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeExternalReferenceRelatedItems(rilsHolder);
        this._unresolvedDimensionsWhenUnresolved = rilsHolder.consumeObjects("Dimensions", Dimension.class);
        this.setDimensionToCubeLinks();
        this._unresolvedMeasuresWhenUnresolved = rilsHolder.consumeObjects("Measures", Measure.class);
        this.setMeasureToCubeLinks();
    }

    private void setDimensionToCubeLinks() {
        for (OMADimension oMADimension : this._unresolvedDimensionsWhenUnresolved) {
            oMADimension.setOwningCube(this);
        }
    }

    private void setMeasureToCubeLinks() {
        for (Measure unresolvedMeasure : this._unresolvedMeasuresWhenUnresolved) {
            if (!(unresolvedMeasure instanceof OMAMeasure)) continue;
            ((OMAMeasure)unresolvedMeasure).setOwningCube(this);
        }
    }

    protected void addRelationshipsToUnresolvedResources(IdentityHashMap mapping) {
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Dimensions", this._unresolvedDimensionsWhenUnresolved);
        this.noteRelationshipsWithOtherUnresolvedResources(mapping, "Measures", this._unresolvedMeasuresWhenUnresolved);
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(thisElement, readingContext);
        this._unresolvedDimensionsWhenUnresolved = OMACube.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposDimension", new Class[]{OMADimension.class});
        for (OMADimension oMADimension : this._unresolvedDimensionsWhenUnresolved) {
            oMADimension.setOwningCube(this);
        }
        this._unresolvedMeasuresWhenUnresolved = OMACube.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposMeasure", new Class[]{OMAMeasure.class});
        for (OMAMeasure oMAMeasure : this._unresolvedMeasuresWhenUnresolved) {
            oMAMeasure.setOwningCube(this);
        }
        List unresolvedCalculatedMeasuresWhenUnresolved = OMACube.pre92_readExternalReferenceListDirectlyUnderElement(thisElement, readingContext, "ReposCalculatedMeasure", new Class[]{OMACalculatedMeasure.class});
        for (OMACalculatedMeasure unresolvedCalculatedMeasure : unresolvedCalculatedMeasuresWhenUnresolved) {
            unresolvedCalculatedMeasure.setOwningCube(this);
            this._unresolvedMeasuresWhenUnresolved.add(unresolvedCalculatedMeasure);
        }
    }

    @Override
    @Nonnull
    public List<AccessPath> getAccessPaths() throws MetadataException {
        List<AccessPath> outPaths;
        this.unresolvedCheck();
        OMAOlapSchema schema = (OMAOlapSchema)this.getOwningOlapSchema();
        if (schema != null) {
            List<SoftwareServer> servers = schema.getSoftwareServers();
            outPaths = new ArrayList<AccessPath>(servers.size());
            for (OMASASOlapServer oMASASOlapServer : servers) {
                AccessPathToOlapData accessPath = new AccessPathToOlapData(oMASASOlapServer, schema);
                outPaths.add(accessPath);
            }
        } else {
            outPaths = Collections.emptyList();
        }
        return outPaths;
    }

    public void setOwningOlapSchema(OMAOlapSchema inputOwningOlapSchema) {
        this._owningOlapSchemaWhenUnresolved = inputOwningOlapSchema;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.OLAPCube.txt", new Object[0]);
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        List<PhysicalResource> returnValue = null;
        if (type == ExternalResourceType.Dimension) {
            returnValue = new ArrayList<Dimension>(this.getDimensions());
        } else if (type == ExternalResourceType.Measure) {
            returnValue = new ArrayList<Measure>(this.getMeasures());
        } else if (type == ExternalResourceType.CalculatedMeasure) {
            returnValue = new ArrayList<Measure>(this.getMeasures());
            returnValue = IQModelImplUtilities.filterList(returnValue, OMACalculatedMeasure.class);
        }
        return returnValue == null ? new ArrayList() : returnValue;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        return this.getOwningOlapSchema();
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getLabel()).append("'][");
        OMAResourceImpl parent = this.getResourceContainer();
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype)).append("]");
        return search.toString();
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
        if (childResource != null) {
            if (childResource instanceof OMADimension) {
                if (!this._unresolvedDimensionsWhenUnresolved.contains(childResource)) {
                    this._unresolvedDimensionsWhenUnresolved.add((OMADimension)childResource);
                    ((OMADimension)childResource).setOwningCube(this);
                }
            } else if (childResource instanceof OMAMeasure && !this._unresolvedMeasuresWhenUnresolved.contains(childResource)) {
                this._unresolvedMeasuresWhenUnresolved.add(childResource);
                ((OMAMeasure)childResource).setOwningCube(this);
            }
        }
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMAOlapSchema) {
            OMAOlapSchema schema = (OMAOlapSchema)parentResource;
            this.setOwningOlapSchema(schema);
        }
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Cube;
    }

    @Override
    public StructureOfData getStructure() {
        return StructureOfData.OLAP;
    }
}

