/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.oma;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.ForeignKey;
import com.sas.iquery.metadata.physical.Index;
import com.sas.iquery.metadata.physical.IndexKey;
import com.sas.iquery.metadata.physical.Key;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.PrimaryKey;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.TableRelationshipKey;
import com.sas.iquery.metadata.physical.UniqueKey;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMATable;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;

public class OMAColumn
extends OMAResourceImpl
implements Column {
    private static final long serialVersionUID = 1L;
    private com.sas.metadata.remote.Column _omrColumn;
    private OMATable _owningTableWhenUnresolved = null;
    private transient String _colSasName = null;
    private transient String _colSasType = null;
    private String _sasColumnTypeWhenUnresolved;
    private String _sasColumnNameWhenUnresolved;

    public OMAColumn() {
    }

    public OMAColumn(com.sas.metadata.remote.Column omrColumn, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException {
        super((CMetadata)omrColumn, session, metadataServer);
        this._omrColumn = omrColumn;
    }

    @Override
    protected String getDefinitionElementName() {
        return "ReposColumn";
    }

    @Override
    public int getExpressionType() {
        int outExprType;
        block6: {
            outExprType = 0;
            try {
                String sasType = this.getSasType();
                if (sasType != null) {
                    if (sasType.equals("C")) {
                        outExprType = 3;
                    } else if (sasType.equals("N")) {
                        outExprType = 2;
                    }
                }
            }
            catch (MetadataException e) {
                if (!_logger.isDebugEnabled()) break block6;
                _logger.debug(e.getMessage());
            }
        }
        return outExprType;
    }

    public static String dataTypeToString(int javaSqlDataType) {
        return IQModelImplUtilities.dataTypeToString(javaSqlDataType);
    }

    public static int dataTypeFromString(String stringFormOfJavaSqlDataType) {
        return IQModelImplUtilities.dataTypeFromString(stringFormOfJavaSqlDataType);
    }

    @Override
    public Table getOwningTable() throws MetadataException {
        if (_logger.isDebugEnabled() && IQSystemProperties.isVerboseLoggingEnabled()) {
            _logger.debug(">> getOwningTable");
        }
        OMATable outTable = this._owningTableWhenUnresolved;
        try {
            if (!this.isUnresolved()) {
                DataTable omrTable = this._omrColumn.getTable();
                outTable = (OMATable)this.getReposObject((CMetadata)omrTable);
            }
        }
        catch (MdException e) {
            this.error(e);
        }
        catch (RemoteException e) {
            this.error(e);
        }
        if (_logger.isDebugEnabled() && IQSystemProperties.isVerboseLoggingEnabled()) {
            _logger.debug("<< getOwningTable returning: " + Utils.toString(outTable));
        }
        return outTable;
    }

    @Override
    public OMAResourceImpl getResourceContainer() throws MetadataException {
        return (OMAResourceImpl)((Object)this.getOwningTable());
    }

    @Override
    public String getRelationshipNameFromKnownConstrainer() {
        return "Columns";
    }

    @Override
    public String getLabel() {
        String outLabel = null;
        if (this.isUnresolved()) {
            outLabel = this._sasColumnNameWhenUnresolved;
        } else {
            outLabel = this.getDescription();
            if (outLabel == null || outLabel.length() == 0) {
                outLabel = super.getLabel();
            }
        }
        return outLabel;
    }

    @Override
    public String getDbmsName() throws MetadataException {
        this.unresolvedCheck();
        String name = null;
        try {
            name = this._omrColumn.getColumnName();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return name;
    }

    @Override
    public int getDbmsType() throws MetadataException {
        return 0;
    }

    @Override
    public int getDbmsLength() throws MetadataException {
        this.unresolvedCheck();
        int length = 0;
        try {
            length = this._omrColumn.getColumnLength();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return length;
    }

    @Override
    public String getSasName() throws MetadataException {
        if (this._colSasName == null) {
            this._colSasName = this._sasColumnNameWhenUnresolved;
            try {
                if (!this.isUnresolved()) {
                    this._colSasName = this._omrColumn.getSASColumnName();
                }
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return this._colSasName;
    }

    @Override
    public String getSasType() throws MetadataException {
        if (this._colSasType == null) {
            this._colSasType = this._sasColumnTypeWhenUnresolved;
            try {
                if (!this.isUnresolved()) {
                    this._colSasType = this._omrColumn.getSASColumnType();
                }
            }
            catch (RemoteException e) {
                this.error(e);
            }
        }
        return this._colSasType;
    }

    @Override
    public int getSasLength() throws MetadataException {
        this.unresolvedCheck();
        int length = 0;
        try {
            length = this._omrColumn.getSASColumnLength();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return length;
    }

    @Override
    public String getSasFormat() throws MetadataException {
        this.unresolvedCheck();
        String format = null;
        try {
            format = this._omrColumn.getSASFormat();
        }
        catch (RemoteException e) {
            this.error(e);
        }
        return format;
    }

    @Override
    public List<Key> getKeys() throws MetadataException {
        _logger.debug(">> getKeys");
        List<Key> results = this.getKeys(Key.class);
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getKeys returning: " + results);
        }
        return results;
    }

    @Override
    public <T extends Key> List<T> getKeys(@Nonnull Class<T> type) throws MetadataException {
        List<T> results;
        block13: {
            if (_logger.isDebugEnabled()) {
                _logger.debug(">> getKeys");
            }
            this.unresolvedCheck();
            if (type == null || !Key.class.isAssignableFrom(type)) {
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("OMAColumn.illegalType.fmt.txt", "com.sas.iquery.metadata.physical.Key"));
            }
            try {
                if (PrimaryKey.class.isAssignableFrom(type)) {
                    results = this.getReposObjects((List<? extends CMetadata>)this._omrColumn.getKeys(), type);
                    break block13;
                }
                if (UniqueKey.class.isAssignableFrom(type)) {
                    results = this.getReposObjects((List<? extends CMetadata>)this._omrColumn.getKeys(), type);
                    break block13;
                }
                if (ForeignKey.class.isAssignableFrom(type)) {
                    results = this.getReposObjects((List<? extends CMetadata>)this._omrColumn.getKeys(), type);
                    break block13;
                }
                if (TableRelationshipKey.class.isAssignableFrom(type)) {
                    results = this.getReposObjects((List<? extends CMetadata>)this._omrColumn.getKeys(), type);
                    break block13;
                }
                if (IndexKey.class.isAssignableFrom(type)) {
                    List<Index> indexes = this.getReposObjects((List<? extends CMetadata>)this._omrColumn.getIndexes(), Index.class);
                    results = new ArrayList<T>(indexes.size());
                    for (Index index : indexes) {
                        IndexKey indexKey = index.getKey();
                        results.add((Key)type.cast(indexKey));
                    }
                    break block13;
                }
                if (Key.class.isAssignableFrom(type)) {
                    results = new ArrayList<T>();
                    results.addAll(this.getKeys(TableRelationshipKey.class));
                    results.addAll(this.getKeys(IndexKey.class));
                    break block13;
                }
                throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("OMAColumn.illegalType.fmt.txt", "com.sas.iquery.metadata.physical.Key"));
            }
            catch (MdException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                _logger.error("", (Throwable)e);
                throw new MetadataException(e);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("<< getKeys returning: " + results);
        }
        return results;
    }

    @Override
    public void writeExternalReference(Element thisElement, WritingContext resources) throws MetadataException {
        super.writeExternalReference(thisElement, resources);
        IQModelImplUtilities.removeAttr(thisElement, "name");
        IQModelImplUtilities.setAttr(thisElement, "sasName", this.getSasName());
        IQModelImplUtilities.setAttr(thisElement, "sasType", this.getSasType());
    }

    @Override
    protected void readExternalReferenceV1(Element element, ReadingContext readingContext) throws MetadataException {
        super.readExternalReferenceV1(element, readingContext);
        this._sasColumnTypeWhenUnresolved = IQModelImplUtilities.getAttr(element, "sasColumnType");
        this._sasColumnNameWhenUnresolved = IQModelImplUtilities.getAttr(element, "sasColumnName");
    }

    public void setOwningTable(OMATable inputOwningTable) {
        this._owningTableWhenUnresolved = inputOwningTable;
    }

    public void setExternalReferenceInfo(String sasName, boolean typeIsNumeric) {
        this._sasColumnNameWhenUnresolved = sasName;
        this._sasColumnTypeWhenUnresolved = typeIsNumeric ? "N" : "C";
        this.setUnresolved();
    }

    @Override
    public boolean isUniqueKey() throws MetadataException {
        boolean returnValue = false;
        List<UniqueKey> keys = this.getKeys(UniqueKey.class);
        if (keys.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public boolean isPrimaryKey() throws MetadataException {
        boolean returnValue = false;
        List<PrimaryKey> keys = this.getKeys(PrimaryKey.class);
        if (keys.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public boolean isForeignKey() throws MetadataException {
        boolean returnValue = false;
        List<ForeignKey> keys = this.getKeys(ForeignKey.class);
        if (keys.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public boolean isIndex() throws MetadataException {
        boolean returnValue = false;
        List<IndexKey> keys = this.getKeys(IndexKey.class);
        if (keys.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public String getType() {
        return IQModelImplUtilities.getMessage("Type.Column.txt", new Object[0]);
    }

    @Override
    public ExternalResourceType getResourceType() {
        return ExternalResourceType.Column;
    }

    @Override
    public boolean isPhysicallyEquivalent(PhysicalResource res) throws MetadataException {
        boolean returnValue = false;
        if (this == res) {
            returnValue = true;
        } else if (res instanceof OMAColumn) {
            OMAColumn oColumn = (OMAColumn)res;
            if (IQModelImplUtilities.sameIgnoreCase(this.getSasType(), oColumn.getSasType())) {
                String tName = this.getSasName();
                String oName = oColumn.getSasName();
                returnValue = IQModelImplUtilities.sameIgnoreCase(tName, oName);
            }
        }
        return returnValue;
    }

    public List getChildResources(ExternalResourceType type) throws MetadataException {
        return null;
    }

    @Override
    public PhysicalResource getParentResource() throws MetadataException {
        Table returnValue = this.getOwningTable();
        return returnValue;
    }

    @Override
    public void addUnresolvedChildResource(PhysicalResource childResource) throws MetadataException {
    }

    @Override
    public void setUnresolvedParentResource(PhysicalResource parentResource) throws MetadataException {
        if (parentResource != null && parentResource instanceof OMATable) {
            OMATable parent = (OMATable)parentResource;
            this.setOwningTable(parent);
        }
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
        super.setUnresolvedProperties(sourceResource);
        if (sourceResource != null && sourceResource instanceof OMAColumn) {
            OMAColumn sourceColumn = (OMAColumn)sourceResource;
            this._sasColumnTypeWhenUnresolved = sourceColumn.getSasType();
            this._sasColumnNameWhenUnresolved = sourceColumn.getSasName();
        }
    }

    @Override
    public String getSearchString() throws MetadataException {
        StringBuffer search = new StringBuffer("*[@Name='");
        search.append(this.getSasName()).append("'][");
        OMAResourceImpl parent = this.getResourceContainer();
        ExternalResourceType ctype = this.getResourceType();
        search.append(parent.getUsedBySearchString(ctype)).append("]");
        return search.toString();
    }
}

