/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.olap;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.RelatedObjectListsHolder;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.oma.OMAHierarchy;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Level;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AllLevel
extends AbstractModelItem
implements QualifiedLevel {
    private Hierarchy _hierarchy;
    private LevelInterface _level;
    private String _label;
    private String _desc;
    private String _initDesc;
    private OLAPServerUtilities _olapServerUtil = null;
    private static final Logger _logger = LogManager.getLogger(AllLevel.class);

    public AllLevel() {
    }

    public AllLevel(OMAHierarchy hierarchy) {
        this._hierarchy = hierarchy;
        this.initLevel(hierarchy);
    }

    public void setHierarchy(OMAHierarchy hierarchy) {
        this._hierarchy = hierarchy;
        this.initLevel(hierarchy);
    }

    @Override
    protected void accumulateDirectlyReferencedItemsInDownwardDefinition(List<? super ModelItem> intoList) {
        intoList.add(this._hierarchy);
    }

    @Override
    protected String getDefinitionElementName() {
        return "AllLevel";
    }

    @Override
    public Hierarchy getOwningHierarchy() throws MetadataException {
        return this._hierarchy;
    }

    @Override
    public String getDescription() {
        block5: {
            LevelInterface level = null;
            try {
                level = this.getLevel();
                if (level != null) {
                    this._desc = level.getDescription();
                }
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoLevelFromServer.fmt.txt", this.getDisplayHierarchyName());
                    _logger.error(msg, (Throwable)e);
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block5;
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoDescription..fmt.txt", this.getDisplayHierarchyName());
                _logger.error(msg, (Throwable)e);
            }
        }
        return this._desc;
    }

    @Override
    public String getLabel() {
        block5: {
            try {
                LevelInterface level = this.getLevel();
                if (level != null) {
                    this._label = level.getLabel();
                }
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoLevelFromServer.fmt.txt", this.getDisplayHierarchyName());
                    _logger.error(msg, (Throwable)e);
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block5;
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoDescription..fmt.txt", this.getDisplayHierarchyName());
                _logger.error(msg, (Throwable)e);
            }
        }
        return this._label;
    }

    @Override
    public String getLevelCaption() throws MetadataException {
        return this.getDescription();
    }

    @Override
    public String getLevelName() throws MetadataException {
        String levelName = null;
        LevelInterface level = this.getLevel();
        if (level != null) {
            try {
                levelName = level.getName();
            }
            catch (OLAPException e) {
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoLevelName.fmt.txt", this.getDisplayHierarchyName());
                MetadataException me = new MetadataException(msg);
                me.initCause(e);
                throw me;
            }
        }
        return levelName;
    }

    @Override
    public int getLevelNumber() throws MetadataException {
        LevelInterface level = this.getLevel();
        int levelNumber = 0;
        if (level != null) {
            try {
                levelNumber = level.getDepth();
            }
            catch (OLAPException e) {
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoLevelNumber.fmt.txt", this.getDisplayHierarchyName());
                MetadataException me = new MetadataException(msg);
                me.initCause(e);
                throw me;
            }
        }
        return levelNumber;
    }

    @Override
    public String getLevelUniqueName() throws MetadataException {
        String uniqueName = null;
        LevelInterface level = this.getLevel();
        if (level != null) {
            try {
                uniqueName = level.getUniqueName();
            }
            catch (OLAPException e) {
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoLevelName.fmt.txt", this.getDisplayHierarchyName());
                _logger.error(msg, (Throwable)e);
                MetadataException me = new MetadataException(msg);
                me.initCause(e);
                throw me;
            }
        }
        return uniqueName;
    }

    @Override
    public List<Member> getMembers() throws MetadataException {
        if (this._hierarchy == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AllLevelNoHierarchySetError.txt", new Object[0]));
        }
        List<Member> members = new ArrayList<Member>();
        LevelInterface level = this.getLevel();
        if (level != null) {
            String myLevelName = null;
            try {
                myLevelName = level.getName();
            }
            catch (OLAPException e) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AllLevelNoLevelName.fmt.txt", this.getDisplayHierarchyName());
                MetadataException me = new MetadataException(msg);
                me.initCause(e);
                throw me;
            }
            if (myLevelName == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AllLevelNoLevelName.fmt.txt", this.getDisplayHierarchyName());
                throw new MetadataException(msg);
            }
            boolean isTempOlapServerUtil = false;
            if (this._olapServerUtil == null) {
                this._olapServerUtil = OLAPServerUtilities.getInstance();
                this._olapServerUtil.setOlapMetadata(this._hierarchy.getOwningDimension());
                isTempOlapServerUtil = true;
            }
            String myCubeName = this._hierarchy.getCubeName();
            MetadataInterface metaI = this._olapServerUtil.getOlapMetadata();
            members = this._olapServerUtil.getMembers(metaI, myCubeName, this._hierarchy.getOwningDimension(), (OMAHierarchy)this._hierarchy, myLevelName);
            if (isTempOlapServerUtil) {
                this._olapServerUtil = null;
            }
        }
        return members;
    }

    @Override
    public String getSasFormat() throws MetadataException {
        return null;
    }

    @Override
    public String getCubeName() throws MetadataException {
        return this._hierarchy.getCubeName();
    }

    @Override
    public String getDimensionName() throws MetadataException {
        return this._hierarchy.getDimensionName();
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        return this._hierarchy.getOwningDimension();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        return this.getLevelUniqueName();
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        LevelInterface level = this.getLevel();
        String memberName = null;
        if (level != null) {
            try {
                memberName = level.getHierarchy().getDefaultMember().getUniqueName();
            }
            catch (OLAPException e) {
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelNoDefaultMemberName.fmt.txt", this.getDisplayHierarchyName());
                MetadataException me = new MetadataException(msg);
                me.initCause(e);
                throw me;
            }
            if (memberName == null) {
                String msg = IQMetadataResourceBundle.getMessageString("AllLevelDefaultMemberNameNull.fmt.txt", this.getDisplayHierarchyName());
                MetadataException me = new MetadataException(msg);
                throw me;
            }
        }
        return memberName;
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return false;
    }

    @Override
    public int getExpressionType() {
        return 3;
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder rilsHolder) throws SAXException {
        super.consumeRelatedObjects(rilsHolder);
        this._hierarchy = (OMAHierarchy)rilsHolder.consumeObject("Hierarchy");
    }

    @Override
    protected void writeDefinition(Element thisElement, WritingContext writingContext) throws MetadataException {
        super.writeDefinition(thisElement, writingContext);
        AllLevel.writeRelatedObject(this._hierarchy, thisElement, writingContext, "Hierarchy");
    }

    public void setOLAPServerUtilities(OLAPServerUtilities olapServerUtil) {
        this._olapServerUtil = olapServerUtil;
    }

    private LevelInterface getLevel() throws MetadataException {
        LevelInterface level;
        block16: {
            level = null;
            boolean resetDescription = false;
            if (this._level != null) {
                String description;
                block15: {
                    description = "";
                    try {
                        description = this._level.getDescription();
                    }
                    catch (OLAPException oe) {
                        if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block15;
                        _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
                    }
                }
                if (description.equals(this._initDesc)) {
                    resetDescription = true;
                } else {
                    return this._level;
                }
            }
            if (this._hierarchy == null) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("AllLevelNoHierarchySetError.txt", new Object[0]));
            }
            if (this._hierarchy.isUnresolved()) {
                if (this._level == null) {
                    this.initLevel(this._hierarchy);
                }
                level = this._level;
            } else {
                String myCubeName = this._hierarchy.getCubeName();
                String myDimensionName = this._hierarchy.getDimensionName();
                String myHierarchyName = this._hierarchy.getUniqueName();
                boolean closeDownOlapServerUtil = false;
                if (this._olapServerUtil == null) {
                    this._olapServerUtil = OLAPServerUtilities.getInstance();
                    this._olapServerUtil.setOlapMetadata(this._hierarchy.getOwningDimension());
                    closeDownOlapServerUtil = true;
                }
                level = this._olapServerUtil.getLevelFromOlapServer(myCubeName, myDimensionName, myHierarchyName, null);
                if (closeDownOlapServerUtil) {
                    this._olapServerUtil = null;
                }
                if (level == null) {
                    MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("AllLevelNoLevelFromServer.fmt.txt", this.getDisplayHierarchyName());
                    throw new MetadataException(msg);
                }
                this._level = level;
                if (resetDescription) {
                    try {
                        this._desc = this._level.getDescription();
                        this._label = this._level.getLabel();
                    }
                    catch (OLAPException oe) {
                        if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block16;
                        _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
                    }
                }
            }
        }
        return level;
    }

    private String getDisplayHierarchyName() {
        String hierName = "";
        if (this._hierarchy != null) {
            if (this._hierarchy.isUnresolved()) {
                hierName = this._hierarchy.getLabel();
            } else {
                try {
                    hierName = this._hierarchy.getUniqueName();
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    hierName = this._hierarchy.getLabel();
                }
            }
        }
        return hierName;
    }

    @Override
    protected void replaceDirectReferences(Object oldObject, Object newObject) {
        this._hierarchy = (Hierarchy)AllLevel.replace(this._hierarchy, oldObject, newObject);
    }

    private void initLevel(Hierarchy hierarchy) {
        block4: {
            String levelValue = IQMetadataResourceBundle.getStringResource("AllLevelAllValue.txt");
            try {
                String dimName = hierarchy.getDimensionName();
                StringBuffer descr = new StringBuffer(levelValue);
                descr.append(" for ").append(dimName).append("(Initial)");
                StringBuffer label = new StringBuffer(levelValue);
                label.append(" ").append(dimName);
                this._label = label.toString();
                this._initDesc = this._desc = descr.toString();
                this._level = new Level(null, null, null, null, hierarchy.getCubeName(), dimName, hierarchy.getHierarchyName(), this._label, null, this._label, 2, 1, 1, this._desc);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    String msg = IQMetadataResourceBundle.getStringResource("AllLevelNoHierarchyName.txt");
                    _logger.error(msg, (Throwable)e);
                }
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block4;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.getLabel();
    }
}

