/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.physical.jfs;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.AbstractModelRepositoryResource;
import com.sas.iquery.metadata.business.impl.AttributesProvider;
import com.sas.iquery.metadata.business.impl.ReadingContext;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.business.impl.WritingContext;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.JFSResourceFactory;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class JFSResourceImpl
extends AbstractModelRepositoryResource
implements JFSResource {
    private MetadataInterface _underlyingMetadataInterface;
    private String _nameWhenUnresolved = "";
    private String _descriptionWhenUnresolved = "";
    private String _absolutePathToLastKnownLocation;
    private static final Logger _logger = LogManager.getLogger(JFSResourceImpl.class);

    public JFSResourceImpl() {
    }

    public JFSResourceImpl(MetadataInterface metadataInterface) {
        this._underlyingMetadataInterface = metadataInterface;
    }

    @Override
    protected abstract String getDefinitionElementName();

    @Override
    public String getLabel() {
        String out = null;
        try {
            if (this.isUnresolved()) {
                if (this._nameWhenUnresolved == null || this._nameWhenUnresolved.length() == 0) {
                    if (this._absolutePathToLastKnownLocation != null) {
                        PathUrl path = new PathUrl("SBIP://PseudoServer" + this._absolutePathToLastKnownLocation);
                        out = path.getName();
                    } else {
                        out = "";
                    }
                } else {
                    out = this._nameWhenUnresolved;
                }
            } else {
                out = this._underlyingMetadataInterface.getName();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return out;
    }

    public final String toString() {
        return this.getLabel();
    }

    @Override
    public String getIdentityString() {
        Object[] msgArgs = new Object[]{this.getDefinitionElementName(), this.getLabel(), "-"};
        String msg = IQMetadataResourceBundle.getMessageString("IdentityStringThreeArgs.fmt.txt", msgArgs);
        return msg;
    }

    @Override
    public String getDescription() {
        String out = null;
        try {
            out = this.isUnresolved() ? this._descriptionWhenUnresolved : this._underlyingMetadataInterface.getDescription();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return out;
    }

    @Override
    public String getLocation() {
        String out = null;
        try {
            if (this.isUnresolved()) {
                out = this._absolutePathToLastKnownLocation;
            } else {
                PathUrl url = this._underlyingMetadataInterface.getPathUrl();
                if (url != null) {
                    out = url.getAbsolutePath();
                } else if (_logger.isDebugEnabled()) {
                    _logger.debug("No path url for JFS resources " + this.getLabel());
                }
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return out;
    }

    private String getAbsolutePathToWrite() {
        String outLocation = null;
        try {
            PathUrl url;
            outLocation = this.isUnresolved() ? this._absolutePathToLastKnownLocation : ((url = this._underlyingMetadataInterface.getPathUrl()) != null ? url.getAbsolutePath() : this._absolutePathToLastKnownLocation);
        }
        catch (RemoteException e) {
            outLocation = this._absolutePathToLastKnownLocation;
        }
        catch (ServiceException e) {
            outLocation = this._absolutePathToLastKnownLocation;
        }
        return outLocation;
    }

    @Override
    public void writeExternalReference(Element thisElement, WritingContext writingContext) throws MetadataException {
        IQModelImplUtilities.setAttr(thisElement, "absolutePathLocation", this.getAbsolutePathToWrite());
    }

    @Override
    public void consumeExternalReferenceAttributes(AttributesProvider attrsProvider) throws SAXException {
        String loc;
        super.consumeExternalReferenceAttributes(attrsProvider);
        this._absolutePathToLastKnownLocation = attrsProvider.consumeAttr("absolutePathLocation");
        if (this._absolutePathToLastKnownLocation == null && (loc = attrsProvider.consumeAttr("location")) != null) {
            this._absolutePathToLastKnownLocation = IQModelImplUtilities.fullPathToAbsolutePath(loc);
        }
    }

    @Override
    protected void readExternalReferenceV1(Element thisElement, ReadingContext readingContext) throws MetadataException {
        this._nameWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "label");
        this._descriptionWhenUnresolved = IQModelImplUtilities.getAttr(thisElement, "desc");
        this._absolutePathToLastKnownLocation = IQModelImplUtilities.fullPathToAbsolutePath(IQModelImplUtilities.getAttr(thisElement, "location"));
    }

    public JFSResourceImpl resolveWithRepository(SessionContextInterface session, ServerInterface server) throws MetadataException {
        MetadataInterface smartObject;
        JFSResourceImpl outResource = null;
        if (this.isUnresolved() && (smartObject = IQModelImplUtilities.absolutePathToMetadataInterface(session, this._absolutePathToLastKnownLocation, server, false)) != null && (outResource = (JFSResourceImpl)JFSResourceFactory.newJFSResource(smartObject)) != null) {
            outResource._absolutePathToLastKnownLocation = this._absolutePathToLastKnownLocation;
        }
        return outResource;
    }

    @Override
    public MetadataInterface getMetadataInterface() {
        return this._underlyingMetadataInterface;
    }

    @Override
    public boolean isPhysicallyEquivalent(PhysicalResource res) throws MetadataException {
        ExternalResourceType resType;
        boolean returnValue = false;
        if (this == res) {
            returnValue = true;
        } else if (res instanceof ResourceRelationshipInterface && (resType = ((ResourceRelationshipInterface)((Object)res)).getResourceType()) == this.getResourceType() && res instanceof JFSResourceImpl && IQModelImplUtilities.same(((JFSResourceImpl)res).getLocation(), this.getLocation())) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void setUnresolvedProperties(PhysicalResource sourceResource) throws MetadataException {
        if (sourceResource != null && sourceResource instanceof JFSResourceImpl) {
            JFSResourceImpl jfsSourceResource = (JFSResourceImpl)sourceResource;
            this._nameWhenUnresolved = jfsSourceResource.getLabel();
            this._descriptionWhenUnresolved = jfsSourceResource.getDescription();
            this._absolutePathToLastKnownLocation = jfsSourceResource.getLocation();
        }
    }

    public void ensureHasPath() throws MetadataException {
        if (this._absolutePathToLastKnownLocation == null) {
            try {
                PathUrl url = this._underlyingMetadataInterface.getPathUrl();
                if (url == null) {
                    MessageFormatter mf = IQMetadataResourceBundle.getMessageFormatter("JFSResourceImpl.ObjectIsNotLocatedInMetadataServerFolder.fmt.txt", this._underlyingMetadataInterface.getName());
                    throw new MetadataException(mf);
                }
                this._absolutePathToLastKnownLocation = url.getAbsolutePath();
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
        }
    }

    public void setAbsolutePathLocation(String absolutePath) {
        this._absolutePathToLastKnownLocation = absolutePath;
    }

    @Override
    public String getSearchString() throws MetadataException {
        return null;
    }
}

