/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.olap.olapserver;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Member;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapServerMember
implements Member {
    private MemberInterface _member = null;
    private Dimension _ourOwningDimensionObject = null;
    private Hierarchy _ourOwningHierarchyObject = null;
    private List listeners = new ArrayList();
    private static final Logger _logger = LogManager.getLogger(OlapServerMember.class);

    public OlapServerMember(MemberInterface member) throws MetadataException {
        this._member = member;
    }

    @Override
    public String getMemberName() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            return this._member.getName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public String getMemberUniqueName() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            return this._member.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public String getLabel() {
        String label;
        block5: {
            label = "";
            if (this._member == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoMem.txt", new Object[0]));
                }
            } else {
                try {
                    label = this._member.getLabel();
                }
                catch (OLAPException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQMetadataResourceBundle.getStringResource("UnknownError.txt"), (Throwable)e);
                }
            }
        }
        return label;
    }

    @Override
    public String getDescription() {
        String description;
        block5: {
            description = "";
            if (this._member == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoMem.txt", new Object[0]));
                }
            } else {
                try {
                    description = this._member.getDescription();
                }
                catch (OLAPException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQMetadataResourceBundle.getStringResource("UnknownError.txt"), (Throwable)e);
                }
            }
        }
        return description;
    }

    @Override
    public String getMemberCaption() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            return this._member.getLabel();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public int getChildrenCardinality() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            return this._member.getChildCount();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public int getParentLevel() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            MemberInterface parentMember = this._member.getParentMember();
            LevelInterface parentLevel = parentMember.getLevel();
            return parentLevel.getDepth();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public String getParentUniqueName() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            MemberInterface parentMember = this._member.getParentMember();
            return parentMember.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public String toString() {
        String toStringIt;
        block2: {
            toStringIt = "";
            try {
                toStringIt = this.getMemberUniqueName();
            }
            catch (MetadataException ex) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("UnknownError.txt"), (Throwable)ex);
            }
        }
        return toStringIt;
    }

    public void setConnectionInfo(MetadataInterface metadata, String hostname, String port, String userID, String password, String cubeName) {
    }

    @Override
    @Nonnull
    public List<Member> getChildrenMembers() throws MetadataException {
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            MemberInterface[] myMembers = this._member.getChildren();
            ArrayList<Member> childMembers = new ArrayList<Member>(myMembers.length);
            for (int i = 0; i < myMembers.length; ++i) {
                OlapServerMember olapMember = new OlapServerMember(myMembers[i]);
                olapMember.setOwningDimension(this.getOwningDimension());
                olapMember.setOwningHierarchy(this.getOwningHierarchy());
                childMembers.add(olapMember);
            }
            return childMembers;
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        catch (Exception ex) {
            throw new MetadataException(ex);
        }
    }

    @Override
    public int getExpressionType() {
        return ExpressionUtil.getExprType(2);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
        this.replaceResource(oldResource, newResource, model, true);
    }

    @Override
    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model, boolean recursive) throws MetadataException {
    }

    @Override
    public String getDimensionName() throws MetadataException {
        return this._ourOwningDimensionObject.getDimensionName();
    }

    @Override
    public boolean isInMeasureDimension() throws MetadataException {
        return this._ourOwningDimensionObject.getDimensionType() == 1;
    }

    public void setOwningDimension(Dimension owningDimension) throws MetadataException {
        this._ourOwningDimensionObject = owningDimension;
    }

    @Override
    public Dimension getOwningDimension() throws MetadataException {
        return this._ourOwningDimensionObject;
    }

    public Hierarchy getOwningHierarchy() {
        return this._ourOwningHierarchyObject;
    }

    public void setOwningHierarchy(Hierarchy owningHierarchy) throws MetadataException {
        this._ourOwningHierarchyObject = owningHierarchy;
    }

    @Override
    public String getCubeName() throws MetadataException {
        return this._ourOwningDimensionObject.getCubeName();
    }

    @Override
    public String getUniqueName() throws MetadataException {
        String uniqueName = null;
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            uniqueName = this._member.getUniqueName();
        }
        catch (OLAPException e) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoUniqueName.txt", new Object[0]), (Throwable)e);
        }
        return uniqueName;
    }

    @Override
    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        String allMemberName = null;
        if (this._member == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoMem.txt", new Object[0]));
        }
        try {
            LevelInterface olapServerLevel = this._member.getLevel();
            HierarchyInterface olapServerHier = olapServerLevel.getHierarchy();
            MemberInterface allMember = olapServerHier.getTopMember();
            allMemberName = allMember.getUniqueName();
        }
        catch (OLAPException e) {
            throw new MetadataException(e, this._member.toString());
        }
        return allMemberName;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void addListener(PropertyChangeListener listener) {
        Utils.addListener(this.listeners, listener);
    }

    @Override
    public void removeListener(PropertyChangeListener listener) {
        Utils.removeListener(this.listeners, listener);
    }

    public List getListeners() {
        return new ArrayList(this.listeners);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Utils.fireChangeEvent(this.listeners, this, EVENT_OBJECT_DEFINITION_CHANGED, null, null);
    }

    protected void accumulateReasonsItemItselfIsUnusable(List<Reason> reasons) {
        Reason reason = new Reason(null, 2, 20, "ObjectNotValid.txt", new Object[0]);
        reasons.add(reason);
    }

    @Override
    public <T> List<T> getResources(@Nonnull Class<T> type, int flags) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsableInQuery() {
        return false;
    }

    @Override
    public List<Reason> getReasonsUnusable() {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        this.accumulateReasonsItemItselfIsUnusable(reasons);
        return reasons;
    }
}

