/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.olap.olapserver;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerHierarchy;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.OLAPException;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapServerDimension {
    private DimensionInterface _dimension = null;
    private Dimension _owningDimension = null;
    private List listeners = new ArrayList();
    private static final Logger _logger = LogManager.getLogger(OlapServerDimension.class);

    public OlapServerDimension(DimensionInterface dimension) throws MetadataException {
        this._dimension = dimension;
    }

    public String getDimensionName() throws MetadataException {
        if (this._dimension == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoDimtxt", new Object[0]));
        }
        try {
            return this._dimension.getName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public String getLabel() {
        String label;
        block5: {
            label = "";
            if (this._dimension == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoDimtxt", new Object[0]));
                }
            } else {
                try {
                    label = this._dimension.getLabel();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoDimName.txt", new Object[0]));
                }
            }
        }
        return label;
    }

    public String getDescription() {
        String desc;
        block5: {
            desc = "";
            if (this._dimension == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoDimtxt", new Object[0]));
                }
            } else {
                try {
                    desc = this._dimension.getDescription();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoDimName.txt", new Object[0]));
                }
            }
        }
        return desc;
    }

    public String getDimensionUniqueName() throws MetadataException {
        String uniqueName = "";
        if (this._dimension == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQModelImplUtilities.getMessage("OlapServerMemberNoDimtxt", new Object[0]));
            }
        } else {
            try {
                uniqueName = this._dimension.getUniqueName();
            }
            catch (OLAPException ex) {
                throw new MetadataException(ex);
            }
        }
        return uniqueName;
    }

    public String getDimensionCaption() throws MetadataException {
        return this.getLabel();
    }

    public List getHierarchies() throws MetadataException {
        if (this._dimension == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoDimtxt", new Object[0]));
        }
        ArrayList<OlapServerHierarchy> hierarchiesList = new ArrayList<OlapServerHierarchy>();
        try {
            HierarchyInterface[] hierarchies = this._dimension.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                OlapServerHierarchy hier = new OlapServerHierarchy(hierarchies[i]);
                hier.setOwnDimension(this.getOwningDimension());
                hier.setCubeName(this.getOwningDimension().getCubeName());
                hierarchiesList.add(hier);
            }
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
        return hierarchiesList;
    }

    public String getDefaultHierarchy() throws MetadataException {
        if (this._dimension == null) {
            throw new MetadataException(IQModelImplUtilities.getMessageFormatter("OlapServerMemberNoDimtxt", new Object[0]));
        }
        try {
            HierarchyInterface hier = this._dimension.getDefaultHierarchy();
            return hier.getUniqueName();
        }
        catch (OLAPException ex) {
            throw new MetadataException(ex);
        }
    }

    public Cube getOwningCube() throws MetadataException {
        throw new MetadataException(IQModelImplUtilities.getMessageFormatter("MetadataNotYet.txt", new Object[0]));
    }

    public int getExpressionType() {
        return ExpressionUtil.getExprType(1);
    }

    public void replaceResource(BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel model) throws MetadataException {
    }

    public List getResources(@Nonnull Class c, int searchFlags) {
        ArrayList list = new ArrayList();
        return list;
    }

    public Dimension getOwningDimension() throws MetadataException {
        return this._owningDimension;
    }

    public void setOwningDimension(Dimension dimension) {
        this._owningDimension = dimension;
    }

    public String getUniqueName() throws MetadataException {
        return this.getDimensionUniqueName();
    }

    public String getUniqueNameWithHierarchyAllMember() throws MetadataException {
        return this.getDimensionUniqueName();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String toStringIt;
        block2: {
            toStringIt = "";
            try {
                toStringIt = this.getUniqueName();
            }
            catch (MetadataException ex) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(IQMetadataResourceBundle.getStringResource("UnknownError.txt"), (Throwable)ex);
            }
        }
        return toStringIt;
    }

    public void addListener(PropertyChangeListener listener) {
        Utils.addListener(this.listeners, listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        Utils.removeListener(this.listeners, listener);
    }

    public List getListeners() {
        return new ArrayList(this.listeners);
    }
}

