/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.olap.olapserver;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.impl.olap.olapserver.OlapServerDimension;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OlapServerCube {
    private String _cubeName = null;
    private MetadataInterface _metadata = null;
    private CubeInterface _cube = null;
    private static final Logger _logger = LogManager.getLogger(OlapServerCube.class);

    public OlapServerCube(MetadataInterface metadata, String cubeName) throws MetadataException {
        this._metadata = metadata;
        this.setCubeName(cubeName);
        this.initialize();
    }

    public String getDescription() {
        return this.getLabel();
    }

    public void setCubeName(String cubeName) throws MetadataException {
        this._cubeName = cubeName;
    }

    public String getCubeName() throws MetadataException {
        return this._cubeName;
    }

    public String getLabel() {
        String out;
        block5: {
            out = "";
            if (this._cube == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQMetadataResourceBundle.getMessageString("OlapServerMemberNoCube.txt", new Object[0]));
                }
            } else {
                try {
                    out = this._cube.getLabel();
                }
                catch (OLAPException ex) {
                    if (!_logger.isEnabled(Level.ERROR)) break block5;
                    _logger.error(IQMetadataResourceBundle.getMessageString("OlapServerMemberNoCubeLabel.txt", new Object[0]));
                }
            }
        }
        return out;
    }

    public List getDimensions() throws MetadataException {
        if (this._cube == null) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OlapServerMemberNoCube.txt", new Object[0]));
        }
        ArrayList<OlapServerDimension> dimensionsList = new ArrayList<OlapServerDimension>();
        try {
            DimensionInterface[] dimensions = this._cube.getDimensions();
            for (int i = 0; i < dimensions.length; ++i) {
                OlapServerDimension dim = new OlapServerDimension(dimensions[i]);
                dimensionsList.add(dim);
            }
        }
        catch (OLAPException ex) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OlapServerMemberNoDim.txt", new Object[0]), (Throwable)ex);
        }
        return dimensionsList;
    }

    public String toString() {
        return "CubeName: " + this._cubeName;
    }

    private void initialize() throws MetadataException {
        try {
            Filter filter = new Filter();
            CubeInterface[] cubes = this._metadata.getCubes(filter);
            CubeInterface cube = null;
            for (int i = 0; i < cubes.length; ++i) {
                cube = cubes[i];
                if (!this._cubeName.equalsIgnoreCase(cube.getName())) continue;
                this._cube = cube;
                break;
            }
        }
        catch (OLAPException ex) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("OlapServerMemberNoCube.txt", new Object[0]), (Throwable)ex);
        }
    }
}

