/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.cache;

import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.impl.cache.MapMDInfo;
import com.sas.iquery.metadata.impl.cache.TextStoreCache;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextStoreMgr {
    private static final boolean DEFAULT_CACHE_IS_ACTIVE = Boolean.TRUE;
    private static final int DEFAULT_MAX_SIZE = 20;
    private static final int DEFAULT_MAX_AGE_SEC = 1800;
    private static final int DEFAULT_MAX_WEIGHTED_SIZE = 2000000;
    private static final String READ_MAP_DATE_TEMPLATE = "<TEMPLATES><Transformation Name=\"\" MetadataUpdated=\"\"/></TEMPLATES>";
    private static TextStoreMgr _instance = null;
    private Tuning _tuning;
    private FilterInterface _filter;
    private boolean _cacheAllowed;
    TextStoreCache _textStoreCache;
    int _rejectedStaleCount;
    private static final Logger _logger = LogManager.getLogger(TextStoreMgr.class);

    public static synchronized TextStoreMgr instance() {
        if (_instance == null) {
            _instance = new TextStoreMgr();
        }
        return _instance;
    }

    private TextStoreMgr() {
        block6: {
            try {
                this.getMetadataQueryFilter();
                this._textStoreCache = new TextStoreCache();
                this._tuning = new Tuning();
                int intProperty = this.getIntProperty("SASQueryServices.OMRInformationMapCache.maxEntries", -1);
                if (intProperty == -1) {
                    intProperty = this.getIntProperty("sas.QueryServices.OMRInformationMapCache.maxEntries", 20);
                }
                this._tuning.setMaxSize(intProperty);
                int intProperty2 = this.getIntProperty("SASQueryServices.OMRInformationMapCache.maxAgeSec", -1);
                if (intProperty2 == -1) {
                    intProperty2 = this.getIntProperty("sas.QueryServices.OMRInformationMapCache.maxAgeSec", 1800);
                }
                this._tuning.setMaxAgeSec(intProperty2);
                int intProperty3 = this.getIntProperty("SASQueryServices.OMRInformationMapCache.maxSize", -1);
                if (intProperty3 == -1) {
                    intProperty3 = this.getIntProperty("sas.QueryServices.OMRInformationMapCache.maxSize", 2000000);
                }
                this._tuning.setMaxWeightedSize(intProperty3);
                Boolean cacheAllowed = this.getBoolProperty("SASQueryServices.OMRInformationMapCache.isActive", null);
                if (cacheAllowed == null) {
                    cacheAllowed = this.getBoolProperty("sas.QueryServices.OMRInformationMapCache.isActive", DEFAULT_CACHE_IS_ACTIVE);
                }
                this.setCacheAllowed(cacheAllowed);
            }
            catch (RuntimeException e) {
                if (!_logger.isDebugEnabled()) break block6;
                _logger.debug("Failure to create TextStoredMgr for cache \n" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public Tuning getTuning() {
        return this._tuning;
    }

    public String getMapText(BriefInformationMap briefInfo, RepositoryInterface repos) {
        String rval;
        try {
            String entityKeyStr = briefInfo.getEntityKey();
            rval = this.getCachedText(entityKeyStr, repos);
        }
        catch (Exception e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(e.getMessage(), (Throwable)e);
            }
            rval = null;
        }
        return rval;
    }

    public String getMapText(String entityKey, RepositoryInterface repos) {
        String rval = null;
        if (this._cacheAllowed) {
            rval = this.getCachedText(entityKey, repos);
        }
        return rval;
    }

    public void storeMapText(BriefInformationMap briefInfo, String textStore) throws ServiceException, RemoteException {
        if (this._cacheAllowed) {
            this.storeMapText(new MapMDInfo(briefInfo, textStore));
        }
    }

    public void storeMapText(MapMDInfo mapMDInfo) {
        if (this._cacheAllowed) {
            this._textStoreCache.putMapMDInfo(mapMDInfo);
        }
    }

    public void removeMapText(String entityKey) {
        this._textStoreCache.removeMapMDInfo(entityKey);
    }

    public void setCacheAllowed(boolean allowed) {
        this._cacheAllowed = allowed;
        if (allowed) {
            this._textStoreCache.activateCache();
        } else {
            this._textStoreCache.deactivateCache();
        }
    }

    public boolean isCachingAllowed() {
        return this._cacheAllowed;
    }

    public String toString() {
        StringBuffer rval = new StringBuffer(200);
        rval.append("IQ TextStoreMgr[").append(this._textStoreCache).append("]");
        if (this._rejectedStaleCount > 0) {
            rval.append(" ** Rejections due to metadata updates [").append(this._rejectedStaleCount).append("]");
        }
        rval.append('.');
        return rval.toString();
    }

    private String getCachedText(String entityKey, RepositoryInterface repos) {
        String rval;
        if (!this._cacheAllowed) {
            return null;
        }
        MapMDInfo info = this._textStoreCache.getMapMDInfo(entityKey);
        if (info == null) {
            return null;
        }
        boolean accessOK = this.verifyAccess(info, repos);
        if (!accessOK) {
            this._textStoreCache.removeMapMDInfo(entityKey);
            ++this._rejectedStaleCount;
            rval = null;
        } else {
            rval = info.getTextStore();
        }
        return rval;
    }

    private boolean verifyAccess(MapMDInfo info, RepositoryInterface repos) {
        boolean rval = false;
        try {
            String mdEntityKey = info.getEntityKey();
            FilterInterface filter = this.getMetadataQueryFilter();
            BrowseMetadataInterface browseFetch = repos.browseFetch(mdEntityKey, filter);
            if (browseFetch != null) {
                long currentModDate = browseFetch.getModifyDate();
                rval = currentModDate == info.getModDate();
            }
        }
        catch (Exception e) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(e.getMessage(), (Throwable)e);
            }
            rval = false;
        }
        return rval;
    }

    private FilterInterface getMetadataQueryFilter() {
        if (this._filter == null) {
            Filter rval = new Filter();
            rval.setOMRTemplate(READ_MAP_DATE_TEMPLATE);
            int queryFlags = -2080372348;
            rval.setOMRFlags(queryFlags);
            this._filter = rval;
        }
        return this._filter;
    }

    private int getIntProperty(String propName, int defaultValue) {
        int rval;
        block3: {
            rval = defaultValue;
            try {
                String propValue = System.getProperty(propName);
                if (propValue != null) {
                    rval = Integer.parseInt(propValue);
                }
            }
            catch (RuntimeException e) {
                if (!_logger.isDebugEnabled()) break block3;
                _logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return rval;
    }

    private Boolean getBoolProperty(String propName, Boolean defaultValue) {
        Boolean rval;
        block6: {
            rval = defaultValue;
            try {
                String propValue = System.getProperty(propName);
                if (propValue != null) {
                    if (propValue.equalsIgnoreCase("true")) {
                        rval = Boolean.TRUE;
                    } else if (propValue.equalsIgnoreCase("false")) {
                        rval = Boolean.FALSE;
                    }
                }
            }
            catch (RuntimeException e) {
                if (!_logger.isDebugEnabled()) break block6;
                _logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return rval;
    }

    public class Tuning {
        protected Tuning() {
        }

        public void setMaxAgeSec(int ageInSeconds) {
            TextStoreMgr.this._textStoreCache.setMaxAgeSec(ageInSeconds);
        }

        public int getMaxAgeSec() {
            return TextStoreMgr.this._textStoreCache.getMaxAgeSec();
        }

        public void setMaxSize(int max) {
            TextStoreMgr.this._textStoreCache.setMaxSize(max);
        }

        public int getMaxSize() {
            return TextStoreMgr.this._textStoreCache.getMaxSize();
        }

        public void setMaxWeightedSize(int maxWeighted) {
            TextStoreMgr.this._textStoreCache.setMaxWeightedSize(maxWeighted);
        }

        public int getMaxWeightedSize() {
            return TextStoreMgr.this._textStoreCache.getMaxWeightedSize();
        }

        public void clear() {
            TextStoreMgr.this._textStoreCache.clear();
        }

        public int getRejectionsDueToMetadataUpdates() {
            return TextStoreMgr.this._rejectedStaleCount;
        }
    }
}

