/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.cache;

import com.sas.iquery.metadata.impl.cache.CacheBase;
import com.sas.iquery.metadata.impl.cache.MapMDInfo;

public final class TextStoreCache
extends CacheBase {
    private static final int DEFAULT_MAX_SIZE = 20;
    private static final int DEFAULT_MAX_AGE_SEC = 3600;
    private static final int MB = 0x100000;
    private static final int DEFAULT_MAX_WEIGHTED_SIZE = 0x500000;
    private int _maxSize;

    public TextStoreCache() {
        super("TextStoreCache");
        this.setMaxSize(20);
        this.setMaxAgeSec(3600);
        this.setMaxWeightedSize(0x500000);
    }

    public MapMDInfo getMapMDInfo(String entityKey) {
        return (MapMDInfo)this.getObject(entityKey);
    }

    public void removeMapMDInfo(String entityKey) {
        this.removeObject(entityKey);
    }

    public void putMapMDInfo(MapMDInfo mapMdInfo) {
        this.putObject(mapMdInfo.getEntityKey(), mapMdInfo);
    }

    public void deactivateCache() {
        super.setMaxSize(0);
    }

    public void activateCache() {
        this.setMaxSize(this._maxSize);
    }

    @Override
    public void setMaxSize(int max) {
        this._maxSize = max;
        super.setMaxSize(max);
    }

    @Override
    public void setMaxAgeSec(int ageInSeconds) {
        super.setMaxAgeSec(ageInSeconds);
    }

    @Override
    protected int calcWeightForEntry(Object entry) {
        MapMDInfo info = (MapMDInfo)entry;
        return info.getTextStore().length();
    }
}

