/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl.cache;

import com.sas.iquery.metadata.impl.cache.CacheListenerInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CacheBase {
    private static final int DEFAULT_MAX_SIZE = 50;
    private String _name;
    private Map _cache;
    private List _listeners;
    private int _hits = 0;
    private int _misses = 0;
    private int _maxSize = 50;
    private int _maxWeightedSize = 0;
    private int _currentWeightedSize;
    private int _maxAgeSec = 0;
    private long _nextStaleEntryScanDue;
    private static final Logger _logger = LogManager.getLogger(CacheBase.class);
    private static final long ONE_SEC_IN_MSEC = 1000L;

    protected CacheBase(String name) {
        this._name = name;
        this._cache = Collections.synchronizedMap(new LinkedHashMap(11, 0.75f, true));
    }

    protected int getMaxSize() {
        return this._maxSize;
    }

    protected void setMaxSize(int maxSize) {
        if (maxSize != this._maxSize) {
            this._maxSize = maxSize;
            this.ensureCacheIsNotOversized();
        }
    }

    protected int getMaxWeightedSize() {
        return this._maxWeightedSize;
    }

    protected void setMaxWeightedSize(int maxWeightedSize) {
        this._maxWeightedSize = maxWeightedSize;
        if (maxWeightedSize > 0) {
            this.calcCurrentWeightedSize();
            this.ensureCacheIsNotOversized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcCurrentWeightedSize() {
        if (this._maxWeightedSize > 0) {
            int result = 0;
            Map map = this._cache;
            synchronized (map) {
                for (Holder holder : this._cache.values()) {
                    result += holder.getWeight();
                }
                this._currentWeightedSize = result;
            }
        }
    }

    protected int calcWeightForEntry(Object entryIgnored) {
        int rval = 0;
        if (entryIgnored == null) {
            rval = 0;
        }
        return rval;
    }

    protected int getMaxAgeSec() {
        return this._maxAgeSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMaxAgeSec(int sec) {
        block7: {
            this._maxAgeSec = sec;
            if (sec > 0) {
                this._nextStaleEntryScanDue = Math.min(this._nextStaleEntryScanDue, CacheBase.now() + 1000L * (long)sec);
                try {
                    if (this._cache.isEmpty()) break block7;
                    Map map = this._cache;
                    synchronized (map) {
                        for (Holder holder : this._cache.values()) {
                            holder.setExpireTime(Math.min(holder.getExpireTime(), this._nextStaleEntryScanDue));
                        }
                        this.removeStaleEntries();
                    }
                }
                catch (RuntimeException e) {
                    if (!_logger.isDebugEnabled()) break block7;
                    _logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        StringBuffer rval = new StringBuffer(300);
        rval.append(this._name).append(" (hit(s): ").append(this._hits).append(", miss(es): ").append(this._misses);
        rval.append("\n\t Size current(").append(this._cache.size());
        if (this.getMaxSize() > 0) {
            rval.append("), max(").append(this.getMaxSize());
        }
        if (this.getMaxWeightedSize() > 0) {
            this.calcCurrentWeightedSize();
            rval.append("),\n\t WEIGHTED Size Current(").append(this._currentWeightedSize).append("), Max(").append(this.getMaxWeightedSize());
        }
        rval.append(").");
        return rval.toString();
    }

    public String toStringDetailed() {
        return this.toString() + ":\n" + this._cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.haveListeners()) {
            this._cache.clear();
        } else {
            HashMap removedEntries = null;
            Map map = this._cache;
            synchronized (map) {
                if (!this._cache.isEmpty()) {
                    removedEntries = new HashMap(this._cache);
                    this._cache.clear();
                }
            }
            this.notifyRemovingObjects(removedEntries);
        }
        this._currentWeightedSize = 0;
    }

    public int size() {
        return this._cache.size();
    }

    protected Object getObject(Object key) {
        Object rval = this.getRealValue(key);
        if (rval == null) {
            ++this._misses;
            if (_logger.isDebugEnabled()) {
                String msg = "cache MISS for " + key + " [" + this + "]";
                _logger.debug(msg);
            }
        } else {
            ++this._hits;
            if (_logger.isDebugEnabled()) {
                String msg = "cache HIT for " + key + " [" + this + "]";
                _logger.debug(msg);
            }
        }
        return rval;
    }

    private Object getRealValue(Object key) {
        Object rval = null;
        Holder holder = (Holder)this._cache.get(key);
        if (holder != null) {
            if (holder.isExpired()) {
                holder = null;
                this.removeObject(key);
            }
            if (holder != null) {
                rval = holder.getValue();
            }
        }
        return rval;
    }

    protected Object putObject(Object key, Object value) {
        Object rval;
        if (value == null) {
            rval = this.removeObject(key);
        } else {
            int weight = this.calcWeightForEntry(value);
            Holder holder = new Holder(this._maxAgeSec, value, weight);
            this._currentWeightedSize += weight;
            rval = this._cache.put(key, holder);
            this.ensureCacheIsNotOversized();
        }
        if (_logger.isEnabled(Level.INFO)) {
            String msg = "Cache put, key [" + key + "] value [" + value + "]";
            _logger.info(msg);
        }
        return rval;
    }

    protected Object removeObject(Object key) {
        Object rval = this.removeObjectNoNotify(key);
        if (rval != null && this.haveListeners()) {
            for (CacheListenerInterface listener : this._listeners) {
                listener.removingCacheObject(key, rval);
            }
        }
        return rval;
    }

    protected Object removeObjectNoNotify(Object key) {
        Object rval = null;
        Holder holder = (Holder)this._cache.remove(key);
        if (holder != null) {
            this._currentWeightedSize -= holder.getWeight();
            if (!holder.isExpired()) {
                rval = holder.getValue();
            }
        }
        return rval;
    }

    private boolean haveListeners() {
        return this._listeners != null && !this._listeners.isEmpty();
    }

    public void addListener(CacheListenerInterface listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(listener);
    }

    public void removeListener(CacheListenerInterface listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    private void notifyRemovingObjects(Map removedEntries) {
        if (removedEntries != null && !removedEntries.isEmpty() && this.haveListeners()) {
            for (CacheListenerInterface listener : this._listeners) {
                Iterator entryIter = removedEntries.entrySet().iterator();
                while (entryIter.hasNext()) {
                    try {
                        Map.Entry entry = entryIter.next();
                        Holder holder = (Holder)entry.getValue();
                        listener.removingCacheObject(entry.getKey(), holder.getValue());
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureCacheIsNotOversized() {
        HashMap removedEntries = null;
        int numRemoved = 0;
        int max = this.getMaxSize();
        if (max >= 0) {
            Map map = this._cache;
            synchronized (map) {
                int numToRemove;
                numRemoved += this.removeStaleEntries();
                if (this._cache.size() > max && (numToRemove = this._cache.size() - max) > 0) {
                    boolean haveListeners = this.haveListeners();
                    if (haveListeners) {
                        removedEntries = new HashMap(numToRemove);
                    }
                    if (_logger.isDebugEnabled()) {
                        String msg = "Cache is oversized, removing: " + numToRemove + " entries...";
                        _logger.debug(msg);
                    }
                    Iterator entryIter = this._cache.entrySet().iterator();
                    for (int i = 0; i < numToRemove && entryIter.hasNext(); ++i) {
                        Map.Entry entry = entryIter.next();
                        if (haveListeners) {
                            removedEntries.put(entry.getKey(), entry.getValue());
                        }
                        ++numRemoved;
                        entryIter.remove();
                    }
                }
            }
        }
        if (this._maxWeightedSize > 0) {
            if (numRemoved > 0) {
                this.calcCurrentWeightedSize();
            }
            if (this._currentWeightedSize > this._maxWeightedSize) {
                boolean haveListeners = this.haveListeners();
                if (haveListeners && removedEntries == null) {
                    removedEntries = new HashMap();
                }
                Map map = this._cache;
                synchronized (map) {
                    Iterator entryIter = this._cache.entrySet().iterator();
                    while (this._currentWeightedSize > this._maxWeightedSize && entryIter.hasNext()) {
                        Map.Entry entry = entryIter.next();
                        if (haveListeners) {
                            removedEntries.put(entry.getKey(), entry.getValue());
                        }
                        Holder holder = (Holder)entry.getValue();
                        this._currentWeightedSize -= holder.getWeight();
                        entryIter.remove();
                    }
                }
            }
        }
        if (removedEntries != null) {
            this.notifyRemovingObjects(removedEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeStaleEntries() {
        if (!this.nextScanIsDue()) {
            return 0;
        }
        HashMap removedEntries = null;
        boolean haveListeners = this.haveListeners();
        long nextScanDue = CacheBase.now() + (long)this._maxAgeSec * 1000L;
        Map map = this._cache;
        synchronized (map) {
            Iterator entryIter = this._cache.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                Holder holder = (Holder)entry.getValue();
                if (holder.isExpired()) {
                    if (haveListeners) {
                        if (removedEntries == null) {
                            removedEntries = new HashMap();
                        }
                        removedEntries.put(entry.getKey(), holder);
                    }
                    entryIter.remove();
                    continue;
                }
                nextScanDue = Math.min(nextScanDue, holder.getExpireTime());
            }
        }
        this._nextStaleEntryScanDue = nextScanDue;
        if (haveListeners) {
            this.notifyRemovingObjects(removedEntries);
        }
        return removedEntries == null ? 0 : removedEntries.size();
    }

    private boolean nextScanIsDue() {
        return this.getMaxAgeSec() > 0 && CacheBase.now() > this._nextStaleEntryScanDue;
    }

    protected Collection getKeys() {
        return new ArrayList(this._cache.keySet());
    }

    public int getHits() {
        return this._hits;
    }

    protected void setHits(int hits) {
        this._hits = hits;
    }

    public int getMisses() {
        return this._misses;
    }

    protected void setMisses(int misses) {
        this._misses = misses;
    }

    protected static long now() {
        return System.currentTimeMillis();
    }

    protected final boolean isAging() {
        return this.getMaxAgeSec() > 0;
    }

    private static class Holder {
        private long _expireTime;
        private Object _value;
        private int _weight;

        Holder(int maxAge, Object value, int weight) {
            if (maxAge > 0) {
                this._expireTime = CacheBase.now() + 1000L * (long)maxAge;
            }
            this._value = value;
            this._weight = weight;
        }

        long getExpireTime() {
            return this._expireTime;
        }

        void setExpireTime(long expireTime) {
            this._expireTime = expireTime < 0L ? 0L : expireTime;
        }

        boolean isExpired() {
            return this._expireTime != 0L && CacheBase.now() > this._expireTime;
        }

        Object getValue() {
            return this._value;
        }

        int getWeight() {
            return this._weight;
        }

        public String toString() {
            return this._value == null ? "" : this._value.toString();
        }
    }
}

