/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.EntityPersistenceUtility;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.NamedObjectInterface;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils {
    private static final Logger _logger = LogManager.getLogger(Utils.class);

    public static Document loadXmlFile(InputStream dataStream) throws IOException {
        Document xmlDocument = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(dataStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException io = new IOException(e.toString());
            io.initCause(e);
            throw io;
        }
        return xmlDocument;
    }

    @Deprecated
    public static void addButNoDuplicates(List targetList, List sourceList) {
        IQModelImplUtilities.addButNoDuplicates(targetList, sourceList);
    }

    @Deprecated
    public static int addButNoDuplicates(List list, Object object) {
        return IQModelImplUtilities.addButNoDuplicates(list, object);
    }

    @Deprecated
    public static List filterList(List inputList, Class returnOnlyOfThisType) {
        return IQModelImplUtilities.filterList(inputList, returnOnlyOfThisType);
    }

    @Deprecated
    public static String toString(Object obj) {
        return IQModelImplUtilities.toString(obj);
    }

    public static String toString(List list) {
        return IQModelImplUtilities.toString(list);
    }

    public static List<Element> getKidElements(Element el) {
        return IQModelImplUtilities.getKidElements(el);
    }

    @Deprecated
    public static Element getSpecificKidElement(Element el, String kidElementTagName) {
        return IQModelImplUtilities.getSpecificKidElement(el, kidElementTagName);
    }

    @Deprecated
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    @Deprecated
    public static final <T> List<T> getGoodInputList(List<T> inList) {
        return ListUtils.newList();
    }

    @Deprecated
    public static final List inList1ButNotInList2(List list1, List list2) {
        ArrayList out = new ArrayList();
        for (Object obj : list1) {
            if (list2.contains(obj)) continue;
            out.add(obj);
        }
        return out;
    }

    public static final void removeListenerOnTheseObjects(PropertyChangeListener listener, List objs) {
        for (Object obj : objs) {
            if (!(obj instanceof PropertyChangeListenee)) continue;
            PropertyChangeListenee listenee = (PropertyChangeListenee)obj;
            listenee.removeListener(listener);
        }
    }

    public static final void addListenerOnTheseObjects(PropertyChangeListener listener, List objs) {
        for (Object obj : objs) {
            if (!(obj instanceof PropertyChangeListenee)) continue;
            PropertyChangeListenee listenee = (PropertyChangeListenee)obj;
            listenee.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(List toThisList, PropertyChangeListener listener) {
        if (toThisList != null && listener != null) {
            List list = toThisList;
            synchronized (list) {
                if (!toThisList.contains(listener)) {
                    toThisList.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(List fromThisList, PropertyChangeListener listener) {
        if (fromThisList != null && listener != null) {
            List list = fromThisList;
            synchronized (list) {
                fromThisList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireChangeEvent(List listeners, Object objectThatChanged, String propertyName, Object newObject, Object oldObject) {
        if (listeners != null && listeners.size() > 0 && objectThatChanged != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(objectThatChanged, propertyName, newObject, oldObject);
            List list = listeners;
            synchronized (list) {
                for (Object obj : listeners) {
                    if (!(obj instanceof PropertyChangeListener)) continue;
                    PropertyChangeListener listener = (PropertyChangeListener)obj;
                    try {
                        listener.propertyChange(event);
                    }
                    catch (Exception e) {
                        if (!_logger.isEnabled(Level.ERROR)) continue;
                        _logger.error(IQMetadataResourceBundle.getStringResource("Utils.ExceptionDuringListenerNotif.txt"), (Throwable)e);
                    }
                }
            }
        }
    }

    @Deprecated
    public static Class verifyResourceClass(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("");
        }
        if (BusinessModelResource.class.isAssignableFrom(c)) {
            return c;
        }
        throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("Utils.MustSpecifyClassOrInterf.txt", new Object[0]));
    }

    public static void addResource(List resources, Object obj, Class c, int searchFlags) {
        if (obj != null) {
            ArrayList parents = new ArrayList();
            Utils.addResource(resources, obj, c, searchFlags, parents);
        }
    }

    private static void addResource(List resources, Object obj, Class c, int searchFlags, List parents) {
        if (obj != null) {
            if (c.isInstance(obj)) {
                Utils.addButNoDuplicates(resources, obj);
            }
            if (searchFlags != 0) {
                boolean keepGoingDeeper = true;
                if (obj instanceof FilterItem) {
                    keepGoingDeeper = (searchFlags & 1) != 0;
                } else if (obj instanceof DataItem) {
                    boolean bl = keepGoingDeeper = (searchFlags & 2) != 0;
                }
                if (keepGoingDeeper && obj instanceof AbstractModelItem) {
                    List<ModelItem> objectsDirectResources = ((AbstractModelItem)obj).getDirectlyReferencedItemsInDownwardDefinition();
                    parents.add(obj);
                    for (ModelItem directResource : objectsDirectResources) {
                        if (resources.contains(directResource)) continue;
                        if (parents.contains(directResource)) {
                            if (_logger.isEnabled(Level.WARN)) {
                                _logger.warn("A circular reference is found within the resource " + directResource.toString());
                            }
                            if (!c.isInstance(obj)) continue;
                            Utils.addButNoDuplicates(resources, obj);
                            continue;
                        }
                        Utils.addResource(resources, directResource, c, searchFlags, parents);
                    }
                    parents.remove(obj);
                }
            }
        }
    }

    public static void accumulate(List intoList, Object item) {
        if (item != null && intoList != null && !intoList.contains(item)) {
            intoList.add(item);
        }
    }

    public static void accumulate(List intoList, List items) {
        if (items != null) {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                Object item = items.get(i);
                Utils.accumulate(intoList, item);
            }
        }
    }

    public static Object replaceResource(Object referencee, BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel referencerModel) throws MetadataException {
        return Utils.replaceResource(referencee, oldResource, newResource, referencerModel, true);
    }

    public static Object replaceResource(Object referencee, BusinessModelResource oldResource, BusinessModelResource newResource, BusinessModel referencerModel, boolean recursive) throws MetadataException {
        if (referencerModel == null || referencee == null || oldResource == null || newResource == null) {
            return referencee;
        }
        Object out = referencee;
        if (referencee == oldResource) {
            out = newResource;
        } else if ((recursive || !(referencee instanceof BusinessModelResource)) && referencee instanceof BusinessModelResourceReferencer) {
            if (referencee instanceof BusinessModelObject) {
                BusinessModelObject referenceeObject = (BusinessModelObject)referencee;
                if (referencerModel == referenceeObject.getBusinessModel()) {
                    referenceeObject.replaceResource(oldResource, newResource, referencerModel, recursive);
                }
            } else {
                ((BusinessModelResourceReferencer)referencee).replaceResource(oldResource, newResource, referencerModel, recursive);
            }
        }
        return out;
    }

    @Deprecated
    public static boolean checkObjectTypes(List objects, Class[] classes) {
        boolean ok = true;
        Iterator it = objects.iterator();
        while (it.hasNext() && ok) {
            ok = Utils.checkObjectType(it.next(), classes);
        }
        return ok;
    }

    public static boolean checkObjectType(Object obj, Class[] classes) {
        boolean ok = false;
        for (int i = 0; i < classes.length && !ok; ++i) {
            ok = classes[i].isInstance(obj);
        }
        return ok;
    }

    public static void ensureProperArgumentType(Object obj, Class[] classes) {
        Preconditions.ensureNonNull(obj);
        boolean ok = Utils.checkObjectType(obj, classes);
        if (!ok) {
            StringBuffer types = new StringBuffer();
            for (int i = 0; i < classes.length; ++i) {
                if (types.length() != 0) {
                    types.append(",");
                }
                types.append(classes[i].getName());
            }
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("IQModelImplUtilities.ImproperObjTypeSpecified.fmt.txt", obj.getClass().getName(), types.toString()));
        }
    }

    @Deprecated
    public static void ensureProperArgumentTypes(List objects, Class[] classes) {
        Preconditions.ensureNonNull(objects);
        for (Object obj : objects) {
            Utils.ensureProperArgumentType(obj, classes);
        }
    }

    @Deprecated
    public static void removeDuplicates(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            int lastIndex = list.lastIndexOf(obj);
            while (lastIndex != i) {
                list.remove(lastIndex);
                lastIndex = list.lastIndexOf(obj);
            }
        }
    }

    public static List filterObjects(BusinessModel businessModel, boolean includeBaseModels, Class objectType) {
        if (businessModel == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("Utils.FilterObjectsNullBusinessModel.txt", new Object[0]));
        }
        List returnList = businessModel.getObjects(includeBaseModels, objectType);
        if (includeBaseModels && returnList.size() > 0) {
            Iterator objectIter = returnList.iterator();
            ArrayList<DataItem> removeList = new ArrayList<DataItem>();
            while (objectIter.hasNext()) {
                DataItem dataItem;
                BusinessModelObject cur = (BusinessModelObject)objectIter.next();
                if (!(cur instanceof DataItemReference) || cur.getBusinessModel() != businessModel || (dataItem = ((DataItemReference)cur).getBaseDataItem()).getBusinessModel() == businessModel) continue;
                removeList.add(dataItem);
            }
            for (Object e : removeList) {
                returnList.remove(e);
            }
        }
        return returnList;
    }

    public static EntityInterface copy(EntityInterface entity) throws MetadataException {
        boolean copy = false;
        Entity newEntity = null;
        if (entity != null) {
            String xmlEntity;
            AttributeDescriptor descriptor;
            AttributeDescriptorInterface[] attributeDescriptors;
            newEntity = new Entity();
            try {
                attributeDescriptors = entity.getAttributeDescriptors();
            }
            catch (Exception e) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Utils.CouldNotReadAttributeDescriptor.fmt.txt", entity.toString());
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new MetadataException(msg, (Throwable)e);
            }
            if (attributeDescriptors.length > 1) {
                copy = true;
            } else if (attributeDescriptors.length == 1 && !(descriptor = (AttributeDescriptor)attributeDescriptors[0]).getName().equalsIgnoreCase("entityKey")) {
                copy = true;
            }
            if (copy && (xmlEntity = EntityPersistenceUtility.writeXMLToString((EntityInterface)entity)) != null && xmlEntity.length() > 0) {
                try {
                    String newEntityKey = newEntity.getEntityKey();
                    newEntity = EntityPersistenceUtility.createEntityFromXML((String)xmlEntity);
                    newEntity.setEntityKey(newEntityKey);
                }
                catch (Exception e) {
                    MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Utils.CouldNotReadEntityXml.fmt.txt", xmlEntity);
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(msg.toString(), (Throwable)e);
                    }
                    throw new MetadataException(msg, (Throwable)e);
                }
            }
        }
        return newEntity;
    }

    public static List<ExpressionInterface> cloneExpressionList(List list, boolean stripDataItems) throws CloneNotSupportedException {
        ArrayList<ExpressionInterface> newList = new ArrayList<ExpressionInterface>();
        for (Object obj : list) {
            if (stripDataItems && obj instanceof DataItem) {
                DataItem da = (DataItem)obj;
                ExpressionInterface daExpr = da.getExpression();
                if (daExpr instanceof BusinessModelResource) {
                    newList.add(daExpr);
                    continue;
                }
                newList.add((ExpressionInterface)daExpr.clone());
                continue;
            }
            if (obj instanceof ExpressionInterface) {
                ExpressionInterface expr = (ExpressionInterface)obj;
                if (!(expr instanceof BusinessModelResource)) {
                    newList.add((ExpressionInterface)expr.clone());
                    continue;
                }
                newList.add(expr);
                continue;
            }
            newList.add((ExpressionInterface)obj);
        }
        return newList;
    }

    public static void ruleBasedResourceReplacement(BusinessModel model, NamedObjectInterface oldItem, NamedObjectInterface newItem, Map relinkRules, boolean recursive) throws MetadataException {
        if (newItem instanceof BusinessModelResourceReferencer) {
            BusinessModelResourceReferencer referencer = (BusinessModelResourceReferencer)((Object)newItem);
            Set keys = relinkRules.keySet();
            for (Object key : keys) {
                Object value;
                if (!(key instanceof BusinessModelResource) || !((value = relinkRules.get(key)) instanceof BusinessModelResource)) continue;
                referencer.replaceResource((BusinessModelResource)key, (BusinessModelResource)value, model, recursive);
            }
        }
        Collection values = relinkRules.values();
        for (Object value : values) {
            if (!(value instanceof BusinessModelResourceReferencer) || !(oldItem instanceof BusinessModelResource) || !(newItem instanceof BusinessModelResource)) continue;
            BusinessModelResourceReferencer referencer = (BusinessModelResourceReferencer)value;
            referencer.replaceResource((BusinessModelResource)oldItem, (BusinessModelResource)newItem, model, recursive);
        }
        relinkRules.put(oldItem, newItem);
    }
}

