/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.impl.RemoteSessionContextStateChangedListenerImpl;
import com.sas.iquery.metadata.impl.SessionContextDependentCacheException;
import com.sas.iquery.util.impl.ListUtils;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextStateChangedEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SessionContextDependentCache
implements RemoteSessionContextStateChangedListenerImpl.SessionContextStateChangedListener {
    private static Map<UUID, SessionContextDependentCache> cache = Collections.synchronizedMap(new HashMap());
    private static String SCDC_END_SESSION_LISTENER = "iquery.SessionContextDependentCache_sessionEndListener";
    private UUID uuid = null;
    private static final Logger _logger = LogManager.getLogger(SessionContextDependentCache.class);
    private final Map<String, Map<String, Object>> _cachedSessionObjects = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<SessionContextEndListener>> _sessionEndListenerLists = Collections.synchronizedMap(new HashMap());

    public static SessionContextDependentCache getNewInstance() {
        SessionContextDependentCache scdc = new SessionContextDependentCache();
        cache.put(scdc.uuid, scdc);
        return scdc;
    }

    public static SessionContextDependentCache getInstance(String id) {
        UUID key = UUID.fromString(id);
        SessionContextDependentCache scdc = cache.get(key);
        return scdc;
    }

    private SessionContextDependentCache() {
        this.uuid = UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(SessionContextInterface session, String key) {
        Object cachedValue = null;
        if (_logger.isDebugEnabled()) {
            _logger.debug("get(s,k): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
        Map<String, Map<String, Object>> map = this._cachedSessionObjects;
        synchronized (map) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("get(s,k): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            try {
                cachedValue = this._get(session, key);
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("get(s,k): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
            }
        }
        return cachedValue;
    }

    private Object _get(SessionContextInterface session, String key) {
        Object cachedValue = null;
        try {
            String sessionKey = session.getEntityKey();
            Map<String, Object> sessionObjects = this._cachedSessionObjects.get(sessionKey);
            if (sessionObjects != null) {
                cachedValue = sessionObjects.get(key);
            }
        }
        catch (RemoteException e) {
            this.logNoEntityKey(e);
        }
        return cachedValue;
    }

    public void put(SessionContextInterface session, String key, Object value) throws SessionContextDependentCacheException {
        this.put(session, key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SessionContextInterface session, String key, Object value, SessionContextEndListener sessionEndListener) throws SessionContextDependentCacheException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("put(s,k,v,l): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
        Map<String, Map<String, Object>> map = this._cachedSessionObjects;
        synchronized (map) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("put(s,k,v,l): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            try {
                this._put(session, key, value, sessionEndListener);
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("put(s,k,v,l): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
            }
        }
    }

    private void _put(SessionContextInterface session, String key, Object value, SessionContextEndListener sessionEndListener) throws SessionContextDependentCacheException {
        this.addSessionContextEndListener(session, sessionEndListener);
        try {
            String sessionKey = session.getEntityKey();
            Map<String, Object> sessionObjects = this._cachedSessionObjects.get(sessionKey);
            if (sessionObjects == null) {
                sessionObjects = new HashMap<String, Object>();
                this._cachedSessionObjects.put(sessionKey, sessionObjects);
            }
            sessionObjects.put(key, value);
        }
        catch (RemoteException e) {
            MessageFormatter msg = this.logNoEntityKey(e);
            throw new SessionContextDependentCacheException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedValue(SessionContextInterface session, String key) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("removeCachedValue(s,k): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
        Map<String, Map<String, Object>> map = this._cachedSessionObjects;
        synchronized (map) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("removeCachedValue(s,k): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            try {
                this._remove(session, key);
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("removeCachedValue(s,k): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
            }
        }
    }

    private void _remove(SessionContextInterface session, String key) {
        try {
            String sessionKey = session.getEntityKey();
            Map<String, Object> sessionObjects = this._cachedSessionObjects.get(sessionKey);
            if (sessionObjects != null) {
                sessionObjects.remove(key);
                if (sessionObjects.isEmpty()) {
                    this._cachedSessionObjects.remove(sessionKey);
                }
            }
        }
        catch (RemoteException e) {
            this.logNoEntityKey(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionContextCacheKeys(SessionContextInterface session) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("getSessionContextCacheKeys(s): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
        Map<String, Map<String, Object>> map = this._cachedSessionObjects;
        synchronized (map) {
            List<String> list;
            if (_logger.isDebugEnabled()) {
                _logger.debug("getSessionContextCacheKeys(s): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            try {
                list = this._getKeys(session);
            }
            catch (Throwable throwable) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("getSessionContextCacheKeys(s): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
                throw throwable;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("getSessionContextCacheKeys(s): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            return list;
        }
    }

    private List<String> _getKeys(SessionContextInterface session) {
        try {
            String sessionKey = session.getEntityKey();
            Map<String, Object> sessionObjects = this._cachedSessionObjects.get(sessionKey);
            if (sessionObjects != null) {
                ArrayList<String> keys = new ArrayList<String>();
                for (String key : sessionObjects.keySet()) {
                    keys.add(key);
                }
                return keys;
            }
        }
        catch (RemoteException e) {
            this.logNoEntityKey(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionContextEndListener(SessionContextInterface session, SessionContextEndListener sessionEndListener) throws SessionContextDependentCacheException {
        if (sessionEndListener == null) {
            return;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("addSessionContextEndListener(s,l): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
        Map<String, Map<String, Object>> map = this._cachedSessionObjects;
        synchronized (map) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("addSessionContextEndListener(s,l): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("addSessionContextEndListener(s,l): About to sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                }
                Map<String, List<SessionContextEndListener>> map2 = this._sessionEndListenerLists;
                synchronized (map2) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("addSessionContextEndListener(s,l): Started sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                    }
                    try {
                        this._addListener(session, sessionEndListener);
                    }
                    finally {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("addSessionContextEndListener(s,l): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                        }
                    }
                }
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("addSessionContextEndListener(s,l): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
            }
        }
    }

    private void _addListener(SessionContextInterface session, SessionContextEndListener sessionEndListener) throws SessionContextDependentCacheException {
        String scdcKey = SCDC_END_SESSION_LISTENER + "_" + this.uuid.toString();
        RemoteSessionContextStateChangedListener listener = null;
        try {
            listener = (RemoteSessionContextStateChangedListener)session.getAttribute(scdcKey);
        }
        catch (IllegalStateException e) {
            _logger.debug("Could not find the Remote State Changed Listener", (Throwable)e);
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
            _logger.error((Object)msg, (Throwable)e);
            throw new SessionContextDependentCacheException(msg, (Throwable)e);
        }
        catch (RemoteException e) {
            _logger.debug("Could not find the Remote State Changed Listener", (Throwable)e);
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
            _logger.error((Object)msg, (Throwable)e);
            throw new SessionContextDependentCacheException(msg, (Throwable)e);
        }
        if (listener == null) {
            try {
                listener = new RemoteSessionContextStateChangedListenerImpl(this);
                session.setAttribute(scdcKey, (Object)listener);
            }
            catch (IllegalStateException e) {
                _logger.debug("Could not add 'this' as the Remote State Changed Listener", (Throwable)e);
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
                _logger.error((Object)msg, (Throwable)e);
                throw new SessionContextDependentCacheException(msg, (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.debug("Could not add 'this' as the Remote State Changed Listener", (Throwable)e);
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
                _logger.error((Object)msg, (Throwable)e);
                throw new SessionContextDependentCacheException(msg, (Throwable)e);
            }
        }
        try {
            String sessionKey = session.getEntityKey();
            List<SessionContextEndListener> sessionEndListeners = this._sessionEndListenerLists.get(sessionKey);
            if (sessionEndListeners == null) {
                sessionEndListeners = new ArrayList<SessionContextEndListener>();
                this._sessionEndListenerLists.put(sessionKey, sessionEndListeners);
            }
            if (!sessionEndListeners.contains(sessionEndListener)) {
                sessionEndListeners.add(sessionEndListener);
            }
        }
        catch (RemoteException e) {
            MessageFormatter msg = this.logNoEntityKey(e);
            throw new SessionContextDependentCacheException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public List<SessionContextEndListener> getSessionContextEndListeners(SessionContextInterface session) {
        if (session != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("getSessionContextEndListeners(s): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            Map<String, Map<String, Object>> map = this._cachedSessionObjects;
            synchronized (map) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("getSessionContextEndListeners(s): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
                try {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("getSessionContextEndListeners(s): About to sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                    }
                    Map<String, List<SessionContextEndListener>> map2 = this._sessionEndListenerLists;
                    synchronized (map2) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("getSessionContextEndListeners(s): Started sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                        }
                        List<SessionContextEndListener> list = this._getListeners(session);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("getSessionContextEndListeners(s): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                        }
                        return list;
                        {
                            catch (Throwable throwable) {
                                if (_logger.isDebugEnabled()) {
                                    _logger.debug("getSessionContextEndListeners(s): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("getSessionContextEndListeners(s): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                    }
                }
            }
        }
        return null;
    }

    private List<SessionContextEndListener> _getListeners(SessionContextInterface session) {
        List<SessionContextEndListener> list = null;
        try {
            String sessionKey = session.getEntityKey();
            List<SessionContextEndListener> sessionEndListeners = this._sessionEndListenerLists.get(sessionKey);
            list = ListUtils.newList(sessionEndListeners);
        }
        catch (RemoteException e) {
            this.logNoEntityKey(e);
        }
        return list;
    }

    public void removeSessionContextEndListener(SessionContextInterface session, SessionContextEndListener endListener) {
        this.removeSessionContextEndListener(session, endListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionContextEndListener(SessionContextInterface session, SessionContextEndListener endListener, boolean removeCachedValue) {
        if (session != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("removeSessionContextEndListener(s,l): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            Map<String, Map<String, Object>> map = this._cachedSessionObjects;
            synchronized (map) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("removeSessionContextEndListener(s,l): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
                try {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("removeSessionContextEndListener(s,l): About to sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                    }
                    Map<String, List<SessionContextEndListener>> map2 = this._sessionEndListenerLists;
                    synchronized (map2) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("removeSessionContextEndListener(s,l): Started sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                        }
                        try {
                            this._removeListener(session, endListener, removeCachedValue);
                        }
                        finally {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("removeSessionContextEndListener(s,l): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                            }
                        }
                    }
                }
                finally {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("removeSessionContextEndListener(s,l): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                    }
                }
            }
        }
    }

    private void _removeListener(SessionContextInterface session, SessionContextEndListener endListener, boolean removeCachedValue) {
        try {
            Map<String, Object> sessionObjects;
            String sessionKey = session.getEntityKey();
            List<SessionContextEndListener> sessionEndListeners = this._sessionEndListenerLists.get(sessionKey);
            if (sessionEndListeners != null) {
                Iterator<SessionContextEndListener> itListens = sessionEndListeners.iterator();
                while (itListens.hasNext()) {
                    SessionContextEndListener listener = itListens.next();
                    if (listener != endListener) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("removing listener: " + listener);
                    }
                    itListens.remove();
                }
            }
            if ((sessionObjects = this._cachedSessionObjects.get(sessionKey)) != null && removeCachedValue) {
                this._cachedSessionObjects.remove(sessionKey);
                sessionObjects = null;
            }
            if ((sessionObjects == null || sessionObjects.isEmpty()) && (sessionEndListeners == null || sessionEndListeners.isEmpty())) {
                if (sessionEndListeners != null) {
                    this._sessionEndListenerLists.remove(sessionKey);
                }
                if (sessionObjects != null) {
                    this._cachedSessionObjects.remove(sessionKey);
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Cleared cached sesssion objects: " + sessionObjects);
                _logger.debug("Cleared listeners ");
            }
        }
        catch (RemoteException e) {
            this.logNoEntityKey(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(SessionContextInterface session) {
        if (session != null) {
            String sessionKey = null;
            try {
                sessionKey = session.getEntityKey();
            }
            catch (RemoteException e) {
                this.logNoEntityKey(e);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("removeSession(s): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
            }
            List<SessionContextEndListener> listeners = null;
            Map<String, Map<String, Object>> map = this._cachedSessionObjects;
            synchronized (map) {
                try {
                    if (sessionKey != null) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("removeSession(s): About to sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                        }
                        Map<String, List<SessionContextEndListener>> map2 = this._sessionEndListenerLists;
                        synchronized (map2) {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("removeSession(s): Started sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                            }
                            try {
                                listeners = this._sessionEndListenerLists.remove(sessionKey);
                            }
                            finally {
                                if (_logger.isDebugEnabled()) {
                                    _logger.debug("removeSession(s): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                                }
                            }
                        }
                        this._removeCached(sessionKey);
                    }
                    int stateChanged = 1;
                    this.removeOverallListener(session, stateChanged);
                }
                finally {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("removeSession(s): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                    }
                }
            }
            if (listeners != null) {
                for (SessionContextEndListener listener : listeners) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Ending for listener: " + listener);
                    }
                    listener.sessionEnd(session);
                }
                listeners.clear();
            }
        }
    }

    private void _removeCached(String sessionKey) {
        Map<String, Object> sessionObjects = this._cachedSessionObjects.get(sessionKey);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Clearing cached sesssion objects: " + sessionObjects);
        }
        if (sessionObjects != null) {
            sessionObjects.clear();
        }
        this._cachedSessionObjects.remove(sessionKey);
    }

    private void removeOverallListener(SessionContextInterface session, int stateChanged) {
        block6: {
            String scdcKey = SCDC_END_SESSION_LISTENER + "_" + this.uuid.toString();
            try {
                session.removeAttribute(scdcKey);
            }
            catch (IllegalStateException e) {
                if (stateChanged != 2) {
                    _logger.debug("Could not find the Remote State Changed Listener to remove", (Throwable)e);
                    if (_logger.isEnabled(Level.ERROR)) {
                        MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
                        _logger.error((Object)msg, (Throwable)e);
                    }
                }
            }
            catch (RemoteException e) {
                _logger.debug("Could not find the Remote State Changed Listener to remove", (Throwable)e);
                if (!_logger.isEnabled(Level.ERROR)) break block6;
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoListener.fmt.txt", e.getLocalizedMessage());
                _logger.error((Object)msg, (Throwable)e);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
        }
    }

    public String getID() {
        return this.uuid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void contextStateChanged(SessionContextStateChangedEvent stateChangedEvent) {
        int stateChanged = stateChangedEvent.getStateChange();
        if (_logger.isDebugEnabled()) {
            _logger.debug("contextStateChanged fired=" + stateChangedEvent);
        }
        if (stateChanged == 1 || stateChanged == 2) {
            _logger.debug("detected: OBJECT_REMOVED or SESSION_CONTEXT_DESTROYED");
            SessionContextInterface eventSession = stateChangedEvent.getSessionContext();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Event Session: " + eventSession);
            }
            if (eventSession != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Session End Event Received for session " + eventSession);
                }
                String eventSessionKey = null;
                try {
                    eventSessionKey = eventSession.getEntityKey();
                }
                catch (RemoteException e) {
                    this.logNoEntityKey(e);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("contextStateChanged(e): About to sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                }
                List<SessionContextEndListener> listeners = null;
                Map<String, Map<String, Object>> map = this._cachedSessionObjects;
                synchronized (map) {
                    block30: {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("contextStateChanged(e): Started sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                        }
                        try {
                            if (eventSessionKey == null) break block30;
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("contextStateChanged(e): About to sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                            }
                            Map<String, List<SessionContextEndListener>> map2 = this._sessionEndListenerLists;
                            synchronized (map2) {
                                if (_logger.isDebugEnabled()) {
                                    _logger.debug("contextStateChanged(e): Started sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                                }
                                try {
                                    listeners = this._sessionEndListenerLists.remove(eventSessionKey);
                                }
                                finally {
                                    if (_logger.isDebugEnabled()) {
                                        _logger.debug("contextStateChanged(e): Ending sync on " + this._objSyncMsgString(this._sessionEndListenerLists));
                                    }
                                }
                            }
                            this._removeCached(eventSessionKey);
                            if (!this._sessionEndListenerLists.isEmpty()) {
                                this.removeOverallListener(eventSession, stateChanged);
                            }
                        }
                        finally {
                            if (_logger.isDebugEnabled()) {
                                _logger.debug("contextStateChanged(e): Ending sync on " + this._objSyncMsgString(this._cachedSessionObjects));
                            }
                        }
                    }
                }
                if (listeners != null) {
                    for (SessionContextEndListener listener : listeners) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Ending for listener: " + listener);
                        }
                        listener.sessionEnd(eventSession);
                    }
                    listeners.clear();
                }
            } else {
                _logger.debug("This event is not for a cached session, ignore it");
            }
        }
    }

    private String _objSyncMsgString(Object obj) {
        return obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
    }

    private MessageFormatter logNoEntityKey(RemoteException e) {
        _logger.debug("Could not get session entity key", (Throwable)e);
        MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("SessionContextDependentCacheNoEntityKey.fmt.txt", e.getLocalizedMessage());
        _logger.error((Object)msg, (Throwable)e);
        return msg;
    }

    public static interface SessionContextEndListener
    extends EventListener {
        public void sessionEnd(SessionContextInterface var1);
    }
}

