/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.impl;

import com.sas.iquery.metadata.impl.SessionContextDependentCache;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextStateChangedEvent;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.EventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RemoteSessionContextStateChangedListenerImpl
extends UnicastRemoteObject
implements RemoteSessionContextStateChangedListener {
    static final long serialVersionUID = 1L;
    String sessionCacheID;
    private static final Logger _logger = LogManager.getLogger(RemoteSessionContextStateChangedListenerImpl.class);

    public RemoteSessionContextStateChangedListenerImpl(SessionContextDependentCache listener) throws RemoteException {
        this.sessionCacheID = listener.getID();
    }

    public void contextStateChanged(SessionContextStateChangedEvent stateChangedEvent) throws RemoteException {
        int changedEvent = stateChangedEvent.getStateChange();
        SessionContextDependentCache listener = SessionContextDependentCache.getInstance(this.sessionCacheID);
        if (_logger.isDebugEnabled()) {
            _logger.debug("ContextStateChanged fired=" + stateChangedEvent);
            _logger.debug("Notifying listener: " + listener);
        }
        listener.contextStateChanged(stateChangedEvent);
    }

    public static interface SessionContextStateChangedListener
    extends EventListener {
        public void contextStateChanged(SessionContextStateChangedEvent var1);
    }
}

